/* $Id: OutputVideoSetting.java 372 2010-05-01 07:17:25Z yuki $ */
package saccubus.properties;

import java.io.File;
import java.util.Properties;

/**
 * o̓RgtɊւݒ.
 * @author yuki
 */
public class OutputVideoSetting extends ProcessFileSetting<Boolean> {

    private static final String PROP_SAVE_CONVERTED = "SaveConvertedFile";
    private static final String PROP_ADD_COMMENT = "AddComment";
    private static final String PROP_ADD_TCOMMENT = "AddTcomment";
    private static final String PROP_CONVERTED_FILE = "ConvertedFile";
    private static final String PROP_NOT_ADD_VIDEOID_CONV = "NotAddVideoIDtoConverted";
    private static final String PROP_CONV_FIX_FILE_NAME = "ConvFixFileName";
    private static final String PROP_CONV_FIX_FILE_NAME_FOLDER = "ConvFixFileNameFolder";
    private final boolean cutIdName;
    private final boolean addComment;
    private final boolean addTcomment;

    /**
     *
     * @param processKind ϊŝłtrue.
     * @param cutIdName o͖ɓIDȂ̂łtrue. autoNamingtruȅꍇɗp.
     * @param addComment ϊ, Rgt̂łtrue.
     * @param addTcomment ϊ, e҃Rgt̂łtrue.
     */
    public OutputVideoSetting(boolean processKind, boolean autoNaming, File folder, File file, boolean cutIdName,
            boolean addComment, boolean addTcomment) {
        super(processKind, autoNaming, folder, file);
        this.cutIdName = cutIdName;
        this.addComment = addComment;
        this.addTcomment = addTcomment;
    }

    @Override
    public void save(Properties prop) {
        prop.setProperty(PROP_SAVE_CONVERTED, Boolean.toString(getProcessKind()));
        prop.setProperty(PROP_ADD_COMMENT, Boolean.toString(isAddComment()));
        prop.setProperty(PROP_ADD_TCOMMENT, Boolean.toString(isAddTcomment()));
        prop.setProperty(PROP_CONVERTED_FILE, getFile().getPath());
        prop.setProperty(PROP_NOT_ADD_VIDEOID_CONV, Boolean.toString(isCutIdName()));
        prop.setProperty(PROP_CONV_FIX_FILE_NAME, (new Boolean(isAutoNaming())).toString());
        prop.setProperty(PROP_CONV_FIX_FILE_NAME_FOLDER, getFolder().getPath());


    }

    public static OutputVideoSetting load(Properties prop) {
        boolean process = Boolean.parseBoolean(prop.getProperty(PROP_SAVE_CONVERTED, "true"));
        boolean addComment = Boolean.valueOf(prop.getProperty(PROP_ADD_COMMENT, "true"));
        boolean addTcomment = Boolean.valueOf(prop.getProperty(PROP_ADD_TCOMMENT, "true"));
        String file = prop.getProperty(PROP_CONVERTED_FILE, "video.avi");
        boolean cutId = Boolean.parseBoolean(prop.getProperty(PROP_NOT_ADD_VIDEOID_CONV, "false"));
        boolean autoNaming = Boolean.parseBoolean(prop.getProperty(PROP_CONV_FIX_FILE_NAME, "true"));
        String folder = prop.getProperty(PROP_CONV_FIX_FILE_NAME_FOLDER, "[out]converted");

        return new OutputVideoSetting(process, autoNaming, new File(folder), new File(file), cutId, addComment,
                addTcomment);
    }

    public final boolean isCutIdName() {
        return cutIdName;
    }

    public final boolean isAddComment() {
        return addComment;
    }

    public final boolean isAddTcomment() {
        return addTcomment;
    }
}
