/**
 * ファイルに関するユーティリティ
 */
package saccubus.util;

import java.io.File;
import java.util.regex.Pattern;

/**
 * @author PSI
 *
 */
public class FileUtil {

    private static Pattern safeFileName_SPACE = Pattern.compile(" {2}+");

    private FileUtil() {
    }

    public static String safeFileName(String str) {
        //実体参照のパース
        int old_index = 0;
        int new_index = 0;
        StringBuffer sb = new StringBuffer();
        String ch;
        while ((new_index = str.indexOf("&#", old_index)) >= 0) {
            sb.append(str, old_index, new_index);
            old_index = str.indexOf(";", new_index);
            ch = str.substring(new_index + 2, old_index);
            sb.append(new String(new char[]{(char) Integer.parseInt(ch)}));
            old_index++;
        }
        //最後に追加
        sb.append(str, old_index, str.length());
        str = sb.toString();
        //ファイルシステムで扱える形に
        str = str.replace('/', '／');
        str = str.replace('\\', '￥');
        str = str.replace('?', '？');
        str = str.replace('*', '＊');
        str = str.replace(':', '：');
        str = str.replace('|', '｜');
        str = str.replace('\"', '”');
        str = str.replace('<', '＜');
        str = str.replace('>', '＞');
        str = str.replace('.', '．');
        str = safeFileName_SPACE.matcher(str).replaceAll(" ");
        return str;
    }

    /**
     * ファイル名から拡張子を取り除きます. 拡張子が無ければ与えられた文字列をそのまま返します.
     * @param fileName 対象ファイル名.
     * @return  拡張子が取り除かれたファイル名.
     */
    public static String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }
}
