package saccubus.worker.profile;

import java.io.File;

/**
 * 変換元情報(入力情報)のプロファイルが実現すべきインタフェースです.
 * @author yuki
 */
interface Inputable {

    /**
     * @return 変換する動画ファイルをニコニコ動画サービスから取得するのであればtrue.
     * ローカルにあるファイルを使用するのであればfalse.
     */
    boolean isDownload();

    /**
     * @return {@link #isDownload()}がtrueの場合に, 取得したファイルを保存するディレクトリを返します.
     * falseの場合は未定義.
     */
    File getDir();

    /**
     * @return {@link #isDownload()}がtrueの場合に, 取得したファイルを保存するファイル名のパターンを返します.
     * falseの場合は未定義.
     */
    String getFileName();

    /**
     * @return {@link #isDownload()}がfalseの場合に, 使用するローカルファイルを返します.
     * trueの場合は未定義.
     */
    File getLocalFile();
}
