package yukihane.inqubus.model;

import org.apache.commons.lang.StringUtils;
import yukihane.inqubus.manager.RequestProcess;
import yukihane.inqubus.manager.TaskKind;
import yukihane.inqubus.manager.TaskStatus;

public class Target {

    private final RequestProcess requestProcess;
    private Progress progress;

    public Target(RequestProcess rp) {
        this.requestProcess = rp;
        this.progress = new Progress("待機中");
    }

    public int getRowId() {
        return requestProcess.getRowId();
    }

    public String getVideoId() {
        return getRequestProcess().getVideoId();
    }

    boolean isVideoDownload() {
        return getRequestProcess().getDownloadProfile().getVideoProfile().isDownload();
    }

    boolean isCommentDownload() {
        return getRequestProcess().getDownloadProfile().getCommentProfile().isDownload();
    }

    boolean isConvert() {
        return getRequestProcess().getConvertProfile().isConvert();
    }

    Progress getProgress() {
        return progress;
    }

    void setProgress(TaskKind kind, TaskStatus status, double percent, String message) {
        String text;
        double p = -1.0;
        if (status == TaskStatus.READY) {
            text = status.toString();
        } else if (status == TaskStatus.DOING || status == TaskStatus.DONE || status == TaskStatus.CANCELLED) {
            if (StringUtils.isEmpty(message)) {
                text = kind.toString() + " " + status.toString();
            } else {
                text = message;
            }
            p = percent;
        } else {
            text = message;
        }
        progress = new Progress(p, text);
    }

    private RequestProcess getRequestProcess() {
        return requestProcess;
    }
}
