///////////////////////////////////////////////////////////////
//    Crowbar（クロウバー）
///////////////////////////////////////////////////////////////

// 動作に関わるオプション．ドキュメントを読んで理解したら自由に設定して構いません．
void Options() {
  // 以下はオプションの一例（crowbarClassのコメントを参照）
  // crowbar.disableDisplay();            // グラフィックスエリアに文字表示しない
  // crowbar.disableTextArea();           // 画面下のテキストエリアに文字表示しない
  // crowbar.enableOverlap();             // ウィンドウ枠からはみ出した文字列を折り返し表示する
  // crowbar.noShowParameters();          // パラメータ入力後にパラメータの値確認なし
  // crowbar.enableLogOutput();           // default.txtにログを記録する
  // crowbar.setcolor(#ffffff, #000000);  // 白黒反転
  // crowbar.setFontSize(24);             // デカ文字

  // Main()終了後にuserDraw()を繰り返し実行するならば以下のcrowbar.nonStop()を有効にする
  // crowbar.nonStop();
}

// パラメータ入力前に行っておきたい処理（setup()の最初に自動実行）
void initializeMain() {
  // 以下の行は削除してはいけない．二つの引数の値を変更するとウィンドウサイズが変わる
  crowbar = new crowbarClass(60, 40);
  // 必要ならば以下に記述
}

///////////////////////////////////////////////////////////////////////////////////
// ここから下のコードはユーザが積極的に記述して構わない
///////////////////////////////////////////////////////////////////////////////////
// システム初期設定
void Setup()
{
  // プログラムコメント（パラメータ入力前に一度だけ画面表示されます．複数宣言可，省略可）
  // 例） crowbar.programComment("平面三リンクロボットシミュレータ");

  // 以下に，入力が必要なパラメータを宣言
  // crowbar.define("説明"); 複数個を宣言しても構わない．宣言が無くても構わない．
  // 例） crowbar.define("リンクの長さ", 1.0);
}

// メインルーチン
// ユーザのメインのプログラム（１度しか実行されない）を以下に記述
void Main() {
  // 変数の代入
  // 例) LinkNumber = crowbar.getInt();
  // 例）PixelRatio = crowbar.getFloat();
  // メインのコードを以下に記述
}

