/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class TestSpace
extends PApplet {
    int cx;
    int cy;
    int targetView = 0;
    boolean clicked;
    crowbarClass crowbar;
    protected int _FONTSIZE = 14;
    protected int _TEXTCOLOR = -16777214;
    protected int _BGCOLOR = -18;
    protected float _HSTEP = 1.2f;
    protected float _VSTEP = 1.4f;
    protected float _TABSIZE = 10.0f;
    protected String _FONTNAME = "MS Gothic";
    protected boolean _DEBUGFLAG = false;
    int i = 0;

    public void Options() {
        this.crowbar.fontSize(12);
        this.crowbar.hStep(1.5f);
        this.crowbar.vStep(1.5f);
        this.crowbar.textColor(-16579837);
    }

    public void initializeMain() {
        this.crowbar = new crowbarClass(60, 40, 2);
    }

    public void Setup() {
        int n = this.width;
        int n2 = this.height;
        this.crowbar.programComment("Tomahawk\u7d71\u5408\u306e\u5b9f\u9a13");
        this.crowbar.createView("Left");
        this.crowbar.cv.viewBgColor(-32640);
        this.crowbar.cv.scale(1.0f);
        this.crowbar.cv.offset(20.0f, 20.0f);
        this.crowbar.splitViewH("RightUpper", 0.5f);
        this.crowbar.cv.viewBgColor(-8323200);
        this.crowbar.cv.scale(1.0f);
        this.crowbar.cv.offset(20.0f, 20.0f);
        this.crowbar.splitViewV("RightLower", 0.5f);
        this.crowbar.cv.viewBgColor(-8355585);
        this.crowbar.cv.scale(2.0f);
        this.crowbar.cv.offset(20.0f, 20.0f);
        this.crowbar.createView("Middle", n / 4, n2 / 4, n / 2, n2 / 2);
        this.crowbar.cv.viewBgColor(-8355712);
        this.crowbar.cv.transparency(128);
        this.crowbar.cv.scale(1.0f);
        this.crowbar.cv.offset(20.0f, 20.0f);
        this.crowbar.createView("Trajectory");
        this.crowbar.cv.transparentView(true);
        this.crowbar.cv.clrView();
        this.crowbar.define("\u30c6\u30ad\u30b9\u30c8\u8868\u793aX\u5ea7\u6a19", 0);
        this.crowbar.define("\u30c6\u30ad\u30b9\u30c8\u8868\u793aY\u5ea7\u6a19", 0);
        this.crowbar.nonStop();
    }

    public void Main() {
        this.crowbar.displayAllViewData();
        this.cx = this.crowbar.getInt();
        this.cy = this.crowbar.getInt();
        this.clicked = false;
    }

    public boolean isKeyNumbers(char c) {
        if (this.isNumberChar(c)) {
            return true;
        }
        switch (c) {
            case '+': 
            case '-': 
            case '.': {
                return true;
            }
        }
        return false;
    }

    public void keyPressed() {
        if (!this.crowbar.running) {
            if (this.crowbar.inputNow) {
                if (this.key == '\n') {
                    if ((this.crowbar.is_numbersOnly() || this.crowbar.is_selectOnly() != 0) && this.crowbar.keyBufferLength() == 0 && this.crowbar.get_initialValue().length() == 0) {
                        this.redraw();
                        return;
                    }
                    this.crowbar.inputFinish();
                    this.crowbar.newline();
                } else if (this.key == '\b') {
                    if (this.crowbar.keyBufferLength() > 0) {
                        this.crowbar.backSpace();
                    }
                } else if (this.key == '\t') {
                    if (this.crowbar.get_initialValue().length() > 0) {
                        this.crowbar.automaticInputByDefalutValue(true);
                        this.crowbar.inputFinish();
                        this.crowbar.newline();
                    }
                } else {
                    int n;
                    boolean bl = true;
                    if (this.crowbar.is_numbersOnly()) {
                        bl = !this.isKeyNumbers(this.key) ? false : this.crowbar.keyCheck.checkFloat(this.key);
                    }
                    if ((n = this.crowbar.is_selectOnly()) > 0) {
                        if (n == 99) {
                            this.crowbar.halt();
                            return;
                        }
                        if (this.crowbar.keyBufferLength() >= 1) {
                            bl = false;
                        }
                        if (!this.isNumberChar(this.key)) {
                            bl = false;
                        }
                        if (PApplet.parseInt((String)TestSpace.str((char)this.key)) >= n) {
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.crowbar.strcat(TestSpace.str((char)this.key));
                        this.crowbar.write(TestSpace.str((char)this.key));
                    }
                }
            } else if (this.key == 'Q' || this.key == 'q') {
                this.crowbar.status = 99;
            }
            if (this.crowbar.afterRunning) {
                if (this.key == '-') {
                    this.crowbar.pageScroll(-0.5f);
                } else if (this.key == '+') {
                    this.crowbar.pageScroll(0.5f);
                } else if (this.key == '\uffff') {
                    if (this.keyCode == 38) {
                        this.crowbar.pageLineScroll(-1);
                    } else if (this.keyCode == 40) {
                        this.crowbar.pageLineScroll(1);
                    } else if (this.keyCode == 37) {
                        this.crowbar.pageScroll(-0.5f);
                    } else if (this.keyCode == 39) {
                        this.crowbar.pageScroll(0.5f);
                    }
                }
            }
            this.redraw();
        } else {
            this.userKeyPressed();
        }
    }

    public void draw() {
        switch (this.crowbar.status) {
            case 0: {
                this.crowbar._nonstop = this.crowbar.nonstop;
                this.crowbar._noShowParams = this.crowbar.noShowParams;
                this.crowbar._userDrawLoop = this.crowbar.userDrawLoop;
                if (this.crowbar.comment != null) {
                    this.crowbar.writeln("\u3010\u30d7\u30ed\u30b0\u30e9\u30e0\u8aac\u660e\u3011");
                    this.crowbar.outputProgramComments();
                    this.crowbar.newline();
                }
                if (this.crowbar.tomahawkMode != 0) {
                    this.crowbar.backupViewports();
                }
                ++this.crowbar.status;
                break;
            }
            case 1: {
                this.crowbar.allResetArguments();
                this.crowbar.automaticInputByDefalutValue(false);
                this.crowbar.nonstop = this.crowbar._nonstop;
                this.crowbar.noShowParams = this.crowbar._noShowParams;
                this.crowbar._userDrawLoop = this.crowbar._userDrawLoop;
                if (!this.crowbar.isNoParameter()) {
                    this.crowbar.newline();
                    this.crowbar.writeln("\u3010\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5165\u529b\u3011");
                }
                if (this.crowbar.tomahawkMode != 0) {
                    this.crowbar.restoreViewports();
                }
                ++this.crowbar.status;
                break;
            }
            case 2: {
                if (!this.crowbar.isNoParameter()) {
                    this.crowbar.keyCheck.reset();
                    this.crowbar.write(String.valueOf(this.crowbar.get_paramMessage(this.crowbar.obtainArgIndex)) + ":");
                    this.crowbar.flushKeyBuffer();
                    this.crowbar.startInput();
                    if (this.crowbar.autoInput && this.crowbar.get_initialValue().length() > 0) {
                        this.crowbar.inputFinish();
                        this.crowbar.newline();
                    } else {
                        this.noLoop();
                    }
                }
                ++this.crowbar.status;
                break;
            }
            case 3: {
                if (!this.crowbar.isNoParameter()) {
                    int n;
                    if (!this.crowbar.inputFixed) break;
                    boolean bl = true;
                    String string = this.crowbar.getKeyBuffer();
                    if (string.length() == 0) {
                        string = this.crowbar.get_initialValue();
                    }
                    if ((n = this.crowbar.is_selectOnly()) > 0) {
                        if (n == 99) {
                            this.crowbar.halt();
                            break;
                        }
                        n = PApplet.parseInt((String)string);
                        if (n < 0 || n > 9) {
                            bl = false;
                        } else if (n > this.crowbar.is_selectOnly()) {
                            bl = false;
                        }
                        if (!bl) {
                            TestSpace.println((String)("SystemError: \u9078\u629e\u80a2\u578b\u306e\u5165\u529b\u5024\u304c\u7570\u5e38\u3067\u3059\uff08" + TestSpace.str((int)n) + "\uff09\uff0e"));
                            this.crowbar.halt();
                            break;
                        }
                        string = this.crowbar.get_selectValue(n);
                    }
                    this.crowbar.setValue(string);
                    ++this.crowbar.obtainArgIndex;
                    this.loop();
                    ++this.crowbar.status;
                    break;
                }
                ++this.crowbar.status;
                break;
            }
            case 4: {
                if (!this.crowbar.isNoParameter()) {
                    if (this.crowbar.allReady()) {
                        ++this.crowbar.status;
                        break;
                    }
                    this.crowbar.status -= 2;
                    break;
                }
                ++this.crowbar.status;
                break;
            }
            case 5: {
                if (!this.crowbar.isNoParameter()) {
                    this.crowbar.newline();
                    this.crowbar.writeln("\u3010\u5168\u3066\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5165\u529b\u304c\u5b8c\u4e86\u3011");
                    if (!this.crowbar.noShowParams) {
                        this.crowbar.showAllParameters();
                    }
                    this.crowbar.write("\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u5b9f\u884c\u3059\u308b(Yes) /\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u5165\u529b\u3057\u76f4\u3059(Retry) : ");
                    this.noLoop();
                }
                ++this.crowbar.status;
                break;
            }
            case 6: {
                if (!this.crowbar.isNoParameter()) {
                    if (!this.keyPressed) break;
                    if (this.key == 'y' || this.key == 'Y') {
                        this.crowbar.writeln(TestSpace.str((char)this.key));
                        this.crowbar.newline();
                        ++this.crowbar.status;
                        this.loop();
                        break;
                    }
                    if (this.key != 'r' && this.key != 'R') break;
                    this.crowbar.writeln(TestSpace.str((char)this.key));
                    this.crowbar.newline();
                    this.crowbar.status -= 5;
                    this.loop();
                    break;
                }
                ++this.crowbar.status;
                break;
            }
            case 7: {
                this.preMain();
                this.crowbar.running = true;
                ++this.crowbar.status;
                break;
            }
            case 8: {
                this.crowbar.enableLogOutput();
                if (this.crowbar.isEnableLogging()) {
                    this.crowbar.restartLogging();
                    this.crowbar.newline2Log();
                    this.crowbar.showAllParameters2Log();
                    this.crowbar.newline2Log();
                }
                ++this.crowbar.status;
                break;
            }
            case 9: {
                this.Main();
                this.loop();
                ++this.crowbar.status;
                break;
            }
            case 10: {
                if (this.crowbar.nonstop) {
                    if (!this.crowbar.userDrawLoop) break;
                    this.userDraw();
                    break;
                }
                ++this.crowbar.status;
                break;
            }
            case 11: {
                this.crowbar.running = false;
                if (this.crowbar.isEnableLogging()) {
                    this.crowbar.pauseLogging();
                }
                ++this.crowbar.status;
                break;
            }
            case 12: {
                this.postMain();
                ++this.crowbar.status;
                break;
            }
            case 13: {
                this.crowbar.setColor(this._TEXTCOLOR, this._BGCOLOR);
                this.crowbar.newline();
                this.crowbar.writeln("\u3010\u30d7\u30ed\u30b0\u30e9\u30e0\u7d42\u4e86\u3011");
                this.crowbar.write("\u3082\u3046\u4e00\u5ea6\uff0c\u5b9f\u884c\u3057\u307e\u3059\u304b\uff1f(Yes/No)\uff1a");
                this.crowbar.afterRunning = true;
                this.crowbar.textbuffer.flushBuffer(!this.crowbar.noOverlap);
                this.crowbar.stopRecordTextBuffer();
                ++this.crowbar.status;
                this.noLoop();
                break;
            }
            case 14: {
                if (!this.keyPressed) break;
                if (this.key == 'y' || this.key == 'Y') {
                    this.crowbar.writeln(TestSpace.str((char)this.key));
                    this.crowbar.newline();
                    this.crowbar.stopRecordTextBuffer();
                    this.crowbar.redrawNewestPage();
                    this.crowbar.afterRunning = false;
                    this.crowbar.startRecordTextBuffer();
                    this.crowbar.status = 1;
                    this.loop();
                    break;
                }
                if (this.key != 'n' && this.key != 'N') break;
                this.crowbar.writeln(TestSpace.str((char)this.key));
                this.crowbar.stopRecordTextBuffer();
                this.crowbar.redrawNewestPage();
                this.crowbar.afterRunning = false;
                this.crowbar.startRecordTextBuffer();
                ++this.crowbar.status;
                this.loop();
                break;
            }
            case 15: {
                this.crowbar.status = 99;
                break;
            }
            case 99: {
                TestSpace.println();
                if (this.crowbar.isEnableLogging()) {
                    TestSpace.println((String)"\u30d5\u30a1\u30a4\u30eb\u3092\u9589\u3058\u307e\u3059\uff0e");
                    this.crowbar.restartLogging();
                    this.crowbar.newline2Log();
                    this.crowbar.stopLogging();
                    this.crowbar.disableLogOutput();
                }
                TestSpace.println((String)"Crowbar\u3092\u7d42\u4e86\u3057\u307e\u3059\uff0e");
                this.exit();
            }
        }
        this.crowbar.refreshView();
    }

    public void mouseDragged() {
        if (this.crowbar.running) {
            this.userMouseDragged();
        }
    }

    public void mouseMoved() {
        if (this.crowbar.running) {
            this.userMouseMoved();
        }
    }

    public void mousePressed() {
        if (this.crowbar.running) {
            this.userMousePressed();
        }
    }

    public void mouseReleased() {
        if (this.crowbar.running) {
            this.userMouseReleased();
        }
    }

    public void mouseClicked() {
        if (this.crowbar.running) {
            this.userMouseClicked();
        }
    }

    public void keyReleased() {
        if (this.crowbar.running) {
            this.userKeyReleased();
        }
    }

    public void keyTyped() {
        if (this.crowbar.running) {
            this.userKyeTyped();
        }
    }

    public void setup() {
        this.initializeMain();
        this.Options();
        this.Setup();
    }

    public int sgn(int n) {
        return this.sgn(PApplet.parseFloat((int)n));
    }

    public int sgn(float f) {
        if (f < 0.0f) {
            return -1;
        }
        if (f > 0.0f) {
            return 1;
        }
        return 0;
    }

    public String nowDateTime() {
        return String.valueOf(TestSpace.str((int)TestSpace.year())) + '/' + this.strRight(String.valueOf('0') + TestSpace.str((int)TestSpace.month()), 2) + '/' + this.strRight(String.valueOf('0') + TestSpace.str((int)TestSpace.day()), 2) + ' ' + this.strRight(String.valueOf('0') + TestSpace.str((int)TestSpace.hour()), 2) + ':' + this.strRight(String.valueOf('0') + TestSpace.str((int)TestSpace.minute()), 2) + ':' + this.strRight(String.valueOf('0') + TestSpace.str((int)TestSpace.second()), 2);
    }

    public char getKEY() {
        if (this.key < 'a' || this.key > 'z') {
            return this.key;
        }
        return TestSpace.str((char)this.key).toUpperCase().charAt(0);
    }

    public boolean isNumberChar(char c) {
        return c >= '0' && c <= '9';
    }

    public String strRight(String string, int n) {
        int n2 = string.length() - n;
        if (n2 < 0) {
            return string;
        }
        return string.substring(n2);
    }

    public String strLeft(String string, int n) {
        return string.substring(0, n);
    }

    public float rotate2Dx(float f, float f2, float f3) {
        return f * TestSpace.cos((float)f3) - f2 * TestSpace.sin((float)f3);
    }

    public float rotate2Dy(float f, float f2, float f3) {
        return f * TestSpace.sin((float)f3) + f2 * TestSpace.cos((float)f3);
    }

    public float norm(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        return TestSpace.sqrt((float)(f5 * f5 + f6 * f6));
    }

    public void preMain() {
    }

    public void postMain() {
    }

    public void userMousePressed() {
    }

    public void userMouseReleased() {
    }

    public void userMouseDragged() {
    }

    public void userMouseMoved() {
    }

    public void userMouseClicked() {
        if (this.mouseButton == 39) {
            int n = this.crowbar.detectActiveView(this.mouseX, this.mouseY);
            if (n < 0) {
                return;
            }
            this.targetView = n;
        } else if (this.mouseButton == 37) {
            int n = this.mouseX;
            int n2 = this.height - this.mouseY;
            this.crowbar.lastView();
            this.crowbar.cv.stroke(-8388608);
            if (!this.clicked) {
                this.crowbar.cv.moveTo(n, n2);
            } else {
                this.crowbar.cv.dashedLineTo(n, n2, 5.0f);
            }
            this.clicked = true;
            this.crowbar.cv.fill(-14671840);
            this.crowbar.cv.stroke(-16777216);
            this.crowbar.cv.rectC(n, n2, 10.0f, 10.0f);
        }
    }

    public void userKeyPressed() {
        switch (this.key) {
            case '1': {
                this.crowbar.toggleVisible(0);
                break;
            }
            case '2': {
                this.crowbar.toggleVisible(1);
                break;
            }
            case '3': {
                this.crowbar.toggleVisible(2);
                break;
            }
            case '4': {
                this.crowbar.toggleVisible(3);
                break;
            }
            case 'T': 
            case 't': {
                this.crowbar.moveToTop(this.targetView);
                break;
            }
            case 'B': 
            case 'b': {
                this.crowbar.moveToBottom(this.targetView);
                break;
            }
            case 'C': 
            case 'c': {
                this.crowbar.lastView();
                this.crowbar.cv.clrView();
                this.clicked = false;
            }
        }
        switch (this.keyCode) {
            case 37: {
                this.crowbar.moveViewRel(this.targetView, -5, 0);
                break;
            }
            case 39: {
                this.crowbar.moveViewRel(this.targetView, 5, 0);
                break;
            }
            case 38: {
                this.crowbar.moveViewRel(this.targetView, 0, -5);
                break;
            }
            case 40: {
                this.crowbar.moveViewRel(this.targetView, 0, 5);
            }
        }
    }

    public void userKeyReleased() {
    }

    public void userKyeTyped() {
        if (this.key == 'Q' || this.key == 'q') {
            this.crowbar.stop();
        }
    }

    public void userDraw() {
        int n = this.mouseX - 20;
        int n2 = this.height - this.mouseY - 20;
        int n3 = 0;
        while (n3 < 4) {
            this.crowbar.view(n3);
            if (n3 == this.targetView) {
                this.crowbar.cv.frameColor(-65536);
            } else {
                this.crowbar.cv.frameColor(-16777216);
            }
            this.crowbar.cv.clrView();
            this.crowbar.cv.stroke(-16777216);
            this.crowbar.cv.fill(-1);
            this.crowbar.cv.line(0.0f, 0.0f, 1000.0f, 0.0f);
            this.crowbar.cv.line(0.0f, 0.0f, 0.0f, 1000.0f);
            this.crowbar.cv.ellipse(0.0f, 0.0f, 20.0f);
            switch (n3) {
                case 1: {
                    this.crowbar.cv.triangleC(n, n2, 50.0f, (float)Math.PI);
                    this.crowbar.cv.textColor(-65536);
                    break;
                }
                case 3: {
                    this.crowbar.cv.triangleC(n, n2, 50.0f);
                    this.crowbar.cv.textColor(-1);
                    break;
                }
                default: {
                    this.crowbar.cv.ellipse(n, n2, 50.0f);
                    this.crowbar.cv.textColor(-16777216);
                }
            }
            this.crowbar.cv.stroke(-12566464);
            this.crowbar.cv.line(0.0f, 0.0f, n, n2);
            this.crowbar.cv.text("Mouse(", 50.0f, 50.0f);
            this.crowbar.cv.text(TestSpace.str((int)this.mouseX));
            this.crowbar.cv.text(",");
            this.crowbar.cv.text(TestSpace.str((int)this.mouseY));
            this.crowbar.cv.text(")");
            ++n3;
        }
        this.crowbar._clrscr();
        this.fill(-8355840);
        this.stroke(-16777216);
        this.ellipse(this.mouseX, this.mouseY, 50.0f, 50.0f);
        this.line(0.0f, 0.0f, this.mouseX, this.mouseY);
        this.crowbar._write(this.cx, this.cy, "Mouse(");
        this.crowbar._write(TestSpace.str((int)this.mouseX));
        this.crowbar._write(",");
        this.crowbar._write(TestSpace.str((int)this.mouseY));
        this.crowbar._write(")");
        this.crowbar._write(this.cx, this.cy + 1, "[1] [2] [3] [4]");
        this.crowbar._write(this.cx, this.cy + 2, "\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u5207\u308a\u66ff\u3048");
        this.crowbar._write(this.cx, this.cy + 3, "\u30de\u30a6\u30b9\u53f3\u30af\u30ea\u30c3\u30af\uff1a\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u9078\u629e");
        this.crowbar._write(this.cx, this.cy + 4, "\u30de\u30a6\u30b9\u5de6\u30af\u30ea\u30c3\u30af\uff1a\u30de\u30fc\u30af\u8868\u793a");
        this.crowbar._write(this.cx, this.cy + 5, "[C]: \u30de\u30fc\u30af\u8868\u793a\u753b\u9762\u306e\u6d88\u53bb");
        this.crowbar._write(this.cx, this.cy + 6, "[T]: \u6700\u4e0a\u9762\u3078 [B]: \u6700\u4e0b\u9762\u3078");
        this.crowbar._write(this.cx, this.cy + 7, "\u30ab\u30fc\u30bd\u30eb\u30ad\u30fc: \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u79fb\u52d5");
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#D4D0C8", "TestSpace"});
    }

    class arguments {
        boolean ready = false;
        String message = "";
        String value = "";
        String initialValue = "";
        String[] selectValues = null;
        char parameterType = (char)65;

        arguments() {
        }

        public void set(String string) {
            this.value = string;
            this.ready = true;
        }
    }

    class consoleClass
    extends tomahawkClass {
        protected float cx;
        protected float cy;
        protected float tabSize;
        screenClass screenSetting;
        protected textAttrClass currentAttr;
        protected boolean nodisplay;
        protected boolean noTextArea;
        protected boolean noOverlap;
        textbufferClass textbuffer;
        private boolean recordTextBuffer;
        protected int autoScrollLines;
        keyInputConstraintClass keyCheck;
        loggingClass logging;
        private boolean enableLogging;
        private String keyBuffer;
        boolean inputNow;
        boolean inputFixed;

        consoleClass(int n, int n2, int n3) {
            super(n3);
            this.cx = 0.0f;
            this.cy = 0.0f;
            this.tabSize = TestSpace.this._TABSIZE;
            this.nodisplay = false;
            this.noTextArea = false;
            this.noOverlap = false;
            this.keyBuffer = "";
            this.inputNow = false;
            this.inputFixed = false;
            this.currentAttr = new textAttrClass();
            this.screenSetting = new screenClass(n, n2, this.currentAttr.fontSize);
            this.screenReset();
            this.setColor(this.currentAttr.textColor, this.currentAttr.bgColor);
            this.textbuffer = new textbufferClass(this.screenSetting, this.currentAttr);
            this.recordTextBuffer = true;
            this.autoScrollLines = 0;
            this.keyCheck = new keyInputConstraintClass();
            this.logging = new loggingClass();
            this.enableLogging = false;
        }

        public void prepareFont() {
            if (this.tomahawkMode == 2) {
                PFont pFont = TestSpace.this.createFont(TestSpace.this._FONTNAME, this.currentAttr.fontSize, false);
                this.screenSetting.pgText.beginDraw();
                this.screenSetting.pgText.textFont(pFont);
                this.screenSetting.pgText.textMode(256);
                this.screenSetting.pgText.textSize((float)this.currentAttr.fontSize);
                this.screenSetting.pgText.textAlign(37, 101);
                this.screenSetting.pgText.endDraw();
            } else {
                PFont pFont = TestSpace.this.createFont(TestSpace.this._FONTNAME, this.currentAttr.fontSize, true);
                TestSpace.this.textFont(pFont);
                TestSpace.this.textSize(this.currentAttr.fontSize);
                TestSpace.this.textAlign(37, 101);
            }
        }

        public void _setFontSize(int n) {
            if (n <= 0) {
                return;
            }
            this.currentAttr.fontSize = n;
            this.textbuffer.fontSize = n;
            this.screenSetting.reCalc(n);
        }

        public void screenReset() {
            TestSpace.this.size(this.screenSetting.gwx, this.screenSetting.gwy);
            this.screenSetting.pgText = this.tomahawkMode == 2 ? TestSpace.this.createGraphics(this.screenSetting.gwx, this.screenSetting.gwy, "processing.core.PGraphics3D") : null;
            this._clrscr();
            this.prepareFont();
        }

        private int ptx(float f) {
            return PApplet.parseInt((float)(f * (float)this.screenSetting.colwidth + (float)this.screenSetting.frameWidth));
        }

        private int pty(float f) {
            return PApplet.parseInt((float)(f * (float)this.screenSetting.rowheight + (float)this.screenSetting.frameWidth));
        }

        public void locate(int n, int n2) {
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.cx = n;
            this.cy = n2;
        }

        private boolean rowCheck() {
            if (this.cy >= (float)this.screenSetting.cheight) {
                if (this.autoScrollLines == 0) {
                    this._clrscr();
                    this.textbuffer.readingLine += this.screenSetting.cheight;
                } else {
                    this.stopRecordTextBuffer();
                    this.pageLineScroll(this.autoScrollLines);
                    this.startRecordTextBuffer();
                }
                return true;
            }
            return false;
        }

        public void backSpace() {
            if (this.keyBufferLength() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
                this.writeBS();
            }
        }

        private void writeBS() {
            if (this.cx <= 0.0f) {
                return;
            }
            if (!this.nodisplay) {
                this.cx -= 0.5f;
                if (this.tomahawkMode == 2) {
                    this.resetAlpha(this.ptx(this.cx), this.pty(this.cy), this.screenSetting.colwidth / 2, this.screenSetting.rowheight, true);
                } else {
                    TestSpace.this.noStroke();
                    TestSpace.this.fill(this.currentAttr.bgColor);
                    TestSpace.this.rect(this.ptx(this.cx), this.pty(this.cy), this.screenSetting.colwidth / 2, this.screenSetting.rowheight);
                    TestSpace.this.fill(this.currentAttr.textColor, 255.0f);
                }
            }
        }

        private float charLength(char c) {
            if (this.tomahawkMode == 2) {
                return this.screenSetting.pgText.textWidth(c) / (float)this.currentAttr.fontSize;
            }
            return TestSpace.this.textWidth(c) / (float)this.currentAttr.fontSize;
        }

        private float getStringWidth(String string) {
            if (this.tomahawkMode == 2) {
                return this.screenSetting.pgText.textWidth(string) / (float)this.currentAttr.fontSize;
            }
            return TestSpace.this.textWidth(string) / (float)this.currentAttr.fontSize;
        }

        public void resetAlpha(int n, int n2, int n3, int n4, boolean bl) {
            this.screenSetting.pgText.beginDraw();
            PImage pImage = this.screenSetting.pgText.get(n, n2, n3, n4);
            int n5 = 0;
            while (n5 < pImage.pixels.length) {
                if (bl) {
                    pImage.pixels[n5] = TestSpace.this.color(-16777216, 0);
                } else {
                    int n6 = pImage.pixels[n5] & 0xFFFFFF;
                    if (n6 <= 0) {
                        pImage.pixels[n5] = TestSpace.this.color(n6, 0);
                    }
                }
                ++n5;
            }
            this.screenSetting.pgText.set(n, n2, pImage);
            this.screenSetting.pgText.endDraw();
        }

        private void putchar(char c) {
            int n = this.ptx(this.cx);
            int n2 = this.pty(this.cy);
            if (this.tomahawkMode == 2) {
                this.screenSetting.pgText.beginDraw();
                this.screenSetting.pgText.text(c, (float)n, (float)n2);
                this.screenSetting.pgText.endDraw();
                this.resetAlpha(n, n2 - 2, this.currentAttr.fontSize * 2, this.currentAttr.fontSize + 4, false);
            } else {
                TestSpace.this.text(c, n, n2);
            }
            this.cx += this.charLength(c);
        }

        public void stopRecordTextBuffer() {
            this.recordTextBuffer = false;
        }

        public void startRecordTextBuffer() {
            this.recordTextBuffer = true;
        }

        public void redrawPage() {
            textAttrClass textAttrClass2 = new textAttrClass();
            textAttrClass2.clone(this.currentAttr);
            this.redrawPage(this.textbuffer.readingLine);
            this.currentAttr.clone(textAttrClass2);
        }

        public void redrawPage(int n) {
            this.textbuffer.incrementReadingLine(0);
            this._clrscr();
            lineClass lineClass2 = this.textbuffer.getTargetLine(n);
            boolean bl = this.noOverlap;
            this.disableOverlap();
            int n2 = 0;
            while (n2 < this.screenSetting.cheight) {
                if (!lineClass2.flag) break;
                int n3 = this.writelnText(lineClass2.line);
                lineClass2 = lineClass2.next;
                n2 += n3;
            }
            this.noOverlap = bl;
        }

        public void pageScroll(float f) {
            this.textbuffer.incrementReadingLine(PApplet.parseInt((float)((float)this.screenSetting.cheight * f)));
            this.redrawPage();
        }

        public void pageLineScroll(int n) {
            this.textbuffer.incrementReadingLine(n);
            this.redrawPage();
        }

        public void redrawNewestPage() {
            if (this.textbuffer.totalLines < this.screenSetting.cheight) {
                this.textbuffer.setReadingLine(0);
            } else {
                this.textbuffer.setReadingLine(this.textbuffer.totalLines - PApplet.parseInt((float)((float)this.screenSetting.cheight / 2.0f)));
            }
            this.redrawPage();
        }

        public int writelnText(sentenceClass sentenceClass2) {
            int n = 1;
            while (true) {
                this.textColor(sentenceClass2.attr.textColor);
                if (this.tomahawkMode == 2) {
                    this.screenSetting.pgText.beginDraw();
                    this.screenSetting.pgText.fill(sentenceClass2.attr.textColor, 255.0f);
                    this.screenSetting.pgText.endDraw();
                } else {
                    TestSpace.this.fill(sentenceClass2.attr.textColor, 255.0f);
                }
                int n2 = this.write(sentenceClass2.sentence);
                if (n2 > 1) {
                    n += n2 - 1;
                }
                if (sentenceClass2.next == null) break;
                sentenceClass2 = sentenceClass2.next;
            }
            this.writeln("");
            return n;
        }

        public void setColor(int n, int n2) {
            this.textColor(n);
            this.bgColor(n2);
        }

        public int textColor() {
            return this.currentAttr.textColor;
        }

        public int textColor(int n) {
            int n2 = this.currentAttr.textColor;
            if (TestSpace.this.brightness(n) <= 2.0f) {
                n = -16777214;
            }
            this.currentAttr.textColor = n;
            if (this.tomahawkMode == 2) {
                this.screenSetting.pgText.beginDraw();
                this.screenSetting.pgText.fill(this.currentAttr.textColor, 255.0f);
                this.screenSetting.pgText.endDraw();
            } else {
                TestSpace.this.fill(this.currentAttr.textColor);
            }
            return n2;
        }

        public int bgColor() {
            return this.currentAttr.bgColor;
        }

        public int bgColor(int n) {
            int n2 = this.currentAttr.bgColor;
            this.currentAttr.bgColor = n;
            return n2;
        }

        public float tabSize() {
            return this.tabSize;
        }

        public float tabSize(float f) {
            float f2 = this.tabSize;
            if (f < 0.0f || f >= (float)this.screenSetting.cwidth) {
                return f2;
            }
            this.tabSize = f;
            return f2;
        }

        public String getTabSpace() {
            String string = "";
            float f = PApplet.parseInt((float)((this.cx + this.tabSize) % this.tabSize * 2.0f));
            if (f == 0.0f) {
                return "";
            }
            f = (float)PApplet.parseInt((float)(this.tabSize * 2.0f)) - f;
            int n = 0;
            while ((float)n < f) {
                string = String.valueOf(string) + " ";
                ++n;
            }
            return string;
        }

        public float tab(boolean bl) {
            String string = this.getTabSpace();
            if (bl) {
                this.write(string);
            } else {
                this._write(string);
            }
            return (float)string.length() / 0.5f;
        }

        public float tab(float f, boolean bl) {
            float f2 = this.tabSize;
            this.tabSize = f;
            float f3 = this.tab(bl);
            this.tabSize = f2;
            return f3;
        }

        public float tab() {
            return this.tab(true);
        }

        public float _tab() {
            return this.tab(false);
        }

        public float tab(float f) {
            return this.tab(f, true);
        }

        public float _tab(float f) {
            return this.tab(f, false);
        }

        public void _clrscr() {
            if (this.tomahawkMode == 2) {
                TestSpace.this.background(this.currentAttr.bgColor);
                this.screenSetting.pgText.beginDraw();
                this.screenSetting.pgText.background(-16777216, 0.0f);
                this.screenSetting.pgText.fill(this.currentAttr.textColor, 255.0f);
                this.screenSetting.pgText.endDraw();
            } else {
                TestSpace.this.background(TestSpace.this._BGCOLOR);
                TestSpace.this.fill(this.currentAttr.textColor);
            }
            this.cy = 0.0f;
            this.cx = 0.0f;
        }

        public void clrscr() {
            this._clrscr();
            this.textbuffer.clearTextBuffer();
        }

        public int _write(String string) {
            int n = 1;
            if (this.tomahawkMode == 2) {
                this.screenSetting.pgText.beginDraw();
                this.screenSetting.pgText.fill(this.currentAttr.textColor, 255.0f);
                this.screenSetting.pgText.endDraw();
            } else {
                TestSpace.this.fill(this.currentAttr.textColor);
            }
            this.rowCheck();
            int n2 = 0;
            while (n2 < string.length()) {
                this.putchar(string.charAt(n2));
                if (!this.noOverlap && this.cx >= (float)this.screenSetting.cwidth) {
                    this.cx = 0.0f;
                    this.cy += 1.0f;
                    ++n;
                    this.rowCheck();
                }
                ++n2;
            }
            return n;
        }

        public int _write(int n, int n2, String string) {
            this.locate(n, n2);
            return this._write(string);
        }

        public int _writeln(String string) {
            int n = this._write(string);
            this.cy += 1.0f;
            this.cx = 0.0f;
            return n;
        }

        public int _writeln(int n, int n2, String string) {
            this.locate(n, n2);
            return this._writeln(string);
        }

        public int write(String string) {
            int n = 0;
            if (!this.nodisplay) {
                this.rowCheck();
                n = this._write(string);
                if (this.recordTextBuffer) {
                    this.textbuffer.appendSentence(string, this.currentAttr);
                    if (!this.noOverlap) {
                        this.textbuffer.normalizeBuffer();
                    }
                }
            }
            if (!this.noTextArea && this.recordTextBuffer) {
                TestSpace.print((String)string);
            }
            if (this.enableLogging) {
                this.print2Log(string);
            }
            return n;
        }

        public int write(int n, int n2, String string) {
            boolean bl = this.displaySwitch();
            this.disableDisplay();
            this.locate(n, n2);
            int n3 = this.write(string);
            this.displaySwitch(bl);
            return n3;
        }

        public int writeln(String string) {
            int n = this.write(string);
            if (!this.nodisplay) {
                if (this.recordTextBuffer) {
                    this.textbuffer.setLine(!this.noOverlap);
                }
                this.cy += 1.0f;
                this.cx = 0.0f;
            }
            if (!this.noTextArea && this.recordTextBuffer) {
                TestSpace.println();
            }
            if (this.enableLogging) {
                this.println2Log("");
            }
            return n;
        }

        public int writeln(int n, int n2, String string) {
            boolean bl = this.displaySwitch();
            this.disableDisplay();
            this.locate(n, n2);
            int n3 = this.writeln(string);
            this.displaySwitch(bl);
            return n3;
        }

        public void newline() {
            this.writeln("");
        }

        public void windowSize(int n, int n2) {
            this.screenSetting.gwx = n;
            this.screenSetting.gwy = n2;
            TestSpace.this.size(this.screenSetting.gwx, this.screenSetting.gwy);
        }

        public boolean displaySwitch() {
            return this.nodisplay;
        }

        public boolean displaySwitch(boolean bl) {
            boolean bl2 = this.nodisplay;
            this.nodisplay = bl;
            return bl2;
        }

        public void disableDisplay() {
            this.nodisplay = true;
        }

        public void enableDisplay() {
            this.nodisplay = false;
        }

        public boolean textAreaSwitch() {
            return this.noTextArea;
        }

        public boolean textAreaSwitch(boolean bl) {
            boolean bl2 = this.noTextArea;
            this.noTextArea = bl;
            return bl2;
        }

        public void disableTextArea() {
            this.noTextArea = true;
        }

        public void enableTextArea() {
            this.noTextArea = false;
        }

        public boolean overlapSwitch() {
            return this.noOverlap;
        }

        public boolean overlapSwitch(boolean bl) {
            boolean bl2 = this.noOverlap;
            this.noOverlap = bl;
            return bl2;
        }

        public void disableOverlap() {
            this.noOverlap = true;
        }

        public void enableOverlap() {
            this.noOverlap = false;
        }

        public String setDefaultFilename() {
            return this.logging.setDefaultFilename();
        }

        public String setDefaultFilename(String string) {
            if (string.length() == 0) {
                return this.setDefaultFilename();
            }
            return this.logging.setDefaultFilename(string);
        }

        public PrintWriter startLogging() {
            return this.startLogging("");
        }

        public PrintWriter startLogging(String string) {
            this.logging.setFileName(string);
            TestSpace.println((String)("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\uff1a" + this.logging.logFileName));
            return this.logging.startLogging();
        }

        public void stopLogging() {
            this.logging.stopLogging();
        }

        public void pauseLogging() {
            this.logging.pauseLogging();
        }

        public void restartLogging() {
            this.logging.restartLogging();
        }

        public void print2Log(String string) {
            this.logging.print2Log(string);
        }

        public void println2Log(String string) {
            this.logging.println2Log(string);
        }

        public void newline2Log() {
            this.logging.newline2Log();
        }

        public void enableLogOutput() {
            this.enableLogging = true;
        }

        public void disableLogOutput() {
            this.enableLogging = false;
        }

        public boolean isEnableLogging() {
            return this.logging.isEnableLogging();
        }

        public void flushKeyBuffer() {
            this.keyBuffer = "";
            this.inputFixed = false;
        }

        public int keyBufferLength() {
            return this.keyBuffer.length();
        }

        public void startInput() {
            this.inputFixed = false;
            this.inputNow = true;
        }

        public void inputFinish() {
            this.inputFixed = true;
            this.inputNow = false;
        }

        public void strcat(String string) {
            this.keyBuffer = String.valueOf(this.keyBuffer) + string;
        }

        public String getKeyBuffer() {
            String string = this.keyBuffer;
            this.keyBuffer = "";
            this.inputNow = false;
            this.inputFixed = false;
            return string;
        }
    }

    class crowbarClass
    extends frontendClass {
        int status;
        String[] comment;
        protected boolean halt;
        protected boolean noShowParams;
        protected boolean _noShowParams;
        boolean running;
        boolean afterRunning;
        protected boolean nonstop;
        protected boolean _nonstop;
        private boolean userDrawLoop;
        private boolean _userDrawLoop;

        crowbarClass(int n, int n2, int n3) {
            super(n, n2, n3);
            this.status = 0;
            this.noShowParams = false;
            this._noShowParams = false;
            this.running = false;
            this.afterRunning = false;
            this.nonstop = false;
            this._nonstop = false;
            this.userDrawLoop = true;
            this._userDrawLoop = true;
            this.comment = null;
            this.halt = false;
        }

        public void showAllParameters() {
            int n = this.readArgIndex;
            if (this.noShowParams) {
                return;
            }
            int n2 = 0;
            while (n2 < this.argc) {
                if (!this.argv[n2].ready) break;
                this.write(String.valueOf(this.get_paramMessage(n2)) + "\uff1a[");
                this.write(this.getStr(n2));
                this.writeln("]");
                ++n2;
            }
            this.readArgIndex = n;
        }

        public void showAllParameters2Log() {
            boolean bl = this.nodisplay;
            boolean bl2 = this.noTextArea;
            this.disableDisplay();
            this.disableTextArea();
            this.showAllParameters();
            if (!bl) {
                this.enableDisplay();
            }
            if (!bl2) {
                this.enableTextArea();
            }
        }

        public void noShowParameters() {
            this.noShowParams = true;
        }

        public void showParameters() {
            this.noShowParams = false;
        }

        public void nonStop() {
            this.nonstop = true;
        }

        public void stop() {
            this.nonstop = false;
        }

        public void loop() {
            this.userDrawLoop = true;
        }

        public void noLoop() {
            this.userDrawLoop = false;
        }

        public void halt() {
            this.halt = true;
            this.status = 99;
        }

        public void outputProgramComments() {
            int n = this.comment.length;
            int n2 = 0;
            while (n2 < n) {
                this.writeln(this.comment[n2]);
                ++n2;
            }
        }

        public void programComment(String string) {
            String[] stringArray = new String[]{string};
            if (this.comment == null) {
                this.comment = new String[1];
                this.comment = stringArray;
            } else {
                this.comment = TestSpace.concat((String[])this.comment, (String[])stringArray);
            }
        }

        public int fontSize() {
            return this.currentAttr.fontSize;
        }

        public int fontSize(int n) {
            int n2 = this.currentAttr.fontSize;
            if (this.status == 0) {
                this._setFontSize(n);
            }
            return n2;
        }

        public void autoScrollLines(int n) {
            if (this.status != 0) {
                return;
            }
            if (n < 0) {
                n = 0;
            }
            if (n > this.screenSetting.cheight) {
                n = 0;
            }
            this.autoScrollLines = n;
        }

        public void autoScrollPage(float f) {
            if (this.status != 0) {
                return;
            }
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.autoScrollLines(PApplet.parseInt((float)((float)this.screenSetting.cheight * f)));
        }

        public float hStep() {
            return this.screenSetting.hStep;
        }

        public float hStep(float f) {
            float f2 = this.screenSetting.hStep;
            if (f <= 0.0f) {
                return f2;
            }
            if (this.status == 0) {
                this.screenSetting.hStep = f;
                this.screenSetting.reCalc(this.fontSize());
                this.screenReset();
            }
            return f2;
        }

        public float vStep() {
            return this.screenSetting.vStep;
        }

        public float vStep(float f) {
            float f2 = this.screenSetting.vStep;
            if (f <= 0.0f) {
                return f2;
            }
            if (this.status == 0) {
                this.screenSetting.vStep = f;
                this.screenSetting.reCalc(this.fontSize());
                this.screenReset();
            }
            return f2;
        }
    }

    class currentDrawingClass {
        boolean isFill;
        int fillColor;
        int fillTrans;
        boolean isStroke;
        int strokeColor;
        int strokeTrans;
        int textColor;
        int vpx;
        int vpy;
        float wpx;
        float wpy;

        currentDrawingClass() {
            this.setDefault();
        }

        public void clone(currentDrawingClass currentDrawingClass2) {
            this.isFill = currentDrawingClass2.isFill;
            this.fillColor = currentDrawingClass2.fillColor;
            this.fillTrans = currentDrawingClass2.fillTrans;
            this.isStroke = currentDrawingClass2.isStroke;
            this.strokeColor = currentDrawingClass2.strokeColor;
            this.strokeTrans = currentDrawingClass2.strokeTrans;
            this.textColor = currentDrawingClass2.textColor;
            this.vpx = currentDrawingClass2.vpx;
            this.vpy = currentDrawingClass2.vpy;
            this.wpx = currentDrawingClass2.wpx;
            this.wpy = currentDrawingClass2.wpy;
        }

        public void setDefault() {
            this.isFill = true;
            this.fillColor = -1;
            this.fillTrans = 255;
            this.isStroke = true;
            this.strokeColor = -16777216;
            this.strokeTrans = 255;
            this.textColor = this.fillColor;
            this.vpy = 0;
            this.vpx = 0;
            this.wpy = 0.0f;
            this.wpx = 0.0f;
        }
    }

    class frontendClass
    extends consoleClass {
        arguments[] argv;
        int argc;
        protected int obtainArgIndex;
        protected int readArgIndex;
        protected boolean autoInput;

        frontendClass(int n, int n2, int n3) {
            super(n, n2, n3);
            this.obtainArgIndex = 0;
            this.readArgIndex = 0;
            this.autoInput = false;
            this.argc = 0;
            this.argv = new arguments[1];
            this.argv[0] = new arguments();
        }

        public void setValue(String string) {
            this.argv[this.obtainArgIndex].set(string);
        }

        public boolean is_numbersOnly() {
            return this.argv[this.obtainArgIndex].parameterType == 'N';
        }

        public int is_selectOnly() {
            arguments arguments2 = this.argv[this.obtainArgIndex];
            if (arguments2.parameterType == 'S') {
                if (arguments2.selectValues == null) {
                    TestSpace.println((String)"SystemError: \u9078\u629e\u80a2\u578b\u306a\u306e\u306b\u9078\u629e\u80a2\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e");
                    return 99;
                }
                if (arguments2.selectValues.length > 10) {
                    TestSpace.println((String)"SystemError: \u9078\u629e\u80a2\u578b\u306e\u9078\u629e\u80a2\u306e\u6570\u304c\uff11\uff10\u500b\u3088\u308a\u591a\u3044\uff0e");
                    return 99;
                }
                return arguments2.selectValues.length;
            }
            return 0;
        }

        public String get_selectValue(int n) {
            return this.argv[this.obtainArgIndex].selectValues[n];
        }

        public String get_initialValue() {
            return this.argv[this.obtainArgIndex].initialValue;
        }

        public boolean allReady() {
            if (this.argv == null) {
                return true;
            }
            int n = 0;
            while (n < this.argc) {
                if (!this.argv[n].ready) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public void allResetArguments() {
            int n = 0;
            while (n < this.argv.length) {
                this.argv[n].ready = false;
                ++n;
            }
            this.readArgIndex = 0;
            this.obtainArgIndex = 0;
        }

        public boolean isNoParameter() {
            return this.argc == 0;
        }

        public String get_paramMessage(int n) {
            if (n >= this.argc || n < 0) {
                TestSpace.println();
                TestSpace.print((String)"[\u8b66\u544a] \u30d1\u30e9\u30e1\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u306eIndex\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\uff01(Index=");
                TestSpace.println((String)(String.valueOf(TestSpace.str((int)n)) + ")"));
                return "";
            }
            arguments arguments2 = this.argv[n];
            String string = arguments2.message;
            if (arguments2.initialValue.length() > 0) {
                string = String.valueOf(string) + "\uff08\u521d\u671f\u5024\uff1a" + arguments2.initialValue + "\uff09";
            }
            if (arguments2.parameterType == 'N') {
                string = String.valueOf(string) + "\uff0f\u6570\u5b57\u306e\u307f";
            } else if (arguments2.parameterType == 'S') {
                string = String.valueOf(string) + "\uff0f\uff08";
                int n2 = 0;
                while (n2 < arguments2.selectValues.length) {
                    if (n2 > 0) {
                        string = String.valueOf(string) + ",";
                    }
                    string = String.valueOf(string) + TestSpace.str((int)n2) + ":" + arguments2.selectValues[n2];
                    ++n2;
                }
                string = String.valueOf(string) + "\uff09";
            }
            return string;
        }

        public void automaticInputByDefalutValue(boolean bl) {
            this.autoInput = bl;
        }

        public void define(String string) {
            this.defineStr(string);
            this.argv[this.argc - 1].parameterType = (char)78;
        }

        public void define(String string, String string2) {
            this.defineStr(string, string2);
            this.argv[this.argc - 1].parameterType = (char)78;
        }

        public void define(String string, float f) {
            this.define(string, TestSpace.str((float)f));
        }

        public void define(String string, int n) {
            this.define(string, TestSpace.str((int)n));
        }

        public void defineStr(String string) {
            if (TestSpace.this.crowbar.status != 0) {
                TestSpace.println((String)("\u30a8\u30e9\u30fc: \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\u306fOptions()\u304bSetup()\u3067\u884c\u3063\u3066\u4e0b\u3055\u3044\uff0f" + string));
                if (TestSpace.this.crowbar.status == 10) {
                    TestSpace.this.crowbar.halt();
                    return;
                }
                TestSpace.this.exit();
            }
            this.argc = this.argv.length;
            this.argv = (arguments[])TestSpace.expand((Object)this.argv, (int)(this.argc + 1));
            this.argv[this.argc] = new arguments();
            this.argv[this.argc - 1].message = string;
        }

        public void defineStr(String string, String string2) {
            this.defineStr(string);
            this.argv[this.argc - 1].initialValue = string2;
        }

        public void defineStr(String string, float f) {
            this.define(string, TestSpace.str((float)f));
        }

        public void defineStr(String string, int n) {
            this.define(string, TestSpace.str((int)n));
        }

        public void defineSel(String string, String string2) {
            if (string2.length() <= 0) {
                TestSpace.println((String)"Error: \u9078\u629e\u80a2\u578b\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u5ba3\u8a00\u306e\u7b2c\uff12\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u7a7a\u6587\u5b57\u5217\u3067\u3059\uff0e");
                TestSpace.this.crowbar.halt();
                return;
            }
            String[] stringArray = TestSpace.split((String)string2, (char)' ');
            if (stringArray.length > 10) {
                TestSpace.println((String)"Error: \u9078\u629e\u80a2\u578b\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u5ba3\u8a00\u306e\u9078\u629e\u80a2\u306e\u6570\u306f\uff11\uff10\u500b\u4ee5\u4e0b\u3067\u3059\uff0e");
                TestSpace.this.crowbar.halt();
                return;
            }
            this.defineStr(string);
            this.argv[this.argc - 1].parameterType = (char)83;
            this.argv[this.argc - 1].selectValues = stringArray;
        }

        public void defineSel(String string, String string2, int n) {
            this.defineSel(string, string2);
            if (n < 0) {
                TestSpace.println((String)"Error: \u9078\u629e\u80a2\u578b\u306e\u521d\u671f\u5024\u306f0\u304b\u30899\u306e\u6574\u6570\u3067\u3059\uff0e");
                TestSpace.this.crowbar.halt();
                return;
            }
            if (n >= this.argv[this.argc - 1].selectValues.length) {
                TestSpace.println((String)"Error: \u9078\u629e\u80a2\u578b\u306e\u521d\u671f\u5024\u306f0\u304b\u3089\u9078\u629e\u80a2\u306e\u6570-1\u307e\u3067\u3067\u3059\uff0e");
                TestSpace.this.crowbar.halt();
                return;
            }
            this.argv[this.argc - 1].initialValue = TestSpace.str((int)n);
        }

        public String getStr(int n) {
            if (n >= this.argc || n < 0) {
                TestSpace.println();
                TestSpace.print((String)"[\u8b66\u544a] \u30d1\u30e9\u30e1\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u306eIndex\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\uff01(Index=");
                TestSpace.println((String)(String.valueOf(TestSpace.str((int)n)) + ")"));
                return "";
            }
            this.readArgIndex = n + 1;
            return this.argv[n].value;
        }

        public float getFloat(int n) {
            return PApplet.parseFloat((String)this.getStr(n));
        }

        public int getInt(int n) {
            return PApplet.parseInt((String)this.getStr(n));
        }

        public String getStr() {
            return this.getStr(this.readArgIndex);
        }

        public float getFloat() {
            return this.getFloat(this.readArgIndex);
        }

        public int getInt() {
            return this.getInt(this.readArgIndex);
        }
    }

    class keyInputConstraintClass {
        private boolean point;
        private boolean sign;
        private boolean inputted;

        keyInputConstraintClass() {
            this.reset();
        }

        public void reset() {
            this.inputted = false;
            this.sign = false;
            this.point = false;
        }

        public boolean checkFloat(char c) {
            boolean bl = true;
            switch (c) {
                case '+': 
                case '-': {
                    if (this.sign || this.inputted) {
                        bl = false;
                        break;
                    }
                    this.sign = true;
                    break;
                }
                case '.': {
                    if (this.point || !this.inputted) {
                        bl = false;
                        break;
                    }
                    this.point = true;
                    break;
                }
                default: {
                    if (TestSpace.this.isNumberChar(c)) {
                        this.inputted = true;
                        break;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public boolean checkInt(char c) {
            if (c == '.') {
                return false;
            }
            return this.checkFloat(c);
        }
    }

    class lineClass {
        protected int no;
        sentenceClass line;
        protected boolean flag;
        protected boolean overlap;
        lineClass next;

        lineClass() {
            this.clear();
        }

        public void clear() {
            this.no = 0;
            this.line = null;
            this.flag = false;
            this.overlap = false;
            this.next = null;
        }

        public void set(sentenceClass sentenceClass2, boolean bl) {
            this.line = sentenceClass2;
            this.flag = true;
            this.overlap = bl;
            if (this.next == null) {
                this.next = new lineClass();
            }
            this.next.no = this.no + 1;
        }

        public void merge() {
            this.line.merge();
        }
    }

    class loggingClass {
        private String _defaultFileName = "default.txt";
        protected String logFileName = "";
        private boolean loggingNow = false;
        private PrintWriter output = null;

        loggingClass() {
        }

        public void setFileName(String string) {
            this.logFileName = string.length() > 0 ? string : this._defaultFileName;
        }

        public boolean isEnableLogging() {
            return this.output != null;
        }

        public void print2Log(String string) {
            if (this.loggingNow) {
                this.output.print(string);
            }
        }

        public void println2Log(String string) {
            if (this.loggingNow) {
                this.output.println(string);
            }
        }

        public void newline2Log() {
            this.println2Log("");
        }

        public String setDefaultFilename() {
            return this._defaultFileName;
        }

        public String setDefaultFilename(String string) {
            String string2 = this._defaultFileName;
            this._defaultFileName = string;
            return string2;
        }

        public PrintWriter startLogging() {
            if (this.output != null) {
                this.stopLogging();
            }
            this.output = TestSpace.this.createWriter(this.logFileName);
            this.loggingNow = true;
            this.println2Log("--- Logging start : " + TestSpace.this.nowDateTime() + "---");
            return this.output;
        }

        public void stopLogging() {
            if (this.output != null) {
                this.println2Log("--- Logging finished : " + TestSpace.this.nowDateTime() + "---");
                this.output.flush();
                this.output.close();
            }
            this.loggingNow = false;
            this.output = null;
        }

        public void pauseLogging() {
            this.loggingNow = false;
        }

        public void restartLogging() {
            if (this.output != null) {
                this.loggingNow = true;
            }
        }
    }

    class screenClass {
        protected int cwidth;
        protected int cheight;
        protected int gwx;
        protected int gwy;
        protected int colwidth;
        protected int rowheight;
        protected int frameWidth;
        protected float hStep;
        protected float vStep;
        protected PGraphics pgText;

        screenClass(int n, int n2, int n3) {
            this.cwidth = n;
            this.cheight = n2;
            this.frameWidth = 10;
            this.hStep = TestSpace.this._HSTEP;
            this.vStep = TestSpace.this._VSTEP;
            this.reCalc(n3);
        }

        public void setPgText(PGraphics pGraphics) {
            this.pgText = pGraphics;
        }

        public void reCalc(int n) {
            this.colwidth = PApplet.parseInt((float)((float)n * this.hStep));
            this.rowheight = PApplet.parseInt((float)((float)n * this.vStep));
            this.gwx = this.cwidth * this.colwidth + this.frameWidth * 2;
            this.gwy = this.cheight * this.rowheight + this.frameWidth * 2;
        }
    }

    class sentenceClass {
        protected String sentence;
        textAttrClass attr;
        sentenceClass next;

        sentenceClass(String string, textAttrClass textAttrClass2) {
            this.sentence = string;
            this.attr = new textAttrClass();
            this.next = null;
            this.attr.clone(textAttrClass2);
        }

        public void clearSentence(textAttrClass textAttrClass2) {
            this.sentence = "";
            this.attr.clone(textAttrClass2);
            this.next = null;
        }

        public void addSentence(String string, textAttrClass textAttrClass2) {
            if (this.next == null) {
                this.next = new sentenceClass(string, textAttrClass2);
            } else {
                this.next.addSentence(string, textAttrClass2);
            }
        }

        public void merge() {
            if (this.next == null) {
                return;
            }
            sentenceClass sentenceClass2 = this;
            while (sentenceClass2.next != null) {
                if (sentenceClass2.attr.checkTextAttr(sentenceClass2.next.attr) || sentenceClass2.sentence.length() == 0) {
                    sentenceClass2.sentence = String.valueOf(sentenceClass2.sentence) + sentenceClass2.next.sentence;
                    sentenceClass2.attr.clone(sentenceClass2.next.attr);
                    sentenceClass2.next = sentenceClass2.next.next;
                    continue;
                }
                sentenceClass2 = sentenceClass2.next;
            }
        }

        public sentenceClass split(int n) {
            sentenceClass sentenceClass2 = new sentenceClass("", this.attr);
            sentenceClass2.sentence = this.sentence.substring(n);
            this.sentence = this.sentence.substring(0, n);
            sentenceClass2.next = this.next;
            this.next = sentenceClass2;
            return sentenceClass2;
        }

        public int length() {
            if (this.next == null) {
                return this.sentence.length();
            }
            return this.next.length() + this.sentence.length();
        }

        public String getPlainText() {
            if (this.next == null) {
                return this.sentence;
            }
            return String.valueOf(this.sentence) + this.next.getPlainText();
        }
    }

    class textAttrClass {
        protected int textColor;
        protected int bgColor;
        protected int fontSize;

        textAttrClass() {
            this.init();
        }

        public void init() {
            this.fontSize = TestSpace.this._FONTSIZE;
            this.textColor = TestSpace.this._TEXTCOLOR;
            this.bgColor = TestSpace.this._BGCOLOR;
        }

        public void setTextColor(int n) {
            this.textColor = n;
        }

        public void setbgColor(int n) {
            this.bgColor = n;
        }

        public void setFontSize(int n) {
            this.fontSize = n;
        }

        public void clone(textAttrClass textAttrClass2) {
            this.fontSize = textAttrClass2.fontSize;
            this.textColor = textAttrClass2.textColor;
            this.bgColor = textAttrClass2.bgColor;
        }

        public boolean checkTextAttr(textAttrClass textAttrClass2) {
            if (textAttrClass2.fontSize != this.fontSize) {
                return false;
            }
            if (textAttrClass2.textColor != this.textColor) {
                return false;
            }
            return textAttrClass2.bgColor == this.bgColor;
        }
    }

    class textbufferClass {
        private int cwidth;
        private screenClass screenSetting;
        int fontSize;
        private lineClass topLine;
        lineClass currentWriteLine;
        textAttrClass currentAttr;
        protected int totalLines;
        protected int readingLine;
        private sentenceClass buff;

        textbufferClass(screenClass screenClass2, textAttrClass textAttrClass2) {
            this.screenSetting = screenClass2;
            this.cwidth = this.screenSetting.cwidth;
            this.fontSize = textAttrClass2.fontSize;
            this.currentWriteLine = this.topLine = new lineClass();
            this.currentAttr = new textAttrClass();
            this.totalLines = 0;
            this.readingLine = 0;
            this.buff = new sentenceClass("", this.currentAttr);
        }

        public void clearTextBuffer() {
            lineClass lineClass2 = this.topLine;
            while (lineClass2.next != null) {
                lineClass lineClass3 = lineClass2.next;
                lineClass2.clear();
                lineClass2 = lineClass3;
            }
            this.currentAttr.init();
            this.currentWriteLine = this.topLine;
            this.totalLines = 0;
            this.readingLine = 0;
            if (this.buff != null) {
                this.buff.clearSentence(this.currentAttr);
            }
        }

        public float getStringWidth(String string) {
            if (TestSpace.this.crowbar.tomahawkMode == 2) {
                return this.screenSetting.pgText.textWidth(string) / (float)this.fontSize;
            }
            return TestSpace.this.textWidth(string) / (float)this.fontSize;
        }

        public int convertStringWidth2Length(String string, int n) {
            int n2 = n - 1;
            while (n2 < string.length()) {
                if (this.getStringWidth(string.substring(0, n2 + 1)) > (float)n) break;
                ++n2;
            }
            return n2;
        }

        public void appendSentence(String string, textAttrClass textAttrClass2) {
            if (this.buff == null) {
                this.buff = new sentenceClass(string, textAttrClass2);
            } else {
                this.buff.addSentence(string, textAttrClass2);
            }
            this.currentAttr.clone(textAttrClass2);
        }

        public void _setLine(boolean bl) {
            this.currentWriteLine.set(this.buff, bl);
            this.currentWriteLine = this.currentWriteLine.next;
            ++this.totalLines;
        }

        public void setLine(boolean bl) {
            if (!bl) {
                this.buff.merge();
                this._setLine(false);
            } else {
                this.normalizeBuffer();
                this._setLine(false);
            }
            this.buff = new sentenceClass("", this.currentAttr);
        }

        public void normalizeBuffer() {
            if (this.getStringWidth(this.buff.getPlainText()) >= (float)this.cwidth) {
                this.buff.merge();
                float f = 0.0f;
                sentenceClass sentenceClass2 = this.buff;
                while (sentenceClass2 != null) {
                    if (f + this.getStringWidth(sentenceClass2.sentence) >= (float)this.cwidth) {
                        sentenceClass sentenceClass3 = sentenceClass2.split(this.convertStringWidth2Length(sentenceClass2.sentence, PApplet.parseInt((float)((float)this.cwidth - f))));
                        sentenceClass2.next = null;
                        this._setLine(true);
                        this.buff = sentenceClass3.sentence.length() == 0 ? sentenceClass3.next : sentenceClass3;
                        sentenceClass2 = this.buff;
                        f = 0.0f;
                        continue;
                    }
                    f += this.getStringWidth(sentenceClass2.sentence);
                    if (sentenceClass2.next == null) break;
                    sentenceClass2 = sentenceClass2.next;
                }
            }
        }

        public void flushBuffer(boolean bl) {
            if (this.buff.length() > 0) {
                this.setLine(bl);
            }
        }

        public lineClass getTargetLine(int n) {
            lineClass lineClass2 = this.topLine;
            int n2 = 0;
            while (n2 < n) {
                if (lineClass2.next == null || !lineClass2.flag) break;
                lineClass2 = lineClass2.next;
                ++n2;
            }
            return lineClass2;
        }

        public void setReadingLine(int n) {
            if (n < 0) {
                n = 0;
            }
            if (TestSpace.this.crowbar.afterRunning && n >= this.totalLines - 1) {
                n = this.totalLines - 1;
            }
            this.readingLine = n;
        }

        public void incrementReadingLine(int n) {
            this.setReadingLine(this.readingLine + n);
        }

        public void displayAllTextBuffer() {
            lineClass lineClass2 = this.topLine;
            int n = 0;
            TestSpace.println();
            TestSpace.println((String)"No.:(No.):flag:overlap:length[sentence1, sentence2, ...]");
            while (lineClass2 != null && lineClass2.line != null) {
                TestSpace.print((String)(String.valueOf(TestSpace.str((int)n)) + ":" + TestSpace.str((int)lineClass2.no) + ":" + TestSpace.str((boolean)lineClass2.flag) + ":" + TestSpace.str((boolean)lineClass2.overlap) + ":" + TestSpace.str((int)lineClass2.line.length())));
                TestSpace.print((String)"[");
                sentenceClass sentenceClass2 = lineClass2.line;
                while (true) {
                    TestSpace.print((String)TestSpace.hex((int)sentenceClass2.attr.textColor));
                    TestSpace.print((String)("(" + TestSpace.str((int)sentenceClass2.sentence.length()) + ")"));
                    TestSpace.print((String)",");
                    if (sentenceClass2.next == null) break;
                    sentenceClass2 = sentenceClass2.next;
                }
                TestSpace.println((String)"]");
                if (lineClass2.next == null) break;
                lineClass2 = lineClass2.next;
                ++n;
            }
        }
    }

    class tomahawkClass {
        protected int viewMax;
        protected int cvNumber;
        protected viewportClass cv;
        protected viewportClass[] viewStack = new viewportClass[1];
        protected viewportClass[] cloneStack;
        protected int tomahawkMode;

        tomahawkClass(int n) {
            this.viewStack[0] = null;
            this.cloneStack = new viewportClass[1];
            this.cloneStack[0] = null;
            this.cvNumber = 0;
            this.cv = null;
            this.viewMax = 0;
            this.tomahawkMode = n;
        }

        public void backupViewports() {
            if (this.cloneStack == null) {
                return;
            }
            int n = 0;
            while (n < this.viewMax) {
                this.cloneStack[n].clone(this.viewStack[n]);
                ++n;
            }
        }

        public void restoreViewports() {
            if (this.cloneStack == null) {
                return;
            }
            int n = 0;
            while (n < this.viewMax) {
                this.viewStack[n].clone(this.cloneStack[n]);
                ++n;
            }
        }

        public void displayAllViewData() {
            int n = 0;
            while (n < this.viewMax) {
                viewportClass viewportClass2 = this.viewStack[n];
                TestSpace.print((String)(String.valueOf(TestSpace.str((int)n)) + ":[" + TestSpace.str((int)viewportClass2.no) + "]" + viewportClass2.label + "/(" + TestSpace.str((int)viewportClass2.vx) + "," + TestSpace.str((int)viewportClass2.vy) + "," + TestSpace.str((int)viewportClass2.vwidth) + "," + TestSpace.str((int)viewportClass2.vheight) + ")"));
                TestSpace.print((String)("-(" + TestSpace.str((float)viewportClass2.wx_min) + "," + TestSpace.str((float)viewportClass2.wy_min) + "," + TestSpace.str((float)viewportClass2.wx_max) + "," + TestSpace.str((float)viewportClass2.wy_max) + ")"));
                TestSpace.print((String)(" Color=#" + TestSpace.hex((int)viewportClass2.viewBgColor()) + ":Ratio =[" + TestSpace.str((float)viewportClass2.pixelRatioX) + "," + TestSpace.str((float)viewportClass2.pixelRatioY) + "]:Scale=" + TestSpace.str((float)viewportClass2.scale())));
                TestSpace.print((String)(" Offset=" + TestSpace.str((float)viewportClass2.offsetX()) + "," + TestSpace.str((float)viewportClass2.offsetY()) + "Visible:" + TestSpace.str((boolean)viewportClass2.visible)));
                TestSpace.println();
                ++n;
            }
        }

        public int createView(String string, int n, int n2, int n3, int n4) {
            if (TestSpace.this.crowbar.status != 0) {
                TestSpace.println((String)"\u30a8\u30e9\u30fc\uff1a\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u4f5c\u6210\u306fOptions()\u304bSetup()\u5185\u3067\u884c\u306a\u3063\u3066\u4e0b\u3055\u3044\uff0e");
                TestSpace.this.exit();
            }
            if (this.viewMax > 0) {
                this.viewStack = (viewportClass[])TestSpace.expand((Object)this.viewStack, (int)(this.viewMax + 1));
                this.cloneStack = (viewportClass[])TestSpace.expand((Object)this.cloneStack, (int)(this.viewMax + 1));
            }
            if (this.viewStack.length != this.viewMax + 1) {
                return -1;
            }
            ++this.viewMax;
            this.cvNumber = this.viewMax - 1;
            this.cv = this.viewStack[this.cvNumber] = new viewportClass(string, n, n2, n3, n4);
            if (this.viewStack[this.cvNumber] == null) {
                return -1;
            }
            this.cloneStack[this.cvNumber] = new viewportClass(string, n, n2, n3, n4);
            this.viewStack[this.cvNumber].setNo(this.cvNumber);
            this.cv.fill(-1, this.cv.transparency);
            this.cv.stroke(-16777216, this.cv.transparency);
            this.cv.world(0.0f, 0.0f, n3, n4);
            return this.cvNumber;
        }

        public int createView(String string) {
            return this.createView(string, 0, 0, TestSpace.this.width, TestSpace.this.height);
        }

        public int splitViewH(int n, String string, float f) {
            if (f <= 0.0f || f >= 1.0f) {
                TestSpace.println((String)"\u30a8\u30e9\u30fc\uff1a\u5206\u5272\u5272\u5408\uff08\u7b2c\u4e8c\u5f15\u6570\uff09\u306f 0 < rate < 1.0\u306e\u7bc4\u56f2\u3067\u3057\u3066\u4e0b\u3055\u3044\uff0e");
                return -1;
            }
            if (!this.isValidViewNumber(n)) {
                TestSpace.println((String)("\u30a8\u30e9\u30fc\uff1a\u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u756a\u53f7\uff08\u7b2c\u4e00\u5f15\u6570\uff09\u306f\u4e0d\u6b63\u3067\u3059\uff0f" + TestSpace.str((int)n)));
                return -1;
            }
            viewportClass viewportClass2 = this.getView(n);
            int n2 = viewportClass2.vx;
            int n3 = viewportClass2.vy;
            int n4 = viewportClass2.vwidth;
            int n5 = viewportClass2.vheight;
            viewportClass2.vwidth = PApplet.parseInt((float)((float)n4 * f));
            this.cv.world(0.0f, 0.0f, viewportClass2.vwidth, viewportClass2.vheight);
            int n6 = n2 + viewportClass2.vwidth;
            int n7 = n3;
            int n8 = n4 - viewportClass2.vwidth;
            int n9 = n5;
            return this.createView(string, n6, n7, n8, n9);
        }

        public int splitViewH(String string, float f) {
            return this.splitViewH(this.cvNumber, string, f);
        }

        public int splitViewV(int n, String string, float f) {
            if (f <= 0.0f || f >= 1.0f) {
                TestSpace.println((String)"\u30a8\u30e9\u30fc\uff1a\u5206\u5272\u5272\u5408\uff08\u7b2c\u4e8c\u5f15\u6570\uff09\u306f 0 < rate < 1.0\u306e\u7bc4\u56f2\u3067\u3057\u3066\u4e0b\u3055\u3044\uff0e");
                return -1;
            }
            if (!this.isValidViewNumber(n)) {
                TestSpace.println((String)("\u30a8\u30e9\u30fc\uff1a\u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u756a\u53f7\uff08\u7b2c\u4e00\u5f15\u6570\uff09\u306f\u4e0d\u6b63\u3067\u3059\uff0f" + TestSpace.str((int)n)));
                return -1;
            }
            viewportClass viewportClass2 = this.getView(n);
            int n2 = viewportClass2.vx;
            int n3 = viewportClass2.vy;
            int n4 = viewportClass2.vwidth;
            int n5 = viewportClass2.vheight;
            viewportClass2.vheight = PApplet.parseInt((float)((float)n5 * f));
            this.cv.world(0.0f, 0.0f, viewportClass2.vwidth, viewportClass2.vheight);
            int n6 = n2;
            int n7 = n3 + viewportClass2.vheight;
            int n8 = n4;
            int n9 = n5 - viewportClass2.vheight;
            return this.createView(string, n6, n7, n8, n9);
        }

        public int splitViewV(String string, float f) {
            return this.splitViewV(this.cvNumber, string, f);
        }

        public boolean isValidViewNumber(int n) {
            if (n >= this.viewMax) {
                return false;
            }
            if (n < 0) {
                return false;
            }
            return n <= this.viewStack.length;
        }

        public int view() {
            return this.cvNumber;
        }

        public boolean view(int n) {
            if (!this.isValidViewNumber(n)) {
                return false;
            }
            this.cvNumber = n;
            this.cv = this.viewStack[this.cvNumber];
            return true;
        }

        public viewportClass getView(int n) {
            if (!this.isValidViewNumber(n)) {
                return null;
            }
            return this.viewStack[n];
        }

        public int nextView() {
            if (++this.cvNumber >= this.viewMax) {
                this.cvNumber = this.viewMax - 1;
            }
            this.view(this.cvNumber);
            return this.cvNumber;
        }

        public int prevView() {
            if (--this.cvNumber < 0) {
                this.cvNumber = 0;
            }
            this.view(this.cvNumber);
            return this.cvNumber;
        }

        public void firstView() {
            this.view(0);
        }

        public void lastView() {
            this.view(this.viewMax - 1);
        }

        public int[] getViewOrderList() {
            int[] nArray = new int[this.viewMax];
            int n = 0;
            while (n < this.viewMax) {
                nArray[this.viewStack[n].no] = n;
                ++n;
            }
            return nArray;
        }

        public void updateViewOrder(int[] nArray) {
            int n = 0;
            while (n < this.viewMax) {
                this.viewStack[nArray[n]].no = n;
                ++n;
            }
        }

        public void moveToTop(int n) {
            if (this.viewMax == 1) {
                return;
            }
            if (!this.isValidViewNumber(n)) {
                return;
            }
            int[] nArray = this.getViewOrderList();
            int n2 = this.viewStack[n].no;
            while (n2 < this.viewMax - 1) {
                nArray[n2] = nArray[n2 + 1];
                ++n2;
            }
            nArray[n2] = n;
            this.updateViewOrder(nArray);
        }

        public void moveToBottom(int n) {
            if (this.viewMax == 1) {
                return;
            }
            if (!this.isValidViewNumber(n)) {
                return;
            }
            int[] nArray = this.getViewOrderList();
            int n2 = this.viewStack[n].no;
            while (n2 > 0) {
                nArray[n2] = nArray[n2 - 1];
                --n2;
            }
            nArray[0] = n;
            this.updateViewOrder(nArray);
        }

        public void moveToTop() {
            this.moveToTop(this.cvNumber);
        }

        public void moveToBottom() {
            this.moveToBottom(this.cvNumber);
        }

        public int frameColor(int n) {
            if (!this.isValidViewNumber(n)) {
                return -1;
            }
            return this.getView((int)n).frameColor;
        }

        public int frameColor(int n, int n2) {
            if (!this.isValidViewNumber(n)) {
                return -1;
            }
            int n3 = this.frameColor(n);
            this.getView(n).frameColor(n2);
            return n3;
        }

        public void viewDrawFrame(int n, boolean bl) {
            if (!this.isValidViewNumber(n)) {
                return;
            }
            this.getView(n).drawFrame(bl);
        }

        public int transparency(int n) {
            if (!this.isValidViewNumber(n)) {
                return -1;
            }
            return this.getView(n).transparency();
        }

        public int transparency(int n, int n2) {
            if (!this.isValidViewNumber(n)) {
                return -1;
            }
            return this.getView(n).transparency(n2);
        }

        public int viewBgColor(int n) {
            if (!this.isValidViewNumber(n)) {
                return -1;
            }
            return this.getView(n).viewBgColor();
        }

        public int viewBgColor(int n, int n2) {
            if (!this.isValidViewNumber(n)) {
                return -1;
            }
            return this.getView(n).viewBgColor(n2);
        }

        public void transparentView(int n, boolean bl) {
            if (!this.isValidViewNumber(n)) {
                return;
            }
            this.getView(n).transparentView(bl);
        }

        public void moveView(int n, int n2, int n3) {
            if (!this.isValidViewNumber(n)) {
                return;
            }
            this.getView(n).moveView(n2, n3);
        }

        public void moveViewRel(int n, int n2, int n3) {
            if (!this.isValidViewNumber(n)) {
                return;
            }
            this.getView(n).moveViewRel(n2, n3);
        }

        private int _px(float f) {
            return this.cv._px(f);
        }

        private int _py(float f) {
            return this.cv._py(f);
        }

        private int px(float f) {
            return this.cv.px(f);
        }

        private int py(float f) {
            return this.cv.py(f);
        }

        public void clrAllView() {
            int n = this.cvNumber;
            int n2 = 0;
            while (n2 < this.viewMax) {
                this.clrView(n2);
                ++n2;
            }
            this.view(n);
        }

        public void clrView(int n) {
            if (!this.view(n)) {
                return;
            }
            this.view(n);
            this.cv.clrView();
        }

        public float scale(int n) {
            if (!this.isValidViewNumber(n)) {
                return 1.0f;
            }
            return this.getView(n).scale();
        }

        public float scale(int n, float f) {
            if (!this.isValidViewNumber(n)) {
                return 1.0f;
            }
            float f2 = this.getView(n).scale();
            this.getView(n).scale(f);
            return f2;
        }

        public void allScale(float f) {
            int n = 0;
            while (n < this.viewMax) {
                this.scale(n, f);
                ++n;
            }
        }

        public float offsetX(int n) {
            viewportClass viewportClass2 = this.getView(n);
            if (viewportClass2 == null) {
                return 0.0f;
            }
            return viewportClass2.offsetX;
        }

        public float offsetY(int n) {
            viewportClass viewportClass2 = this.getView(n);
            if (viewportClass2 == null) {
                return 0.0f;
            }
            return viewportClass2.offsetY;
        }

        public float offsetX(int n, float f) {
            viewportClass viewportClass2 = this.getView(n);
            if (viewportClass2 == null) {
                return 0.0f;
            }
            float f2 = viewportClass2.offsetX;
            viewportClass2.offsetX = f;
            return f2;
        }

        public float offsetY(int n, float f) {
            viewportClass viewportClass2 = this.getView(n);
            if (viewportClass2 == null) {
                return 0.0f;
            }
            float f2 = viewportClass2.offsetY;
            viewportClass2.offsetY = f;
            return f2;
        }

        public boolean offset(int n, float f, float f2) {
            viewportClass viewportClass2 = this.getView(n);
            if (viewportClass2 == null) {
                return false;
            }
            viewportClass2.offsetX = f;
            viewportClass2.offsetY = f2;
            return true;
        }

        public float world_minX(int n) {
            if (!this.isValidViewNumber(n)) {
                return 0.0f;
            }
            return this.getView((int)n).wx_min;
        }

        public float world_maxX(int n) {
            if (!this.isValidViewNumber(n)) {
                return 0.0f;
            }
            return this.getView((int)n).wx_max;
        }

        public float world_minY(int n) {
            if (!this.isValidViewNumber(n)) {
                return 0.0f;
            }
            return this.getView((int)n).wy_min;
        }

        public float world_maxY(int n) {
            if (!this.isValidViewNumber(n)) {
                return 0.0f;
            }
            return this.getView((int)n).wy_max;
        }

        public boolean world(int n, float f, float f2, float f3, float f4) {
            if (!this.isValidViewNumber(n)) {
                return false;
            }
            this.getView(n).world(f, f2, f3, f4);
            return true;
        }

        public boolean world_minX(int n, float f) {
            return this.world(n, f, this.world_maxX(n), this.world_minY(n), this.world_maxY(n));
        }

        public boolean world_maxX(int n, float f) {
            return this.world(n, this.world_minX(n), f, this.world_minY(n), this.world_maxY(n));
        }

        public boolean world_minY(int n, float f) {
            return this.world(n, this.world_minX(n), this.world_maxX(n), f, this.world_maxY(n));
        }

        public boolean world_maxY(int n, float f) {
            return this.world(n, this.world_minX(n), this.world_maxX(n), this.world_minY(n), f);
        }

        public boolean isVisible(int n) {
            if (!this.isValidViewNumber(n)) {
                return false;
            }
            return this.getView(n).isVisible();
        }

        public void visible(int n) {
            if (!this.isValidViewNumber(n)) {
                return;
            }
            this.getView(n).visible();
        }

        public void unVisible(int n) {
            if (!this.isValidViewNumber(n)) {
                return;
            }
            this.getView(n).unVisible();
        }

        public void changeVisible(int n, boolean bl) {
            if (!this.isValidViewNumber(n)) {
                return;
            }
            if (bl) {
                this.visible(n);
            } else {
                this.unVisible(n);
            }
        }

        public boolean toggleVisible(int n) {
            if (!this.isValidViewNumber(n)) {
                return false;
            }
            return this.getView(n).toggleVisible();
        }

        public int detectActiveView(int n, int n2) {
            return this.detectActiveView(n, n2, true);
        }

        public int detectActiveView(int n, int n2, boolean bl) {
            int[] nArray = this.getViewOrderList();
            int n3 = this.viewMax - 1;
            while (n3 >= 0) {
                block5: {
                    viewportClass viewportClass2;
                    block6: {
                        viewportClass2 = this.viewStack[nArray[n3]];
                        if (!viewportClass2.isVisible() || bl && viewportClass2.transparentView) break block5;
                        if (viewportClass2.transparency != 0) break block6;
                        if (bl) break block5;
                        viewportClass2.pg.beginDraw();
                        int n4 = viewportClass2.pg.get(n - viewportClass2.vx, n2 - viewportClass2.vy);
                        viewportClass2.pg.endDraw();
                        if ((n4 & 0xFF000000) == 0) break block5;
                    }
                    int n5 = viewportClass2.vx;
                    int n6 = viewportClass2.vy;
                    int n7 = n5 + viewportClass2.vwidth;
                    int n8 = n6 + viewportClass2.vheight;
                    if (n5 <= n && n <= n7 && n6 <= n2 && n2 <= n8) {
                        return nArray[n3];
                    }
                }
                --n3;
            }
            return -1;
        }

        public void refreshView() {
            if (this.tomahawkMode == 0) {
                return;
            }
            if (TestSpace.this.crowbar.status == 10) {
                int[] nArray = this.getViewOrderList();
                int n = 0;
                while (n < this.viewMax) {
                    viewportClass viewportClass2 = this.viewStack[nArray[n]];
                    if (viewportClass2.isVisible()) {
                        if (viewportClass2.drawFrame) {
                            viewportClass2.pg.beginDraw();
                            viewportClass2.pg.noFill();
                            viewportClass2.pg.stroke(viewportClass2.frameColor, 255.0f);
                            viewportClass2.pg.rect(0.0f, 0.0f, (float)(viewportClass2.vwidth - 1), (float)(viewportClass2.vheight - 1));
                            viewportClass2.pg.endDraw();
                        }
                        TestSpace.this.blend((PImage)viewportClass2.pg, 0, 0, viewportClass2.vwidth, viewportClass2.vheight, viewportClass2.vx, viewportClass2.vy, viewportClass2.vwidth, viewportClass2.vheight, 1);
                    }
                    ++n;
                }
            }
            if (this.tomahawkMode == 2) {
                TestSpace.this.blend((PImage)TestSpace.this.crowbar.screenSetting.pgText, 0, 0, TestSpace.this.crowbar.screenSetting.gwx, TestSpace.this.crowbar.screenSetting.gwy, 0, 0, TestSpace.this.crowbar.screenSetting.gwx, TestSpace.this.crowbar.screenSetting.gwy, 1);
            }
        }
    }

    class viewportClass {
        protected PGraphics pg;
        protected float wx_min;
        protected float wx_max;
        protected float wy_min;
        protected float wy_max;
        protected int vx;
        protected int vy;
        protected int vwidth;
        protected int vheight;
        boolean monoRatio;
        float pixelRatioX;
        float pixelRatioY;
        protected int bgColor;
        protected boolean transparentView;
        protected int transparency;
        boolean drawFrame;
        int frameColor;
        protected String label;
        protected int no;
        float magnification;
        float offsetX;
        float offsetY;
        protected boolean visible;
        currentDrawingClass cdSet;

        viewportClass(String string, int n, int n2, int n3, int n4) {
            this.vx = n;
            this.vy = n2;
            this.vwidth = n3;
            this.vheight = n4;
            this.monoRatio = true;
            this.world(0.0f, 0.0f, this.vwidth, this.vheight);
            this.bgColor = TestSpace.this._BGCOLOR;
            this.transparentView = false;
            this.drawFrame = true;
            this.transparency = 255;
            this.frameColor = -16777216;
            this.cdSet = new currentDrawingClass();
            this.magnification = 1.0f;
            this.offsetY = 0.0f;
            this.offsetX = 0.0f;
            this.label = string;
            this.no = -1;
            this.pg = TestSpace.this.createGraphics(this.vwidth, this.vheight, "processing.core.PGraphicsJava2D");
            this.pg.beginDraw();
            this.pg.smooth();
            this.pg.endDraw();
            this.visible = true;
        }

        public void clone(viewportClass viewportClass2) {
            this.vx = viewportClass2.vx;
            this.vy = viewportClass2.vy;
            this.vwidth = viewportClass2.vwidth;
            this.vheight = viewportClass2.vheight;
            this.monoRatio = viewportClass2.monoRatio;
            this.bgColor = viewportClass2.bgColor;
            this.transparentView = viewportClass2.transparentView;
            this.drawFrame = viewportClass2.drawFrame;
            this.transparency = viewportClass2.transparency;
            this.frameColor = viewportClass2.frameColor;
            this.cdSet.clone(viewportClass2.cdSet);
            this.magnification = viewportClass2.magnification;
            this.offsetX = viewportClass2.offsetX;
            this.offsetY = viewportClass2.offsetY;
            this.label = viewportClass2.label;
            this.no = viewportClass2.no;
            this.visible = viewportClass2.visible;
        }

        public void setNo(int n) {
            this.no = n;
        }

        public void calcPixelRatio() {
            float f = (float)this.vwidth / (this.wx_max - this.wx_min);
            float f2 = (float)this.vheight / (this.wy_max - this.wy_min);
            if (this.monoRatio) {
                if (f > f2) {
                    this.pixelRatioX = f2;
                    this.pixelRatioY = f2;
                } else {
                    this.pixelRatioX = f;
                    this.pixelRatioY = f;
                }
            } else {
                this.pixelRatioX = f;
                this.pixelRatioY = f2;
            }
        }

        public float world_minX() {
            return this.wx_min;
        }

        public float world_maxX() {
            return this.wx_max;
        }

        public float world_minY() {
            return this.wy_min;
        }

        public float world_maxY() {
            return this.wy_max;
        }

        public void world(float f, float f2, float f3, float f4) {
            if (f >= f3 || f2 >= f4) {
                TestSpace.println((String)"\u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u306e\u8a2d\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\uff08\u6700\u5c0f\u5024\u3068\u6700\u5927\u5024\u304c\u9006\u3067\u3059\uff09");
                TestSpace.this.exit();
            }
            this.wx_min = f;
            this.wy_min = f2;
            this.wx_max = f3;
            this.wy_max = f4;
            this.calcPixelRatio();
        }

        public float world_minX(float f) {
            float f2 = this.wx_min;
            this.world(f, this.wy_min, this.wx_max, this.wy_max);
            return f2;
        }

        public float world_minY(float f) {
            float f2 = this.wy_min;
            this.world(this.wx_min, f, this.wx_max, this.wy_max);
            return f2;
        }

        public float world_maxX(float f) {
            float f2 = this.wx_max;
            this.world(this.wx_min, this.wy_min, f, this.wy_max);
            return f2;
        }

        public float world_maxY(float f) {
            float f2 = this.wy_max;
            this.world(this.wx_min, this.wy_min, this.wx_max, f);
            return f2;
        }

        public int _px(float f) {
            return PApplet.parseInt((float)(f * this.magnification * this.pixelRatioX));
        }

        public int _py(float f) {
            return PApplet.parseInt((float)(f * this.magnification * this.pixelRatioY));
        }

        public int px(float f) {
            float f2 = (this.wx_max + this.wx_min) / 2.0f - this.offsetX;
            return PApplet.parseInt((float)((f - f2) * this.magnification * this.pixelRatioX)) + this.vwidth / 2;
        }

        public int py(float f) {
            float f2 = (this.wy_max + this.wy_min) / 2.0f - this.offsetY;
            return this.vheight - (PApplet.parseInt((float)((f - f2) * this.magnification * this.pixelRatioY)) + this.vheight / 2);
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void visible() {
            this.visible = true;
        }

        public void unVisible() {
            this.visible = false;
        }

        public void changeVisible(boolean bl) {
            if (bl) {
                this.visible();
            } else {
                this.unVisible();
            }
        }

        public boolean toggleVisible() {
            if (this.isVisible()) {
                this.unVisible();
                return false;
            }
            this.visible();
            return true;
        }

        public void moveView(int n, int n2) {
            this.vx = n;
            this.vy = n2;
        }

        public void moveViewRel(int n, int n2) {
            this.vx += n;
            this.vy += n2;
        }

        public int frameColor() {
            return this.frameColor;
        }

        public int frameColor(int n) {
            int n2 = this.frameColor();
            this.frameColor = n & 0xFFFFFFFF;
            return n2;
        }

        public void drawFrame(boolean bl) {
            this.drawFrame = bl;
        }

        public int transparency() {
            return this.transparency;
        }

        public int transparency(int n) {
            int n2 = this.transparency();
            if (n < 0) {
                n = 0;
            }
            if (n > 255) {
                n = 255;
            }
            this.cdSet.fillTrans = this.cdSet.strokeTrans = n;
            this.transparency = this.cdSet.strokeTrans;
            return n2;
        }

        public int viewBgColor() {
            return this.bgColor;
        }

        public int viewBgColor(int n) {
            int n2 = this.viewBgColor();
            this.bgColor = n & 0xFFFFFFFF;
            return n2;
        }

        public void transparentView(boolean bl) {
            this.transparentView = bl;
        }

        public float scale() {
            return this.magnification;
        }

        public float scale(float f) {
            if (f <= 0.0f) {
                f = 1.0f;
            }
            float f2 = this.scale();
            this.magnification = f;
            return f2;
        }

        public float offsetX() {
            return this.offsetX;
        }

        public float offsetY() {
            return this.offsetY;
        }

        public float offsetX(float f) {
            float f2 = this.offsetX();
            this.offsetX = f;
            return f2;
        }

        public float offsetY(float f) {
            float f2 = this.offsetY();
            this.offsetY = f;
            return f2;
        }

        public boolean offset(float f, float f2) {
            this.offsetX(f);
            this.offsetY(f2);
            return true;
        }

        public int fill() {
            return this.cdSet.fillColor;
        }

        public int fill(int n) {
            return this.fill(n, this.cdSet.fillTrans);
        }

        public int fill(int n, int n2) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            int n3 = this.fill();
            this.cdSet.fillColor = n & 0xFFFFFFFF;
            this.cdSet.fillTrans = n2;
            this.pg.beginDraw();
            this.pg.fill(this.cdSet.fillColor, (float)this.cdSet.fillTrans);
            this.pg.endDraw();
            this.cdSet.isFill = false;
            return n3;
        }

        public void noFill() {
            this.cdSet.isFill = false;
            this.pg.beginDraw();
            this.pg.noFill();
            this.pg.endDraw();
        }

        public void reFill() {
            this.fill(this.cdSet.fillColor, this.cdSet.fillTrans);
        }

        public int stroke() {
            return this.cdSet.strokeColor;
        }

        public int stroke(int n) {
            return this.stroke(n, this.cdSet.fillTrans);
        }

        public int stroke(int n, int n2) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > 255) {
                n2 = 255;
            }
            int n3 = this.stroke();
            this.cdSet.strokeColor = n & 0xFFFFFFFF;
            this.cdSet.strokeTrans = n2;
            this.pg.stroke(this.cdSet.strokeColor, (float)this.cdSet.strokeTrans);
            return n3;
        }

        public void noStroke() {
            this.cdSet.isStroke = false;
            this.pg.beginDraw();
            this.pg.noStroke();
            this.pg.endDraw();
        }

        public void reStroke() {
            this.stroke(this.cdSet.strokeColor, this.cdSet.strokeTrans);
        }

        public int getBgColor() {
            return this.bgColor;
        }

        public void clrView() {
            this.pg.beginDraw();
            if (this.transparentView) {
                this.pg.background(this.bgColor, 0.0f);
            } else {
                this.pg.background(this.bgColor, (float)this.transparency);
            }
            this.pg.endDraw();
        }

        public void _moveTo(int n, int n2) {
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void moveTo(float f, float f2) {
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void _moveToRel(int n, int n2) {
            this.cdSet.vpx += n;
            this.cdSet.vpy += n2;
        }

        public void moveToRel(float f, float f2) {
            this.cdSet.wpx += f;
            this.cdSet.wpy += f2;
        }

        public void _line(int n, int n2, int n3, int n4) {
            this.pg.beginDraw();
            this.pg.line((float)n, (float)n2, (float)n3, (float)n4);
            this.pg.endDraw();
            this.cdSet.vpx = n3;
            this.cdSet.vpy = n4;
        }

        public void line(float f, float f2, float f3, float f4) {
            this._line(this.px(f), this.py(f2), this.px(f3), this.py(f4));
            this.cdSet.wpx = f3;
            this.cdSet.wpy = f4;
        }

        public void _lineTo(int n, int n2) {
            this._line(this.cdSet.vpx, this.cdSet.vpy, n, n2);
        }

        public void lineTo(float f, float f2) {
            this.line(this.cdSet.wpx, this.cdSet.wpy, f, f2);
        }

        public void _lineRel(int n, int n2) {
            this._line(this.cdSet.vpx, this.cdSet.vpy, this.cdSet.vpx + n, this.cdSet.vpy + n2);
        }

        public void lineRel(float f, float f2) {
            this.line(this.cdSet.wpx, this.cdSet.wpy, this.cdSet.wpx + f, this.cdSet.wpy + f2);
        }

        public void _dashedLine(int n, int n2, int n3, int n4, int n5) {
            boolean bl = true;
            this.cdSet.vpx = n3;
            this.cdSet.vpy = n4;
            int n6 = PApplet.parseInt((float)(TestSpace.this.norm(n, n2, n3, n4) / (float)n5));
            if (n6 <= 0) {
                this._line(n, n2, n3, n4);
                return;
            }
            float f = n;
            float f2 = n2;
            int n7 = 0;
            while (n7 < n6) {
                float f3 = (float)n3 - f;
                float f4 = (float)n4 - f2;
                float f5 = TestSpace.sqrt((float)(f3 * f3 + f4 * f4));
                if (f5 < (float)n5) {
                    this._line(PApplet.parseInt((float)f), PApplet.parseInt((float)f2), n3, n4);
                    return;
                }
                float f6 = f3 / f5;
                float f7 = f4 / f5;
                float f8 = f + f6 * (float)n5;
                float f9 = f2 + f7 * (float)n5;
                if (bl) {
                    this._line(PApplet.parseInt((float)f), PApplet.parseInt((float)f2), PApplet.parseInt((float)f8), PApplet.parseInt((float)f9));
                }
                bl = !bl;
                f = f8;
                f2 = f9;
                ++n7;
            }
        }

        public void dashedLine(float f, float f2, float f3, float f4, float f5) {
            this._dashedLine(this.px(f), this.py(f2), this.px(f3), this.py(f4), PApplet.parseInt((float)((float)(this._px(f5) + this._py(f5)) / 2.0f)));
            this.cdSet.wpx = f3;
            this.cdSet.wpy = f4;
        }

        public void _dashedLineTo(int n, int n2, int n3) {
            this._dashedLine(this.cdSet.vpx, this.cdSet.vpy, n, n2, n3);
        }

        public void dashedLineTo(float f, float f2, float f3) {
            this.dashedLine(this.cdSet.wpx, this.cdSet.wpy, f, f2, f3);
        }

        public void _dashedLineRel(int n, int n2, int n3) {
            this._dashedLine(this.cdSet.vpx, this.cdSet.vpy, this.cdSet.vpx + n, this.cdSet.vpy + n2, n3);
        }

        public void dashedLineRel(float f, float f2, float f3) {
            this.dashedLine(this.cdSet.wpx, this.cdSet.wpy, this.cdSet.wpx + f, this.cdSet.wpy + f2, f3);
        }

        public void _ellipse(int n, int n2, int n3) {
            this._ellipse(n, n2, n3, n3);
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void _ellipse(int n, int n2, int n3, int n4) {
            this.pg.beginDraw();
            this.pg.ellipse((float)n, (float)n2, (float)n3, (float)n4);
            this.pg.endDraw();
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void ellipse(float f, float f2, float f3) {
            this.ellipse(f, f2, f3, f3);
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void ellipse(float f, float f2, float f3, float f4) {
            this._ellipse(this.px(f), this.py(f2), this._px(f3), this._py(f4));
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void _triangle(int n, int n2, int n3, int n4, int n5, int n6) {
            this.pg.beginDraw();
            this.pg.triangle((float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6);
            this.pg.endDraw();
            this.cdSet.vpx = n5;
            this.cdSet.vpy = n6;
        }

        public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
            this._triangle(this.px(f), this.py(f2), this.px(f3), this.py(f4), this.px(f5), this.py(f6));
            this.cdSet.wpx = f5;
            this.cdSet.wpy = f6;
        }

        public void _triangleC(int n, int n2, int n3, float f) {
            float f2 = 2.0943952f;
            int n4 = 0;
            int n5 = n3;
            int n6 = PApplet.parseInt((float)TestSpace.this.rotate2Dx(n4, n5, f + f2));
            int n7 = PApplet.parseInt((float)TestSpace.this.rotate2Dy(n4, n5, f + f2));
            int n8 = PApplet.parseInt((float)TestSpace.this.rotate2Dx(n4, n5, f - f2));
            int n9 = PApplet.parseInt((float)TestSpace.this.rotate2Dy(n4, n5, f - f2));
            n4 = PApplet.parseInt((float)TestSpace.this.rotate2Dx(n4, n5, f));
            n5 = PApplet.parseInt((float)TestSpace.this.rotate2Dy(n4, n5, f));
            this._triangle(n + n4, n2 + n5, n + n6, n2 + n7, n + n8, n2 + n9);
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void _triangleC(int n, int n2, int n3) {
            this._triangleC(n, n2, n3, 0.0f);
        }

        public void triangleC(float f, float f2, float f3, float f4) {
            float f5 = 2.0943952f;
            float f6 = 0.0f;
            float f7 = f3;
            float f8 = TestSpace.this.rotate2Dx(f6, f7, f4 + f5);
            float f9 = TestSpace.this.rotate2Dy(f6, f7, f4 + f5);
            float f10 = TestSpace.this.rotate2Dx(f6, f7, f4 - f5);
            float f11 = TestSpace.this.rotate2Dy(f6, f7, f4 - f5);
            f6 = TestSpace.this.rotate2Dx(f6, f7, f4);
            f7 = TestSpace.this.rotate2Dy(f6, f7, f4);
            this.triangle(f + f6, f2 + f7, f + f8, f2 + f9, f + f10, f2 + f11);
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void triangleC(float f, float f2, float f3) {
            this.triangleC(f, f2, f3, 0.0f);
        }

        public void _quad(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.pg.beginDraw();
            this.pg.quad((float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6, (float)n7, (float)n8);
            this.pg.endDraw();
            this.cdSet.vpx = n7;
            this.cdSet.vpy = n8;
        }

        public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this._quad(this.px(f), this.py(f2), this.px(f3), this.py(f4), this.px(f5), this.py(f6), this.px(f7), this.py(f8));
            this.cdSet.wpx = f7;
            this.cdSet.wpy = f8;
        }

        public void _rect(int n, int n2, int n3, int n4) {
            this.pg.beginDraw();
            this.pg.rect((float)n, (float)n2, (float)n3, (float)n4);
            this.pg.endDraw();
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void rect(float f, float f2, float f3, float f4) {
            this._rect(this.px(f), this.py(f2), this._px(f3), this._py(f4));
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void _rectC(int n, int n2, int n3, int n4) {
            this._rect(n - n3 / 2, n2 + n4 / 2, n3, n4);
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void rectC(float f, float f2, float f3, float f4) {
            this.rect(f - f3 / 2.0f, f2 + f4 / 2.0f, f3, f4);
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void _rectLR(int n, int n2, int n3, int n4) {
            this._rect(n, n2, n3 - n, n4 - n2);
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void rectLR(float f, float f2, float f3, float f4) {
            this.rect(f, f2, f3 - f, f4 - f2);
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void _arc(int n, int n2, int n3, int n4, float f, float f2) {
            this.pg.beginDraw();
            this.pg.arc((float)n, (float)n2, (float)n3, (float)n4, f, f2);
            this.pg.endDraw();
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void arc(float f, float f2, float f3, float f4, float f5, float f6) {
            this._arc(this.px(f), this.py(f2), this._px(f3), this._py(f4), f5, f6);
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void _point(int n, int n2) {
            this.pg.beginDraw();
            this.pg.point((float)n, (float)n2);
            this.pg.endDraw();
            this.cdSet.vpx = n;
            this.cdSet.vpy = n2;
        }

        public void point(float f, float f2) {
            this._point(this.px(f), this.py(f2));
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void prepareFont(int n) {
            this.prepareFont(TestSpace.this._FONTNAME, n);
        }

        public void prepareFont(String string, int n) {
            if (TestSpace.this.crowbar.status != 0) {
                TestSpace.println((String)"\u30a8\u30e9\u30fc: \u30d5\u30a9\u30f3\u30c8\u306e\u5ba3\u8a00\u306fOptions()\u304bSetup()\u3067\u884c\u3063\u3066\u4e0b\u3055\u3044\uff0c");
                return;
            }
            PFont pFont = TestSpace.this.createFont(string, n, false);
            this.pg.beginDraw();
            this.pg.textFont(pFont);
            this.pg.textMode(256);
            this.pg.textSize((float)n);
            this.pg.textAlign(37, 101);
            this.pg.endDraw();
        }

        public void textSize(int n) {
            this.pg.beginDraw();
            this.pg.textSize((float)n);
            this.pg.endDraw();
        }

        public void textAlign(int n) {
            this.pg.beginDraw();
            this.pg.textAlign(n);
            this.pg.endDraw();
        }

        public void textAlign(int n, int n2) {
            this.pg.beginDraw();
            this.pg.textAlign(n, n2);
            this.pg.endDraw();
        }

        public void _text(String string, int n, int n2) {
            this.pg.beginDraw();
            this.pg.fill(this.cdSet.textColor);
            this.pg.text(string, (float)n, (float)n2);
            this.pg.fill(this.cdSet.fillColor);
            this.cdSet.vpx = n + PApplet.parseInt((float)this.pg.textWidth(string));
            this.cdSet.vpy = n2;
            this.pg.endDraw();
        }

        public void _text(String string) {
            this._text(string, this.cdSet.vpx, this.cdSet.vpy);
        }

        public void text(String string, float f, float f2) {
            this._text(string, this.px(f), this.py(f2));
            this.cdSet.wpx = f;
            this.cdSet.wpy = f2;
        }

        public void text(String string) {
            this._text(string);
        }

        public int textColor() {
            return this.cdSet.textColor;
        }

        public int textColor(int n) {
            int n2 = this.textColor();
            this.cdSet.textColor = n & 0xFFFFFFFF;
            return n2;
        }
    }
}

