import processing.core.*; 
import processing.xml.*; 

import java.applet.*; 
import java.awt.Dimension; 
import java.awt.Frame; 
import java.awt.event.MouseEvent; 
import java.awt.event.KeyEvent; 
import java.awt.event.FocusEvent; 
import java.awt.Image; 
import java.io.*; 
import java.net.*; 
import java.text.*; 
import java.util.*; 
import java.util.zip.*; 
import java.util.regex.*; 

public class TestSpace extends PApplet {

///////////////////////////////////////////////////////////////
//    Crowbar\uff08\u30af\u30ed\u30a6\u30d0\u30fc\uff09
///////////////////////////////////////////////////////////////

// \u52d5\u4f5c\u306b\u95a2\u308f\u308b\u30aa\u30d7\u30b7\u30e7\u30f3\uff0e\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u3092\u8aad\u3093\u3067\u7406\u89e3\u3057\u305f\u3089\u81ea\u7531\u306b\u8a2d\u5b9a\u3057\u3066\u69cb\u3044\u307e\u305b\u3093\uff0e
public void Options() {
//  crowbar.setAutoScrollPage(0.5);
//  crowbar.setAutoScrollLines(2);
//  crowbar.enableOverlap();
  crowbar.fontSize(12);
  crowbar.hStep(1.5f);
  crowbar.vStep(1.5f);
  crowbar.textColor(0xff030303);
//crowbar.nonStop();
}

// \u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u524d\u306b\u884c\u3063\u3066\u304a\u304d\u305f\u3044\u51e6\u7406\uff08setup()\u306e\u6700\u521d\u306b\u81ea\u52d5\u5b9f\u884c\uff09
public void initializeMain() {
  // \u4ee5\u4e0b\u306e\u884c\u306f\u524a\u9664\u3057\u3066\u306f\u3044\u3051\u306a\u3044\uff0e\u4e8c\u3064\u306e\u5f15\u6570\u306e\u5024\u3092\u5909\u66f4\u3059\u308b\u3068\u30a6\u30a3\u30f3\u30c9\u30a6\u30b5\u30a4\u30ba\u304c\u5909\u308f\u308b\uff0e\u5358\u4f4d\u306f\u6587\u5b57\u6570\uff0c\u884c\u6570
  // \u7b2c\uff13\u5f15\u6570\u306f\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u30e9\u30a4\u30d6\u30e9\u30eaTomahawk\u306e\u30e2\u30fc\u30c9 0, 1, 2\u3088\u308a\u9078\u629e
  crowbar = new crowbarClass(60, 40, 2);
  // \u5fc5\u8981\u306a\u3089\u3070\u4ee5\u4e0b\u306b\u8a18\u8ff0
}

///////////////////////////////////////////////////////////////////////////////////
// \u3053\u3053\u304b\u3089\u4e0b\u306e\u30b3\u30fc\u30c9\u306f\u30e6\u30fc\u30b6\u304c\u7a4d\u6975\u7684\u306b\u8a18\u8ff0\u3057\u3066\u69cb\u308f\u306a\u3044
///////////////////////////////////////////////////////////////////////////////////
// \u30b7\u30b9\u30c6\u30e0\u521d\u671f\u8a2d\u5b9a
public void Setup()
{
  int w, h;
  w = width; h = height;
  crowbar.programComment("Tomahawk\u7d71\u5408\u306e\u5b9f\u9a13");

  crowbar.createView("Left");
  crowbar.cv.viewBgColor(0xffff8080);
  crowbar.cv.scale(1.0f);
  crowbar.cv.offset(20, 20);
  crowbar.splitViewH("RightUpper", 0.5f);
  crowbar.cv.viewBgColor(0xff80ff80);
  crowbar.cv.scale(1.0f);
  crowbar.cv.offset(20, 20);
  crowbar.splitViewV("RightLower", 0.5f);
  crowbar.cv.viewBgColor(0xff8080ff);
  crowbar.cv.scale(2.0f);
  crowbar.cv.offset(20, 20);
/*
  crowbar.createView("Left",       0,     0,     w / 2, h);
  crowbar.createView("RightUpper", w / 2, 0,     w / 2, h / 2);
  crowbar.createView("RightLower", w / 2, h / 2, w / 2, h / 2);
*/
  // \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u30a6\u30a3\u30f3\u30c9\u30a6\u98a8
  crowbar.createView("Middle", w / 4, h / 4, w /2, h /2);
  crowbar.cv.viewBgColor(0xff808080);
  crowbar.cv.transparency(128);
  crowbar.cv.scale(1.0f);
  crowbar.cv.offset(20, 20);
  // \u8ecc\u8de1\u8868\u793a\u7528
  crowbar.createView("Trajectory");
  crowbar.cv.transparentView(true);
  crowbar.cv.clrView();
//  crowbar.offset(3, 30, -10);
//  crowbar.unvisible(0);
//  crowbar.unvisible(1);
//  crowbar.unvisible(2);

  crowbar.define("\u30c6\u30ad\u30b9\u30c8\u8868\u793aX\u5ea7\u6a19", 0);
  crowbar.define("\u30c6\u30ad\u30b9\u30c8\u8868\u793aY\u5ea7\u6a19", 0);
  crowbar.nonStop();
}

// \u30e1\u30a4\u30f3\u30eb\u30fc\u30c1\u30f3
// \u30e6\u30fc\u30b6\u306e\u30e1\u30a4\u30f3\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\uff08\uff11\u5ea6\u3057\u304b\u5b9f\u884c\u3055\u308c\u306a\u3044\uff09\u3092\u4ee5\u4e0b\u306b\u8a18\u8ff0
int cx, cy;
int targetView = 0;
boolean clicked;

public void Main() {
  crowbar.displayAllViewData();
  cx = crowbar.getInt();
  cy = crowbar.getInt();
  
  clicked = false;
}

///////////////////////////////////////////////////////////////
// Processing\u306b\u3088\u308b\u4e8c\u5206\u6cd5\u306e\u5bfe\u8a71\u7684\u30d7\u30ed\u30b0\u30e9\u30e0\u958b\u767a\u7528\u30d5\u30ec\u30fc\u30e0\u30ef\u30fc\u30af
//    Crowbar\uff08\u30af\u30ed\u30a6\u30d0\u30fc\uff09
//                                  \u767d\u4e95\u3000\u9054\u4e5f\uff08Tatsuya Shirai)
//                       shirai\uff20mech.suzuka-ct.ac.jp, @tatsuva
//                                       2012/04/20    Ver. 0.9
//                                       2012/05/14    Ver. 1.0
//                                       2012/05/15    Ver. 1.1
//                                       2012/05/24    Ver. 1.2
//                                       2012/05/26    Ver. 1.3
//                          2012/05/27 - 2012/06/01    Ver. 2.0
//                          2012/06/04 - 2012/06/04    Ver. 2.1
//                          2012/06/05 -               Ver. 2.2
///////////////////////////////////////////////////////////////
// \u6700\u65b0\u7248\u306e\u516c\u958b\u306f\u4ee5\u4e0b\u306eSourceForge.JP\u306b\u3066\u884c\u3063\u3066\u3044\u307e\u3059\uff0e
// http://sourceforge.jp/projects/crowbar/
// \u30c9\u30ad\u30e5\u30e1\u30f3\u30c8\u306f\u4ee5\u4e0b\u306eMoodle\u30b5\u30a4\u30c8\u4e0a\u306eWiki\u306b\u3066\u516c\u958b\u3057\u3066\u3044\u307e\u3059\uff0e
// http://www.suzuka-ct.ac.jp/mech/moodle/mod/wiki/view.php?id=1739&page=Crowbar
// \u8cea\u554f\u306a\u3069\u306f\u4e0a\u8a18SourceForge.JP\u3042\u308b\u3044\u306fmechMoodle\u4e0a\u306e\u30d5\u30a9\u30fc\u30e9\u30e0\u306b
// \u6295\u7a3f\u3059\u308b\u304b\uff0c\u3042\u308b\u3044\u306fTwitter\uff0c\u307e\u305f\u306f\u30e1\u30fc\u30eb\u3067\u304a\u554f\u3044\u5408\u308f\u305b\u4e0b\u3055\u3044\uff0e

// \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u30e9\u30a4\u30d6\u30e9\u30eaTomahawk\u3092\u4f7f\u7528\u3057\u306a\u3044\u5834\u5408\u306f\uff0c\u30bf\u30d6TomahawkClass\u3092Delete\u3057\u305f\u4e0a\u3067\uff0c\u4ee5\u4e0b\u306e\u30b3\u30e1\u30f3\u30c8\u30a2\u30a6\u30c8\u3055\u308c\u305f\u4e00\u884c\u306e\u30b3\u30fc\u30c9\u306e\u884c\u982d\u306e\u30b3\u30e1\u30f3\u30c8\u8a18\u53f7\uff08//\uff09\u3092\u5916\u3059\uff0e
// \u3055\u3089\u306binitializeMain()\u4e2d\u306ecrowbar = new crowbarClass(60, 50, 0);\u306e\u3088\u3046\u306b\u7b2c3\u5f15\u6570\u30920\u306b\u3059\u308b\u3053\u3068\uff0e
// class tomahawkClass { tomahawkClass(int mode) {} protected int tomahawkMode = 0; void backupViewports() {} void restoreViewports() {} void refreshView() {} }

// \u30e1\u30a4\u30f3\u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u5ba3\u8a00\uff08\u7d76\u5bfe\u306b\u524a\u9664\u3057\u3066\u306f\u3044\u3051\u307e\u305b\u3093\uff09
crowbarClass crowbar;

// \u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30c6\u30ad\u30b9\u30c8\u5c5e\u6027
protected int _FONTSIZE      = 14;
protected int _TEXTCOLOR     = 0xff000002;  // PGraphics\u306e\u4ed5\u69d8\u4e0a\u306e\u554f\u984c\u70b9\u306e\u56de\u907f (#000000\u3084#000001\u3067\u306ftext()\u3067\u8cbc\u3063\u305f\u969b\u306b\u8272\u304c#000000\u306b\u306a\u3063\u3066\u80cc\u666f\u3068\u533a\u5225\u304c\u3064\u304b\u306a\u3044\uff09
protected int _BGCOLOR       = 0xffffffee;
// \u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30b9\u30af\u30ea\u30fc\u30f3\u5c5e\u6027\uff08\u3044\u307e\u306e\u3068\u3053\u308d\u5909\u66f4\u4e88\u5b9a\u306a\u3057\uff09
protected float _HSTEP       = 1.2f;  // \u6587\u5b57\u9001\u308a
protected float _VSTEP       = 1.4f;  // \u884c\u9001\u308a
// \u30bf\u30d6\u8868\u793a\u306e\u521d\u671f\u5024
protected float _TABSIZE     = 10.0f;

// \u30d5\u30a9\u30f3\u30c8\u540d
protected String _FONTNAME = "MS Gothic";

// \u30c7\u30d0\u30c3\u30b0\u7528
protected boolean _DEBUGFLAG = false;

///////////////////////////
// \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u306e\u30af\u30e9\u30b9
// \uff08\u30b9\u30af\u30ed\u30fc\u30eb\u5bfe\u5fdc\u7528\uff09
///////////////////////////
// \u30e1\u30e2\u30ea\u306e\u78ba\u4fdd\u306f\u5358\u4e00\u65b9\u5411\u30ea\u30b9\u30c8\u69cb\u9020\u3068\u3059\u308b\uff0e
// \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3057\u3066\u6298\u308a\u8fd4\u3059\u5206\u306f\u6b21\u306e\u30e9\u30a4\u30f3\u30c7\u30fc\u30bf\u306b\u5165\u308c\u308b\uff0e\u5f8c\u65e5\uff0c\u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u30b5\u30a4\u30ba\u5909\u66f4\u306b
// \u5bfe\u5fdc\u3059\u308b\u969b\u306b\u306f\uff0c\u4e00\u65e6\uff0c\u6539\u884c\u3055\u308c\u305f\u30e9\u30a4\u30f3\u30c7\u30fc\u30bf\u3092\u7e4b\u3052\u76f4\u3057\u3066\uff0c\u305d\u308c\u304b\u3089\u307e\u305f\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3057\u76f4\u3059\uff0e
// \u305d\u306e\u969b\u306b\u884c\u6570\u304c\u6e1b\u308b\u304b\u3082\u77e5\u308c\u306a\u3044\uff0e\u4e0d\u8981\u306b\u306a\u3063\u305f\u30e9\u30a4\u30f3\u30c7\u30fc\u30bf\u306f\u30ea\u30b9\u30c8\u69cb\u9020\u304b\u3089\u5207\u308a\u96e2\u3057\uff0cGC\u306b\u958b\u653e\u3055\u305b\u308b\uff0e
// Ver.1.04.00\u3067\u6587\u5b57\u8272\u306e\u5909\u66f4\u306b\u5bfe\u5fdc\u3059\u308b\u305f\u3081\u306b\uff0cwrite()\u3067\u51fa\u529b\u3055\u308c\u305f\u5358\u4f4d\u3067\u4e00\u3064\u306eclass\u3068\u3057\u3066\u6587\u5b57\u60c5\u5831\u3068\u3057\u305f\uff0e
// \u4e00\u5fdc\uff0c\u5c06\u6765\u7684\u306a\u62e1\u5f35\u3092\u8003\u616e\u306b\u5165\u308c\u3066\u80cc\u666f\u8272\u3082\u8003\u616e\u3059\u308b\uff0eclass\u3068\u3057\u3066\u306f\u4ed6\u306e\u62e1\u5f35\u5c5e\u6027\u306e\u3082\u5bfe\u5fdc\u3067\u304d\u308b\u3088\u3046\u306b\u8003\u3048\u305f\u4e0a\u3067\u5b9f\u88c5\u3059\u308b\uff0e

// \u30c6\u30ad\u30b9\u30c8\u60c5\u5831\u306e\u5c5e\u6027
class textAttrClass {
  protected int  textColor;  // \u6587\u5b57\u8272        \uff1a\u5909\u66f4\u53ef
  protected int  bgColor;    // \u80cc\u666f\u8272        \uff1a\u57fa\u672c\u7684\u306b\u5909\u3048\u306a\u3044
  protected int  fontSize;   // \u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\uff1a\u57fa\u672c\u7684\u306b\u5909\u3048\u306a\u3044
  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  textAttrClass () {
    init();
  }
  // \u30b7\u30b9\u30c6\u30e0\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u3067\u521d\u671f\u5316
  public void init() {
    fontSize   = _FONTSIZE;
    textColor  = _TEXTCOLOR;
    bgColor    = _BGCOLOR;
  }
  // \u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u306e\u5909\u66f4
  public void setTextColor(int col) { textColor = col;  }  // \u30e6\u30fc\u30b6\u306f\u5229\u7528\u4e0d\u53ef
  public void setbgColor(int col)   { bgColor   = col;  }  // \u30e6\u30fc\u30b6\u306f\u5229\u7528\u4e0d\u53ef
  public void setFontSize(int size) { fontSize  = size; }  // \u30e6\u30fc\u30b6\u306f\u5229\u7528\u4e0d\u53ef
  // \u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u306e\u8907\u88fd
  public void clone(textAttrClass attr) {
    fontSize  = attr.fontSize;    // \u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba 
    textColor = attr.textColor;   // \u6587\u5b57\u8272
    bgColor   = attr.bgColor;     // \u80cc\u666f\u8272
  }
  // \u5f15\u6570\u3067\u4e0e\u3048\u3089\u308c\u305f\u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u3068\u73fe\u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u306e\u6bd4\u8f03\uff08\u7b49\u3057\u3051\u308c\u3070true\u3092\u8fd4\u3059\uff09
  public boolean checkTextAttr(textAttrClass attr) {
    if (attr.fontSize   != fontSize)  return false;
    if (attr.textColor  != textColor) return false;
    if (attr.bgColor    != bgColor)   return false;
    return true;
  }
}

// \u30c6\u30ad\u30b9\u30c8\u306e\u6700\u5c0f\u5358\u4f4d\uff08\u30bb\u30f3\u30c6\u30f3\u30b9\uff09\uff1awrite()\u3059\u308b\u5ea6\u306b\u30d0\u30c3\u30d5\u30a1\u306b\u8ffd\u52a0\u3055\u308c\u308b
class sentenceClass {
  protected String sentence;   // \u540c\u3058\u6587\u5b57\u5c5e\u6027\u306e\u4e00\u9023\u306a\u308a\u306e\u6587\u5b57\u5217
  textAttrClass    attr;       // \u6587\u5b57\u5c5e\u6027
  sentenceClass    next;       // \u6b21\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u3078\u306e\u30dd\u30a4\u30f3\u30bf
  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  sentenceClass(String str, textAttrClass attribute) {
    sentence = str;
    attr     = new textAttrClass();
    next     = null;
    attr.clone(attribute);
  }
  // \u3053\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u306e\u307f\u3092\u521d\u671f\u5316\uff08\u30ea\u30b9\u30c8\u69cb\u9020\u3092\u4e0b\u6d41\u306b\u4e0b\u3089\u306a\u3044\uff09
  public void clearSentence(textAttrClass attribute) {
    sentence = "";
    attr.clone(attribute);
    next     = null;
  }
  // \u30bb\u30f3\u30c6\u30f3\u30b9\u306e\u30ea\u30b9\u30c8\u6700\u5f8c\u90e8\u3078\u306e\u8ffd\u52a0
  public void addSentence(String str, textAttrClass attr) {
    if (next == null) next = new sentenceClass(str, attr);  // \u7d42\u4e86\u6761\u4ef6
      else            next.addSentence(str, attr);          // \u518d\u5e30\u547c\u3073\u51fa\u3057
  }
  // \u6587\u5b57\u5c5e\u6027\u3092\u8003\u616e\u306b\u5165\u308c\u3066\u540c\u3058\u5c5e\u6027\u306e\u5834\u5408\u306f\u6587\u5b57\u5217\u3092\u30de\u30fc\u30b8\u3059\u308b
  // \u518d\u5e30\u547c\u3073\u51fa\u3057\u3067\u306f\u306a\u3044\u304c\uff0c\u30ea\u30b9\u30c8\u672b\u5c3e\u307e\u3067\u300c\u3053\u308c\u3068\u305d\u306e\u6b21\u3092\u6bd4\u8f03\u3057\u3066\u3053\u308c\u306b\u6b21\u3092\u30de\u30fc\u30b8\u300d\u3092\u7e70\u308a\u8fd4\u3059\uff0e
  public void merge() {
    if (next == null) return;  // \uff11\u500b\u3057\u304b\u7121\u3044\uff08\u3042\u308b\u3044\u306f\u7d42\u7aef\u3092\u547c\u3070\u308c\u305f\uff09\u306a\u3089\u3070\u30de\u30fc\u30b8\u306f\u4e0d\u8981\uff0e\u7279\u306b\u7a7a\u884c\u306e\u3053\u3068\u3092\u8003\u616e\u306b\u3044\u308c\u305f\u7279\u4f8b
    sentenceClass current = this;
    while (current.next != null) {
      if (current.attr.checkTextAttr(current.next.attr) || (current.sentence.length() == 0)) {
        // \u3082\u3057\u3053\u308c\u3068\u6b21\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u306e\u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u304c\u7b49\u3057\u3044\u306a\u3089\u3070\u6b21\u306e\u6587\u5b57\u5217\u3092\u3053\u308c\u306e\u6587\u5b57\u5217\u306b\u8ffd\u52a0
        current.sentence += current.next.sentence;
        // \u6587\u5b57\u5217\u6570\u30bc\u30ed\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u3092\u5f8c\u308d\u306e\u6587\u5b57\u5217\u3068\u5408\u4f53\u3055\u305b\u308b\u305f\u3081\u306b\u5c5e\u6027\u3092\u5f8c\u308d\u304b\u3089\u30b3\u30d4\u30fc
        current.attr.clone(current.next.attr);
        // \u6b21\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u3092\u7121\u8996\u3057\u3066\u305d\u306e\u6b21\u3068\u7e4b\u3052\u76f4\u3059\uff08current.netxt.next\u306fnull\u304b\u3082\u77e5\u308c\u306a\u3044\u304c\uff0c\u305d\u308c\u306f\u6b21\u306ewhile\u306e\u7d42\u4e86\u6761\u4ef6\u3067\u30c1\u30a7\u30c3\u30af\u3055\u308c\u308b\uff09
        current.next = current.next.next;
        // \u30bf\u30fc\u30b2\u30c3\u30c8\u306f\u6b21\u3078\u79fb\u308b\u306e\u3067\u306f\u306a\u304f\uff0c\u3053\u308c\u306e\u307e\u307e\u3067\u3042\u308b\u306e\u304c\u30df\u30bd
      } else {
        // \u300c\u3053\u308c\u3068\u6b21\u304c\u7570\u306a\u308b\u300d\u306a\u3089\u3070\u30bf\u30fc\u30b2\u30c3\u30c8\u3092\u6b21\u306b\u79fb\u3059
        current = current.next;
      }
    }
  }
  // \u30bb\u30f3\u30c6\u30f3\u30b9\u3092\u6307\u5b9a\u3055\u308c\u305f\u9577\u3055\u3067\u5206\u5272\u3057\uff0c\u6b8b\u308a\u3092\u65b0\u305f\u306b\u78ba\u4fdd\u3057\u305f\u9818\u57df\u306b\u30b3\u30d4\u30fc\u3059\u308b
  // \u5206\u5272\u306e\u5fc5\u8981\u304c\u7121\u304b\u3063\u305f\u5834\u5408\u306f\u6587\u5b57\u5217\u6570\uff10\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u3092\u8fd4\u3059\uff08\u6271\u3044\u306f\u4e0a\u6d41\u306b\u4efb\u305b\u308b\uff09
  public sentenceClass split(int len) {
    sentenceClass newone = new sentenceClass("", attr);  // \u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u30af\u30ed\u30fc\u30f3\u3067\u65b0\u898f\u306b\u4f5c\u6210
    // \u6587\u5b57\u5217\u306e\u5206\u5272\u30b3\u30d4\u30fc
    newone.sentence = sentence.substring(len);
    sentence        = sentence.substring(0, len);
    // \u30ea\u30b9\u30c8\u3092\u633f\u5165
    newone.next = next;
    next        = newone;
    return newone;
  }
  // \u6587\u5b57\u5217\u306e\u9577\u3055\uff08\u3053\u306e\u30ea\u30b9\u30c8\u304b\u3089\u5148\u306e\u6587\u5b57\u5217\u306e\u9577\u3055\u3092\u5408\u7b97\uff09
  public int length() {
    if (next == null) return sentence.length();                  // \u7d42\u4e86\u6761\u4ef6
      else            return next.length() + sentence.length();  // \u518d\u5e30\u547c\u3073\u51fa\u3057
  }
   // \u5c5e\u6027\u306a\u3057\u306e\u6587\u5b57\u5217\u3068\u3057\u3066\u8fd4\u3059\uff08\u3053\u306e\u30ea\u30b9\u30c8\u304b\u3089\u5148\u306e\u5168\u3066\uff09
   public String getPlainText() {
   if (next == null) return sentence;
     else            return sentence + next.getPlainText();
   }
}

// \u4e00\u884c\u5206\u306e\u30af\u30e9\u30b9
class lineClass {
  protected int     no;      // \u884c\u756a\u53f7\uff0e\uff10\u304b\u3089\u59cb\u307e\u308b\uff08\u30c7\u30d0\u30c3\u30b0\u7528\uff09
  sentenceClass     line;    // \u30bb\u30f3\u30c6\u30f3\u30b9\u306e\u30ea\u30b9\u30c8\u69cb\u9020\u306e\u5148\u982d\uff08\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u306e\u30c7\u30fc\u30bf\u306f\u3053\u3053\u306b\uff09
  protected boolean flag;    // \u5165\u529b\u6e08\u307f\u304b\uff1f\uff08\u7a7a\u884c\u3092\u8003\u616e\uff0eline\u306e\u6587\u5b57\u6570\u3067\u306f\u5224\u65ad\u3067\u304d\u306a\u3044\u305f\u3081\uff0e\u3055\u3089\u306bGC\u3092\u4f7f\u308f\u305a\u30ea\u30b9\u30c8\u3092\u518d\u5229\u7528\u3059\u308b\u305f\u3081\u306b\u3082\uff09
  protected boolean overlap; // \u524d\u306e\u884c\u306e\u6298\u308a\u8fd4\u3057\u304b\uff08\u5f8c\u65e5\uff0c\u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u30b5\u30a4\u30ba\u5909\u66f4\u306b\u5bfe\u5fdc\u3059\u308b\u305f\u3081\u306b\uff09
  lineClass         next;    // \u6b21\u306e\u884c\u306e\u4f4d\u7f6e
  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  lineClass() {
    clear();
  }
  // \u30af\u30ea\u30a2
  public void clear() {
    no         = 0;
    line       = null;
    flag       = false;
    overlap    = false;
    next       = null;
  }
  // \u884c\u5358\u4f4d\u306e\u30c7\u30fc\u30bf\u306e\u30bb\u30c3\u30c8\uff08\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u51e6\u7406\u306f\u4e0a\u6d41\u3067\u884c\u3046\uff0e\u3053\u306e\u884c\u304c\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3059\u308b\u884c\u306a\u3089\u3070over\u3092true\u306b\u30bb\u30c3\u30c8\u3057\u3066\u30b3\u30fc\u30eb\uff09
  public void set(sentenceClass data, boolean over) {
    // \u73fe\u30ea\u30b9\u30c8\u306b\u30c7\u30fc\u30bf\u3092\u30bb\u30c3\u30c8
    // no \u306f\u521d\u671f\u5316\u6642\u3042\u308b\u3044\u306f\u4e00\u3064\u524d\u306e\u30ea\u30b9\u30c8\u306b\u30c7\u30fc\u30bf\u3092\u30bb\u30c3\u30c8\u3055\u308c\u305f\u6642\u306b\u8a2d\u5b9a\u6e08\u307f
    line    = data;    // buff\u3092\u305d\u306e\u307e\u307e\u4f7f\u3046\uff0e\u3057\u305f\u304c\u3063\u3066buff\u306fset()\u3057\u305f\u5f8c\u306b\u518d\u78ba\u4fdd\u304c\u5fc5\u8981
    flag    = true;
    overlap = over;
    if (next == null) next = new lineClass();  // \u6b21\u306e\u884c\u30c7\u30fc\u30bf\u306e\u78ba\u4fdd\uff08\u305f\u3060\u3057\uff0c\u30ea\u30b9\u30c8\u69cb\u9020\u3092\u518d\u5229\u7528\u3059\u308b\u5834\u5408\u306f\u78ba\u4fdd\u3057\u306a\u3044\uff09
    next.no = no + 1;  // \u81ea\u52d5\u52a0\u7b97
  }
  // \u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u3092\u8003\u616e\u306b\u5165\u308c\u3066\u540c\u3058\u30c6\u30ad\u30b9\u30c8\u5c5e\u6027\u3092\u6301\u3064\u96a3\u63a5\u3057\u305f\u30ea\u30b9\u30c8\u3092\u30de\u30fc\u30b8\u3059\u308b\u51e6\u7406\u3092\u884c\u5358\u4f4d\u3067\u5b9f\u884c\u3059\u308b
  public void merge() { 
    line.merge();
  }
}

///////////////////////////////
// \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u672c\u4f53\u306e\u30af\u30e9\u30b9
class textbufferClass {
  private int           cwidth;            // \u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u30c6\u30ad\u30b9\u30c8\u306e\u4e00\u884c\u306e\u6587\u5b57\u6570
  private screenClass   screenSetting;     // \u753b\u9762\u8a2d\u5b9a
  int                   fontSize;          // \u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u30c6\u30ad\u30b9\u30c8\u306e\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba
  private lineClass     topLine;           // \u4e00\u756a\u6700\u521d\u306e\u884c\u30c7\u30fc\u30bf
  lineClass             currentWriteLine;  // \u73fe\u5728\u306e\u66f8\u304d\u8fbc\u307f\u53ef\u80fd\u306a\u884c\u30c7\u30fc\u30bf
  textAttrClass         currentAttr;       // \u73fe\u5728\u306e\u6587\u5b57\u5c5e\u6027\uff08\u4e3b\u306b\u66f8\u304d\u8fbc\u307f\u7528\uff09
  protected int         totalLines;        // \u51fa\u529b\u6e08\u307f\u306e\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u306e\u884c\u6570\u3092\u5358\u7d14\u306b\u8fd4\u3059\uff08\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u306f\u8003\u616e\u3057\u306a\u3044\u2192\u8003\u616e\u3059\u308b\uff09
  protected int         readingLine;       // \u73fe\u5728\u306e\u8aad\u307f\u51fa\u3057\u3055\u308c\u3066\u3044\u308b\u884c\u756a\u53f7
  private sentenceClass buff;              // \u73fe\u5728\u306e\u672a\u6539\u884c\u306e\u30d0\u30c3\u30d5\u30a1

  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  textbufferClass(screenClass scr, textAttrClass attr) {
    screenSetting    = scr;
    cwidth           = screenSetting.cwidth;  // \u4e00\u884c\u306e\u6587\u5b57\u6570
    fontSize         = attr.fontSize;
    topLine          = new lineClass();
    currentWriteLine = topLine;
    currentAttr      = new textAttrClass();  // \u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u308b
    totalLines       = 0;
    readingLine      = 0;
    buff             = new sentenceClass("", currentAttr);  // \u5e38\u306b\u6700\u521d\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u306f\u7a7a
  }
  // \u5168\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u306e\u30af\u30ea\u30a2
  // GC\u3067\u6d88\u3048\u308b\u306e\u3092\u671f\u5f85\u3059\u308b\u306e\u3067\u306f\u306a\u304f\u53e4\u3044\u30ea\u30b9\u30c8\u69cb\u9020\u3092\u518d\u5229\u7528\u3059\u308b
  public void clearTextBuffer() {
    lineClass  temp, next;
    temp = topLine;
    while (true) {
      if (temp.next == null)  break;
      //    if (temp.flag == false) break;  // \u5b89\u5168\u306e\u305f\u3081\u306b\u30b3\u30e1\u30f3\u30c8\u30a2\u30a6\u30c8
      next = temp.next;  // \u6b21\u306e\u30ea\u30b9\u30c8\u306e\u30dd\u30a4\u30f3\u30bf\u3092\u9000\u907f\u3055\u305b\u3066\u304b\u3089
      temp.clear();      // \u73fe\u30e9\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u3092\u521d\u671f\u5316\u3057\u3066
      temp = next;       // \u6b21\u306b\u79fb\u52d5\u3059\u308b
    }
    currentAttr.init();  // \u30b7\u30b9\u30c6\u30e0\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u306b\u521d\u671f\u5316
    currentWriteLine = topLine;
    totalLines       = 0;
    readingLine      = 0;
    if (buff != null) buff.clearSentence(currentAttr);  // \u30d0\u30c3\u30d5\u30a1\u306e\u521d\u671f\u5316\uff08\u30ea\u30b9\u30c8\u3092\u8fbf\u3089\u306a\u3044\uff1aGC\u306b\u671f\u5f85\uff09
  }
  ///////////////////////
  // \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u95a2\u4fc2
  // \u4e0e\u3048\u3089\u308c\u305f\u6587\u5b57\u5217\u306e\u5e45\uff08\u6587\u5b57\u6570\u3067\u306f\u7121\u3044\uff09\u3092\u8fd4\u3059\uff08\u5168\u89d21.0\uff0c\u534a\u89d20.5\uff09
  public float getStringWidth(String str) { 
    if (crowbar.tomahawkMode == 2) return screenSetting.pgText.textWidth(str) / fontSize;
    return textWidth(str) / fontSize;
  }
  // \u6307\u5b9a\u3055\u308c\u305f\u6587\u5b57\u5e45\u306f\u4e0e\u3048\u3089\u308c\u305f\u6587\u5b57\u5217\u306e\u4f55\u6587\u5b57\u76ee\u307e\u3067\u306a\u306e\u304b\u3092\u8abf\u3079\u308b
  public int convertStringWidth2Length(String str, int len) {
    int i;
    for (i = len - 1; i < str.length(); i++) {    // len - 1\u304b\u3089\u59cb\u3081\u308b\u306e\u306f\u9ad8\u901f\u5316\u306e\u305f\u3081
      if (getStringWidth(str.substring(0, i + 1)) > len) break;
    }
    return i;
  }
  // -----------\u30d0\u30c3\u30d5\u30a1\u95a2\u9023 --------------------
  // \u30d0\u30c3\u30d5\u30a1\u306b\u30bb\u30f3\u30c6\u30f3\u30b9\u3092\u8ffd\u52a0\u3059\u308b\uff08\u5358\u7d14\u306b\u30c1\u30a7\u30fc\u30f3\u3092\u7e4b\u3050\uff0e\u5f8c\u3067\u5c5e\u6027\u3092\u30c1\u30a7\u30c3\u30af\u3057\u3066\u30de\u30fc\u30b8\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\uff0e\u7a7a\u6587\u5b57\u5217\u3067\u3082\u7e4b\u3050\uff09
  public void appendSentence(String str, textAttrClass attr) {
    if (buff == null) buff = new sentenceClass(str, attr);  // \u30d0\u30c3\u30d5\u30a1\u304c\u7121\u3044\uff01\u3053\u3068\u306f\u7121\u3044\u306f\u305a\uff0e
      else            buff.addSentence(str, attr);
    // \u6587\u5b57\u8868\u793a\u5c5e\u6027\u306e\u66f4\u65b0
    currentAttr.clone(attr);
  }
  // \u30c7\u30fc\u30bf\u66f8\u304d\u8fbc\u307f\u306e\u672c\u4f53\uff08\u3082\u3057\u3053\u306e\u884c\u304c\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3055\u308c\u305f\u884c\u306a\u3089\u3070overlap\u306btrue\u3092\u30bb\u30c3\u30c8\u3057\u3066\u30b3\u30fc\u30eb\u3059\u308b\uff09
  public void _setLine(boolean overlapped) {
    currentWriteLine.set(buff, overlapped);
    currentWriteLine = currentWriteLine.next;
    totalLines++;
  }
  // \u30d0\u30c3\u30d5\u30a1\u306e\u30c7\u30fc\u30bf\u3092\u884c\u30c7\u30fc\u30bf\u3068\u3057\u3066\u78ba\u5b9a\u3059\u308b
  // \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3092\u8003\u616e\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\u3068\u304d\u306foverlap\u3092true\u306b\u30bb\u30c3\u30c8\u3057\u3066\u30b3\u30fc\u30eb\u3059\u308b
  // \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u6709\u52b9\u6642\u306b\u6298\u308a\u8fd4\u3057\u5206\u3092\u65b0\u305f\u306b\u884c\u30c7\u30fc\u30bf\u3092\u4f5c\u6210\u3057\u3066\u305d\u3061\u3089\u306b\u7d9a\u3051\u308b\uff0e
  public void setLine(boolean overlap) {
    if (!overlap) {
      buff.merge();  // \u30de\u30fc\u30b8\u3092\u5148\u306b\u884c\u3046
      _setLine(false);
    } else {
      normalizeBuffer();
      _setLine(false);
    }
    buff = new sentenceClass("", currentAttr);  // \u5e38\u306b\u6700\u521d\u306e\u30bb\u30f3\u30c6\u30f3\u30b9\u306f\u7a7a
  }
  // \u3044\u307e\u30d0\u30c3\u30d5\u30a1\u306b\u6e9c\u307e\u3063\u3066\u3044\u308b\u30bb\u30f3\u30c6\u30f3\u30b9\u304c\u4e00\u884c\u306e\u884c\u6570\u3092\u8d85\u3048\u3066\u3044\u308b\u306a\u3089\u3070\u8d85\u3048\u3066\u3044\u308b\u5206\u306f\u30e9\u30a4\u30f3\u30c7\u30fc\u30bf\u3068\u3057\u3066\u78ba\u5b9a\u3059\u308b
  // \u3053\u308c\u306f\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u8a31\u53ef\u6642\u4ee5\u5916\u306b\u547c\u3073\u51fa\u3057\u3066\u306f\u3044\u3051\u306a\u3044\uff0e
  public void normalizeBuffer() {
    if (getStringWidth(buff.getPlainText()) >= cwidth) {
      // \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u6709\u52b9\u6642\u306e\u5206\u5272\u51e6\u7406
      // lineClass\u306eoverlap\u306f\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u306e\u201d\u767a\u751f\u3057\u305f\u201d\u884c\u306e\u307ftrue\u3068\u3059\u308b
      buff.merge();  // \u30de\u30fc\u30b8\u3092\u5148\u306b\u884c\u3046
      sentenceClass  bufBakPtr, buffPtr;
      textAttrClass  bakAttr;
      float total = 0.0f;

      buffPtr = buff;
      while (true) {
        if (buffPtr == null) break;
        // \u6298\u308a\u8fd4\u3057\u304c\u5fc5\u8981\u306a\u5834\u5408
        if (total + getStringWidth(buffPtr.sentence) >= cwidth) {
          // \u30bb\u30f3\u30c6\u30f3\u30b9\u3092\u5206\u5272\u3059\u308b
          bufBakPtr = buffPtr.split(convertStringWidth2Length(buffPtr.sentence, PApplet.parseInt(cwidth - total)));
          buffPtr.next = null;
          // \u3053\u308c\u306f\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3057\u305f\u5206\u306a\u306e\u3067\u5f15\u6570true
          _setLine(true);
          // \u5206\u5272\u3057\u305f\u6b8b\u308a\u304c\u7a7a\u306e\u5834\u5408
          if (bufBakPtr.sentence.length() == 0) buff = bufBakPtr.next;  // \u5358\u306b\u7121\u8996
            else                                buff = bufBakPtr;
          buffPtr = buff;
          total   = 0;
        } else {
          total += getStringWidth(buffPtr.sentence);
          if (buffPtr.next == null) {
            // \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u306e\u767a\u751f\u3057\u3066\u3044\u306a\u3044\u884c\uff08\u3042\u308b\u3044\u306f\u6b8b\u308a\u306e\u90e8\u5206\uff09
            break;
          } else buffPtr = buffPtr.next;
        }
      }
    }
    return;
  }
  // \u30d0\u30c3\u30d5\u30a1\u3092\u30d5\u30e9\u30c3\u30b7\u30e5\uff08\u66f8\u304d\u51fa\u3059\uff09
  public void flushBuffer(boolean overlap) {
    if (buff.length() > 0) setLine(overlap);
  }
  // \u6307\u5b9a\u3055\u308c\u305f\u884c\u756a\u53f7\u306e\u884c\u30c7\u30fc\u30bf\u3092\u8fd4\u3059\uff08\uff10\u884c\u304b\u3089\u59cb\u3081\u308b\uff09
  public lineClass getTargetLine(int line) {
    lineClass temp = topLine;
    int  num;
    for (num = 0; num < line; num++) {
      if (temp.next == null) break;
      if (temp.flag != true) break;
      temp = temp.next;
    }
    return temp;
  }
  // \u8868\u793a\u958b\u59cb\u884c\u3092\u30c0\u30a4\u30ec\u30af\u30c8\u306b\u6307\u5b9a\u3059\u308b
  public void setReadingLine(int num) {
    if (num < 0) num = 0;
    if (crowbar.afterRunning && (num >= totalLines - 1)) num = totalLines - 1;
    readingLine = num;
  }
  // \u8868\u793a\u958b\u59cb\u884c\u6570\u3092\u6307\u5b9a\u884c\u6570\u5206\uff0c\u5897\u52a0\u3059\u308b
  public void incrementReadingLine(int num) {
    setReadingLine(readingLine + num);
  }
  // \u30c7\u30d0\u30c3\u30b0\u7528\uff1a\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u3092\u5168\u3066\u8868\u793a
  public void displayAllTextBuffer() {
    int  i;
    lineClass temp;
    temp = topLine;
    sentenceClass sen;
    i = 0;
    println();
    println("No.:(No.):flag:overlap:length[sentence1, sentence2, ...]");
    while (true) {
      if (temp == null) break;
      if (temp.line == null) break;
      print(str(i) + ":" + str(temp.no) + ":" + str(temp.flag) +":" + str(temp.overlap) + ":" + str(temp.line.length()));
      print("[");
      sen = temp.line;
      while (true) {
        print(hex(sen.attr.textColor));
        print("(" + str(sen.sentence.length()) + ")");
        print(",");
        if (sen.next == null) break;
        sen = sen.next;
      } 
      println("]");
      if (temp.next == null) break;
      temp = temp.next;
      i++;
    }
  }
}

// \u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u898f\u5247\u306e\u30af\u30e9\u30b9
class keyInputConstraintClass {
  private boolean point;     // [.]\u30ad\u30fc\u304c\u62bc\u3055\u308c\u305f\u304b
  private boolean sign;      // [+],[-]\u30ad\u30fc\u304c\u62bc\u3055\u308c\u305f\u304b
  private boolean inputted;  // \u6570\u5b57\u304c\u65e2\u306b\u5165\u529b\u6e08\u307f\u304b
  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  keyInputConstraintClass() { reset(); }
  // \u521d\u671f\u5316
  public void reset() { point = sign = inputted = false; }
  // 1) \u6d6e\u52d5\u5c0f\u6570\u70b9\u6642\u306e\u5165\u529b\u898f\u5247\u30c1\u30a7\u30c3\u30af
  public boolean checkFloat(char c) {
    boolean flag = true;
    switch (c) {
      // \u7b26\u53f7
    case '+' :
    case '-' :
      if ((sign) || (inputted)) flag = false;
        else                    sign = true;
      break;
      // \u5c0f\u6570\u70b9
    case '.' :
      if ((point) || (!inputted)) flag  = false;
        else                      point = true;
      break;
    default :
      if (isNumberChar(c)) inputted = true;
        else               flag     = false;
      break;
    }
    return flag;
  }
  // 2) \u6574\u6570\u5165\u529b\u6642\u306e\u5165\u529b\u898f\u5247\u30c1\u30a7\u30c3\u30af\uff08\u73fe\u72b6\u306f\u4f7f\u308f\u308c\u3066\u3044\u306a\u3044\uff09
  public boolean checkInt(char c) {
    if (c == '.') return false;
    return checkFloat(c);
  }
}

// \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u8a18\u9332\u7528\u30af\u30e9\u30b9
class loggingClass {
  private String       _defaultFileName = "default.txt";
  protected String     logFileName;    // \u30d5\u30a1\u30a4\u30eb\u540d\uff08\u30b9\u30b1\u30c3\u30c1\u30d5\u30a9\u30eb\u30c0\u306b\u4fdd\u5b58\uff09
  private boolean      loggingNow;     // true\u306e\u9593\u306f\u30ed\u30b0\u3092\u8a18\u9332\u3059\u308b
  private PrintWriter  output;         // \u30ed\u30b0\u51fa\u529b\u7528\u30d5\u30a1\u30a4\u30eb\u30dd\u30a4\u30f3\u30bf
  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  loggingClass() {
    logFileName   = "";
    loggingNow    = false;
    output        = null;
  }
  public void setFileName(String filename) {
    if (filename.length() > 0) logFileName = filename;
      else                     logFileName = _defaultFileName;
  }
  public boolean isEnableLogging() { return output == null ? false : true; }
  // ---- \u30ed\u30b0\u95a2\u4fc2\u306e\u30b3\u30de\u30f3\u30c9 -----
  // \u30e6\u30fc\u30b6\u30fc\u306f\u4f7f\u7528\u3057\u306a\u3044
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307fprint()
  public void print2Log(String str) { 
    if (loggingNow) output.print(str);
  }
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307fprintln()
  public void println2Log(String str) { 
    if (loggingNow) output.println(str);
  }
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307fnewline()
  public void newline2Log() { 
    println2Log("");
  }
  // ---- \u95a2\u6570 -------------------------------------------------
  // \u5b9f\u969b\u306b\u306f\u4e00\u3064\u4e0a\u306e\u30af\u30e9\u30b9\u304cI/F\u306b\u306a\u308b\u306e\u3067\u30e6\u30fc\u30b6\u306f\u4f7f\u7528\u3057\u306a\u3044\u3053\u3068
  // ---- \u95a2\u6570 -------------------------------------------------
  public String setDefaultFilename() { return _defaultFileName; }
  public String setDefaultFilename(String fname) {
    String oldname = _defaultFileName;
    _defaultFileName = fname;
    return oldname;
  }
  // \u30ed\u30b0\u8a18\u9332\u958b\u59cb
  public PrintWriter startLogging() {
    if (output != null) stopLogging();
    output     = createWriter(logFileName);
    loggingNow = true;
    println2Log("--- Logging start : " + nowDateTime() + "---");
    return output;
  }
  // \u30ed\u30b0\u8a18\u9332\u7d42\u4e86
  public void stopLogging() {
    if (output != null) {
      println2Log("--- Logging finished : " + nowDateTime() + "---");
      // \u30d5\u30a1\u30a4\u30eb\u3092\u9589\u3058\u308b
      output.flush();
      output.close();
    }
    // \u8a2d\u5b9a\u3092\u521d\u671f\u5316\u3059\u308b
    loggingNow  = false;
    output      = null;
  }
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u3092\u4e00\u6642\u7684\u306b\u505c\u6b62\u3059\u308b
  public void pauseLogging() { 
    loggingNow = false;
  }
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u3092\u518d\u958b\u3059\u308b
  public void restartLogging() {
    if (output != null) loggingNow = true;
  }
}

// ------------------------------------
// \u30c6\u30ad\u30b9\u30c8\u753b\u9762\uff08\u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\uff09\u306e\u5c5e\u6027
// ------------------------------------
class screenClass {
  protected int   cwidth, cheight;           // \u30ad\u30e3\u30e9\u30af\u30bf\u306e\u6a2a\u6587\u5b57\u6570\uff0c\u884c\u6570
  protected int   gwx, gwy;                  // \u30b9\u30af\u30ea\u30fc\u30f3\u30b5\u30a4\u30ba
  protected int   colwidth, rowheight;       // \u4e00\u6587\u5b57\u306e\u6587\u5b57\u9001\u308a\uff0c\u884c\u9593\uff08pixel\uff09
  protected int   frameWidth;                // \u984d\u7e01\u306e\u5e45\uff08\u4e0a\u4e0b\u5de6\u53f3\u540c\u4e00\uff09
  protected float hStep, vStep;              // \u6587\u5b57\u9593\u9694\uff0c\u884c\u9593\u9694\u306e\u6bd4\u7387\uff081.0\u3067\u5bc6\u7740\uff09
  protected PGraphics pgText;                // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528
  screenClass(int max_x, int max_y, int fsize) {
    cwidth     = max_x;
    cheight    = max_y;
    frameWidth = 10;
    hStep      = _HSTEP;
    vStep      = _VSTEP;
    reCalc(fsize);
  }
  public void setPgText(PGraphics pg) { pgText = pg; }
  public void reCalc(int fsize) {
    colwidth   = PApplet.parseInt(fsize * hStep);
    rowheight  = PApplet.parseInt(fsize * vStep);
    gwx        = cwidth  * colwidth  + frameWidth * 2;
    gwy        = cheight * rowheight + frameWidth * 2;
  }
}

/////////////////////////////////////////
// \u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u3068\u30b3\u30f3\u30bd\u30fc\u30eb\u51fa\u529b\u306e\u30af\u30e9\u30b9
/////////////////////////////////////////
class consoleClass extends tomahawkClass {
  // \u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u95a2\u4fc2\u306e\u7ba1\u7406\u7528\u5909\u6570
  protected float cx = 0.0f, cy = 0.0f;        // \u30ad\u30e3\u30e9\u30af\u30bf\u306e\u8868\u793a\u4f4d\u7f6e\uff08\u30ab\u30ec\u30f3\u30c8\u30dd\u30b8\u30b7\u30e7\u30f3\uff09\uff0c\u534a\u89d2\u6587\u5b57\u306f0.5\u6587\u5b57
  protected float tabSize = _TABSIZE;        // \u30bf\u30d6\u6587\u5b57\u6570
  screenClass     screenSetting;
  // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u306e\u5c5e\u6027\u306e\u8a2d\u5b9a\uff08clrscr()\u3067\u8a2d\u5b9a\u3055\u308c\u308b\uff09
  protected textAttrClass  currentAttr;
  // \u6a5f\u80fd\u9078\u629e\u306e\u30d5\u30e9\u30b0
  protected boolean nodisplay   = false;   // \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u8868\u793a\u306e\u6291\u5236
  protected boolean noTextArea  = false;   // PDE\u306e\u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2\u3078\u306e\u6587\u5b57\u5217\u306e\u8868\u793a\u306e\u6291\u5236
  protected boolean noOverlap   = false;   // \u30a6\u30a3\u30f3\u30c9\u30a6\u304b\u3089\u306f\u307f\u51fa\u3059\u6587\u5b57\u5217\u3092\u6298\u308a\u8fd4\u3057\u3066\u6b21\u884c\u306b\u8868\u793a\u3057\u306a\u3044
  // \u30c6\u30ad\u30b9\u30c8\u753b\u9762\u306e\u30b9\u30af\u30ed\u30fc\u30eb\u8868\u793a\u95a2\u4fc2
  textbufferClass      textbuffer;         // \u30d0\u30c3\u30d5\u30a1\u95a2\u4fc2\u306e\u30af\u30e9\u30b9
  private boolean      recordTextBuffer;   // true\u306e\u9593\u306f\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u306b\u8a18\u9332\u3059\u308b
  protected int        autoScrollLines;    // \u81ea\u52d5\u30b9\u30af\u30ed\u30fc\u30eb\u3059\u308b\u884c\u6570\uff080\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u6642\u306f\u5b8c\u5168\u306b\u6d88\u53bb\uff09
  // \u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u898f\u5247\u306e\u30c1\u30a7\u30c3\u30af
  keyInputConstraintClass  keyCheck;
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u95a2\u4fc2
  loggingClass         logging;
  private boolean      enableLogging;  // \u30c6\u30ad\u30b9\u30c8\u30ed\u30b0\u3092\u8a18\u9332\u3059\u308b\uff08setup()\u3067\u306e\u307f\u6709\u52b9\uff09

  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\uff08\u5f15\u6570\u306f\u6a2a\u65b9\u5411\u306e\u6700\u5927\u6587\u5b57\u6570\u3068\u7e26\u65b9\u5411\u306e\u6700\u5927\u884c\u6570\uff09
  consoleClass(int max_x, int max_y, int mode) {
    super(mode);
    // \u30b9\u30af\u30ea\u30fc\u30f3\u306e\u8a2d\u5b9a
    currentAttr   = new textAttrClass();
    screenSetting = new screenClass(max_x, max_y, currentAttr.fontSize);
    // \u518d\u8a2d\u5b9a
    screenReset();
    // \u30c7\u30d5\u30a9\u30eb\u30c8\u6587\u5b57\u8272\u3068\u80cc\u666f\u8272\u306e\u8a2d\u5b9a
    setColor(currentAttr.textColor, currentAttr.bgColor);
    // \u30b9\u30af\u30ed\u30fc\u30eb\u8868\u793a\u7528\u306e\u30d0\u30c3\u30d5\u30a1\u95a2\u9023
    textbuffer       = new textbufferClass(screenSetting, currentAttr);
    recordTextBuffer = true;
    autoScrollLines  = 0;
    // \u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u898f\u5247\u30c1\u30a7\u30c3\u30af
    keyCheck      = new keyInputConstraintClass();
    // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u95a2\u4fc2
    logging       = new loggingClass();
    enableLogging = false;
  }
  // Tomahawk\u304c\u5229\u7528\u53ef\u80fd\u304b\u3069\u3046\u304b\uff1f\uff08\u3053\u308c\u306f\u4f7f\u308f\u306a\u3044\u304b\u306a\uff09
/*
  boolean isEnableTomahawk() {
    if (screenSetting.pgText == null) return false;
    return true;
  }
*/
  // \u30d5\u30a9\u30f3\u30c8\u306e\u8a2d\u5b9a
  public void prepareFont() {
    if (tomahawkMode == 2) {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642
      PFont font = createFont(_FONTNAME, currentAttr.fontSize, false);  // \u30d5\u30a9\u30f3\u30c8\u3092\u5909\u63db
      screenSetting.pgText.beginDraw();
      screenSetting.pgText.textFont(font);                     // \u30d5\u30a9\u30f3\u30c8\u3092\u8a2d\u5b9a
      screenSetting.pgText.textMode(SCREEN);
      screenSetting.pgText.textSize(currentAttr.fontSize);     // \u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\u3092\u8a2d\u5b9a\uff08\u4e0d\u8981\uff1f\uff09
      screenSetting.pgText.textAlign(LEFT, TOP);               // \u914d\u7f6e
//    screenSetting.pgText.smooth();
      screenSetting.pgText.endDraw();
    } else {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4e0d\u4f7f\u7528\u6642
      PFont font = createFont(_FONTNAME, currentAttr.fontSize, true);  // \u30d5\u30a9\u30f3\u30c8\u3092\u5909\u63db
      textFont(font);                     // \u30d5\u30a9\u30f3\u30c8\u3092\u8a2d\u5b9a
//    textMode(SCREEN);                   // \u3053\u308c\u3092\u6709\u52b9\u306b\u3059\u308b\u3068\u6587\u5b57\u304c\u8868\u793a\u3055\u308c\u306a\u3044
      textSize(currentAttr.fontSize);     // \u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\u3092\u8a2d\u5b9a\uff08\u4e0d\u8981\uff1f\uff09
      textAlign(LEFT, TOP);               // \u914d\u7f6e
    }
  }
  // \u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\u306e\u521d\u671f\u8a2d\u5b9a\u306e\u5b9f\u4f53\uff08\u76f4\u63a5\uff0c\u30e6\u30fc\u30b6\u306f\u547c\u3073\u51fa\u3055\u306a\u3044\uff09
  public void _setFontSize(int size) {
    if (size <= 0) return;
    currentAttr.fontSize  = size;
    textbuffer.fontSize   = size;
    screenSetting.reCalc(size);
  }
  // \u753b\u9762\u30d1\u30e9\u30e1\u30fc\u30bf\u5909\u66f4\u5f8c\u306e\u30ea\u30bb\u30c3\u30c8\u52d5\u4f5c
  public void screenReset() {
    // \u30b9\u30af\u30ea\u30fc\u30f3\u306e\u8a2d\u5b9a
    size(screenSetting.gwx, screenSetting.gwy);
    if (tomahawkMode == 2) screenSetting.pgText = createGraphics(screenSetting.gwx, screenSetting.gwy, P3D);  // JAVA2D\u3060\u3068\u6587\u5b57\u304c\u51fa\u306a\u3044
      else                 screenSetting.pgText = null;
    _clrscr();  
    // \u30d5\u30a9\u30f3\u30c8\u95a2\u4fc2
    prepareFont();
  }

  // ----------- \u753b\u9762\u51fa\u529b\u95a2\u4fc2-----------------
  // \u6587\u5b57\u4f4d\u7f6e\u3092\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u5ea7\u6a19\u306b\u5909\u63db
  private int ptx(float x) { 
    return PApplet.parseInt(x * screenSetting.colwidth  + screenSetting.frameWidth);
  }
  private int pty(float y) { 
    return PApplet.parseInt(y * screenSetting.rowheight + screenSetting.frameWidth);
  }

  // \u51fa\u529b\u4f4d\u7f6e\u6307\u5b9a\uff08\u5ec3\u6b62\u4e88\u5b9a\uff1a\u4f7f\u3063\u3066\u3082\u826f\u3044\u304c\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u306f\u975e\u5bfe\u5fdc\uff09
  public void locate(int x, int y) {
    if (x < 0) x = 0;
    if (y < 0) y = 0;
    cx = x;
    cy = y;
  }
  // \u884c\u6570\u304c\u6700\u5927\u5024\u306b\u9054\u3057\u305f\u304b
  private boolean rowCheck() {
    // \u9054\u3057\u305f\u306a\u3089\u3070\u753b\u9762\u6d88\u53bb
    if (cy >= screenSetting.cheight) {
      if (autoScrollLines == 0) {
        // \u30aa\u30fc\u30c8\u30b9\u30af\u30ed\u30fc\u30eb\u7121\u52b9\uff08\u5168\u753b\u9762\u6d88\u53bb\uff09
        _clrscr();
        textbuffer.readingLine += screenSetting.cheight;  // \u3053\u3053\u3060\u3051\u306f\u5f37\u5236\u7684\u306b\u30a4\u30f3\u30af\u30ea\u30e1\u30f3\u30c8\u3059\u308b\u5fc5\u8981\u304c\u3042\u308b\uff08\u307e\u3060\u51fa\u529b\u3057\u3066\u3044\u306a\u3044\uff09
      } else {
        // \u30aa\u30fc\u30c8\u30b9\u30af\u30ed\u30fc\u30eb\u5bfe\u5fdc
        stopRecordTextBuffer();
        pageLineScroll(autoScrollLines);
        startRecordTextBuffer();
      }
      return true;
    }
    return false;
  }
  // BS\u30ad\u30fc\u304c\u62bc\u3055\u308c\u305f\u5834\u5408\u306e\u51e6\u7406
  public void backSpace() {
    if (keyBufferLength() > 0) {
      keyBuffer = keyBuffer.substring(0, keyBuffer.length() - 1);
      writeBS();
    }
  }
  // \u30c6\u30ad\u30b9\u30c8\u6587\u5b570.5\u6587\u5b57\u5206\u3092\u524a\u9664\uff08\u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u6642\u306e\u307f\u6709\u52b9\u306a\u305f\u3081\uff09
  private void writeBS() {
    if (cx <= 0) return;
    if (!nodisplay) {
      cx -= 0.5f;
      if (tomahawkMode == 2) {
        // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642
        resetAlpha(ptx(cx), pty(cy), screenSetting.colwidth/2, screenSetting.rowheight, true);
      } else {
        // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u30ec\u30a4\u30e4\u30fc\u4e0d\u4f7f\u7528\u6642
        noStroke();
        fill(currentAttr.bgColor);    // \u80cc\u666f\u8272
        rect(ptx(cx), pty(cy), screenSetting.colwidth/2, screenSetting.rowheight);
        fill(currentAttr.textColor, 255);          // \u5857\u308a\u3064\u3076\u3057\u8272
      }
    }
    //  if (!noTextArea) print("\b");  // backspace\u306e\u30a8\u30b9\u30b1\u30fc\u30d7\u30b7\u30fc\u30b1\u30f3\u30b9\u306f\u7121\u52b9\u306e\u6a21\u69d8\uff0e
  }
  // \u4e0e\u3048\u3089\u308c\u305f\u6587\u5b57\u306e\u5927\u304d\u3055\u3092\u8fd4\u3059\uff0e\u5168\u89d2\u306a\u3089\u3070\uff11\uff0c\u534a\u89d2\u306a\u3089\u30700.5
  private float charLength(char c) {
    if (tomahawkMode == 2) return screenSetting.pgText.textWidth(c) / currentAttr.fontSize;
    return textWidth(c) / currentAttr.fontSize;
  }
  // \u4e0e\u3048\u3089\u308c\u305f\u6587\u5b57\u5217\u306e\u9577\u3055\uff08\u5e45\uff09\u3092\u8fd4\u3059
  private float getStringWidth(String str) {
    if (tomahawkMode == 2) return screenSetting.pgText.textWidth(str) / currentAttr.fontSize;
    return textWidth(str) / currentAttr.fontSize;
  }
  // \u03b1\u5024\u3092\u30ea\u30bb\u30c3\u30c8\u3059\u308b\uff0e\u7b2c\uff15\u5f15\u6570\u304ctrue\u306e\u5834\u5408\u306f\u7121\u6761\u4ef6\u306b#000000\u3067\u5857\u308a\u3064\u3076\u3059
  public void resetAlpha(int x, int y, int w, int h, boolean clr) {
    PImage pimg;
    int    p, i;
    screenSetting.pgText.beginDraw();
    pimg = screenSetting.pgText.get(x, y, w, h);
    for (i = 0; i < pimg.pixels.length; i++) {
      if (clr) {
        pimg.pixels[i] = color(0xff000000, 0);
      } else {
        p = pimg.pixels[i] & 0x0ffffff;
        if (p > 0) {
  //        p |= 0x0ff000000;
  //        pimg.pixels[i] = color(p);
        } else {
          pimg.pixels[i] = color(p, 0);
        }
      }
    }
    screenSetting.pgText.set(x, y, pimg);
    screenSetting.pgText.endDraw();
  }
  // \u4e00\u6587\u5b57\u8868\u793a\uff08\u6587\u5b57\u5217\u306f\u5168\u3066\u3053\u306e\u95a2\u6570\u3092\u4ecb\u3057\u3066text()\u3067\u8868\u793a\u3059\u308b
  private void putchar(char c) {
    int  px, py;
    px = ptx(cx);
    py = pty(cy);
    if (tomahawkMode == 2) {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642
      screenSetting.pgText.beginDraw();
      screenSetting.pgText.text(c, px, py);
      screenSetting.pgText.endDraw();
//      resetAlpha(px, py - 2, int(getStringWidth(str(c)) * currentAttr.fontSize), currentAttr.fontSize, false);   // \u306a\u305c\u304b-1\u3057\u306a\u3044\u3068\u7dda\u304c\u6b8b\u308b
        resetAlpha(px, py - 2, currentAttr.fontSize * 2, currentAttr.fontSize + 4, false);   // \u306a\u305c\u304b-2\u3057\u306a\u3044\u3068\u7dda\u304c\u6b8b\u308b
    } else {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4e0d\u4f7f\u7528\u6642
      text(c, px, py);
    }
    cx += charLength(c);
  }

  ///////////////////////
  // \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u95a2\u9023
  ///////////////////////
  // \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u3078\u306e\u8a18\u9332\u3092\u4e00\u6642\u7684\u306b\u505c\u6b62\u3059\u308b
  public void stopRecordTextBuffer() { 
    recordTextBuffer = false;
  }
  // \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u3078\u306e\u8a18\u9332\u3092\u518d\u958b\u3059\u308b
  public void startRecordTextBuffer() { 
    recordTextBuffer = true;
  }
  // \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u306e\u6307\u5b9a\u3055\u308c\u305f\u884c\u304b\u3089\uff11\u30da\u30fc\u30b8\u5206\u3092\u518d\u63cf\u753b\u3059\u308b
  public void redrawPage() {
    // \u81ea\u52d5\u30b9\u30af\u30ed\u30fc\u30eb\uff08Run\u4e2d\uff09\u306e\u305f\u3081\u306b\u30ab\u30ec\u30f3\u30c8\u5c5e\u6027\u3092\u30d0\u30c3\u30af\u30a2\u30c3\u30d7
    textAttrClass bakAttr = new textAttrClass();
    bakAttr.clone(currentAttr);
    // \u518d\u63cf\u753b
    redrawPage(textbuffer.readingLine);
    // \u30ab\u30ec\u30f3\u30c8\u5c5e\u6027\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3092\u30ea\u30b9\u30c8\u30a2
    currentAttr.clone(bakAttr);
  }
  public void redrawPage(int line) {
    int       lineCount, dcy;
    lineClass thisline;

    // \u8868\u793a\u958b\u59cb\u884c\u6570\u306e\u30c1\u30a7\u30c3\u30af
    textbuffer.incrementReadingLine(0);
    // \u521d\u671f\u5316
    _clrscr();
    thisline = textbuffer.getTargetLine(line);
    // \u518d\u63cf\u753b
    // \u30b9\u30af\u30ed\u30fc\u30eb\u8868\u793a\u6642\u306f\u4e00\u6642\u7684\u306b\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3092\u5f37\u5236\u7684\u306b\u30aa\u30d5\u306b\u3059\u308b
    boolean over_flag = noOverlap;
    disableOverlap();
    for (lineCount = 0; lineCount < screenSetting.cheight; lineCount += dcy) {
      if (!thisline.flag) break; // \u3053\u308c\u4ee5\u964d\uff0c\u30c6\u30ad\u30b9\u30c8\u304c\u51fa\u529b\u3055\u308c\u3066\u3044\u306a\u3044\u306e\u3067\u629c\u3051\u308b
      dcy      = writelnText(thisline.line);
      thisline = thisline.next;
    }
    // \u5143\u306e\u72b6\u614b\u306b\u623b\u3059
    noOverlap = over_flag;
  }
  // \u30da\u30fc\u30b8\u5358\u4f4d\u306e\u30b9\u30af\u30ed\u30fc\u30eb
  // page\u304c\u6b63\u3067\u4e0b\uff0c\u8ca0\u3067\u4e0a\u306b\u30b9\u30af\u30ed\u30fc\u30eb
  public void pageScroll(float page) {
    textbuffer.incrementReadingLine(PApplet.parseInt(screenSetting.cheight * page));
    redrawPage();
  }
  // \u6307\u5b9a\u3057\u305f\u884c\u6570\u3060\u3051\u4e0a/\u4e0b\u306b\u30b9\u30af\u30ed\u30fc\u30eb\u3059\u308b
  // num \u304c\u6b63\u3067\u4e0b\uff0c\u8ca0\u3067\u4e0a\u306b\u30b9\u30af\u30ed\u30fc\u30eb
  public void pageLineScroll(int num) {
    textbuffer.incrementReadingLine(num);
    redrawPage();
  }
  // \u6700\u65b0\u306e\u30da\u30fc\u30b8\u3092\u518d\u63cf\u753b\uff08\u30ab\u30fc\u30bd\u30eb\u4f4d\u7f6e\u304c\u5fa9\u5143\u3055\u308c\u306a\u3044\u306e\u306f\u4ed5\u65b9\u304c\u7121\u3044
  public void redrawNewestPage() {
    int  linenumber;
    if (textbuffer.totalLines < screenSetting.cheight) {
      textbuffer.setReadingLine(0);
    } else {
      textbuffer.setReadingLine(textbuffer.totalLines - PApplet.parseInt(screenSetting.cheight / 2.0f));
    }
    redrawPage();
  }
  // \u65b0\u3057\u3044\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u5f62\u5f0f\u3067\u4e00\u884c\u5206\u306e\u51fa\u529b\uff08\u8272\u3064\u304d\uff09
  public int writelnText(sentenceClass sen) {
    int num = 1;
    int dy;
    while (true) {
      textColor(sen.attr.textColor);
      // \u30c6\u30ad\u30b9\u30c8\u30ab\u30e9\u30fc\u3092\u5909\u66f4
      if (tomahawkMode == 2) {
        // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642
        screenSetting.pgText.beginDraw();
        screenSetting.pgText.fill(sen.attr.textColor, 255f);
        screenSetting.pgText.endDraw();
      } else {
        // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4e0d\u4f7f\u7528\u6642
        fill(sen.attr.textColor, 255);
      }
      if ((dy = write(sen.sentence)) > 1) num += (dy - 1);
      if (sen.next == null) break;
      sen = sen.next;
    }
    writeln("");
    return num;
  }
  // ------------------------
  // \u6587\u5b57\u8272\u3068\u80cc\u666f\u8272\u306e\u521d\u671f\u8a2d\u5b9a
  // ------------------------
  public void setColor(int tcolor, int bcolor) {
    textColor(tcolor);
    bgColor(bcolor);
  }
  // \u6587\u5b57\u306e\u8272\u306e\u307f\u3092\u5909\u66f4\u3059\u308b
  // (a) \u73fe\u5728\u306e\u8a2d\u5b9a\u5024\u3092\u8fd4\u3059
  public int textColor() { 
    return currentAttr.textColor;
  }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int textColor(int textcolor) {
    int oldColor;
    oldColor              = currentAttr.textColor;
    if (brightness(textcolor) <= 2.0f) textcolor = 0xff000002;  // PGraphics\u306e\u4ed5\u69d8\u4e0a\u306e\u554f\u984c\u70b9\u306e\u56de\u907f
    currentAttr.textColor = textcolor;
    if (tomahawkMode == 2) {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642
      screenSetting.pgText.beginDraw();
      screenSetting.pgText.fill(currentAttr.textColor, 255);
      screenSetting.pgText.endDraw();
    } else {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4e0d\u4f7f\u7528\u6642
      fill(currentAttr.textColor);
    }
    return oldColor;
  }
  // \u80cc\u666f\u306e\u8272\u306e\u307f\u3092\u5909\u66f4\u3059\u308b\uff08\u3042\u307e\u308a\u304a\u52e7\u3081\u3057\u306a\u3044\uff09
  // (a) \u73fe\u5728\u306e\u8a2d\u5b9a\u5024\u3092\u8fd4\u3059
  public int bgColor() { 
    return currentAttr.bgColor;
  }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int bgColor(int bgcolor) {
    int oldColor;
    oldColor            = currentAttr.bgColor;
    currentAttr.bgColor = bgcolor;
    return oldColor;
  }
  // \u30bf\u30d6\u6587\u5b57\u6570\u306e\u8a2d\u5b9a
  // (a) \u73fe\u5728\u306e\u8a2d\u5b9a\u5024\u3092\u8fd4\u3059
  public float tabSize() { return tabSize; }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public float tabSize(float num) {
    float oldnum = tabSize;
    if ((num < 0.0f) || (num >= screenSetting.cwidth)) return oldnum;
    tabSize = num;
    return oldnum;
  }
  // --------
  // \u30bf\u30d6\u51fa\u529b
  // --------
  public String getTabSpace() {
    String space = "";
    float  num;
    int    i;
    num = PApplet.parseInt((cx + tabSize) % tabSize * 2);
    if (num == 0) return "";
    num = PApplet.parseInt(tabSize * 2) - num;
    for (i = 0; i < num; i++) space += " ";    
    return space;
  }
  // \u5f15\u6570\u6307\u5b9a\u306a\u3057\uff08\u8a2d\u5b9a\u5024\u3092\u4f7f\u7528\u3059\u308b\uff09
  public float tab(boolean flag) {
    String space;
    space = getTabSpace();
    if (flag) write(space); else _write(space);
    return space.length() / 0.5f;
  }
  // \u5f15\u6570\u6307\u5b9a\u3042\u308a\uff08\u66ab\u5b9a\u7684\u306b\u6307\u5b9a\u3055\u308c\u305f\u5024\u3092\u4f7f\u7528\u3059\u308b\uff09
  public float tab(float temp, boolean flag) {
    float bak = tabSize;
    float num;
    tabSize = temp;
    num = tab(flag);
    tabSize = bak;
    return num;
  }
  // \u5f15\u6570\u6307\u5b9a\u306a\u3057\uff08\u8a2d\u5b9a\u5024\u3092\u4f7f\u7528\u3059\u308b\uff09
  public float tab()  { return tab(true); }
  public float _tab() { return tab(false); }
  // \u5f15\u6570\u6307\u5b9a\u3042\u308a\uff08\u66ab\u5b9a\u7684\u306b\u6307\u5b9a\u3055\u308c\u305f\u5024\u3092\u4f7f\u7528\u3059\u308b\uff09
  public float tab(float temp)  { return tab(temp, true); }
  public float _tab(float temp) { return tab(temp, false); }

  // \u753b\u9762\u6d88\u53bb\uff08\u753b\u9762\u306e\u307f\u30af\u30ea\u30a2\uff09
  public void _clrscr() {
    if (tomahawkMode == 2) {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642
      background(currentAttr.bgColor);  // \u80cc\u666f\u8272
      screenSetting.pgText.beginDraw();
      screenSetting.pgText.background(0xff000000, 0);
      screenSetting.pgText.fill(currentAttr.textColor, 255);      // \u5857\u308a\u3064\u3076\u3057\u8272
      screenSetting.pgText.endDraw();
    } else {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4e0d\u4f7f\u7528\u6642
      background(_BGCOLOR);
      fill(currentAttr.textColor);      // \u5857\u308a\u3064\u3076\u3057\u8272
    }
    cx = cy = 0;
  }
  // \u753b\u9762\u6d88\u53bb\uff08\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u3082\u30af\u30ea\u30a2\uff09
  public void clrscr() {
    _clrscr();
    textbuffer.clearTextBuffer();
  }
  // \u30c6\u30ad\u30b9\u30c8\u51fa\u529b\uff08\u5358\u7d14\u306b\u63cf\u753b\u3059\u308b\u3060\u3051\uff09: userDraw()\u4e2d\u3067\u5229\u7528\u3059\u308b\u306e\u306b\u9069\u3057\u3066\u3044\u308b
  public int _write(String message) {
    int  i, num = 1;
    // \u30c6\u30ad\u30b9\u30c8\u306e\u8272\u3092\u5fa9\u5143\u3059\u308b
    if (tomahawkMode == 2) {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642
      screenSetting.pgText.beginDraw();
      screenSetting.pgText.fill(currentAttr.textColor, 255);
      screenSetting.pgText.endDraw();
    } else {
      // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4e0d\u4f7f\u7528\u6642
      fill(currentAttr.textColor);
    }
    rowCheck();
    for (i = 0; i < message.length(); i++) {
      putchar(message.charAt(i));
      // \u6298\u308a\u8fd4\u3057\u8868\u793a\u306b\u95a2\u3059\u308b\u51e6\u7406
      if (noOverlap != true) {
        if (cx >= screenSetting.cwidth) {
          cx = 0;
          cy++;
          num++;
          rowCheck();
        }
      }
    }
    return num;
  }
  // \u5ea7\u6a19\u6307\u5b9a\uff08\u30ed\u30b0\u51fa\u529b\u7b49\u306a\u3057\uff09
  public int _write(int x, int y, String message) {
    locate(x, y);
    return _write(message);
  }
  // \u6539\u884c\u3042\u308a
  public int _writeln(String message) {
    int  num;
    num = _write(message);
    cy++;
    cx = 0;
    return num;
  }
  // \u5ea7\u6a19\u6307\u5b9a\uff08\u30ed\u30b0\u51fa\u529b\u7b49\u306a\u3057\uff09
  public int _writeln(int x, int y, String message) {
    locate(x, y);
    return _writeln(message);
  }
  // \u30c6\u30ad\u30b9\u30c8\u51fa\u529b\uff08\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\uff0c\u30ed\u30b0\u8a18\u9332\uff0c\u30d0\u30c3\u30af\u30b9\u30da\u30fc\u30b9\u306b\u3088\u308b\u6d88\u53bb\u306b\u5bfe\u5fdc\uff09
  // \u623b\u308a\u5024\u306f\u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u51fa\u529b\u3057\u305f\u5b9f\u969b\u306e\u884c\u6570\uff08\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u3092\u8003\u616e\uff09
  public int write(String message) {
    int i;
    int num = 0;
    if (!nodisplay) {
      rowCheck();
      num = _write(message);
      if (recordTextBuffer) {
        textbuffer.appendSentence(message, currentAttr);
        // \u3082\u3057\u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u6307\u5b9a\u304c\u6709\u52b9\u304b\u3064\u4e00\u884c\u3092\u8d85\u3048\u3066\u3044\u308b\u306a\u3089\u3070\uff0c\u8d85\u3048\u3066\u3044\u308b\u5206\u3092\u5148\u306b\u78ba\u5b9a\u3059\u308b\uff0e
        if (!noOverlap) textbuffer.normalizeBuffer();
      }
    }
    // \u30b3\u30f3\u30bd\u30fc\u30eb\u306b\u51fa\u529b
    if (!noTextArea) {
      if (recordTextBuffer) print(message);
    }
    // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u8a18\u9332
    if (enableLogging) print2Log(message);
    return num;
  }
  // \u5ea7\u6a19\u6307\u5b9a\uff08\u30ed\u30b0\u51fa\u529b\u7b49\u5bfe\u5fdc\uff09
  public int write(int x, int y, String message) {
    int     num;
    boolean flag;
    flag = displaySwitch();
    disableDisplay();
    locate(x, y);
    num = write(message);
    displaySwitch(flag);
    return num;
  }
  // \u30c6\u30ad\u30b9\u30c8\u51fa\u529b\uff08\u6539\u884c\uff09
  public int writeln(String message) {
    int num;

    // \u4ee5\u4e0b\u6539\u884c\u306e\u307f\u51fa\u529b
    num = write(message);
    if (!nodisplay) {
      if (recordTextBuffer) textbuffer.setLine(!noOverlap);
      cy++;
      cx = 0;
    }
    // \u30b3\u30f3\u30bd\u30fc\u30eb\u306b\u51fa\u529b
    if (!noTextArea) {
      if (recordTextBuffer) println();
    }
    // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u8a18\u9332
    if (enableLogging) println2Log("");
    return num;
  }
  // \u5ea7\u6a19\u6307\u5b9a\uff08\u30ed\u30b0\u51fa\u529b\u7b49\u5bfe\u5fdc\uff09
  public int writeln(int x, int y, String message) {
    int     num;
    boolean flag;
    flag = displaySwitch();
    disableDisplay();
    locate(x, y);
    num = writeln(message);
    displaySwitch(flag);
    return num;
  }
  // \u6539\u884c
  public void newline() { 
    writeln("");
  }
  // ----------
  // \u8a2d\u5b9a\u306e\u5909\u66f4
  // ----------
  // \u30a6\u30a3\u30f3\u30c9\u30a6\u30b5\u30a4\u30ba\u306e\u5909\u66f4\uff1a\u3000\u5f37\u5236\u7684\u306b\u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u30b5\u30a4\u30ba\u304c\u5909\u66f4\u3055\u308c\u308b\u3060\u3051\u3067\u30c6\u30ad\u30b9\u30c8\u753b\u9762\u306e\u51e6\u7406\u306b\u306f\u53cd\u6620\u3055\u308c\u306a\u3044\u305f\u3081\u975e\u63a8\u5968\uff0e
  public void windowSize(int x, int y) {
    screenSetting.gwx = x;
    screenSetting.gwy = y;
    size(screenSetting.gwx, screenSetting.gwy);
  }
  // \u30c7\u30a3\u30b9\u30d7\u30ec\u30a4\u8868\u793a\u306e\u6291\u5236\u3068\u8a31\u53ef
  // (a) \u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059
  public boolean displaySwitch() { return nodisplay; }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u8a2d\u5b9a\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public boolean displaySwitch(boolean flag) {
    boolean oldflag = nodisplay;
    nodisplay = flag;
    return oldflag;
  }
  public void disableDisplay() { 
    nodisplay = true;
  }
  public void enableDisplay() { 
    nodisplay = false;
  }
  // \u30c6\u30ad\u30b9\u30c8\u30a8\u30ea\u30a2\u8868\u793a\u306e\u6291\u5236\u3068\u8a31\u53ef
  // (a) \u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059
  public boolean textAreaSwitch() { return noTextArea; }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u8a2d\u5b9a\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public boolean textAreaSwitch(boolean flag) { 
    boolean oldflag = noTextArea;
    noTextArea = flag;
    return oldflag;
  }
  public void disableTextArea() { 
    noTextArea = true;
  }
  public void enableTextArea() { 
    noTextArea = false;
  }
  // \u30aa\u30fc\u30d0\u30fc\u30e9\u30c3\u30d7\u8868\u793a\uff08\u6298\u308a\u8fd4\u3057\uff09\u306e\u6291\u5236\u3068\u8a31\u53ef
  // (a) \u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059
  public boolean overlapSwitch() { return noOverlap; }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u8a2d\u5b9a\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public boolean overlapSwitch(boolean flag) { 
    boolean oldflag = noOverlap;
    noOverlap = flag;
    return oldflag;
  }
  public void disableOverlap() { 
    noOverlap = true;
  }
  public void enableOverlap() { 
    noOverlap = false;
  }

  // \u3010\u30c6\u30ad\u30b9\u30c8\u51fa\u529b\u306e\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u51fa\u529b\u3011
  // Main() \u3068 userDraw()\u5b9f\u884c\u4e2d\u306ecrowbar.write()/writeln()\u3092\u30ed\u30b0\u306b\u8a18\u9332
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u9332\u958b\u59cb\uff1aOptions()\u306e\u4e2d\u3067\u5ba3\u8a00\u3059\u308b\u306e\u304c\u7121\u96e3\u3060\u304c\uff0c
  // \u305d\u308cMain()\u3084userDraw()\u306e\u4e2d\u3067\u5ba3\u8a00\u3057\u3066\u3082\u69cb\u308f\u306a\u3044\uff0e
  // \u30d5\u30a1\u30a4\u30eb\u3078\u306e\u8ffd\u8a18\u306f\u4ed5\u69d8\u4e0a\u4e0d\u53ef\u80fd\u306a\u3088\u3046\u306a\u306e\u3067\uff0c\u73fe\u72b6\u3067\u306f\u672a\u5bfe\u5fdc
  // \u65e2\u306b\u8a18\u9332\u958b\u59cb\u3057\u3066\u3044\u3066\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u306a\u3044\u5834\u5408\u306f\uff0c\u73fe\u5728\u8a18\u9332\u4e2d\u306e\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u9589\u3058\u3066\u65b0\u3057\u304f\u8a18\u9332\u3092\u958b\u59cb\u3059\u308b
  // 1) \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u5909\u66f4\u3059\u308b
  public String setDefaultFilename() {
    return logging.setDefaultFilename();
  }
  public String setDefaultFilename(String fname) { 
    if (fname.length() == 0) return setDefaultFilename();
    return logging.setDefaultFilename(fname);
  }
  // 2-1) \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u30aa\u30fc\u30d7\u30f3\uff08\u5f15\u6570\u7121\u3057\uff1a\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u3067\u4fdd\u5b58\uff09
  public PrintWriter startLogging() { 
    return startLogging("");
  }
  // 2-2) \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u30aa\u30fc\u30d7\u30f3\uff08\u30d5\u30a1\u30a4\u30eb\u540d\u6307\u5b9a\u3042\u308a\uff09
  public PrintWriter startLogging(String fname) {
    logging.setFileName(fname);
    println("\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u4f5c\u6210\u3057\u307e\u3059\uff1a" + logging.logFileName);
    return logging.startLogging();
  }
  // 3) \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u30af\u30ed\u30fc\u30ba\uff08\u660e\u793a\u3057\u306a\u3044\u3067\u3082crowbar\u7d42\u4e86\u6642\u306b\u9589\u3058\u3066\u304f\u308c\u308b\uff09
  public void stopLogging() {
    logging.stopLogging();
  }
  // 4-1) \u30ed\u30b0\u8a18\u9332\u306e\u4e00\u6642\u4e2d\u65ad
  public void pauseLogging() { 
    logging.pauseLogging();
  }
  // 4-2) \u30ed\u30b0\u8a18\u9332\u306e\u518d\u958b
  public void restartLogging() { 
    logging.restartLogging();
  }
  // 5) \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307fprint()
  public void print2Log(String str) { 
    logging.print2Log(str);
  }
  // 6) \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307fprintln()
  public void println2Log(String str) { 
    logging.println2Log(str);
  }
  // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307fnewline()
  public void newline2Log() {
    logging.newline2Log();
  }
  // \u4ee5\u4e0b\u306f\u30e6\u30fc\u30b6\u304c\u7528\u3044\u3066\u306f\u3044\u3051\u306a\u3044\uff08\u30b7\u30b9\u30c6\u30e0\u7528\uff09
  public void enableLogOutput() { 
    enableLogging = true;
  }   // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u3092\u8a31\u53ef
  public void disableLogOutput() { 
    enableLogging = false;
  }   // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306e\u51fa\u529b\u3092\u4e0d\u8a31\u53ef
  public boolean isEnableLogging() { 
    return logging.isEnableLogging();  
//  return enableLogging;
  }

  // --------------- \u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u95a2\u9023 -------------------
  // \u4ee5\u4e0b\u306e\u95a2\u6570\u3084\u5909\u6570\u3092\u30e6\u30fc\u30b6\u306f\u5229\u7528\u3057\u306a\u3044\u3067\u4e0b\u3055\u3044
  //
  private String keyBuffer = "";
  boolean inputNow = false;    // \u30a8\u30b3\u30fc\u30d0\u30c3\u30af\u3042\u308a
  boolean inputFixed = false;  // ENTER\u304c\u5165\u529b\u3055\u308c\u305f\u3089true
  // \u30d0\u30c3\u30d5\u30a1\u30af\u30ea\u30a2  
  public void flushKeyBuffer() {
    keyBuffer = "";
    inputFixed = false;
  }
  // \u6587\u5b57\u5217\u9577\u3092\u8fd4\u3059
  public int keyBufferLength() {
    return keyBuffer.length();
  }
  // \u30b3\u30f3\u30bd\u30fc\u30eb\u304b\u3089\u306e\u5165\u529b\u3092\u958b\u59cb
  public void startInput() {
    inputFixed = false;
    inputNow   = true;
  }
  // \u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u5b8c\u4e86
  public void inputFinish() {
    inputFixed = true;
    inputNow   = false;
  }
  // \u6587\u5b57\u5217\u306e\u8ffd\u52a0
  public void strcat(String str) {
    keyBuffer += str;
  }
  // \u30ad\u30fc\u30d0\u30c3\u30d5\u30a1\u30fc\u3092\u8aad\u307f\u51fa\u3059
  public String getKeyBuffer() {
    String buf;
    buf = keyBuffer;  // \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u30af\u30ed\u30fc\u30f3\u304c\u4f5c\u6210\u3055\u308c\u308b\u306e\u306a\u3089\u826f\u3044\u3051\u308c\u3069\uff0e
    keyBuffer = "";
    inputNow   = false;
    inputFixed = false;
    return buf;  // \u6587\u5b57\u5217\u30c7\u30fc\u30bf\u306e\u307f\u3092\u8fd4\u3055\u306a\u304f\u3066\u826f\u3044\u306e\u304b\uff1f
  }
}

//////////////////////////////
// \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u6700\u5c0f\u5358\u4f4d\u306e\u30af\u30e9\u30b9
//////////////////////////////
class arguments {
  boolean ready;
  String  message;
  String  value;
  String  initialValue;   // ""\u306e\u5834\u5408\u306f\u521d\u671f\u5024\u306e\u6307\u5b9a\u306a\u3057\u3068\u5224\u65ad
  String [] selectValues; // null\u306e\u5834\u5408\u306f\u9078\u629e\u80a2\u30bf\u30a4\u30d7\u3067\u306f\u306a\u3044\u3068\u5224\u65ad\uff08\u8a2d\u5b9a\u6642\u306f\u7a7a\u767d\u3067\u533a\u5207\u3089\u308c\u305f\u6587\u5b57\u5217\uff09
  char    parameterType;  // 'A': Normal, 'N': \u6570\u5024\u306e\u307f, 'S': \u9078\u629e\u80a2
  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  arguments() {
    ready   = false;
    message = value = initialValue = "";
    selectValues  = null;
    parameterType = 'A';
  }
  // \u5024\u3092\u8a2d\u5b9a\uff08\u6a19\u6e96\uff09
  public void set(String str) {
    value = str;
    ready = true;
  }
}

class frontendClass extends consoleClass { 
  arguments [] argv;                    // \u30d1\u30e9\u30e1\u30fc\u30bf\u7fa4\uff08\u30e6\u30fc\u30b6\u306b\u3088\u308a\u5bfe\u8a71\u7684\u306b\u5165\u529b\u3055\u308c\u308b\uff09
  int          argc;                    // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u6570
  protected int obtainArgIndex = 0;     // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u30b3\u30e1\u30f3\u30c8\u5ba3\u8a00\u6642\u306e\u81ea\u52d5\u767b\u9332\u7528\u30ab\u30a6\u30f3\u30bf
  protected int readArgIndex = 0;       // \u30d1\u30e9\u30e1\u30fc\u30bf\u81ea\u52d5\u8aad\u307f\u51fa\u3057\u7528\u30ab\u30a6\u30f3\u30bf
  protected boolean autoInput = false;  // TAB\u30ad\u30fc\u3092\u62bc\u3059\u3068\u305d\u308c\u4ee5\u964d\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u3067\u306f\u521d\u671f\u5024\u3092\u63a1\u7528

  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  frontendClass(int x, int y, int mode) {
    // consoleClass\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u3092\u547c\u3076
    super(x, y, mode);
    // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u521d\u671f\u5316
    argc = 0;
    argv = (arguments [])new arguments[1]; // \u5e38\u306b\u4e00\u3064\u4f59\u5206\u306b\u4f5c\u6210
    argv[0] = new arguments();
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5024\u306e\u30bb\u30c3\u30c8
  public void setValue(String str) {
    argv[obtainArgIndex].set(str);
  }
  // \u30ad\u30fc\u5165\u529b\u30eb\u30fc\u30eb\uff08\u6570\u5024\u306e\u307f\uff09
  public boolean is_numbersOnly() {
    if (argv[obtainArgIndex].parameterType == 'N') return true;
    return false;
  }
  // \u30ad\u30fc\u5165\u529b\u30eb\u30fc\u30eb\uff08\u9078\u629e\u80a2\uff09
  // \u9078\u629e\u80a2\u578b\u306a\u3089\u3070\u9078\u629e\u80a2\u6570\uff08\u6700\u5927\uff11\uff10\uff09\u3092\u8fd4\u3059
  // \u9078\u629e\u80a2\u578b\u3067\u306f\u306a\u3044\u306a\u3089\u3070\uff10\u3092\u8fd4\u3059
  // \u7570\u5e38\u6642\u306f99\u3092\u8fd4\u3059
  public int is_selectOnly() {
    arguments arg;
    arg = argv[obtainArgIndex];
    if (arg.parameterType == 'S') {
      // \u30c1\u30a7\u30c3\u30af\uff11
      if (arg.selectValues == null) {
        println("SystemError: \u9078\u629e\u80a2\u578b\u306a\u306e\u306b\u9078\u629e\u80a2\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e");
        return 99;
      }
      // \u30c1\u30a7\u30c3\u30af\uff12
      if (arg.selectValues.length > 10) {
        println("SystemError: \u9078\u629e\u80a2\u578b\u306e\u9078\u629e\u80a2\u306e\u6570\u304c\uff11\uff10\u500b\u3088\u308a\u591a\u3044\uff0e");
        return 99;
      }
      return arg.selectValues.length;
    }
    return 0;
  }
  // \u9078\u629e\u80a2\u578b\u306e\u9078\u629e\u3055\u308c\u305f\u30d1\u30e9\u30e1\u30fc\u30bf\u5024\u3092\u8fd4\u3059
  public String get_selectValue(int index) {
    return argv[obtainArgIndex].selectValues[index];
  }
  // \u521d\u671f\u5024\u3092\u53d6\u5f97
  public String get_initialValue() {
    return argv[obtainArgIndex].initialValue;
  }
  // \u5168\u3066\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5165\u529b\u5b8c\u4e86\u3057\u3066\uff0cMain()\u3092\u5b9f\u884c\u53ef\u80fd\u304b\uff1f
  public boolean allReady() {
    int i;
    // \u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044
    if (argv == null) return true;
    // \u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b
    for (i = 0; i < argc; i++) {
      if (argv[i].ready != true) return false;
    }
    return true;
  }
  // \u5168\u3066\u306e\u5165\u529b\u5b8c\u4e86\u30d5\u30e9\u30b0\u3092\u30ea\u30bb\u30c3\u30c8\uff08\u518d\u5165\u529b\u6642\u7528\uff09
  public void allResetArguments() {
    int i;
    for (i = 0; i < argv.length; i++) argv[i].ready = false;
    readArgIndex   = 0;
    obtainArgIndex = 0;
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u4e00\u3064\u3082\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u5834\u5408\u306btrue\uff1a\u4f59\u8a08\u306a\u30b7\u30b9\u30c6\u30e0\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u51fa\u529b\u3092\u6291\u5236\u3059\u308b\u305f\u3081
  public boolean isNoParameter() {
    if (argc == 0) return true;
    return false;
  }
  // ------------------------------
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u8aac\u660e\u306e\u53d6\u5f97
  public String get_paramMessage(int index) {
    String    message;
    arguments arg;

    // \u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u7bc4\u56f2\u306e\u30c1\u30a7\u30c3\u30af
    if ((index >= argc) || (index < 0)) {
      println();
      print("[\u8b66\u544a] \u30d1\u30e9\u30e1\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u306eIndex\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\uff01(Index=");
      println(str(index)+")");
      return "";
    }
    // \u8aac\u660e\u306e\u53d6\u5f97
    arg     = argv[index];
    // \u5168\u3066\u306e\u30bf\u30a4\u30d7\u306b\u5171\u901a
    message = arg.message;
    // \u4ee5\u4e0b\uff0c\u30aa\u30d7\u30b7\u30e7\u30f3\u306b\u3088\u3063\u3066\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8ffd\u52a0
    // \u521d\u671f\u5024\u304c\u4e0e\u3048\u3089\u308c\u3066\u3044\u308b\u5834\u5408
    if (arg.initialValue.length() > 0) message += "\uff08\u521d\u671f\u5024\uff1a" + arg.initialValue + "\uff09";
    // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u7a2e\u985e\u306b\u3088\u3063\u3066
    if (arg.parameterType == 'N') {
      // \u6570\u5b57\u306e\u307f
      message += "\uff0f\u6570\u5b57\u306e\u307f";
    } else if (arg.parameterType == 'S') {
      // \u9078\u629e\u80a2\u578b
      int i;
      message += "\uff0f\uff08";
      for (i = 0; i < arg.selectValues.length; i++) {
        if (i > 0) message += ",";
        message += str(i) + ":" + arg.selectValues[i];
      }
      message += "\uff09";
    }
    return message;
  }
  // \u521d\u671f\u5024\u306e\u81ea\u52d5\u5165\u529b\u30e2\u30fc\u30c9\uff08true\u3067\u81ea\u52d5\u5165\u529b\uff09
  public void automaticInputByDefalutValue(boolean flag) { autoInput = flag; }
  // --------------------------------------------
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u753b\u9762\u306b\u8868\u793a\u3059\u308b\u30e1\u30c3\u30bb\u30fc\u30b8\uff09
  // --------------------------------------------
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u6a19\u6e96\uff1a\u6570\u5b57\u306e\u307f\uff09
  public void define(String str) {
    defineStr(str);
    argv[argc - 1].parameterType = 'N';
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u6a19\u6e96\uff1a\u6570\u5b57\u306e\u307f\uff1a\u521d\u671f\u5024\u3042\u308a\uff09
  public void define(String str1, String str2) {
    defineStr(str1, str2);
    argv[argc - 1].parameterType = 'N';
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u6570\u5b57\u306e\u307f\uff1a\u521d\u671f\u5024\u3042\u308a\uff0cfloat\u6e21\u3057\uff09
  public void define(String str, float f) { 
    define(str, str(f));
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u6570\u5b57\u306e\u307f\uff1a\u521d\u671f\u5024\u3042\u308a\uff0cint\u6e21\u3057\uff09
  public void define(String str, int i) { 
    define(str, str(i));
  }

  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u5165\u529b\u5236\u9650\u898f\u5247\u306a\u3057\uff09\uff1a\u5168\u3066\u306edefine\u7cfb\u306f\u6700\u7d42\u7684\u306b\u3053\u306e\u95a2\u6570\u3092\u547c\u3076
  public void defineStr(String str) {
    if (crowbar.status != 0) {
      println("\u30a8\u30e9\u30fc: \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\u306fOptions()\u304bSetup()\u3067\u884c\u3063\u3066\u4e0b\u3055\u3044\uff0f" + str);
      if (crowbar.status == 10) {
        crowbar.halt(); // userDraw()\u306e\u6642\u306f\u5b89\u5168\u306b\u7d42\u4e86
        return;
      } else exit();
    }
    argc = argv.length;
    argv = (arguments [])expand(argv, argc + 1);
    argv[argc] = new arguments();
    // \u73fe\u5728\u306e\u5024\u3092\u30bb\u30c3\u30c8
    argv[argc - 1].message = str;
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u5165\u529b\u5236\u9650\u898f\u5247\u306a\u3057\uff1a\u521d\u671f\u5024\u3042\u308a\uff09
  public void defineStr(String str1, String str2) {
    defineStr(str1);
    argv[argc - 1].initialValue = str2;
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u5165\u529b\u5236\u9650\u898f\u5247\u306a\u3057\uff1a\u521d\u671f\u5024\u3042\u308a\uff0cfloat\u6e21\u3057\uff09
  public void defineStr(String str, float f) { 
    define(str, str(f));
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u5165\u529b\u5236\u9650\u898f\u5247\u306a\u3057\uff1a\u521d\u671f\u5024\u3042\u308a\uff0cint\u6e21\u3057\uff09
  public void defineStr(String str, int i) { 
    define(str, str(i));
  }

  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u9078\u629e\u80a2\u578b\uff1a\u5165\u529b\u5236\u9650\u898f\u5247\u306f0-9\u306e\u307f\uff09
  public void defineSel(String str1, String str2) {
    String list[];
    if (str2.length() <= 0) {
      println("Error: \u9078\u629e\u80a2\u578b\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u5ba3\u8a00\u306e\u7b2c\uff12\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u7a7a\u6587\u5b57\u5217\u3067\u3059\uff0e");
      crowbar.halt();
      return;
    }
    list = split(str2, ' ');
    if (list.length > 10) {
      println("Error: \u9078\u629e\u80a2\u578b\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u5ba3\u8a00\u306e\u9078\u629e\u80a2\u306e\u6570\u306f\uff11\uff10\u500b\u4ee5\u4e0b\u3067\u3059\uff0e");
      crowbar.halt();
      return;
    }
    defineStr(str1);
    argv[argc - 1].parameterType = 'S';
    argv[argc - 1].selectValues = list;
  }
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5ba3\u8a00\uff08\u9078\u629e\u578b\uff1a\u521d\u671f\u5024\u3042\u308a\uff09
  public void defineSel(String str1, String str2, int num) {
    defineSel(str1, str2);
    if (num < 0) {
      println("Error: \u9078\u629e\u80a2\u578b\u306e\u521d\u671f\u5024\u306f0\u304b\u30899\u306e\u6574\u6570\u3067\u3059\uff0e");
      crowbar.halt();
      return;
    }
    if (num >= argv[argc - 1].selectValues.length) {
      println("Error: \u9078\u629e\u80a2\u578b\u306e\u521d\u671f\u5024\u306f0\u304b\u3089\u9078\u629e\u80a2\u306e\u6570-1\u307e\u3067\u3067\u3059\uff0e");
      crowbar.halt();
      return;
    }
    argv[argc - 1].initialValue = str(num);
  } 

  //-------------------------
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5024\u3092\u53d7\u3051\u53d6\u308b
  //-------------------------
  // 1) index\u3092\u660e\u793a\u7684\u306b\u6307\u5b9a\u3059\u308b
  // 1-a) \u30d1\u30e9\u30e1\u30fc\u30bf\u540d\u3092\u6587\u5b57\u5217\u3067\u8fd4\u3059
  public String getStr(int index) {
    if ((index >= argc) || (index < 0)) {
      println();
      print("[\u8b66\u544a] \u30d1\u30e9\u30e1\u30fc\u30bf\u8aad\u307f\u51fa\u3057\u306eIndex\u304c\u7bc4\u56f2\u3092\u8d85\u3048\u3066\u3044\u307e\u3059\uff01(Index=");
      println(str(index)+")");
      return "";
    }
    // \u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u81ea\u52d5\u66f4\u65b0
    readArgIndex = index + 1;
    return argv[index].value;
  }
  // 1-b) \u30d1\u30e9\u30e1\u30fc\u30bf\u3092float\u3067\u8fd4\u3059
  public float getFloat(int index) { 
    return PApplet.parseFloat(getStr(index));
  }
  // 1-c) \u30d1\u30e9\u30e1\u30fc\u30bf\u3092int\u3067\u8fd4\u3059
  public int getInt(int index) { 
    return PApplet.parseInt(getStr(index));
  }

  // 2) index\u3092\u660e\u793a\u7684\u306b\u6307\u5b9a\u3057\u306a\u3044\u3067\u9806\u756a\u306b\u81ea\u52d5\u7684\u306b\u8aad\u307f\u51fa\u3059
  // 2-a) \u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u6587\u5b57\u5217\u3067\u6e21\u3059\uff08\u81ea\u52d5\uff09
  public String getStr() { 
    return getStr(readArgIndex);
  }
  // 2-b) \u30d1\u30e9\u30e1\u30fc\u30bf\u3092float\u3067\u8fd4\u3059\uff08\u81ea\u52d5\uff09
  public float getFloat() { 
    return getFloat(readArgIndex);
  }
  // 2-c) \u30d1\u30e9\u30e1\u30fc\u30bf\u3092int\u3067\u8fd4\u3059\uff08\u81ea\u52d5\uff09
  public int getInt() { 
    return getInt(readArgIndex);
  }
}


//////////////////////////////////////////////////////////////////////////////
// \u30d7\u30ed\u30bb\u30b9\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb\u306e\u30af\u30e9\u30b9\uff08\u30ad\u30fc\u30dc\u30fc\u30c9\u5165\u529b\u3068\u30b3\u30f3\u30bd\u30fc\u30eb\u51fa\u529b\u306e\u30af\u30e9\u30b9\u3092\u7d99\u627f\uff09
//////////////////////////////////////////////////////////////////////////////
class crowbarClass extends frontendClass {
  int          status = 0;          // \u30d7\u30ed\u30bb\u30b9\u306e\u72b6\u614b\u3092\u7ba1\u7406
  String []    comment;             // \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u30b3\u30e1\u30f3\u30c8\uff0e\u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u524d\u306b\u8868\u793a\u3055\u308c\u308b\uff0e
  protected boolean halt;           // \u5f37\u5236\u7d42\u4e86\u30d5\u30e9\u30b0\uff08halt()\u3067\u30bb\u30c3\u30c8\u3055\u308c\u308b\uff09
  protected boolean noShowParams  = false;    // \u5165\u529b\u6e08\u307f\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u78ba\u8a8d\u306e\u305f\u3081\u306b\u8868\u793a\u3059\u308b\u304b\uff1f
  protected boolean _noShowParams = false;    // setup()\u4e2d\u3067crowbar.noShowParameters()\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u306e\u5bfe\u7b56\uff0e\u518d\u5b9f\u884c\u6642\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3057\u307e\u3046\u305f\u3081\uff0e
  boolean running                 = false;    // Main()\u3042\u308b\u3044\u306fcrowbar.nonStop()\u6307\u5b9a\u6642\u306b\u30e6\u30fc\u30b6\u30d7\u30ed\u30b0\u30e9\u30e0\u5b9f\u884c\u4e2d\u306ftrue
  boolean afterRunning            = false;    // Main()\u304c\u7d42\u308f\u3063\u305f\u5f8c\uff0c\u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u3092\u518d\u63cf\u753b\u53ef\u80fd\u306a\u9593\u306e\u307ftrue;\uff08userDraw()\u304c\u52d5\u3044\u3066\u3044\u3066\u3082\u305d\u308c\u306f\u6c17\u306b\u3057\u306a\u3044\uff0e\u4eca\u306e\u3068\u3053\u308d\uff09
  protected boolean nonstop       = false;    // Main()\u7d42\u4e86\u5f8c\u306fdraw()\u306e\u7d42\u7aef\u306b\u8a18\u8ff0\u3057\u305f\u30b3\u30fc\u30c9\u3092\u7e70\u308a\u8fd4\u3057\u5b9f\u884c\u3059\u308b\uff0enonStop()\u3067true/stop()\u3067false
  protected boolean _nonstop      = false;    // setup()\u4e2d\u3067crowbar.nonStop()\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u306e\u5bfe\u7b56\uff0e\u518d\u5b9f\u884c\u6642\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3057\u307e\u3046\u305f\u3081\uff0e
  private boolean   userDrawLoop  = true;     // userDraw()\u306e\u30eb\u30fc\u30d7\u5b9f\u884c\u3092\u505c\u6b62\u3057\u305f\u308a\u518d\u958b\u3057\u305f\u308a\u3059\u308b\u969b\u306b\u7528\u3044\u308b\uff0etrue\u3067\u7e70\u308a\u8fd4\u3057\u5b9f\u884c\uff0eloop(), noLoop()\u3067\u8a2d\u5b9a\uff0e
  private boolean   _userDrawLoop = true;     // \u30d7\u30ed\u30b0\u30e9\u30e0\u518d\u5b9f\u884c\u6642\u306b\u521d\u671f\u72b6\u614b\u306b\u623b\u3059\u305f\u3081\u306b\u8a18\u61b6\u3059\u308b\uff0e

  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  crowbarClass(int x, int y, int mode) {
    super(x, y, mode);
    // \u30d7\u30ed\u30b0\u30e9\u30e0\u30b3\u30e1\u30f3\u30c8\u306e\u521d\u671f\u5316
    comment = null;
    // \u5f37\u5236\u7d42\u4e86\u30d5\u30e9\u30b0
    halt    = false;
  }
  // \u4ee5\u4e0b\u306e\u95a2\u6570\u3092\u30e6\u30fc\u30b6\u306f\u4f7f\u7528\u3057\u306a\u3044\u3067\u4e0b\u3055\u3044
  // \u5165\u529b\u6e08\u307f\u306e\u5168\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u8868\u793a\u3059\u308b
  public void showAllParameters() {
    int i, _readArgIndex;
    // \u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7
    _readArgIndex = readArgIndex;
    if (noShowParams) return; // \u5ff5\u306e\u305f\u3081
    for (i = 0; i < argc; i++) {
      if (!argv[i].ready) break;  // \u5165\u529b\u6e08\u307f\u306e\u5206\u306e\u307f\u8868\u793a\u3059\u308b\u306e\u3067\uff0e
      write(get_paramMessage(i) + "\uff1a[");
      write(getStr(i));
      writeln("]");
    }
    // \u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306e\u30ea\u30b9\u30c8\u30a2
    readArgIndex = _readArgIndex;
  }
  // \u5165\u529b\u6e08\u307f\u306e\u5168\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u306e\u307f\u51fa\u529b
  public void showAllParameters2Log() {
    boolean _display, _textarea;
    // \u30d5\u30e9\u30b0\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7
    _display  = nodisplay;
    _textarea = noTextArea;
    // \u30c6\u30ad\u30b9\u30c8\u51fa\u529b\u3092\u4e00\u6642\u7684\u306b\u7981\u6b62
    disableDisplay();
    disableTextArea();
    // \u7981\u6b62\u3057\u305f\u4e0a\u3067\u51fa\u529b\u3059\u308c\u3070\u30ed\u30b0\u306b\u306e\u307f\u51fa\u529b\u3055\u308c\u308b
    showAllParameters();
    // \u30d5\u30e9\u30b0\u3092\u623b\u3059
    if (!_display)  enableDisplay();
    if (!_textarea) enableTextArea();
  }
  // -----------------------------------------------
  // \u30d1\u30e9\u30e1\u30fc\u30bf\u8868\u793a\u306e\u78ba\u8a8d\u8868\u793a\u306e\u6291\u5236\uff08Options()\u3067\u6307\u5b9a\uff09
  public void noShowParameters() { 
    noShowParams = true;
  }
  public void showParameters() { 
    noShowParams = false;
  } // \u5fc5\u8981\u6027\u306f\u7121\u3044

  // ----------------------------------------------------------------------------
  // Main()\u7d42\u4e86\u5f8c\u306bdraw()\u7d42\u7aef\u306b\u8a18\u8ff0\u3057\u305f\u30b3\u30fc\u30c9\u3092\u7e70\u308a\u8fd4\u3057\u5b9f\u884c\u3059\u308b\u305f\u3081\u306e\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb
  // ----------------------------------------------------------------------------
  public void nonStop() { 
    nonstop = true;
  }   // userDraw()\u95a2\u6570\u304c\u6709\u52b9
  public void stop() { 
    nonstop = false;
  }  // userDraw()\u95a2\u6570\u304c\u7d42\u4e86\u3057\u305f\u3089\u30d7\u30ed\u30b0\u30e9\u30e0\u7d42\u4e86

  // ------------------------------------------------------
  // userDraw()\u306e\u30eb\u30fc\u30d7\u5b9f\u884c\u306e\u505c\u6b62\u3068\u518d\u958b\u306e\u305f\u3081\u306e\u30b3\u30f3\u30c8\u30ed\u30fc\u30eb
  // ------------------------------------------------------
  public void loop() { 
    userDrawLoop = true;
  }
  public void noLoop() { 
    userDrawLoop = false;
  }
  
  // ----------------------------------------
  // Crowbar\u3092\u5b89\u5168\u306b\u5f37\u5236\u7d42\u4e86\u3059\u308b
  // \u305f\u3060\u3057\u7121\u9650\u30eb\u30fc\u30d7\u304b\u3089\u306e\u8131\u51fa\u306f\u539f\u7406\u7684\u306b\u7121\u7406
  // ----------------------------------------
  public void halt() {
    halt   = true;
    status = 99;
  }

  // ----------------------------------------------
  // \u30d7\u30ed\u30b0\u30e9\u30e0\u306e\u8aac\u660e\uff08\u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u524d\u306b\u8868\u793a\u3055\u308c\u308b
  // ----------------------------------------------
  // \u30d7\u30ed\u30b0\u30e9\u30e0\u30b3\u30e1\u30f3\u30c8\u3092\u8868\u793a\u3059\u308b
  public void outputProgramComments() {
    int i, commNum;
    commNum = comment.length;
    for (i = 0; i < commNum; i++) writeln(comment[i]);
  }
  // \u30d7\u30ed\u30b0\u30e9\u30e0\u30b3\u30e1\u30f3\u30c8\u3092\u5ba3\u8a00\uff08\u8907\u6570\u5ba3\u8a00\u53ef\u80fd\uff09\uff0esetup()\u5185\u3067\u30e6\u30fc\u30b6\u304c\u5ba3\u8a00\u3059\u308b\uff0e
  public void programComment(String str) {
    String addStr[];
    addStr    = new String[1];
    addStr[0] = str;
    if (comment == null) {
      // \u4e00\u500b\u76ee\u306e\u30b3\u30e1\u30f3\u30c8\u306e\u5834\u5408
      comment = (String [])new String[1];
      comment = addStr;
    } else {
      // \u4e8c\u500b\u76ee\u4ee5\u964d\u306e\u30b3\u30e1\u30f3\u30c8\u306e\u5834\u5408
      comment = concat(comment, addStr);
    }
  }
  // ---------------------------------------------------------------
  // \u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\u3092\u5909\u66f4\u3059\u308b\uff08Options(), Setup()\u306e\u4e2d\u3067\u4f7f\u7528\u3059\u308b\u3053\u3068\uff09
  // ---------------------------------------------------------------
  // (a) \u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059
  public int fontSize() {
    return currentAttr.fontSize;
  }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int fontSize(int size) {
    int oldSize;
    oldSize = currentAttr.fontSize;
    if (status == 0) _setFontSize(size);  // Main()\u5b9f\u884c\u524d\u4ee5\u5916\u306f\u5909\u66f4\u3092\u8a8d\u3081\u306a\u3044
    return oldSize;
  }
  // -------------------------------------------------------------------
  // \u81ea\u52d5\u30b9\u30af\u30ed\u30fc\u30eb\u306e\u8a2d\u5b9a\u3092\u5909\u66f4\u3059\u308b\uff1aOptions(), Setup()\u306e\u4e2d\u3067\u4f7f\u7528\u3059\u308b\u3053\u3068
  // -------------------------------------------------------------------
  // \u81ea\u52d5\u30b9\u30af\u30ed\u30fc\u30eb\u306e\u884c\u6570\u6307\u5b9a
  public void autoScrollLines(int lines) {
    if (status != 0) return;  // Main()\u5b9f\u884c\u524d\u4ee5\u5916\u306f\u5909\u66f4\u3092\u8a8d\u3081\u306a\u3044
    // \u7bc4\u56f2\u30c1\u30a7\u30c3\u30af
    if (lines < 0)                     lines = 0;
    if (lines > screenSetting.cheight) lines = 0;
    autoScrollLines = lines;
  }
  public void autoScrollPage(float rate) {
    if (status != 0) return;  // Main()\u5b9f\u884c\u524d\u4ee5\u5916\u306f\u5909\u66f4\u3092\u8a8d\u3081\u306a\u3044
    // \u7bc4\u56f2\u30c1\u30a7\u30c3\u30af
    if (rate < 0.0f) rate = 0.0f;
    if (rate > 1.0f) rate = 1.0f;
    autoScrollLines(PApplet.parseInt(screenSetting.cheight * rate));
  }
  // ------------------------------------------------------
  // \u6587\u5b57\u9001\u308a\uff0c\u884c\u9001\u308a\u3092\u5909\u66f4\u3059\u308b\uff08Options()\u306e\u4e2d\u3067\u4f7f\u7528\u3059\u308b\u3053\u3068\uff09
  // ------------------------------------------------------
  // (a) \u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059
  public float hStep() {
    return screenSetting.hStep;
  }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public float hStep(float step) {
    float oldStep;
    oldStep = screenSetting.hStep;
    if (step <= 0.0f) return oldStep;
    if (status == 0) {
      screenSetting.hStep = step;
      screenSetting.reCalc(fontSize());
      screenReset();
    }
    return oldStep;
  }
  // (a) \u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059
  public float vStep() {
    return screenSetting.vStep;
  }
  // (b) \u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public float vStep(float step) {
    float oldStep;
    oldStep = screenSetting.vStep;
    if (step <= 0.0f) return oldStep;
    if (status == 0) {
      screenSetting.vStep = step;
      screenSetting.reCalc(fontSize());
      screenReset();
    }
    return oldStep;
  }
}

///////////////
// \u30ad\u30fc\u5165\u529b\u5224\u5b9a
///////////////
// \u6570\u5b57\u5165\u529b\u7528\u30ad\u30fc\u304b\uff1f
public boolean isKeyNumbers(char c) {
  if (isNumberChar(c)) return true;
  switch (c) {
  case '.' :
    //  case ',' :  // \u304a\u7bc0\u4ecb\u904e\u304e\u308b
  case '+' :
  case '-' :
    return true;
  }
  return false;
}

public void keyPressed() {
  if (crowbar.running == false) {
    // \u30e6\u30fc\u30b6\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u52d5\u4f5c\u3057\u3066\u3044\u306a\u3044\u6642\uff08\u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u4e2d\u306a\u3069\uff09
    if (crowbar.inputNow) {
      // \u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u4e2d
      if (key == ENTER) {
        if (crowbar.is_numbersOnly() || (crowbar.is_selectOnly() != 0)) {
          // \u6570\u5024\u5165\u529b\u3068\u9078\u629e\u578b\uff08\u3064\u307e\u308a\u6587\u5b57\u5217\u5165\u529b\u6642\u4ee5\u5916\uff09\u306e\u5834\u5408\u306f\u7a7a\u5165\u529b\u306f\u62d2\u5426
          if ((crowbar.keyBufferLength() == 0) && (crowbar.get_initialValue().length() == 0)) {
            redraw();
            return;
          }
        }
        crowbar.inputFinish();
        crowbar.newline();
      } else if (key == BACKSPACE) {
        if (crowbar.keyBufferLength() > 0) {
          crowbar.backSpace();
        }
      } else if (key == TAB) {
        if (crowbar.get_initialValue().length() > 0) {
          crowbar.automaticInputByDefalutValue(true);
          crowbar.inputFinish();
          crowbar.newline();
        }
      } else {
        // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5165\u529b
        boolean flag = true;
        int     num;
        // \u30ad\u30fc\u5165\u529b\u30eb\u30fc\u30eb
        // \u6570\u5024\u306e\u307f\u306e\u5834\u5408
        if (crowbar.is_numbersOnly()) {
          if (!isKeyNumbers(key)) flag = false;
            else                  flag = crowbar.keyCheck.checkFloat(key);
        }
        // \u9078\u629e\u80a2\u306e\u5834\u5408
        if ((num = crowbar.is_selectOnly()) > 0) {
          if (num == 99) {  // \u7570\u5e38\u691c\u51fa
            crowbar.halt();
            return;
          }
          // \u65e2\u306b\uff11\u6587\u5b57\u5165\u529b\u6e08\u307f\uff08\u534a\u89d2\u7a7a\u767d\u3082\u542b\u3080\uff09
          if (crowbar.keyBufferLength() >= 1) flag = false;
          // \u6570\u5b57\u30ad\u30fc\uff080-9\uff09\u3067\u306f\u306a\u3044
          if (!isNumberChar(key))             flag = false;
          // \u9078\u629e\u80a2\u306e\u6570\u3088\u308a\u3082\u5927\u304d\u306a\u6570\u5b57
          if (PApplet.parseInt(str(key)) >= num)           flag = false;
        }
        if (flag) {
          crowbar.strcat(str(key));
          crowbar.write(str(key));
        }
      }
    } else {
      // \u5f37\u5236\u7684\u306b\u629c\u3051\u305f\u3044\u5834\u5408
      if ((key == 'Q') || (key == 'q')) crowbar.status = 99;
    }
    // \u30b9\u30af\u30ed\u30fc\u30eb\u53ef\u80fd\u306a\u72b6\u614b\uff08\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u4e00\u65e6\u7d42\u4e86\u3057\u3066\u30ad\u30fc\u5165\u529b\u3092\u5f85\u3063\u3066\u3044\u308b\u9593\u306e\u307f\uff09
    if (crowbar.afterRunning) {
      if (key == '-') {
        crowbar.pageScroll(-0.5f);
      } else if (key == '+') {
        crowbar.pageScroll(0.5f);
      } else if (key == CODED) {
        if (keyCode == UP) {
          crowbar.pageLineScroll(-1);
        } else if (keyCode == DOWN) {
          crowbar.pageLineScroll(1);
        } else if (keyCode == LEFT) {
          crowbar.pageScroll(-0.5f);
        } else if (keyCode == RIGHT) {
          crowbar.pageScroll(0.5f);
        }
      }
    }
    redraw();
  } else {
    // crowbar.nonStop()\u6307\u5b9a\u6642\u306e\u30e6\u30fc\u30b6\u30d7\u30ed\u30b0\u30e9\u30e0\u5b9f\u884c\u4e2d\u306e\u30ad\u30fc\u5165\u529b\u5224\u5b9a
    // \u30b3\u30fc\u30c9\u306fuserKeyPressed()\u306b\u8a18\u8ff0\u3059\u308b\u3068\u826f\u3044\uff0e
    userKeyPressed();
  }
}

///////////////
// \u30d7\u30ed\u30bb\u30b9\u7ba1\u7406
///////////////
public void draw() {
  switch (crowbar.status) {
  case 0: // \u521d\u671f\u72b6\u614b
    // Setup()\u4e2d\u3067crowbar.nonStop()/noShowParams()\u304c\u5b9f\u884c\u3055\u308c\u305f\u5834\u5408\u306e\u5bfe\u7b56(Main()\u306a\u3069\u3067\u5909\u66f4\u3055\u308c\u3066\u3044\u308b\u6050\u308c\u304c\u3042\u308b\u305f\u3081\uff09
    crowbar._nonstop      = crowbar.nonstop;
    crowbar._noShowParams = crowbar.noShowParams;
    crowbar._userDrawLoop = crowbar.userDrawLoop;
    // \u30d7\u30ed\u30b0\u30e9\u30e0\u30b3\u30e1\u30f3\u30c8\u306e\u8868\u793a
    if (crowbar.comment != null) {
      crowbar.writeln("\u3010\u30d7\u30ed\u30b0\u30e9\u30e0\u8aac\u660e\u3011");
      crowbar.outputProgramComments();
      crowbar.newline();
    }
    // Tomahawk\u95a2\u4fc2
    if (crowbar.tomahawkMode != 0) crowbar.backupViewports();
    crowbar.status++;
    break;
  case 1: // \u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u958b\u59cb\uff08\u518d\u5b9f\u884c\u6642\u306f\u3053\u3053\u306b\u30b8\u30e3\u30f3\u30d7\u3057\u3066\u304f\u308b\uff09
    // \u521d\u671f\u5316
    crowbar.allResetArguments();
    crowbar.automaticInputByDefalutValue(false);
    // setup()\u4e2d\u3067crowbar.nonStop()/noShowParams()\u3092\u8a2d\u5b9a\u3057\u305f\u5024\u304cMain()\u3084userDraw()\u306e\u5b9f\u884c\u3067\u5909\u66f4\u3055\u308c\u308b\u6050\u308c\u304c\u3042\u308b\u306e\u3067\u521d\u671f\u5316\u3059\u308b\u305f\u3081\u306b\u8a18\u61b6\u3059\u308b\uff0e
    crowbar.nonstop       = crowbar._nonstop;
    crowbar.noShowParams  = crowbar._noShowParams;
    crowbar._userDrawLoop = crowbar._userDrawLoop;
    // \u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5165\u529b\u8981\u6c42\u304c\u4e00\u3064\u3082\u7121\u304b\u3063\u305f\u5834\u5408\u306f\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u8868\u793a\u3057\u306a\u3044
    if (!crowbar.isNoParameter()) {
      crowbar.newline();
      crowbar.writeln("\u3010\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5165\u529b\u3011");
    }
    // Tomahawk\u95a2\u4fc2
    if (crowbar.tomahawkMode != 0) crowbar.restoreViewports();
    crowbar.status++;
    break;
  case 2: // \u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u4e2d
    if (!crowbar.isNoParameter()) {
      crowbar.keyCheck.reset();  // \u30ad\u30fc\u5165\u529b\u898f\u5247\u306e\u30ea\u30bb\u30c3\u30c8
      crowbar.write(crowbar.get_paramMessage(crowbar.obtainArgIndex) + ":");
      crowbar.flushKeyBuffer();
      crowbar.startInput();
      // \u521d\u671f\u8a2d\u5b9a\u5024\u306e\u81ea\u52d5\u5165\u529b\u30e2\u30fc\u30c9\u6709\u52b9\u306e\u5834\u5408\u306f\u30d1\u30b9\u3059\u308b
      if ((crowbar.autoInput == true) && (crowbar.get_initialValue().length() > 0)) {
        crowbar.inputFinish();
        crowbar.newline();
      } else {
        // \u30eb\u30fc\u30d7\u505c\u6b62
        noLoop();
      }
    }
    crowbar.status++;
    break;
  case 3: // \u5165\u529b\u78ba\u5b9a
    if (!crowbar.isNoParameter()) {
      String inputs;
      if (crowbar.inputFixed) {
        boolean flag = true;
        inputs = crowbar.getKeyBuffer();
        // \u7a7a\u304b\u3064\u521d\u671f\u5024\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u5834\u5408
        if (inputs.length() == 0) {
          inputs = crowbar.get_initialValue();
        }
        // \u9078\u629e\u80a2\u578b\u306e\u5834\u5408
        int  num;
        if ((num = crowbar.is_selectOnly()) > 0) {
          if (num == 99) { // \u7570\u5e38\u691c\u51fa
            crowbar.halt();
            break;
          }
          // \u5ff5\u306e\u305f\u3081\u306b\u30c1\u30a7\u30c3\u30af
          if (((num = PApplet.parseInt(inputs)) < 0) || (num > 9)) {
            flag = false;
          } else if (num > crowbar.is_selectOnly()) {
            flag = false;
          }
          if (!flag) {
            // \u3042\u308a\u5f97\u306a\u3044\u306f\u305a\uff08\u5165\u529b\u6642\u306b\u30c1\u30a7\u30c3\u30af\u3057\u3066\u3044\u308b\u306e\u3067\uff09
            println("SystemError: \u9078\u629e\u80a2\u578b\u306e\u5165\u529b\u5024\u304c\u7570\u5e38\u3067\u3059\uff08" + str(num) + "\uff09\uff0e");
            crowbar.halt();
            break;
          }
          inputs = crowbar.get_selectValue(num);
        }
        crowbar.setValue(inputs);
        crowbar.obtainArgIndex++;
        // \u30eb\u30fc\u30d7\u518d\u958b
        loop();
        crowbar.status++;
      }
    } else crowbar.status++;
    break;
  case 4: // \u30d1\u30e9\u30e1\u30fc\u30bf\u5165\u529b\u5b8c\u4e86\u304b\u306e\u5224\u5b9a
    if (!crowbar.isNoParameter()) {
      if (crowbar.allReady()) {
        crowbar.status++;
      } else {
        crowbar.status -= 2;
      }
    } else crowbar.status++;
    break;
  case 5: // \u5b9f\u884c\u304b\uff1f \u518d\u5165\u529b\u304b\uff1f
    if (!crowbar.isNoParameter()) {
      crowbar.newline();
      crowbar.writeln("\u3010\u5168\u3066\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u5165\u529b\u304c\u5b8c\u4e86\u3011");
      if (!crowbar.noShowParams) crowbar.showAllParameters();
      crowbar.write("\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u5b9f\u884c\u3059\u308b(Yes) /\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u5165\u529b\u3057\u76f4\u3059(Retry) : ");
      noLoop();
    }
    crowbar.status++;
    break;
  case 6: // \u30ad\u30fc\u5224\u5b9a\u7d50\u679c
    if (!crowbar.isNoParameter()) {
      if (keyPressed) {
        if ((key == 'y') || (key == 'Y')) {
          crowbar.writeln(str(key));
          crowbar.newline();
          crowbar.status++;
          loop();
        } else if ((key == 'r') || (key == 'R')) {
          crowbar.writeln(str(key));
          crowbar.newline();
          crowbar.status -= 5;
          loop();
        }
      }
    } else crowbar.status++;
    break;
  case 7: // \u30e1\u30a4\u30f3\u30d7\u30ed\u30b0\u30e9\u30e0\u5b9f\u884c\u524d\u51e6\u7406\uff08\u3042\u308b\u306a\u3089\u3070\uff09
    preMain(); // optionCode\u30bf\u30d6\u53c2\u7167
    crowbar.running = true;
    crowbar.status++;
    break;
  case 8: // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3078\u306e\u51fa\u529b\u3092\u8a31\u53ef\u3059\u308b:\u3053\u308c\u306f\u3082\u3057\u304b\u3057\u305f\u3089status==0\u304b\u3089\u8a31\u53ef\u3059\u308b\u304b\u3082\u77e5\u308c\u306a\u3044\uff0e\u4f59\u8a08\u306a\u6587\u5b57\u60c5\u5831\u306f\u8a18\u9332\u3057\u306a\u3044\u3068\u3044\u3046\u4ed5\u69d8\u306f\u304a\u7bc0\u4ecb\u3060\u3063\u305f\u304b\u3082\u3068\u3044\u3046\u53cd\u7701\uff0e
    crowbar.enableLogOutput();
    if (crowbar.isEnableLogging()) {
      // \u5168\u30d1\u30e9\u30e1\u30fc\u30bf\u3092\u51fa\u529b\u3059\u308b
      crowbar.restartLogging();
      crowbar.newline2Log();
      crowbar.showAllParameters2Log();
      crowbar.newline2Log();
    }
    crowbar.status++;
    break;
  case 9: // \u30e1\u30a4\u30f3\u30d7\u30ed\u30b0\u30e9\u30e0\u5b9f\u884c
    Main();
    // \u30eb\u30fc\u30d7\u518d\u958b
    loop();
    crowbar.status++;
    break;
  case 10: // \u7e70\u308a\u8fd4\u3057\u5b9f\u884c\u30b3\u30fc\u30c9\uff08\u30aa\u30d7\u30b7\u30e7\u30f3\uff09
    if (crowbar.nonstop) {
      // crowbar.nonStop()\u6307\u5b9a\u6642\u306e\u7e70\u308a\u8fd4\u3057\u51e6\u7406\u306fuserDraw()\u306b\u8a18\u8ff0
      if (crowbar.userDrawLoop) userDraw();
    } else {
      crowbar.status++;
    }
    break;
  case 11: // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u3092\u4e00\u6642\u7684\u306b\u6b62\u3081\u308b
    crowbar.running = false;
    if (crowbar.isEnableLogging()) {
      crowbar.pauseLogging();
    }
    crowbar.status++;
    break;
  case 12: // \u30e1\u30a4\u30f3\u30d7\u30ed\u30b0\u30e9\u30e0\u5b9f\u884c\u5f8c\u51e6\u7406\uff08\u3042\u308b\u306a\u3089\u3070\uff09
    postMain(); // optionCode\u30bf\u30d6\u53c2\u7167
    crowbar.status++;
    break;
  case 13: // \u30ea\u30c8\u30e9\u30a4\u78ba\u8a8d\u30e1\u30c3\u30bb\u30fc\u30b8
    crowbar.setColor(_TEXTCOLOR, _BGCOLOR);
    crowbar.newline();
    crowbar.writeln("\u3010\u30d7\u30ed\u30b0\u30e9\u30e0\u7d42\u4e86\u3011");
    crowbar.write("\u3082\u3046\u4e00\u5ea6\uff0c\u5b9f\u884c\u3057\u307e\u3059\u304b\uff1f(Yes/No)\uff1a");
    // \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u95a2\u9023
    crowbar.afterRunning = true;
    crowbar.textbuffer.flushBuffer(!crowbar.noOverlap);
    crowbar.stopRecordTextBuffer();
    crowbar.status++;
    noLoop();
    break;
  case 14: // \u30ad\u30fc\u5224\u5b9a\u7d50\u679c
    if (keyPressed) {
      if ((key == 'y') || (key == 'Y')) {
        crowbar.writeln(str(key));
        crowbar.newline();
        // \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u2015\u95a2\u9023
        crowbar.stopRecordTextBuffer();
        crowbar.redrawNewestPage();
        crowbar.afterRunning = false;
        crowbar.startRecordTextBuffer();
        crowbar.status = 1;
        loop();
      } else if ((key == 'n') || (key == 'N')) {
        crowbar.writeln(str(key));
        // \u30c6\u30ad\u30b9\u30c8\u30d0\u30c3\u30d5\u30a1\u2015\u95a2\u9023
        crowbar.stopRecordTextBuffer();
        crowbar.redrawNewestPage();
        crowbar.afterRunning = false;
        crowbar.startRecordTextBuffer();
        crowbar.status++;
        loop();
      }
    }
    break;
  case 15: // \u7d42\u4e86
    crowbar.status = 99;
    break;
  case 99: // \u7d42\u4e86\u51e6\u7406
    println();
    // \u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3044\u305f\u307e\u307e\u306a\u3089\u9589\u3058\u308b
    if (crowbar.isEnableLogging()) {
      println("\u30d5\u30a1\u30a4\u30eb\u3092\u9589\u3058\u307e\u3059\uff0e");
      crowbar.restartLogging();
      crowbar.newline2Log();
      crowbar.stopLogging();
      crowbar.disableLogOutput();
    }
    println("Crowbar\u3092\u7d42\u4e86\u3057\u307e\u3059\uff0e");
    exit();
    break;
  }
  crowbar.refreshView();  // Tomahawk\u306e\u30d3\u30e5\u30fc\u5408\u6210
}

public void mouseDragged() {
  if (crowbar.running) userMouseDragged();
}
public void mouseMoved() {
  if (crowbar.running) userMouseMoved();
}
public void mousePressed() {
  if (crowbar.running) userMousePressed();
}
public void mouseReleased() {
  if (crowbar.running) userMouseReleased();
}
public void mouseClicked() {
  if (crowbar.running) userMouseClicked();
}
public void keyReleased() {
  if (crowbar.running) userKeyReleased();
}
public void keyTyped() {
  if (crowbar.running) userKyeTyped();
}

// \u30b7\u30b9\u30c6\u30e0\u521d\u671f\u8a2d\u5b9a
public void setup()
{
  initializeMain();
  Options();
  Setup();
}

/////////////////////////////////////////////////////
// Processing\u306b\u306f\u7528\u610f\u3055\u308c\u3066\u3044\u306a\u3044\u6570\u5b66\u7cfb\u306e\u6c4e\u7528\u7684\u306a\u95a2\u6570
/////////////////////////////////////////////////////

// 1. int sgn(float), int sgn(int)                 : \u8ca0\u306a\u3089\u3070-1\uff0c\u6b63\u306a\u3089\u3070 1\uff0c\u30bc\u30ed\u306a\u3089\u3070 0 \u3092\u8fd4\u3059
// 2. String nowDateTime(void)                     : \u65e5\u6642\u3092\u6587\u5b57\u5217\u3067\u8fd4\u3059\uff08yyyy/mm/dd hh:mm:ss\uff09
// 3. char getKEY(void)                            : \u30ad\u30fc\u30dc\u30fc\u30c9\u304b\u3089\u5165\u529b\u3055\u308c\u305f\u6587\u5b57\u3092\u5927\u6587\u5b57\u306b\u5909\u63db\u3057\u3066\u8fd4\u3059(a-z\u306e\u5834\u5408\u306e\u307f)
// 4. boolean isNumberChar(char)                   : char\u304c'0'\u304b\u3089'9'\u306a\u3089\u3070\u771f
// 5. String strRight(String, int)                 : \u6587\u5b57\u5217\u306e\u53f3\u304b\u3089\u6307\u5b9a\u3055\u308c\u305f\u9577\u3055\u306e\u6587\u5b57\u5217\u3092\u8fd4\u3059
// 6. String strLeft(String, int)                  : \u6587\u5b57\u5217\u306e\u5de6\u304b\u3089\u6307\u5b9a\u3055\u308c\u305f\u9577\u3055\u306e\u6587\u5b57\u5217\u3092\u8fd4\u3059
// 7. float rotate2Dx(float x, float y, float rad) : \u4e8c\u6b21\u5143\u5e73\u9762\u306b\u304a\u3051\u308b\u56de\u8ee2\u884c\u5217\uff08\uff58\u8ef8\u6210\u5206\uff09
//    float rotate2Dy(float x, float y, float rad) : \u4e8c\u6b21\u5143\u5e73\u9762\u306b\u304a\u3051\u308b\u56de\u8ee2\u884c\u5217\uff08\uff59\u8ef8\u6210\u5206\uff09
// 8. float norm(float x0, float y0, float x1, float y1) : \u4e8c\u6b21\u5143\u5e73\u9762\u306b\u304a\u3051\u308b\u4e8c\u70b9\u9593\u306e\u8ddd\u96e2\uff08\u30e6\u30fc\u30af\u30ea\u30c3\u30c9\u30ce\u30eb\u30e0\uff09\u3092\u6c42\u3081\u308b


// 1. int sgn(float), int sgn(int) : \u8ca0\u306a\u3089\u3070-1\uff0c\u6b63\u306a\u3089\u3070 1\uff0c\u30bc\u30ed\u306a\u3089\u3070 0 \u3092\u8fd4\u3059
public int sgn(int i) {
  return sgn(PApplet.parseFloat(i));
}
public int sgn(float f) {
  if (f < 0.0f) return -1;
  if (f > 0.0f) return  1;
  return 0;
}

// 2. String nowDateTime() : \u65e5\u6642\u3092\u6587\u5b57\u5217\u3067\u8fd4\u3059\uff08yyyy/mm/dd hh:mm:ss\uff09
public String nowDateTime() {
  return str(year()) + '/' + strRight('0' + str(month()), 2) + '/' + strRight('0' + str(day()), 2) + ' ' + strRight('0' + str(hour()), 2) + ':' + strRight('0' + str(minute()), 2) + ':' + strRight('0' + str(second()), 2);
}

// 3. char getKEY() : \u30ad\u30fc\u30dc\u30fc\u30c9\u304b\u3089\u5165\u529b\u3055\u308c\u305f\u6587\u5b57\u3092\u5927\u6587\u5b57\u306b\u5909\u63db\u3057\u3066\u8fd4\u3059(a-z\u306e\u5834\u5408\u306e\u307f)
public char getKEY() {
  if ((key < 'a') || (key > 'z')) return key;
  return str(key).toUpperCase().charAt(0);
}

// 4. boolean isNumberChar(char)    : char\u304c'0'\u304b\u3089'9'\u306a\u3089\u3070\u771f
public boolean isNumberChar(char c) {
  if ((c >= '0') && (c <= '9')) return true;
  return false;
}

// 5. String strRight(String, int) : \u6587\u5b57\u5217\u306e\u53f3\u304b\u3089\u6307\u5b9a\u3055\u308c\u305f\u9577\u3055\u306e\u6587\u5b57\u5217\u3092\u8fd4\u3059
public String strRight(String str, int len) {
  int  index;
  index = str.length() - len;
  if (index < 0) return str;
//return str.substring(index, len);
  return str.substring(index);
}

// 6. String strLeft(String, int)  : \u6587\u5b57\u5217\u306e\u5de6\u304b\u3089\u6307\u5b9a\u3055\u308c\u305f\u9577\u3055\u306e\u6587\u5b57\u5217\u3092\u8fd4\u3059
public String strLeft(String str, int len) {
  return str.substring(0, len);
}

// 7. float rotate2Dx(float x, float y, float rad) : \u4e8c\u6b21\u5143\u5e73\u9762\u306b\u304a\u3051\u308b\u56de\u8ee2\u884c\u5217\uff08\uff58\u8ef8\u6210\u5206\uff09
//    float rotate2Dy(float x, float y, float rad): \u4e8c\u6b21\u5143\u5e73\u9762\u306b\u304a\u3051\u308b\u56de\u8ee2\u884c\u5217\uff08\uff59\u8ef8\u6210\u5206\uff09
public float rotate2Dx(float x, float y, float rad) {
  return x * cos(rad) - y * sin(rad);
}
public float rotate2Dy(float x, float y, float rad) {
  return x * sin(rad) + y * cos(rad);
}

// 8. float norm(float x0, float y0, float x1, float y1) : \u4e8c\u6b21\u5143\u5e73\u9762\u306b\u304a\u3051\u308b\u4e8c\u70b9\u9593\u306e\u8ddd\u96e2\uff08\u30e6\u30fc\u30af\u30ea\u30c3\u30c9\u30ce\u30eb\u30e0\uff09\u3092\u6c42\u3081\u308b
public float norm(float x0, float y0, float x1, float y1) {
  float dx, dy;
  dx = x1 - x0;
  dy = y1 - y0;
  return sqrt(dx * dx + dy * dy);
}
//-----------\u3000\u4ee5\u4e0b\u306e\u30b3\u30fc\u30c9\u306f\u5fc5\u8981\u306e\u3042\u308b\u30e6\u30fc\u30b6\u306e\u307f\u8a18\u8ff0\u3059\u308b --------------

// \u3082\u3057Main()\u306e\u958b\u59cb\u524d\u306b\u5b9f\u884c\u3057\u3066\u304a\u304d\u305f\u3044\u30b3\u30fc\u30c9\u304c\u5225\u306b\u3042\u308b\u5834\u5408\u306f\u4ee5\u4e0b\u306b\u8a18\u8ff0\uff0e
// \u3053\u306e\u30eb\u30fc\u30c1\u30f3\u306e\u51fa\u529b\u306f\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u8a18\u9332\u3055\u308c\u307e\u305b\u3093\uff0e
public void preMain() {
}

// \u3082\u3057Main()\u7d42\u4e86\u5f8c\u306b\u5b9f\u884c\u3057\u3066\u304a\u304d\u305f\u3044\u30b3\u30fc\u30c9\u304c\u5225\u306b\u3042\u308b\u5834\u5408\u306f\u4ee5\u4e0b\u306b\u8a18\u8ff0\uff0e
// \u3053\u306e\u30eb\u30fc\u30c1\u30f3\u306e\u51fa\u529b\u306f\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u306b\u8a18\u9332\u3055\u308c\u307e\u305b\u3093\uff0e
public void postMain() {
}

// \u30e6\u30fc\u30b6\u72ec\u81ea\u306emousePressed()
public void userMousePressed() {
}
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306emouseRelased()
public void userMouseReleased() {
}
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306emouseDragged()
public void userMouseDragged() {
}
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306emouseMoved()
public void userMouseMoved() {
}
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306emouseClicked()
public void userMouseClicked() {
  if (mouseButton == RIGHT) {
    int target = crowbar.detectActiveView(mouseX, mouseY);
    if (target < 0) return;
    targetView = target;
  } else if (mouseButton == LEFT) {
    int mx, my;
    mx = mouseX; my = height - mouseY;
    crowbar.lastView();
    crowbar.cv.stroke(0xff800000);
    if (clicked == false) crowbar.cv.moveTo(mx, my);
      else                crowbar.cv.dashedLineTo(mx, my, 5.0f);
    clicked = true;
    crowbar.cv.fill(0xff202020);
    crowbar.cv.stroke(0xff000000);
    crowbar.cv.rectC(mx, my, 10, 10);
  }
}
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306ekeyPressed()
public void userKeyPressed() {
  switch (key) {
    case '1' : crowbar.toggleVisible(0); break;
    case '2' : crowbar.toggleVisible(1); break;
    case '3' : crowbar.toggleVisible(2); break;
    case '4' : crowbar.toggleVisible(3); break;
    case 't' :
    case 'T' : crowbar.moveToTop(targetView); break;
    case 'b' :
    case 'B' : crowbar.moveToBottom(targetView); break;
    case 'c' :
    case 'C' : crowbar.lastView(); crowbar.cv.clrView(); clicked = false; break;
  }
  switch (keyCode) {
    case LEFT  : crowbar.moveViewRel(targetView, -5,  0); break;
    case RIGHT : crowbar.moveViewRel(targetView,  5,  0); break;
    case UP    : crowbar.moveViewRel(targetView,  0, -5); break;
    case DOWN  : crowbar.moveViewRel(targetView,  0,  5); break;
  }
}
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306ekeyRleased()
public void userKeyReleased() {
}
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306ekeyTyped()
public void userKyeTyped() {
  if ((key == 'Q') || (key == 'q')) crowbar.stop();
}

// \u3082\u3057Main()\u7d42\u4e86\u5f8c\u306b\u901a\u5e38\u306eProcessing\u306e\u3088\u3046\u306b\u30a8\u30f3\u30c9\u30ec\u30b9\u306b\u51e6\u7406\u3092\u7d9a\u3051\u308b\u5834\u5408\u306f
// setup()\u306bcrowbar.nonStop()\u3092\u8a18\u8ff0\u3059\u308b\u3068\u5171\u306b\uff0c\u4ee5\u4e0b\u306b\u30b3\u30fc\u30c9\u3092\u8a18\u8ff0\uff0e
// \u30e6\u30fc\u30b6\u72ec\u81ea\u306edraw()
int i = 0;
public void userDraw() {
//background(_BGCOLOR);
  int mx, my, i;
  mx = mouseX - 20;
  my = height - mouseY - 20;

//crowbar.clrAllView();
  for (i = 0; i < 4; i++) {
    crowbar.view(i);
    if (i == targetView) crowbar.cv.frameColor(0xffff0000);
      else               crowbar.cv.frameColor(0xff000000);
    crowbar.cv.clrView();
    crowbar.cv.stroke(0xff000000);
    crowbar.cv.fill(0xffffffff);
    crowbar.cv.line(0, 0, 1000,    0);
    crowbar.cv.line(0, 0,    0, 1000);
    crowbar.cv.ellipse(0, 0, 20);
    switch (i) {
      case 1 :
        crowbar.cv.triangleC(mx, my, 50.0f, PI);
        crowbar.cv.textColor(0xffff0000);
        break;
      case 3 : 
        crowbar.cv.triangleC(mx, my, 50.0f);
        crowbar.cv.textColor(0xffffffff);
        break;
      default :
        crowbar.cv.ellipse(mx, my, 50);
        crowbar.cv.textColor(0xff000000);
    }
    crowbar.cv.stroke(0xff404040);
    crowbar.cv.line(0, 0, mx, my);
    crowbar.cv.text("Mouse(", 50, 50);
    crowbar.cv.text(str(mouseX));
    crowbar.cv.text(",");
    crowbar.cv.text(str(mouseY));
    crowbar.cv.text(")");
  }

  crowbar._clrscr();
  fill(0xff808000);
  stroke(0xff000000);
  ellipse(mouseX, mouseY, 50, 50);
  line(0, 0, mouseX, mouseY);
  crowbar._write(cx, cy, "Mouse(");
  crowbar._write(str(mouseX));
  crowbar._write(",");
  crowbar._write(str(mouseY));
  crowbar._write(")");
  crowbar._write(cx, cy + 1, "[1] [2] [3] [4]");
  crowbar._write(cx, cy + 2, "\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u5207\u308a\u66ff\u3048");
  crowbar._write(cx, cy + 3, "\u30de\u30a6\u30b9\u53f3\u30af\u30ea\u30c3\u30af\uff1a\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u9078\u629e");
  crowbar._write(cx, cy + 4, "\u30de\u30a6\u30b9\u5de6\u30af\u30ea\u30c3\u30af\uff1a\u30de\u30fc\u30af\u8868\u793a");
  crowbar._write(cx, cy + 5, "[C]: \u30de\u30fc\u30af\u8868\u793a\u753b\u9762\u306e\u6d88\u53bb");
  crowbar._write(cx, cy + 6, "[T]: \u6700\u4e0a\u9762\u3078 [B]: \u6700\u4e0b\u9762\u3078");
  crowbar._write(cx, cy + 7, "\u30ab\u30fc\u30bd\u30eb\u30ad\u30fc: \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u79fb\u52d5");
}

// Crowbar\u7d44\u8fbc\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30e9\u30a4\u30d6\u30e9\u30eaTomahawk
// by T.Shirai
// \u958b\u767a\u958b\u59cb 2012/6/7

// tomahawkMode : 0, 1, 2 \u306fTomahawk\u306e\u30e2\u30fc\u30c9\u3092\u5207\u308a\u66ff\u3048\u308b\u975e\u5e38\u306b\u91cd\u8981\u306a\u30d1\u30e9\u30e1\u30fc\u30bf\u3067\uff0c\u5b9f\u884c\u4e2d\u306b\u5909\u66f4\u3059\u308b\u3082\u306e\u3067\u306f\u306a\u3044\uff0e
// 0 : \u3053\u306eCrowbar\u306b\u306fTomahawk\u304c\u5b58\u5728\u3057\u306a\u3044\u5834\u5408\uff08tomahawkClass.pde\u3092\u524a\u9664\u3057\uff0ccrowbarClass.pde\u5192\u982d\u306e\u30b3\u30e1\u30f3\u30c8\u3092\u5916\u3059\uff09
//     Tomahawk\u306f\u975e\u5e38\u306b\u8ca0\u8377\u304c\u5927\u304d\u3044\u306e\u3067\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u5229\u7528\u3059\u308b\u5fc5\u8981\u304c\u306a\u3044\u5834\u5408\u306f\u3053\u306e\u30e2\u30fc\u30c9\u306e\u4f7f\u7528\u3092\u52e7\u3081\u307e\u3059\uff0e
// 1 : Tomahawk\u3092\u5229\u7528\u3059\u308b\u304cCrowbar\u306e\u30c6\u30ad\u30b9\u30c8\u8868\u793a\u3092\u80cc\u666f\u306b\u63cf\u753b\u3059\u308b\uff0e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306f\u305d\u306e\u4e0a\u306e\u30ec\u30a4\u30e4\u30fc\u3068\u3057\u3066\u4e0a\u66f8\u304d\u3055\u308c\u308b\uff0e
//     \u5b9f\u884c\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u4e00\u90e8\u3092\u753b\u50cf\u63cf\u753b\u7528\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3068\u3057\u3066\u6d3b\u7528\u3059\u308b\u5834\u5408\u306a\u3069\u306b\u9069\u3057\u3066\u3044\u308b\uff0e
//     \u30c6\u30ad\u30b9\u30c8\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u3092\u30d6\u30ec\u30f3\u30c9\u3057\u306a\u3044\u305f\u3081\u6bd4\u8f03\u7684\u8ca0\u8377\u304c\u5c11\u306a\u3044\uff0e
// 2 : Tomahawk\u3092\u5229\u7528\u3059\u308b\uff0e\u3055\u3089\u306bCrowbar\u306e\u30c6\u30ad\u30b9\u30c8\u51fa\u529b\u3092\u5c02\u7528\u306e\u30ec\u30a4\u30e4\u30fc\u306b\u63cf\u753b\u3059\u308b\uff0e
//     \u30ec\u30a4\u30e4\u30fc\u306f\u80cc\u666f\uff0c\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\uff0c\u30c6\u30ad\u30b9\u30c8\u8868\u793a\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u306e\u9806\u3067\u30d6\u30ec\u30f3\u30c9\u3055\u308c\u308b\u305f\u3081\u30c6\u30ad\u30b9\u30c8\u8868\u793a\u304c\u96a0\u308c\u308b\u3053\u3068\u304c\u7121\u3044\uff0e
//     \u30aa\u30fc\u30d0\u30fc\u30d8\u30c3\u30c9\u304c\u6700\u3082\u91cd\u3044\u30e2\u30fc\u30c9\uff0e
// \uff08\u30c6\u30ad\u30b9\u30c8\u5c02\u7528\u30ec\u30a4\u30e4\u30fc\u4f7f\u7528\u6642\uff1a2\u306e\u5236\u7d04\uff09\uff1aProcessing\u306e\u4ed5\u69d8\u306b\u57fa\u3065\u304f
//   \u307e\u305a\uff0c\u30d5\u30a9\u30f3\u30c8\u306e\u898b\u6804\u3048\u304c\u60aa\u3044\uff0e\u30c6\u30ad\u30b9\u30c8\u306e\u8272\u3082\u4f55\u6545\u304b\u6307\u5b9a\u3057\u305f\u5024\u3088\u308a\u3082\u5c11\u3057\u6697\u304f\u306a\u308b\uff0e
//   \u30ec\u30a4\u30e4\u30fc\u3092\u91cd\u306d\u308b\u306e\u306bblend()\u3092\u4f7f\u7528\u3057\u3066\u3044\u308b\uff0e\u30c6\u30af\u30cb\u30c3\u30af\u3068\u3057\u3066\u306f\u4e0d\u900f\u660e\u5ea6\uff10\uff08\u3064\u307e\u308a\u900f\u660e\uff09\u304b\u3064\u9ed2\u3044\u80cc\u666f\u306b\u4e0d\u900f\u660e\u5ea6255\u3067
//   \u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u63cf\u753b\u3092\u884c\u306a\u3044\uff0cblend(BLEND)\u3059\u308b\u3068\u4e0d\u900f\u660e\u5ea6255\u306ePixel\u306e\u307f\u304c\u5408\u6210\u3055\u308c\u308b\u3068\u3044\u3046\u624b\u6cd5\u3092\u53d6\u3063\u3066\u3044\u307e\u3059\uff0e
//   \u3068\u3053\u308d\u304ctext()\u306fbackground(#000000, 0)\u306e\u80cc\u666f\u8272#000000\u3092\u5229\u7528\u3057\u3066\u304f\u308c\u308b\u306e\u3067\u3059\u304c\uff0c\u4e0d\u900f\u660e\u5ea6255\u3067\u63cf\u753b\u3057\u3066\u3057\u307e\u3044\u307e\u3059\uff0e
//   \u305d\u3053\u3067\u6587\u5b57\u3092text()\u3067\u63cf\u753b\u3059\u308b\u5ea6\u306b\u305d\u306e\u30a8\u30ea\u30a2\u3092pixel\u5358\u4f4d\u3067\u30c1\u30a7\u30c3\u30af\u3057\u3066\u80cc\u666f\u8272#000000\u306e\u5834\u5408\u306f\u5f37\u5236\u7684\u306bcolor(#00000, 0)
//   \u306b\u5909\u66f4\u3057\u307e\u3059\uff0e\u3057\u305f\u304c\u3063\u3066\u6587\u5b57\u8272\u3068\u3057\u3066#000000\u3092\u6307\u5b9a\u3059\u308b\u3068\u533a\u5225\u304c\u4ed8\u304d\u307e\u305b\u3093\u306e\u3067\u5185\u90e8\u3067\u52dd\u624b\u306b#000002\u306b\u6587\u5b57\u8272\u3092\u5909\u66f4\u3057\u3066
//   \u3044\u307e\u3059\uff0e\u3053\u306e\u4e0d\u900f\u660e\u5ea6\u306e\u5909\u66f4\u306e\u51e6\u7406\u306b\u3082\u4f59\u8a08\u306a\u30aa\u30fc\u30d0\u30fc\u30d8\u30c3\u30c9\u304c\u751f\u3058\u3066\u3044\u307e\u3059\uff0e\u3042\u307e\u308a\u5927\u304d\u306a\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\u3092\u6307\u5b9a\u3059\u308b\u3068\uff0c
//   blend()\u306b\u3082\u6642\u9593\u304c\u639b\u304b\u308a\u307e\u3059\uff0e

/*
class vectorClass {
  float x, y;
  vectorClass() {
    x = y = 0.0;
  }
  void scale(float a) {
    x *= a;
    y *= a;
  }
}
*/

// \u73fe\u5728\u306e\u7dda\u8272\u3084\u5ea7\u6a19\u306a\u3069\u306e\u60c5\u5831\u3092\u4fdd\u6301
class currentDrawingClass {
  boolean  isFill;       // \u5857\u308a\u6f70\u3059\uff1f
  int      fillColor;    // \u5857\u308a\u6f70\u3057\u8272
  int      fillTrans;    // \u5857\u308a\u6f70\u3057\u306e\u4e0d\u900f\u660e\u5ea6
  boolean  isStroke;     // \u5916\u5f62\u7dda\u63cf\u304f\uff1f
  int      strokeColor;  // \u5916\u5f62\u7dda\u8272
  int      strokeTrans;  // \u5916\u5f62\u7dda\u306e\u4e0d\u900f\u660e\u5ea6
  int      textColor;    // \u30c6\u30ad\u30b9\u30c8\u6587\u5b57\u306e\u8272
  int      vpx, vpy;     // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u5185\u306e\u6700\u5f8c\u306b\u63cf\u753b\u3057\u305f\u5ea7\u6a19
  float    wpx, wpy;     // \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u306b\u304a\u3051\u308b\u6700\u5f8c\u306b\u63cf\u753b\u3057\u305f\u5ea7\u6a19
  currentDrawingClass() {
    setDefault();
  }
  // \u8907\u88fd
  public void clone(currentDrawingClass src) {
    isFill      = src.isFill;
    fillColor   = src.fillColor;
    fillTrans   = src.fillTrans;
    isStroke    = src.isStroke;
    strokeColor = src.strokeColor;
    strokeTrans = src.strokeTrans;
    textColor   = src.textColor;
    vpx         = src.vpx;
    vpy         = src.vpy;
    wpx         = src.wpx;
    wpy         = src.wpy;
  }
  // \u521d\u671f\u5024\u306b\u8a2d\u5b9a
  public void setDefault() {
    isFill       = true;
    fillColor    = 0xffffffff;
    fillTrans    = 255;
    isStroke     = true;
    strokeColor  = 0xff000000;
    strokeTrans  = 255;
    textColor    = fillColor;
    vpx = vpy    = 0;
    wpx = wpy    = 0.0f;
  }
}


class viewportClass {
  protected PGraphics pg;                              // \u30d3\u30e5\u30fc\u306e\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u306e\u30cf\u30f3\u30c9\u30eb
  protected float     wx_min, wx_max, wy_min, wy_max;  // \u30d3\u30e5\u30fc\u306e\u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19
  protected int       vx, vy;                          // \u30d3\u30e5\u30fc\u306e\u5b9f\u884c\u30b9\u30af\u30ea\u30fc\u30f3\u306b\u5bfe\u3059\u308b\u5de6\u4e0a\u306e\u5ea7\u6a19
  protected int       vwidth, vheight;                 // \u30d3\u30e5\u30fc\u306e\u6a2a\u5e45\uff0f\u7e26\u5e45
  boolean             monoRatio;                       // \u30d4\u30af\u30bb\u30eb\u6bd4\u306f\u7e26\u3082\u6a2a\u3082\u540c\u4e00\u306b\u3059\u308b\u304b
  float               pixelRatioX, pixelRatioY;        // \u30d4\u30af\u30bb\u30eb\u6bd4\uff08\u7e26\u3068\u6a2a\uff09\u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u2192\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u5185\u306ePixel\u5ea7\u6a19\u5909\u63db\u7528
  protected int       bgColor;                         // \u30d3\u30e5\u30fc\u306e\u80cc\u666f\u8272
  protected boolean   transparentView;                 // \u30d3\u30e5\u30fc\u306e\u80cc\u666f\u304c\u900f\u660e\u306a\u30d3\u30e5\u30fc
  protected int       transparency;                    // \u30d3\u30e5\u30fc\u306e\u900f\u660e\u5ea6\uff08\u67a0\u306f\u9664\u304f\uff09\uff1a 0\uff5e255\uff08\u30c7\u30d5\u30a9\u30eb\u30c8\u306f255\uff09
  boolean             drawFrame;                       // \u67a0\u306e\u8868\u793a\u3092\u884c\u306a\u3046\u304b\uff1f
  int                 frameColor;                      // \u67a0\u306e\u8272
  protected String    label;                           // \u30d3\u30e5\u30fc\u306e\u8aac\u660e\uff08\u30aa\u30d7\u30b7\u30e7\u30f3\uff09
  protected int       no;                              // \u8868\u793a\u9806\uff08\u512a\u5148\u5ea6\uff09\uff1a\u6570\u5b57\u304c\u5927\u304d\u3044\u307b\u3069\u5f8c\uff08\u4e0a\uff09\u306b\u8868\u793a\u3055\u308c\u308b
  float               magnification;                   // \u753b\u9762\u306e\u62e1\u5927\u7387\uff08\u30d4\u30af\u30bb\u30eb\u6bd4\u306b\u3053\u306e\u5024\u3092\u639b\u3051\u308b\uff09
  float               offsetX, offsetY;                // \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u306b\u304a\u3051\u308b\u30aa\u30d5\u30bb\u30c3\u30c8\u91cf
  protected boolean   visible;                         // \u30d3\u30e5\u30fc\u306e\u8868\u793a\u3092\u30c0\u30a4\u30ca\u30df\u30c3\u30af\u306bOn/Off\u3067\u304d\u308b
  currentDrawingClass cdSet;                           // \u6700\u65b0\u306e\u63cf\u753b\u95a2\u4fc2\u306e\u60c5\u5831
  // \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf
  viewportClass(String name, int x, int y, int width, int height) {
    // \u5ea7\u6a19\u95a2\u4fc2\u306e\u521d\u671f\u5316
    vx         = x;
    vy         = y;
    vwidth     = width;
    vheight    = height;
    monoRatio  = true;
    world(0.0f, 0.0f, vwidth, vheight);  // \u521d\u671f\u5024\u3067\u8a2d\u5b9a
    // \u80cc\u666f\u8272\uff0c\u30d5\u30ec\u30fc\u30e0
    bgColor      = _BGCOLOR;
    transparentView = false;
    drawFrame    = true;
    transparency = 255;
    frameColor   = 0xff000000;
    // \u6700\u65b0\u306e\u63cf\u753b\u95a2\u4fc2\u306e\u60c5\u5831
    cdSet      = new currentDrawingClass();
    // \u62e1\u5927\u30fb\u4e26\u9032\u30d1\u30e9\u30e1\u30fc\u30bf
    magnification = 1.0f;
    offsetX = offsetY = 0.0f;
    // \u30c7\u30d0\u30c3\u30b0\u60c5\u5831
    label     = name;
    no        = -1;
    // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u7528\u306e\u30b0\u30e9\u30d5\u30a3\u30c3\u30af\u30b9\u3092\u78ba\u4fdd
    pg        = createGraphics(vwidth, vheight, JAVA2D);    // P3D\u3067\u63cf\u753b\u3059\u308b\u3068\u5186\u306b\u5909\u306a\u7dda\u304c\u6ca2\u5c71\u5165\u308b\u306e\u3067\uff0e
    pg.beginDraw();
    pg.smooth();                      // \u4e00\u5fdc\uff0c\u5ff5\u306e\u305f\u3081\u306b
    pg.endDraw();
    visible   = true;
  }
  // \u30af\u30e9\u30b9\u306e\u8907\u88fd
  public void clone(viewportClass src) {
    vx              = src.vx;
    vy              = src.vy;
    vwidth          = src.vwidth;
    vheight         = src.vheight;
    monoRatio       = src.monoRatio;
    bgColor         = src.bgColor;
    transparentView = src.transparentView;
    drawFrame       = src.drawFrame;
    transparency    = src.transparency;
    frameColor      = src.frameColor;
    cdSet.clone(src.cdSet);
    magnification   = src.magnification;
    offsetX         = src.offsetX;
    offsetY         = src.offsetY;
    label           = src.label;
    no              = src.no;
    visible         = src.visible;
  }
  
  // \u78ba\u8a8d\u7528\u306e\u30d3\u30e5\u30fc\u756a\u53f7\u3092\u30bb\u30c3\u30c8
  public void setNo(int n) { no = n; }

  // \u30d4\u30af\u30bb\u30eb\u6bd4\u306e\u8a08\u7b97
  public void calcPixelRatio() {
    float px, py;
    px = vwidth  / (wx_max - wx_min);
    py = vheight / (wy_max - wy_min);
    if (monoRatio) {
      // \u7e26\u3068\u6a2a\u306e\u30d4\u30af\u30bb\u30eb\u6bd4\u3092\u540c\u4e00\u306b
      if (px > py) {
        // \u7e26\u512a\u5148
        pixelRatioX = py;
        pixelRatioY = py;
      } else {
        // \u6a2a\u512a\u5148
        pixelRatioX = px;
        pixelRatioY = px;
      }
    } else {
      // \u5225\u3005
      pixelRatioX = px;
      pixelRatioY = py;
    }
  }
  // --------------------
  // \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u306e\u8a2d\u5b9a
  // --------------------
  // \u3010\u53c2\u7167\u3011
  public float world_minX() { return wx_min; }
  public float world_maxX() { return wx_max; }
  public float world_minY() { return wy_min; }
  public float world_maxY() { return wy_max; }
  // \u3010\u5909\u66f4\u3011
  // (a) \u5168\u6307\u5b9a
  public void world(float minx, float miny, float maxx, float maxy) {
    if ((minx >= maxx) || (miny >= maxy)) {
      println("\u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u306e\u8a2d\u5b9a\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\uff08\u6700\u5c0f\u5024\u3068\u6700\u5927\u5024\u304c\u9006\u3067\u3059\uff09");
      exit();
    }
    wx_min = minx;
    wy_min = miny;
    wx_max = maxx;
    wy_max = maxy;
    calcPixelRatio();
  }
  // (b) \uff58\uff0c\uff59\u305d\u308c\u305e\u308c\u306e\u6700\u5c0f\u5024\uff0f\u6700\u5927\u5024\u3092\u500b\u5225\u306b\u5909\u66f4
  public float world_minX(float x) {
    float oldvalue = wx_min;
    world(x, wy_min, wx_max, wy_max);
    return oldvalue;
  }
  public float world_minY(float y) {
    float oldvalue = wy_min;
    world(wx_min, y, wx_max, wy_max);
    return oldvalue;
  }
  public float world_maxX(float x) {
    float oldvalue = wx_max;
    world(wx_min, wy_min, x, wy_max);
    return oldvalue;
  }
  public float world_maxY(float y) {
    float oldvalue = wy_max;
    world(wx_min, wy_min, wx_max, y);
    return oldvalue;
  }

  // ---------------------------------------------------
  // \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u304b\u3089\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306ePixel\u5ea7\u6a19\u7cfb\u3078\u306e\u5909\u63db
  // ---------------------------------------------------
  // a) \u5358\u306b\u30d4\u30af\u30bb\u30eb\u6bd4\u3092\u639b\u3051\u305f\u3082\u306e\uff08\u534a\u5f84\u3084\u9ad8\u3055\uff0f\u5e45\u7528\uff09
  public int _px(float x) { return PApplet.parseInt(x * magnification * pixelRatioX); }
  public int _py(float y) { return PApplet.parseInt(y * magnification * pixelRatioY); }
  // b) \u5ea7\u6a19\u5909\u63db
  public int px(float x) {
    float center = (wx_max + wx_min) / 2.0f - offsetX;
    return PApplet.parseInt((x - center) * magnification * pixelRatioX) + (vwidth / 2);
  }
  public int py(float y) {
    float center = (wy_max + wy_min) / 2.0f - offsetY;
    return vheight - (PApplet.parseInt((y - center) * magnification * pixelRatioY) + (vheight / 2));
  }
  // --------------------------------------------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\uff0f\u975e\u8868\u793a\u306e\u30c0\u30a4\u30ca\u30df\u30c3\u30af\u306a\u5207\u308a\u66ff\u3048
  // --------------------------------------------------
  // \u72b6\u614b
  public boolean isVisible() { return visible; }
  // (a) \u8868\u793a
  public void visible()   { visible = true;  }
  // (b) \u975e\u8868\u793a
  public void unVisible() { visible = false; }
  // (c) \u5f15\u6570\u306b\u3088\u308b\u6307\u5b9a
  public void changeVisible(boolean flag) { if (flag) visible(); else unVisible(); }
  // (d) \u30c8\u30b0\u30eb\u52d5\u4f5c
  public boolean toggleVisible() {
    if (isVisible()) {
      unVisible();
      return false;
    } else {
      visible();
      return true;
    }
  }
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u79fb\u52d5
  public void moveView(int x, int y)      { vx  = x;  vy  = y;  }
  public void moveViewRel(int dx, int dy) { vx += dx; vy += dy; }

  // ----------------------------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u67a0\u7dda\u3084\u4e0d\u900f\u660e\u5ea6\u306e\u8a2d\u5b9a
  // ----------------------------------
  // (a) \u30d5\u30ec\u30fc\u30e0\u30ab\u30e9\u30fc\u3092\u4fee\u5f97\uff08\u73fe\u5728\u306e\u30d5\u30ec\u30fc\u30e0\u306e\u307f\uff09
  public int  frameColor()     { return frameColor; }
  // (b) \u30d5\u30ec\u30fc\u30e0\u30ab\u30e9\u30fc\u306e\u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\uff09
  public int frameColor(int c) {
    int oldcolor = frameColor();
    frameColor = c & 0xffffffff;
    return oldcolor;
  }
  // (c) \u30d5\u30ec\u30fc\u30e0\u306e\u8868\u793a\uff0f\u975e\u8868\u793a
  public void drawFrame(boolean flag) { drawFrame = flag; }

  // (a) \u4e0d\u900f\u660e\u5ea6\u306e\u53d6\u5f97
  public int transparency() { return transparency; }
  // (b) \u4e0d\u900f\u660e\u5ea6\u306e\u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\uff09
  public int transparency(int trans) {
    int oldtrans = transparency();
    if (trans < 0)   trans = 0;
    if (trans > 255) trans = 255;
    transparency = cdSet.fillTrans = cdSet.strokeTrans = trans;  // \u5857\u308a\u6f70\u3057\u3084\u7dda\u306e\u4e0d\u900f\u660e\u5ea6\u3082\u5909\u66f4\u3059\u308b
    return oldtrans;
  }

  // \u80cc\u666f\u8272\u306e\u8a2d\u5b9a
  // (a) \u8272\u3092\u53d6\u5f97\uff08\u4e0d\u900f\u660e\u5ea6\u306f\u7121\u8996\uff09
  public int viewBgColor() { return bgColor; }
  // (b) \u8272\u3092\u8a2d\u5b9a\uff08\u4e0d\u900f\u660e\u5ea6\u306f255\uff09
  public int viewBgColor(int c) {
    int oldcolor = viewBgColor();
    bgColor = c & 0xffffffff;
    return oldcolor;
  }
  // \u80cc\u666f\u3092\u900f\u660e\u306a\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306b\u3059\u308b\uff0f\u3057\u306a\u3044
  public void transparentView(boolean flag) { transparentView = flag; }
/*
  // \u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u306e\u80cc\u666f\u8272\u3092\u5909\u66f4\u3059\u308b
  void viewBgColor(int v, int bg) {
    viewportClass vp = getView(v);
    if (vp == null) return;
    vp.bgColor(bg);
  }
  // \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u306e\u80cc\u666f\u8272\u3092\u5909\u66f4\u3059\u308b
  void viewBgColor(int bg) {
    cv.bgColor(bg);
  }
*/

  // --------
  // \u500d\u7387\u95a2\u4fc2
  // --------
  // (a) \u73fe\u5728\u306e\u500d\u7387\u3092\u8fd4\u3059
  public float scale() { return magnification; }
  // (b) \u500d\u7387\u306e\u5024\u3092\u5909\u66f4\u3059\u308b\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public float scale(float s) {
    float oldscale;
    if (s <= 0.0f) s = 1.0f;  // \u4e0d\u6b63\u306a\u5024
    oldscale = scale();
    magnification = s;
    return oldscale;
  }

  // ----------------
  // \u30aa\u30d5\u30bb\u30c3\u30c8\u91cf\u95a2\u4fc2
  // ----------------
  // (a) \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u30aa\u30d5\u30bb\u30c3\u30c8\u91cf\u3092\u8fd4\u3059
  // (a-1) \uff58\u65b9\u5411
  public float offsetX() { return offsetX; }
  // (a-2) \uff59\u65b9\u5411
  public float offsetY() { return offsetY; }
  // (b) \u30aa\u30d5\u30bb\u30c3\u30c8\u91cf\u3092\u5909\u66f4\u3059\u308b\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09\uff1a\u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8
  // (b-1) \uff58\u65b9\u5411
  public float offsetX(float offset) {
    float oldoffset = offsetX();
    offsetX = offset;
    return oldoffset;
  }
  // (b-2) \uff59\u65b9\u5411
  public float offsetY(float offset) {
    float oldoffset = offsetY();
    offsetY = offset;
    return oldoffset;
  }
  // (b-3) \uff58\u65b9\u5411\uff0f\uff59\u65b9\u5411\u540c\u6642\uff1a\u5e38\u306btrue\u3092\u8fd4\u3059
  public boolean offset(float offx, float offy) {
    offsetX(offx);
    offsetY(offy);
    return true;
  }

  // ------
  // \u8272\u95a2\u4fc2
  // ------
  // (a) fill()
  // (a-1) \u73fe\u5728\u306e\u5857\u308a\u6f70\u3057\u8272\u3092\u53d6\u5f97
  public int fill() { return cdSet.fillColor; }
  // (a-2) \u5857\u308a\u6f70\u3057\u8272\u3092\u5909\u66f4\uff08\uff0b\u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int fill(int c) { return this.fill(c, cdSet.fillTrans); }
  // (a-3) \u5857\u308a\u6f70\u3057\u8272\u3092\u5909\u66f4\uff08\u4e0d\u900f\u660e\u5ea6\u5bfe\u5fdc\uff0b\u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int fill(int c, int trans) {
    if (trans < 0)   trans = 0;
    if (trans > 255) trans = 255;
    int oldcolor;
    oldcolor = this.fill();
    cdSet.fillColor = c & 0xffffffff;
    cdSet.fillTrans = trans;
    pg.beginDraw();
    pg.fill(cdSet.fillColor, cdSet.fillTrans);
    pg.endDraw();
    cdSet.isFill = false;
    return oldcolor;
  }
  // (a-4) \u5857\u308a\u6f70\u3057\u7121\u3057
  public void noFill() {
    cdSet.isFill = false;
    pg.beginDraw();
    pg.noFill();
    pg.endDraw();
  }
  // (a-5) \u518d\u3073\u5857\u308a\u6f70\u3057
  public void reFill() {
    this.fill(cdSet.fillColor, cdSet.fillTrans);
  }
  // (b) stroke()
  // (b-1) \u73fe\u5728\u306e\u7dda\u8272\u3092\u53d6\u5f97
  public int stroke() { return cdSet.strokeColor; }
  // (b-2) \u7dda\u8272\u3092\u5909\u66f4\uff08\uff0b\u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int stroke(int c) { return this.stroke(c, cdSet.fillTrans); }
  // (b-3) \u7dda\u8272\u3092\u5909\u66f4\uff08\u4e0d\u900f\u660e\u5ea6\u5bfe\u5fdc\uff0b\u73fe\u5728\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int stroke(int c, int trans) {
    if (trans < 0)   trans = 0;
    if (trans > 255) trans = 255;
    int oldcolor;
    oldcolor = this.stroke();
    cdSet.strokeColor = c & 0xffffffff;
    cdSet.strokeTrans = trans;
    pg.stroke(cdSet.strokeColor, cdSet.strokeTrans);
    return oldcolor;
  }
  // (b-4) \u7dda\u7121\u3057
  public void noStroke() {
    cdSet.isStroke = false;
    pg.beginDraw();
    pg.noStroke();
    pg.endDraw();
  }
  // (b-5) \u518d\u3073\u7dda\u6709\u308a
  public void reStroke() {
    this.stroke(cdSet.strokeColor, cdSet.strokeTrans);
  }
  // (c) \u80cc\u666f\u8272
  public int getBgColor() {
    return bgColor;
  }

  // \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u753b\u9762\u6d88\u53bb\u3059\u308b
  public void clrView() {
    pg.beginDraw();
    if (transparentView) pg.background(bgColor, 0);
      else               pg.background(bgColor, transparency);
    pg.endDraw();
  }

  // --------------
  // \u5ea7\u6a19\u3092\u79fb\u52d5\u3059\u308b
  // --------------
  public void _moveTo(int x, int y) {
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  public void moveTo(float x, float y) {
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  public void _moveToRel(int dx, int dy) {
    cdSet.vpx += dx;
    cdSet.vpy += dy;
  }
  public void moveToRel(float dx, float dy) {
    cdSet.wpx += dx;
    cdSet.wpy += dy;
  }
  // ------------
  // \u76f4\u7dda\u63cf\u753b\u95a2\u4fc2
  // ------------
  // \u76f4\u7dda\u3092\u63cf\u304f\uff08\u30d4\u30af\u30bb\u30eb\u5ea7\u6a19\uff09
  public void _line(int x1, int y1, int x2, int y2) {
    pg.beginDraw();
    pg.line(x1, y1, x2, y2);
    pg.endDraw();
    cdSet.vpx = x2;
    cdSet.vpy = y2;
  }
  // \u76f4\u7dda\u3092\u63cf\u304f\uff08\u30ef\u30fc\u30eb\u30c9\uff09
  public void line(float x1, float y1, float x2, float y2) {
    _line(px(x1), py(y1), px(x2), py(y2));
    cdSet.wpx = x2;
    cdSet.wpy = y2;
  }
  // \u59cb\u70b9\u7701\u7565\uff08\u7d76\u5bfe\u5ea7\u6a19\uff09
  public void _lineTo(int x, int y)    { _line(cdSet.vpx, cdSet.vpy, x, y); }
  public void lineTo(float x, float y) { this.line(cdSet.wpx, cdSet.wpy, x, y); }
  // \u59cb\u70b9\u7701\u7565\uff08\u76f8\u5bfe\u5ea7\u6a19\uff09
  public void _lineRel(int dx, int dy)    { _line(cdSet.vpx, cdSet.vpy, cdSet.vpx + dx, cdSet.vpy + dy); }
  public void lineRel(float dx, float dy) { this.line(cdSet.wpx, cdSet.wpy, cdSet.wpx + dx, cdSet.wpy + dy); }
  // ----------
  // \u70b9\u7dda\u3092\u63cf\u304f
  // ----------
  // (a) \u7d76\u5bfe\u5ea7\u6a19\u6307\u5b9a
  // (a-1) \u30d4\u30af\u30bb\u30eb\u5ea7\u6a19
  public void _dashedLine(int x0, int y0, int x1, int y1, int step) {
//  int    step = 10;
    float  px0, py0, px1, py1, normv;
    float  unitx, unity;
    float  dx, dy;
    int    countmax, count;
    boolean stroke = true;

    cdSet.vpx = x1;
    cdSet.vpy = y1;
    countmax = PApplet.parseInt(norm(x0, y0, x1, y1) / step);
    if (countmax <= 0) {
      _line(x0, y0, x1, y1);
      return;
    }
    px0 = x0;
    py0 = y0;
    for (count = 0; count < countmax; count++) {
      dx = x1 - px0;
      dy = y1 - py0;
      normv = sqrt(dx * dx + dy * dy);
      if (normv < step) {
        _line(PApplet.parseInt(px0), PApplet.parseInt(py0), x1, y1);
        return;
      }
      unitx = dx / normv;
      unity = dy / normv;
      px1 = px0 + unitx * step;
      py1 = py0 + unity * step;
      if (stroke) _line(PApplet.parseInt(px0), PApplet.parseInt(py0), PApplet.parseInt(px1), PApplet.parseInt(py1));
      stroke = !stroke;
      px0 = px1;
      py0 = py1;
    }
  }
  // (a-2) \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb
  public void dashedLine(float x1, float y1, float x2, float y2, float step) {
    _dashedLine(px(x1), py(y1), px(x2), py(y2), PApplet.parseInt((_px(step) + _py(step)) / 2.0f));
    cdSet.wpx = x2;
    cdSet.wpy = y2;
  }
  // (b) \u59cb\u70b9\u7701\u7565\uff08\u7d76\u5bfe\u5ea7\u6a19\uff09
  public void _dashedLineTo(int x, int y, int step)      { _dashedLine(cdSet.vpx, cdSet.vpy, x, y, step); }
  public void dashedLineTo(float x, float y, float step) { dashedLine(cdSet.wpx, cdSet.wpy, x, y, step);  }
  // (c) \u59cb\u70b9\u7701\u7565\uff08\u76f8\u5bfe\u5ea7\u6a19\uff09
  public void _dashedLineRel(int dx, int dy, int step)      { _dashedLine(cdSet.vpx, cdSet.vpy, cdSet.vpx + dx, cdSet.vpy + dy, step); }
  public void dashedLineRel(float dx, float dy, float step) { dashedLine(cdSet.wpx, cdSet.wpy, cdSet.wpx + dx, cdSet.wpy + dy, step);  }

  // --------
  // \u5186\u3092\u63cf\u304f
  // --------
  // \u771f\u5186\u3092\u63cf\u304f\uff08\u751f\uff1a\u534a\u5f84\u6307\u5b9a\uff09
  public void _ellipse(int x, int y, int r) {
    _ellipse(x, y, r, r);
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  // \u6955\u5186\u3092\u63cf\u304f\uff08\u751f\uff1a\u5e45\u3068\u9ad8\u3055\u3092\u6307\u5b9a\uff09
  public void _ellipse(int x, int y, int w, int h) {
    pg.beginDraw();
    pg.ellipse(x, y, w, h);
    pg.endDraw();
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  // \u771f\u5186\u3092\u63cf\u304f\uff08\u30ef\u30fc\u30eb\u30c9\uff1a\u534a\u5f84\u6307\u5b9a\uff09
  public void ellipse(float x, float y, float r) {
    this.ellipse(x, y, r, r);
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  // \u6955\u5186\u3092\u63cf\u304f\uff08\u30ef\u30fc\u30eb\u30c9\uff1a\u5e45\u3068\u9ad8\u3055\u6307\u5b9a\uff09
  public void ellipse(float x, float y, float w, float h) {
    _ellipse(px(x), py(y), _px(w), _py(h));
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  // -----------
  // \u4e09\u89d2\u5f62\u3092\u63cf\u304f
  // -----------
  public void _triangle(int x1, int y1, int x2, int y2, int x3, int y3) {
    pg.beginDraw();
    pg.triangle(x1, y1, x2, y2, x3, y3);
    pg.endDraw();
    cdSet.vpx = x3;
    cdSet.vpy = y3;
  }
  public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
    _triangle(px(x1), py(y1), px(x2), py(y2), px(x3), py(y3));
    cdSet.wpx = x3;
    cdSet.wpy = y3;
  }
  // \u4e2d\u5fc3\u5ea7\u6a19\u3092\u6307\u5b9a\uff08\u56de\u8ee2\u5bfe\u5fdc\uff09
  public void _triangleC(int x, int y, int s, float angle) {
    int   dx1, dy1, dx2, dy2, dx3, dy3;
    float da;
    da  = TWO_PI / 3.0f;
    dx1 = 0;
    dy1 = s;
    dx2 = PApplet.parseInt(rotate2Dx(dx1, dy1, angle + da));
    dy2 = PApplet.parseInt(rotate2Dy(dx1, dy1, angle + da));
    dx3 = PApplet.parseInt(rotate2Dx(dx1, dy1, angle - da));
    dy3 = PApplet.parseInt(rotate2Dy(dx1, dy1, angle - da));
    dx1 = PApplet.parseInt(rotate2Dx(dx1, dy1, angle));
    dy1 = PApplet.parseInt(rotate2Dy(dx1, dy1, angle));
    _triangle(x + dx1, y + dy1, x + dx2, y + dy2, x + dx3, y + dy3);
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  public void _triangleC(int x, int y, int s) {
    _triangleC(x, y, s, 0.0f);
  }
  public void triangleC(float x, float y, float s, float angle) {
    float dx1, dy1, dx2, dy2, dx3, dy3, da;
    da  = TWO_PI / 3.0f;
    dx1 = 0;
    dy1 = s;
    dx2 = rotate2Dx(dx1, dy1, angle + da);
    dy2 = rotate2Dy(dx1, dy1, angle + da);
    dx3 = rotate2Dx(dx1, dy1, angle - da);
    dy3 = rotate2Dy(dx1, dy1, angle - da);
    dx1 = rotate2Dx(dx1, dy1, angle);
    dy1 = rotate2Dy(dx1, dy1, angle);
    this.triangle(x + dx1, y + dy1, x + dx2, y + dy2, x + dx3, y + dy3);
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  public void triangleC(float x, float y, float s) {
    triangleC(x, y, s, 0.0f);
  }
  // ------------
  // \u56db\u8fba\u5f62\u3092\u63cf\u304f
  // ------------
  public void _quad(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
    pg.beginDraw();
    pg.quad(x1, y1, x2, y2, x3, y3, x4, y4);
    pg.endDraw();
    cdSet.vpx = x4;
    cdSet.vpy = y4;
  }
  public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
    _quad(px(x1), py(y1), px(x2), py(y2), px(x3), py(y3), px(x4), py(y4));
    cdSet.wpx = x4;
    cdSet.wpy = y4;
  }
  // ------------
  // \u9577\u65b9\u5f62\u3092\u63cf\u304f
  // ------------
  // (a) \u5de6\u4e0a\u59cb\u70b9
  public void _rect(int x, int y, int w, int h) {
    pg.beginDraw();
    pg.rect(x, y, w, h);
    pg.endDraw();
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  public void rect(float x, float y, float w, float h) {
    _rect(px(x), py(y), _px(w), _py(h));
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  // (b) \u4e2d\u592e\u6307\u5b9a
  public void _rectC(int x, int y, int w, int h) {
    _rect(x - w / 2, y + h / 2, w, h);
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  public void rectC(float x, float y, float w, float h) {
    this.rect(x - w / 2.0f, y + h / 2.0f, w, h);
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  // (b) \u5de6\u4e0a\uff0c\u53f3\u4e0b\u6307\u5b9a
  public void _rectLR(int x1, int y1, int x2, int y2) {
    _rect(x1, y1, x2 - x1, y2 - y1);
    cdSet.vpx = x1;
    cdSet.vpy = y1;
  }
  public void rectLR(float x1, float y1, float x2, float y2) {
    this.rect(x1, y1, x2 - x1, y2 - y1);
    cdSet.wpx = x1;
    cdSet.wpy = y1;
  }
  // ---------
  // \u5186\u5f27\u3092\u63cf\u304f
  // ---------
  public void _arc(int x, int y, int w, int h, float start, float stop) {
    pg.beginDraw();
    pg.arc(x, y, w, h, start, stop);
    pg.endDraw();
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  public void arc(float x, float y, float w, float h, float start, float stop) {
    _arc(px(x), py(y), _px(w), _py(h), start, stop);
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  // ------------
  // \u70b9\u3092\u63cf\u753b\u3059\u308b
  // ------------
  public void _point(int x, int y) {
    pg.beginDraw();
    pg.point(x, y);
    pg.endDraw();
    cdSet.vpx = x;
    cdSet.vpy = y;
  }
  public void point(float x, float y) {
    _point(px(x), py(y));
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  // ----------------
  // \u30c6\u30ad\u30b9\u30c8\u8868\u793a\u95a2\u4fc2
  // ----------------
  public void prepareFont(int fontsize) {
    prepareFont(_FONTNAME, fontsize);
  }
  public void prepareFont(String fontname, int fontsize) {
    if (crowbar.status != 0) {
      println("\u30a8\u30e9\u30fc: \u30d5\u30a9\u30f3\u30c8\u306e\u5ba3\u8a00\u306fOptions()\u304bSetup()\u3067\u884c\u3063\u3066\u4e0b\u3055\u3044\uff0c");
      return;
    }
    PFont font = createFont(fontname, fontsize, false);  // \u30d5\u30a9\u30f3\u30c8\u3092\u5909\u63db
    pg.beginDraw();
    pg.textFont(font);         // \u30d5\u30a9\u30f3\u30c8\u3092\u8a2d\u5b9a
    pg.textMode(SCREEN);
    pg.textSize(fontsize);     // \u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba\u3092\u8a2d\u5b9a\uff08\u4e0d\u8981\uff1f\uff09
    pg.textAlign(LEFT, TOP);   // \u914d\u7f6e
    pg.endDraw();
  }
  public void textSize(int size) {
    pg.beginDraw();
    pg.textSize(size);
    pg.endDraw();
  }
  public void textAlign(int align) {
    pg.beginDraw();
    pg.textAlign(align);
    pg.endDraw();
  }
  public void textAlign(int align, int yalign) {
    pg.beginDraw();
    pg.textAlign(align, yalign);
    pg.endDraw();
  }
  // \u5b9f\u969b\u306b\u63cf\u753b\u3059\u308b
  public void _text(String str, int x, int y) {
    pg.beginDraw();
    pg.fill(cdSet.textColor);
    pg.text(str, x, y);
    pg.fill(cdSet.fillColor);
    cdSet.vpx = x + PApplet.parseInt(pg.textWidth(str));
    cdSet.vpy = y;
    pg.endDraw();
  }
  public void _text(String str) {
    _text(str, cdSet.vpx, cdSet.vpy);
  }
  public void text(String str, float x, float y) {
    _text(str, px(x), py(y));
    cdSet.wpx = x;
    cdSet.wpy = y;
  }
  public void text(String str) {
    _text(str);
    // \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u3092\u52d5\u304b\u3059\u306e\u306f\u9762\u5012\u306a\u306e\u3067\u30d1\u30b9\uff08\u4e0d\u53ef\u80fd\u3067\u306f\u306a\u3044\u304c\uff09\uff0e
  }
  // \u6587\u5b57\u8272\u95a2\u4fc2
  // (a) \u6587\u5b57\u8272\u306e\u53d6\u5f97
  public int textColor() {
    return cdSet.textColor;
  }
  // (b) \u6587\u5b57\u8272\u306e\u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public int textColor(int c) {
    int oldcolor = this.textColor();
    cdSet.textColor = c & 0xffffffff;
    return oldcolor;
  }
}

// Tomahawk\u672c\u4f53\u30af\u30e9\u30b9\uff08Crowbar\u306b\u7d99\u627f\u3055\u308c\u307e\u3059\uff09
class tomahawkClass {
  protected int               viewMax;       // \u5ba3\u8a00\u6e08\u307f\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u6570
  protected int               cvNumber;      // \u73fe\u5728\u6ce8\u76ee\u3057\u3066\u3044\u308b\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u756a\u53f7
  protected viewportClass     cv;            // \u73fe\u5728\u6ce8\u76ee\u3057\u3066\u3044\u308b\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u30af\u30e9\u30b9
  protected viewportClass []  viewStack;     // \u5ba3\u8a00\u6e08\u307f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8
  protected viewportClass []  cloneStack;    // Options(), Setup()\u3067\u5ba3\u8a00\u3057\u305f\u72b6\u614b\u3092\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\uff06\u30ea\u30b9\u30c8\u30a2\u3059\u308b\u305f\u3081\u306e\u9818\u57df
  protected int               tomahawkMode;  // mode == 0: noTomahawk, 1: Basic, 2: Advanced
  tomahawkClass(int mode) {
//  background(_BGCOLOR);  // Crowbar\u3067\u6307\u5b9a\u3059\u308b\u80cc\u666f\u8272\u3067\u521d\u671f\u5316
    viewStack    = (viewportClass [])new viewportClass[1];  // \u914d\u5217\u3092\u4e00\u3064\u3060\u3051\u78ba\u4fdd\u3059\u308b\uff08\u3042\u3068\u3067\u5ba3\u8a00\u3055\u308c\u308b\u5ea6\u306b\u62e1\u5f35\u3059\u308b\uff09
    viewStack[0] = null;
    cloneStack    = (viewportClass [])new viewportClass[1];  // \u914d\u5217\u3092\u4e00\u3064\u3060\u3051\u78ba\u4fdd\u3059\u308b\uff08\u3042\u3068\u3067\u5ba3\u8a00\u3055\u308c\u308b\u5ea6\u306b\u62e1\u5f35\u3059\u308b\uff09
    cloneStack[0] = null;
    cvNumber     = 0;
    cv           = null;
    viewMax      = 0;
    tomahawkMode = mode;
  }
  // \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u72b6\u614b\u3092\u30d0\u30c3\u30af\u30a2\u30c3\u30d7
  public void backupViewports() {
    int i;
    if (cloneStack == null) return;
    for (i = 0; i < viewMax; i++) cloneStack[i].clone(viewStack[i]);
  }
  // \u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u72b6\u614b\u3092\u30ea\u30b9\u30c8\u30a2\u3059\u308b
  public void restoreViewports() {
    int i;
    if (cloneStack == null) return;
    for (i = 0; i < viewMax; i++) viewStack[i].clone(cloneStack[i]);
  }
  // \u30c7\u30d0\u30c3\u30b0\u7528\uff08\u5168\u30d3\u30e5\u30fc\u306e\u60c5\u5831\u3092\u8868\u793a\u3059\u308b\uff09
  public void displayAllViewData() {
    int  i;
    viewportClass vp;
    for (i = 0; i < viewMax; i++) {
      vp = viewStack[i];
      print(str(i) + ":[" + str(vp.no) + "]" + vp.label + "/(" + str(vp.vx) + "," + str(vp.vy) + "," + str(vp.vwidth) + "," + str(vp.vheight) + ")");
      print("-(" + str(vp.wx_min) + "," + str(vp.wy_min) + "," + str(vp.wx_max) + "," + str(vp.wy_max) + ")");
      print(" Color=#" + hex(vp.viewBgColor()) + ":Ratio =[" + str(vp.pixelRatioX) + "," + str(vp.pixelRatioY) + "]:Scale=" + str(vp.scale()));
      print(" Offset=" + str(vp.offsetX()) + "," + str(vp.offsetY()) + "Visible:" + str(vp.visible));
      println();
    }
  }
  
  // ----------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u95a2\u9023
  // ----------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u65b0\u898f\u4f5c\u6210\uff08\u6210\u529f\u3057\u305f\u5834\u5408\u306f\u30d3\u30e5\u30fc\u756a\u53f7\u3092\u8fd4\u3059\uff0e\u5931\u6557\u3057\u305f\u5834\u5408\u306f -1 \u3092\u8fd4\u3059\uff09
  public int createView(String label, int x, int y, int width, int height) {
    if (crowbar.status != 0) {
      println("\u30a8\u30e9\u30fc\uff1a\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u4f5c\u6210\u306fOptions()\u304bSetup()\u5185\u3067\u884c\u306a\u3063\u3066\u4e0b\u3055\u3044\uff0e");
      exit();
    }
    if (viewMax > 0) {
      viewStack  = (viewportClass [])expand(viewStack,  viewMax + 1);  // \u6700\u521d\u3060\u3051\u306f\u914d\u5217\u6570\uff11\u3067\u78ba\u4fdd\u3055\u308c\u3066\u3044\u308b\u305f\u3081
      cloneStack = (viewportClass [])expand(cloneStack, viewMax + 1);  // \u6700\u521d\u3060\u3051\u306f\u914d\u5217\u6570\uff11\u3067\u78ba\u4fdd\u3055\u308c\u3066\u3044\u308b\u305f\u3081
    }
    if (viewStack.length != viewMax + 1) return -1;  // \u6b63\u3057\u304f\u914d\u5217\u306e\u62e1\u5927\u304c\u3067\u304d\u306a\u304b\u3063\u305f\u5834\u5408
    viewMax++;
    cvNumber = viewMax - 1;
    if ((cv = viewStack[cvNumber] = new viewportClass(label, x, y, width, height)) == null) return -1;  // \u5b9f\u969b\u306b\u78ba\u4fdd\u3059\u308b
    cloneStack[cvNumber] = new viewportClass(label, x, y, width, height);                               // \u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u9818\u57df\u3092\u78ba\u4fdd
    viewStack[cvNumber].setNo(cvNumber);  // \u30c7\u30d0\u30c3\u30b0\u7528\u306b\u30d3\u30e5\u30fc\u756a\u53f7\u3092\u30bb\u30c3\u30c8
    // \u8272\u60c5\u5831\u306a\u3069\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u8a2d\u5b9a
    cv.fill(0xffffffff,   cv.transparency); // \u900f\u660e\u5ea6\u306b\u5bfe\u5fdc\uff0e\u521d\u671f\u8272
    cv.stroke(0xff000000, cv.transparency); // \u900f\u660e\u5ea6\u306b\u5bfe\u5fdc\uff0e\u521d\u671f\u8272
    cv.world(0, 0, width, height);
    return cvNumber;
  }
  // \u5168\u753b\u9762\u6307\u5b9a\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u4f5c\u6210\u3059\u308b
  public int createView(String label) {
    return createView(label, 0, 0, width, height);
  }
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u5206\u5272\u3057\u3066\u65b0\u3057\u304f\u78ba\u4fdd\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u756a\u53f7\u3092\u8fd4\u3059\uff0e\u5931\u6557\u3057\u305f\u5834\u5408\u306f-1\u3092\u8fd4\u3059\uff0e
  // (a) \u6c34\u5e73\u65b9\u5411
  public int splitViewH(int v, String label, float rate) {
    // \u30a8\u30e9\u30fc\u30c1\u30a7\u30c3\u30af
    if ((rate <= 0) || (rate >= 1.0f)) {
      println("\u30a8\u30e9\u30fc\uff1a\u5206\u5272\u5272\u5408\uff08\u7b2c\u4e8c\u5f15\u6570\uff09\u306f 0 < rate < 1.0\u306e\u7bc4\u56f2\u3067\u3057\u3066\u4e0b\u3055\u3044\uff0e");
      return -1;
    }
    if (isValidViewNumber(v) == false) { // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
      println("\u30a8\u30e9\u30fc\uff1a\u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u756a\u53f7\uff08\u7b2c\u4e00\u5f15\u6570\uff09\u306f\u4e0d\u6b63\u3067\u3059\uff0f" + str(v));
      return -1;
    }
    // \u5206\u5272
    viewportClass vp = getView(v);
    int xL, yL, wL, hL;
    int xR, yR, wR, hR;
    // \u5148\u306b\u5de6\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u7e2e\u5c0f\u3059\u308b
    xL = vp.vx;
    yL = vp.vy;
    wL = vp.vwidth;
    hL = vp.vheight;

    vp.vwidth = PApplet.parseInt(wL * rate);  // \u5de6\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u5f8c\u306e\u5e45
    cv.world(0, 0, vp.vwidth, vp.vheight);
    // \u7d42\u308f\u3063\u305f\u3089\u65b0\u898f\u4f5c\u6210
    xR = xL + vp.vwidth;            // \u53f3\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u5ea7\u6a19
    yR = yL;
    wR = wL - vp.vwidth;
    hR = hL;
    return createView(label, xR, yR, wR, hR);
  }
  // (b) \u5782\u76f4\u65b9\u5411
  public int splitViewH(String label, float rate) {
    return splitViewH(cvNumber, label, rate);
  }
  public int splitViewV(int v, String label, float rate) {
    // \u30a8\u30e9\u30fc\u30c1\u30a7\u30c3\u30af
    if ((rate <= 0) || (rate >= 1.0f)) {
      println("\u30a8\u30e9\u30fc\uff1a\u5206\u5272\u5272\u5408\uff08\u7b2c\u4e8c\u5f15\u6570\uff09\u306f 0 < rate < 1.0\u306e\u7bc4\u56f2\u3067\u3057\u3066\u4e0b\u3055\u3044\uff0e");
      return -1;
    }
    if (isValidViewNumber(v) == false) { // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
      println("\u30a8\u30e9\u30fc\uff1a\u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u756a\u53f7\uff08\u7b2c\u4e00\u5f15\u6570\uff09\u306f\u4e0d\u6b63\u3067\u3059\uff0f" + str(v));
      return -1;
    }
    // \u5206\u5272
    viewportClass vp = getView(v);
    int xU, yU, wU, hU;
    int xL, yL, wL, hL;
    // \u5148\u306b\u4e0a\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u7e2e\u5c0f\u3059\u308b
    xU = vp.vx;
    yU = vp.vy;
    wU = vp.vwidth;
    hU = vp.vheight;

    vp.vheight = PApplet.parseInt(hU * rate);  // \u4e0a\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u5909\u66f4\u5f8c\u306e\u9ad8\u3055
    cv.world(0, 0, vp.vwidth, vp.vheight);
    // \u7d42\u308f\u3063\u305f\u3089\u65b0\u898f\u4f5c\u6210
    xL = xU;
    yL = yU + vp.vheight;
    wL = wU;
    hL = hU - vp.vheight;
    return createView(label, xL, yL, wL, hL);
  }
  public int splitViewV(String label, float rate) {
    return splitViewV(cvNumber, label, rate);
  }

  // \u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u756a\u306f\u6b63\u3057\u3044\u304b\uff1f
  public boolean isValidViewNumber(int n) {
    if (n >= viewMax)         return false;
    if (n < 0)                return false;
    if (n > viewStack.length) return false;
    return true;
  }
  // \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u756a\u53f7\u3092\u8fd4\u3059
  public int view() { return cvNumber; }
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u9078\u629e\uff08\u6210\u529f\u3057\u305f\u5834\u5408\u306ftrue\uff09
  public boolean view(int n) {
    if (isValidViewNumber(n) == false) return false;
    cvNumber = n;
    cv = viewStack[cvNumber];
    return true;
  }
  // \u6307\u5b9a\u3055\u308c\u305f\u756a\u53f7\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u30af\u30e9\u30b9\u3092\u8fd4\u3059
  public viewportClass getView(int no) {
    if (isValidViewNumber(no) == false) return null;
    return viewStack[no];
  }
  // ------------------------
  // \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u79fb\u52d5
  // ------------------------
  // \u4e00\u3064\u6b21\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3078
  public int nextView() {
    if (++cvNumber >= viewMax) cvNumber = viewMax - 1;
    view(cvNumber);
    return cvNumber;
  }
  // \u4e00\u3064\u524d\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3078
  public int prevView() {
    if (--cvNumber < 0) cvNumber = 0;
    view(cvNumber);
    return cvNumber;
  }
  // \u6700\u521d\u306b\u78ba\u4fdd\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3078
  public void firstView() { view(0);           }
  // \u6700\u5f8c\u306b\u78ba\u4fdd\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3078
  public void lastView()  { view(viewMax - 1); }
  
  // ----------------------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u4e0a\u4e0b\u95a2\u4fc2\u306e\u79fb\u52d5
  // ----------------------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u9806\u3092\u8868\u308f\u3059\u884c\u5217\u3092\u8fd4\u3059
  public int [] getViewOrderList() {
    int [] order = new int[viewMax];
    int i;
    for (i = 0; i < viewMax; i++) order[viewStack[i].no] = i;
    return order;
  }
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u9806\u30ea\u30b9\u30c8\u3092\u5b9f\u969b\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u30c7\u30fc\u30bf\u306b\u66f8\u304d\u623b\u3059
  public void updateViewOrder(int [] order) {
    int i;
    for (i = 0; i < viewMax; i++) viewStack[order[i]].no = i;
  }
  // \u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u9806\u3092\u4e00\u756a\u4e0a\u306b\u79fb\u3059
  public void moveToTop(int v) {
    if (viewMax == 1) return;  // \u4e0d\u8981\u306a\u306e\u3067
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    int i;
    int [] order = getViewOrderList();
    for (i = viewStack[v].no; i < viewMax - 1; i++) order[i] = order[i + 1];
    order[i] = v;
    updateViewOrder(order);
  }
  // \u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u9806\u3092\u4e00\u756a\u4e0b\u306b\u79fb\u3059
  public void moveToBottom(int v) {
    if (viewMax == 1) return;  // \u4e0d\u8981\u306a\u306e\u3067
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    int i;
    int [] order = getViewOrderList();
    for (i = viewStack[v].no; i > 0; i--) order[i] = order[i - 1];
    order[0] = v;
    updateViewOrder(order);
  }
  // \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u9806\u3092\u4e00\u756a\u4e0a\u306b\u79fb\u3059
  public void moveToTop()    { moveToTop(cvNumber); }
  // \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\u9806\u3092\u4e00\u756a\u4e0b\u306b\u79fb\u3059
  public void moveToBottom() { moveToBottom(cvNumber); }

  // ----------------------------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u67a0\u7dda\u3084\u4e0d\u900f\u660e\u5ea6\u306e\u8a2d\u5b9a
  // ----------------------------------
  // (a) \u30d5\u30ec\u30fc\u30e0\u30ab\u30e9\u30fc\u3092\u4fee\u5f97
  public int frameColor(int v) {
    if (isValidViewNumber(v) == false) return -1;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).frameColor;
  }
  // (b) \u30d5\u30ec\u30fc\u30e0\u30ab\u30e9\u30fc\u306e\u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\uff09
  // (b-2) \u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8
  public int frameColor(int v, int c) {
    if (isValidViewNumber(v) == false) return -1;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    int oldcolor = frameColor(v);
    getView(v).frameColor(c);
    return oldcolor;
  }
  // (c) \u30d5\u30ec\u30fc\u30e0\u306e\u8868\u793a\uff0f\u975e\u8868\u793a
  public void viewDrawFrame(int v, boolean flag) {
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    getView(v).drawFrame(flag);
  }
  // (a) \u4e0d\u900f\u660e\u5ea6\u306e\u53d6\u5f97
  public int transparency(int v) {
    if (isValidViewNumber(v) == false) return -1;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).transparency();
  }
  // (b) \u4e0d\u900f\u660e\u5ea6\u306e\u8a2d\u5b9a\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\uff09
  public int transparency(int v, int trans) {
    if (isValidViewNumber(v) == false) return -1;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).transparency(trans);
  }
  // \u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u306e\u80cc\u666f\u8272\u3092\u5909\u66f4\u3059\u308b
  // (a) \u80cc\u666f\u8272\u3092\u53d6\u5f97
  public int viewBgColor(int v) {
    if (isValidViewNumber(v) == false) return -1;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).viewBgColor();
  }
  // (b) \u80cc\u666f\u8272\u3092\u6307\u5b9a
  public int viewBgColor(int v, int c) {
    if (isValidViewNumber(v) == false) return -1;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).viewBgColor(c);
  }
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u80cc\u666f\u3092\u900f\u660e\u306b\u3059\u308b\u304b\uff1f\uff08true\u3067\u900f\u660e\uff09
  public void transparentView(int v, boolean flag) {
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    getView(v).transparentView(flag);    
  }

  // ------------------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u4f4d\u7f6e\u306e\u5909\u66f4
  // ------------------------
  // (a) \u6307\u5b9a\u3057\u305f\u4f4d\u7f6e\u306b\u79fb\u52d5
  // (a-1) \u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8
  // (a-2) \u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8
  public void moveView(int v, int x, int y) {
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    getView(v).moveView(x, y);
  }
  public void moveViewRel(int v, int dx, int dy) {
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    getView(v).moveViewRel(dx, dy);
  }

  // \u5ea7\u6a19\u5909\u63db\uff08\u73fe\u5728\u306e\u30d3\u30e5\u30fc\uff09
  // \u5ea7\u6a19\u5909\u63db\uff08\u30ef\u30fc\u30eb\u30c9\u2192\u30d3\u30e5\u30fc\uff1a\u5927\u304d\u3055\u306e\u307f\uff09
  private int _px(float x) { return cv._px(x); }
  private int _py(float y) { return cv._py(y); }
  // \u5ea7\u6a19\u5909\u63db\uff08\u30ef\u30fc\u30eb\u30c9\u2192\u30d3\u30e5\u30fc\uff09
  private int px(float x) { return cv.px(x); }
  private int py(float y) { return cv.py(y); }

  // -----------------------------------
  // \u63cf\u753b\u30b3\u30de\u30f3\u30c9\u95a2\u4fc2\uff08\u30e6\u30fc\u30b6\u306b\u3088\u308b\u5229\u7528\uff09
  // -----------------------------------
  // \u5168\u3066\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u753b\u9762\u6d88\u53bb\u3059\u308b\uff08\u73fe\u5728\u306e\u30d3\u30e5\u30fc\u306f\u5909\u66f4\u3057\u306a\u3044\uff09
  public void clrAllView() {
    int i, cv;
    cv = cvNumber;
    for (i = 0; i < viewMax; i++) clrView(i);
    view(cv);
  }
  // \u6307\u5b9a\u3055\u308c\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u753b\u9762\u6d88\u53bb\u3059\u308b\uff08\u73fe\u5728\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u305d\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306b\u79fb\u3059\uff09
  public void clrView(int i) {
    if (view(i) != true) return;
    view(i);
    cv.clrView();
  }

  // --------
  // \u500d\u7387\u95a2\u4fc2
  // --------
  // (a) \u73fe\u5728\u306e\u500d\u7387\u3092\u8fd4\u3059\uff1a\u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7\u306e\u5834\u5408\u306f1.0\u3092\u8fd4\u3059
  public float scale(int v) {
    if (isValidViewNumber(v) == false) return 1.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).scale();
  }
  // (b) \u500d\u7387\u306e\u5024\u3092\u5909\u66f4\u3059\u308b\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09
  public float scale(int v, float s) {
    float oldscale;    
    if (isValidViewNumber(v) == false) return 1.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    oldscale = getView(v).scale();
    getView(v).scale(s);
    return oldscale;
  }
  // (c) \u5168\u3066\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u500d\u7387\u3092\u6307\u5b9a\u3057\u305f\u500d\u7387\u306b\u5909\u66f4\u3059\u308b
  public void allScale(float s) {
    int i;
    for (i = 0; i < viewMax; i++) scale(i, s);
  }

  // ----------------
  // \u30aa\u30d5\u30bb\u30c3\u30c8\u91cf\u95a2\u4fc2
  // ----------------
  // (a) \u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u30aa\u30d5\u30bb\u30c3\u30c8\u91cf\u3092\u8fd4\u3059
  // (a-1) \uff58\u65b9\u5411
  public float offsetX(int v) {
      viewportClass vp = getView(v);
    if (vp == null) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc
    return vp.offsetX;
  }
  // (a-2) \uff59\u65b9\u5411
  public float offsetY(int v) {
      viewportClass vp = getView(v);
    if (vp == null) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc
    return vp.offsetY;
  }
  // (b) \u30aa\u30d5\u30bb\u30c3\u30c8\u91cf\u3092\u5909\u66f4\u3059\u308b\uff08\uff0b\u5909\u66f4\u524d\u306e\u5024\u3092\u8fd4\u3059\uff09\uff1a\u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8
  // (b-1) \uff58\u65b9\u5411
  public float offsetX(int v, float offset) {
    viewportClass vp = getView(v);
    if (vp == null) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc
    float oldoffset = vp.offsetX;
    vp.offsetX = offset;
    return oldoffset;
  }
  // (b-2) \uff59\u65b9\u5411
  public float offsetY(int v, float offset) {
    viewportClass vp = getView(v);
    if (vp == null) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc
    float oldoffset = vp.offsetY;
    vp.offsetY = offset;
    return oldoffset;
  }
  // (b-3) \uff58\u65b9\u5411\uff0f\uff59\u65b9\u5411\u540c\u6642\uff1a\u6210\u529f\u3057\u305f\u5834\u5408\u306ftrue\u3092\u8fd4\u3059
  public boolean offset(int v, float offx, float offy) {
    float oldoffset;
    viewportClass vp = getView(v);
    if (vp == null) return false;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc
    vp.offsetX = offx;
    vp.offsetY = offy;
    return true;
  }

  // --------------------
  // \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u306e\u8a2d\u5b9a
  // --------------------
  // \u3010\u53c2\u7167\u3011
  // (a) \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u306e\u8a2d\u5b9a\u5024\u306e\u53c2\u7167\uff1a\u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\uff1a\u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u756a\u53f7\u304c\u6307\u5b9a\u3055\u308c\u305f\u5834\u5408\u306f0.0\u3092\u8fd4\u3059
  public float world_minX(int v) {
    if (isValidViewNumber(v) == false) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).wx_min;
  }
  public float world_maxX(int v) {
    if (isValidViewNumber(v) == false) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).wx_max;
  }
  public float world_minY(int v) {
    if (isValidViewNumber(v) == false) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).wy_min;
  }
  public float world_maxY(int v) {
    if (isValidViewNumber(v) == false) return 0.0f;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).wy_max;
  }
  // \u3010\u5909\u66f4\u3011
  // (a) \u30ef\u30fc\u30eb\u30c9\u5ea7\u6a19\u7cfb\u306e\u5909\u66f4\uff1a\u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\uff1a\u6210\u529f\u3057\u305f\u5834\u5408\u306ftrue\u3092\u8fd4\u3059
  public boolean world(int v, float x1, float y1, float x2, float y2) {
    if (isValidViewNumber(v) == false) return false;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    getView(v).world(x1, y1, x2, y2);
    return true;
  }
  // (b) \uff58\uff0c\uff59\u305d\u308c\u305e\u308c\u306e\u6700\u5c0f\u5024\uff0f\u6700\u5927\u5024\u3092\u500b\u5225\u306b\u5909\u66f4
  // \u6307\u5b9a\u3057\u305f\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u5024\u3092\u5909\u66f4\uff1a\u6210\u529f\u3057\u305f\u5834\u5408\u306ftrue\u3092\u8fd4\u3059
  public boolean world_minX(int v, float x) { return world(v, x, world_maxX(v), world_minY(v), world_maxY(v)); }
  public boolean world_maxX(int v, float x) { return world(v, world_minX(v), x, world_minY(v), world_maxY(v)); }
  public boolean world_minY(int v, float y) { return world(v, world_minX(v), world_maxX(v), y, world_maxY(v)); }
  public boolean world_maxY(int v, float y) { return world(v, world_minX(v), world_maxX(v), world_minY(v), y); }

  // --------------------------------------------------
  // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u306e\u8868\u793a\uff0f\u975e\u8868\u793a\u306e\u30c0\u30a4\u30ca\u30df\u30c3\u30af\u306a\u5207\u308a\u66ff\u3048
  // --------------------------------------------------
  // \u72b6\u614b
  public boolean isVisible(int v) {
    if (isValidViewNumber(v) == false) return false;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).isVisible();
  }
  // (a) \u8868\u793a
  public void visible(int v) {
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    getView(v).visible();
  }
  // (b) \u975e\u8868\u793a
  public void unVisible(int v) {
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    getView(v).unVisible();
  }
  // (c) \u5f15\u6570\u306b\u3088\u308b\u6307\u5b9a
  public void changeVisible(int v, boolean flag) {
    if (isValidViewNumber(v) == false) return;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    if (flag) visible(v); else unVisible(v);
  }
  // (d) \u30c8\u30b0\u30eb\u52d5\u4f5c
  public boolean toggleVisible(int v) {
    if (isValidViewNumber(v) == false) return false;  // \u4e0d\u6b63\u306a\u30d3\u30e5\u30fc\u756a\u53f7
    return getView(v).toggleVisible();
  }

  // \u4e0e\u3048\u3089\u308c\u305f\u5ea7\u6a19\uff08\u30de\u30a6\u30b9\u30af\u30ea\u30c3\u30af\u306a\u3069\uff09\u306f\u3069\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u6307\u3057\u3066\u3044\u308b\u306e\u304b\uff1f
  // \uff08\u3069\u306e\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3082\u542b\u307e\u308c\u306a\u3044\u306a\u3089\u3070-1\uff09
  // trans == true \u306e\u5834\u5408\u306f\u900f\u660e\u306a\u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u3092\u7121\u8996\u3059\u308b
  public int detectActiveView(int x, int y) { return detectActiveView(x, y, true); }
  public int detectActiveView(int x, int y, boolean trans) {
    int [] order = getViewOrderList();
    int i, x1, y1, x2, y2;
    viewportClass vp;
    for (i = viewMax - 1; i >= 0; i--) {
      vp = viewStack[order[i]];
      if (vp.isVisible() == false) continue;  // \u975e\u8868\u793a\u306f\u7121\u8996
      if ((trans == true) && (vp.transparentView == true)) continue;
      if (vp.transparency == 0) {           // \u30d3\u30e5\u30fc\u30dd\u30fc\u30c8\u304c\u900f\u660e\u80cc\u666f
        if (trans == true) continue;
        int col;
        vp.pg.beginDraw();
        col = vp.pg.get(x - vp.vx, y - vp.vy);
        vp.pg.endDraw();
        if ((col & 0x0ff000000) == 0) continue;  // \u3082\u3057\u63cf\u753b\u3055\u308c\u3066\u3044\u306a\u3044\u306a\u3089\u3070\u7121\u8996
      }
      x1 = vp.vx;
      y1 = vp.vy;
      x2 = x1 + vp.vwidth;
      y2 = y1 + vp.vheight;
      if ((x1 <= x) && (x <= x2) && (y1 <= y) && (y <= y2)) return order[i];
    }
    return -1;
  }

// =========================================================================================================

  // -----------------------------------------------
  // \u30d3\u30e5\u30fc\u306e\u5408\u6210\uff08crowbarClass.pde\u306edraw()\u306b\u3066\u4f7f\u7528\uff09
  // -----------------------------------------------
  public void refreshView() {
    if (tomahawkMode == 0) return;
//    if (tomahawkMode == 2) background(_BGCOLOR);
    if (crowbar.status == 10) {
      // \u30d3\u30e5\u30fc\u306e\u5408\u6210
      int i;
      int [] order = getViewOrderList();
      // \u8868\u793a\u9806\u306e\u30ea\u30b9\u30c8\u4f5c\u6210\uff08\u304d\u3061\u3093\u3068\u6b20\u756a\uff0c\u91cd\u8907\u306a\u304f\u4e26\u3093\u3067\u3044\u308b\u3053\u3068\u306f\u4e0a\u4e0b\u95a2\u4fc2\u306e\u64cd\u4f5c\u6642\u306b\u78ba\u8a8d\u6e08\u307f\u3068\u3044\u3046\u524d\u63d0\uff09
      viewportClass vp;
      for (i = 0; i < viewMax; i++) {
        vp = viewStack[order[i]];
        if (vp.isVisible() == false) continue;
        if (vp.drawFrame) {
          vp.pg.beginDraw();
          vp.pg.noFill();
          vp.pg.stroke(vp.frameColor, 255);
          vp.pg.rect(0, 0, vp.vwidth - 1, vp.vheight - 1);
          vp.pg.endDraw();
        }
        blend(vp.pg, 0, 0, vp.vwidth, vp.vheight, vp.vx, vp.vy, vp.vwidth, vp.vheight, BLEND);
      }
    }
    if (tomahawkMode == 2) blend(crowbar.screenSetting.pgText, 0, 0, crowbar.screenSetting.gwx, crowbar.screenSetting.gwy, 0, 0, crowbar.screenSetting.gwx, crowbar.screenSetting.gwy, BLEND);
  }
}

  static public void main(String args[]) {
    PApplet.main(new String[] { "--bgcolor=#D4D0C8", "TestSpace" });
  }
}
