///////////////////////////////////////////
// Processingによる二分法の対話的プログラム
//   ビジュアル版
//                      2012/05/23 T.Shirai
//     Tomahawk対応     2012/06/21 T.Shirai
//             shirai＠mech.suzuka-ct.ac.jp
///////////////////////////////////////////

// 動作に関わるオプション．ドキュメントを読んで理解したら自由に設定して構いません．
void Options() {
//  crowbar.startLogging();           // default.txtにログを記録する
    crowbar.disableTextArea();
    crowbar.nonStop();
}

void initCrowbar() {
  startCrowbar.generate(60, 30, 2);
}

///////////////////////////////////////////////////////////////////////////////////
// ここから下のコードはユーザが積極的に記述して構わない
///////////////////////////////////////////////////////////////////////////////////
// システム初期設定
void Setup()
{
  // プログラムコメント（パラメータ入力前に画面表示されます．複数宣言可，省略可）
  crowbar.programComment("二分法のプログラム");
  crowbar.programComment("ビジュアル版");
  crowbar.programComment("区間aは区間bよりも小さな値（例： a = 1, b = 2）");

  // 以下に，入力が必要なパラメータを宣言
  crowbar.define("区間ａ", 1.0);
  crowbar.define("区間ｂ", 2.0);

  crowbar.createView("Graph");
  crowbar.splitViewH("Text", 0.6);
  crowbar.cv.viewBgColor(#ffffff);
  crowbar.cv.clrView();
  crowbar.cv.prepareFont(18);
}

float err;
float a, b, c;
int   loopcount;

// メインルーチン
// void Main() の関数名を変えてはいけない．
void Main() {
  float tmp;
  // 許容誤差
  err = 0.000001;
  // 変数の代入
  a = crowbar.getFloat();
  b = crowbar.getFloat();
  // 範囲のチェックその１
  if (a > b) {
    tmp = a; a = b; b = tmp; // swap
  }
  // 範囲のチェックその２
  if (sgn(f(a)) == sgn(f(b))) {
    crowbar.writeln("Error: 値の範囲が正しくありません．");
    crowbar.writeln("f(a) = " + nf(f(a), 1, 4) + " f(b) = " + nf(f(b), 1, 3));
    crowbar.stop();
    return;
  }
  loopcount = 0;
}

// 問題の方程式
float f(float x) {
  float y;
  y = pow(x,3) - 3.0 * pow(x, 2) + 9.0 * x - 8.0;
  return y;
}

