////////////////////////////////////////////////////////////////////////////////////////////////
//
//  mod_csp -- Apache mod_csp module
//
// It is a module that executes the script written by C language. 
// Please see http://csp.b-rabbit.com/ in detail. 
//
// author  : kumatiki
//
// Copyright (C) 2011 mod_csp project
// License : Apache Licence 2.0
//
// version : 0.01
//
// Last modification by kumatiki
//
////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//   mod_csp.c
//
//
////////////////////////////////////////////////////////////////////////////////////////////////

#include <httpd.h>
#include <http_config.h>
#include <http_protocol.h>
#include <ap_config.h>
#include <apr_hash.h>
#include <apr_strings.h>
#include <unistd.h>
#include <apr_time.h>
#include <apr_signal.h>
#include<setjmp.h>


module AP_MODULE_DECLARE_DATA csp_module;

////////////////////////////////////////////////////////////////////////////////////////////////
//			macros
////////////////////////////////////////////////////////////////////////////////////////////////
#define cat(...) apr_pstrcat(p,__VA_ARGS__,NULL)


////////////////////////////////////////////////////////////////////////////////////////////////
//			define
////////////////////////////////////////////////////////////////////////////////////////////////

#define PARAM_DELIM 		","
#define DEFAULT_TABLE_SIZE 	3

#define BUFFLEN 			0x1000
#define POSTMAX 			0x1000000

#define SESSION_MAX_NUM		64

#define	CSPOK				0
#define	CSPNG				1
#define CSPERROR			1
#define	CSPTRUE				1
#define	CSPFALSE			0



////////////////////////////////////////////////////////////////////////////////////////////////
//		include
////////////////////////////////////////////////////////////////////////////////////////////////


# 1 "growmem.c" 1
# 9 "growmem.c"
typedef struct _growMem {
 apr_pool_t *p;
 char * mem;
 int size;
 int index;
} GROWMEM;


static GROWMEM * getGrowMem(apr_pool_t *p,int size){
 if(size < 1024)size = 1024;
 GROWMEM * gm = apr_pcalloc(p,sizeof(GROWMEM));
 gm->p = p;
 gm->mem = apr_palloc(p,size);
 gm->size = size;
 gm->index = 0;
 return gm;
}

static void gm_putc(GROWMEM * gm,char c){
 if(gm->size < gm->index + 1){
  char * tmp = apr_pcalloc(gm->p,gm->size * 2);
  memcpy(tmp,gm->mem,gm->size);
  gm->mem = tmp;
  gm->size = gm->size * 2;
 }
 * (gm->mem + gm->index) = c;
 gm->index++;
}

static void gm_puts(GROWMEM * gm,char * str){
 int len = strlen(str);

 if(gm->size < gm->index + len){
  int growsize = gm->size * 2;
  if(gm->size + len > gm->size * 2)
   growsize = (gm->size + len)*2;

  char * tmp = apr_pcalloc(gm->p,growsize);
  memcpy(tmp,gm->mem,gm->size);
  gm->mem = tmp;
  gm->size = growsize;
 }
 strcpy((gm->mem + gm->index),str);
 gm->index +=len;
}

static char * gm_getmem(GROWMEM * gm){
 return gm->mem;
}

static int gm_getsize(GROWMEM * gm){
 return gm->index;
}
# 8 "include.c" 2

# 1 "file.c" 1






static char * fileRead(apr_pool_t * p,char * filename,int * s)
{
 apr_file_t *fpr;
     apr_status_t rv = apr_file_open(&fpr, filename, APR_READ, APR_OS_DEFAULT , p);
 if(rv!=APR_SUCCESS)return NULL;

 apr_finfo_t finfo;
    apr_file_info_get(&finfo, APR_FINFO_MIN, fpr);
    unsigned int size = finfo.size;
    char * buffer = (char * )apr_palloc(p,size);
 apr_file_read(fpr,buffer,&size);
 apr_file_close(fpr);

 * s = size;
 return buffer;
}
# 9 "include.c" 2

# 1 "param.c" 1
# 10 "param.c"
struct csp_config {
 char * message;
} csp_config;

static void * create_per_dir_config (apr_pool_t *pool, char *arg)
{
 void * buf = apr_pcalloc(pool, sizeof(csp_config));
 struct csp_config *cfg = (struct csp_config*)buf;
 cfg->message = "/tmp/csp";
 return buf;
}




static const char *cmd_csp_message (cmd_parms *parms, void *mconfig, char *arg){
  struct csp_config *cfg = (struct csp_config*)mconfig;
  cfg->message = apr_pstrdup(parms->pool,arg);
  return 0;
}




typedef const char *(*CMD_HAND_TYPE) (cmd_parms*,void*);

static const command_rec csp_cmds[] = {
  {
 "csp_tmp",
 (CMD_HAND_TYPE)cmd_csp_message,
 0,
 OR_ALL,
 TAKE1,
 "Error Message"
 },
 {0},
};
# 10 "include.c" 2

# 1 "cookie.c" 1
# 10 "cookie.c"
static void setCookie(request_rec *r,char * args1,char * args2){

 char * c1 = apr_pstrdup(r->pool, "Set-Cookie");
 char * c2 = apr_pstrdup(r->pool, apr_pstrcat(r->pool,args1,"=",args2,NULL));
 apr_table_addn(r->headers_out, c1,c2);

}




static apr_table_t * getCOOKIE(request_rec* r) {

 const char * cookie = apr_table_get(r->headers_in, "Cookie");
    if (NULL == cookie)
        return NULL;

    apr_table_t* cookei_params = apr_table_make(r->pool, DEFAULT_TABLE_SIZE);

    char* cookie_arg = apr_pstrdup(r->pool, cookie);

 char* state;
    char* hash_unit = apr_strtok(cookie_arg, ";", &state);

   do {
        char *key, *h_state;
        int hash_size = strlen(hash_unit);
        if (NULL != (key = apr_strtok(hash_unit, "= ", &h_state)) && strlen(key) + 1 < hash_size) {
            char* val = key;
            val += strlen(key) + 1;
   apr_table_set(cookei_params, key, val);

         }
    } while (NULL != (hash_unit = apr_strtok(NULL, ";", &state)));

    return cookei_params;
}
# 11 "include.c" 2

# 1 "getpost.c" 1
# 10 "getpost.c"
static apr_table_t * getGET(request_rec* r) {

    if (NULL == r->args)
        return NULL;

 apr_table_t* get_params = apr_table_make(r->pool, DEFAULT_TABLE_SIZE);

    char* url_arg = apr_pstrdup(r->pool, r->args);
    char* state;
    char* hash_unit = apr_strtok(url_arg, "&", &state);


    do {
        char *key, *h_state;
        int hash_size = strlen(hash_unit);
        if (NULL != (key = apr_strtok(hash_unit, "=", &h_state))
            && strlen(key) + 1 < hash_size) {
            char* val = key;
            val += strlen(key) + 1;

            ap_unescape_url(key);
            ap_unescape_url(val);
   apr_table_set(get_params, key, val);
         }
    } while (NULL != (hash_unit = apr_strtok(NULL, "&", &state)));

    return get_params;
}




static apr_table_t * getPOST(request_rec* r) {
    char* result = "";
    int total_bytes = 0;

    if (ap_setup_client_block(r, REQUEST_CHUNKED_DECHUNK)!=OK) {
        return NULL;
    }

    if (ap_should_client_block(r)) {
        while (total_bytes<POSTMAX) {
            char buffer[BUFFLEN];
            int read_bytes = ap_get_client_block(r, buffer, BUFFLEN-1);
            if (read_bytes<=0) {
                break;
            }
            buffer[read_bytes] = '\0';
            result = apr_pstrcat(r->pool, result, buffer, NULL);
            total_bytes += read_bytes;
        }


  apr_table_t* get_params = apr_table_make(r->pool, DEFAULT_TABLE_SIZE);
  char* state;
  char* hash_unit = apr_strtok(result, "&", &state);

     do {
         char *key, *h_state;
         int hash_size = strlen(hash_unit);
         if (NULL != (key = apr_strtok(hash_unit, "=", &h_state))
             && strlen(key) + 1 < hash_size) {
             char* val = key;
             val += strlen(key) + 1;

             ap_unescape_url(key);
             ap_unescape_url(val);
             apr_table_set(get_params, key, val);
         }
     } while (NULL != (hash_unit = apr_strtok(NULL, "&", &state)));

  return get_params;
    }
    return NULL;
}
# 12 "include.c" 2

# 1 "trans.c" 1
# 10 "trans.c"
static int includetenkai(apr_pool_t * p,GROWMEM * buf,char * filename,char * dstdir,request_rec *r)
{

 char * dstfile = cat(dstdir,"/",filename,NULL);


 int size;
 char * buffer = fileRead(p,dstfile,&size);
 if(buffer==NULL){
  ap_rprintf(r,"<br>File %s is Read Error<br>",dstfile);
  return CSPERROR;
 }

 int i = 0;
 while(i<size){

  if(strncmp((buffer+i),"<%include",9)==0 && strncmp((buffer+i),"<%includepath",13)!=0 ){
   char * tmp = buffer+i;
   char * tmp1 = strchr(tmp,'\"');
   if(tmp1==NULL)return CSPERROR;
   char * tmp2 = strchr(tmp1+1,'\"');
   if(tmp2==NULL)return CSPERROR;
   char * tmp3 = strstr(tmp2+1,"%>");

   if(tmp3==NULL || tmp1-tmp1 > 1024 )
    return CSPERROR;

   int len = tmp2-tmp1-1;
   char * nfile = apr_pcalloc(p,1024);
   strncpy(nfile,tmp1+1,len);
   int ret = includetenkai(p,buf,nfile,dstdir,r);

   if(ret==CSPERROR)
    return CSPERROR;

   i+=tmp3-tmp+2;
  }
  gm_putc(buf,* (buffer+i));
  i++;
 }
 return CSPOK;
}






static int csptoc(apr_pool_t *p, GROWMEM * ten,char * dstcfile,char * dstdir,GROWMEM * pinclude ,GROWMEM * plib,request_rec *r){

 int mode1flag = 0;

 int size= gm_getsize(ten);
 char * buffer = gm_getmem(ten);
    GROWMEM * t1 = getGrowMem(p,size*2);
    GROWMEM * t2 = getGrowMem(p,size*2);

 int mode = 0;
 int i = 0;

 while(i<size){

  if(mode==0){
   gm_puts(t1,"ap_rputs(\"");
   while(i<size){
    if(strncmp((buffer+i),"<%iparam",8)==0){
     mode = 4;
     i+=8;
     break;
    } else
    if(strncmp((buffer+i),"<%lparam",8)==0){
     mode = 5;
     i+=8;
     break;
    } else
    if(strncmp((buffer+i),"<%csp",5)==0){
     mode1flag = 1;
     mode = 1;
     i+=5;
     break;
    } else
    if(strncmp((buffer+i),"<%=",3)==0){
     mode = 2;
     i+=3;
     break;
    }else
    if(strncmp((buffer+i),"<%",2)==0){
     i+=2;
     mode = 3;
     break;
    }

    if(* (buffer+i)=='\r' && * (buffer+i+1)=='\n'){
     gm_puts(t1,"\\n\"\n\"");
     i++;
    } else
    if(* (buffer+i)=='\n' || * (buffer+i)=='\r'){
     gm_puts(t1,"\\n\"\n\"");
    }else
     if(*(buffer+i)=='"'){
      gm_puts(t1,"\\\"");
     } else
      gm_putc(t1,* (buffer+i));
    i++;
   }
   gm_puts(t1,"\",__r__);\n");
  }



  if(mode==1){
   while(i<size){
    if(strncmp((buffer+i),"%>",2)==0){
     mode = 0;
     i +=2;
     break;
    }
    gm_putc(t2,* (buffer+i));
    i++;
   }
  }

  if(mode==2){
   gm_puts(t1,"ap_rprintf(__r__,");
   while(i<size){
    if(strncmp((buffer+i),"%>",2)==0){
     mode = 0;
     i +=2;
     break;
    }
    gm_putc(t1,* (buffer+i));
    i++;
   }

   gm_puts(t1,");\n");
  }

  if(mode==3){
   while(i<size){
    if(strncmp((buffer+i),"%>",2)==0){
     mode = 0;
     i +=2;
     break;
    }
    gm_putc(t1,* (buffer+i));
    i++;
   }
  }

  if(mode==4){
   while(i<size){
    if(strncmp((buffer+i),"%>",2)==0){
     mode = 0;
     i +=2;
     break;
    }
    gm_putc(pinclude,* (buffer+i));
    i++;
   }
  }

  if(mode==5){
   while(i<size){
    if(strncmp((buffer+i),"%>",2)==0){
     mode = 0;
     i +=2;
     break;
    }
    gm_putc(plib,* (buffer+i));
    i++;
   }
  }
 }

 apr_file_t *fpw;
 apr_file_open(&fpw, dstcfile, APR_WRITE|APR_CREATE|APR_TRUNCATE|APR_FOPEN_BINARY, APR_OS_DEFAULT , p);

 apr_file_puts(

# 1 "head.h" 1
"////////////////////////////////////////////////////////////////////////////////////////////////\n"
"//\n"
"//  mod_csp -- Apache mod_csp module\n"
"//\n"
"////////////////////////////////////////////////////////////////////////////////////////////////\n"
"\n"
"// for printf\n"
"#include <stdio.h>\n"
"\n"
"#include <httpd.h>\n"
"#include <http_config.h>\n"
"#include <http_protocol.h>\n"
"#include <ap_config.h>\n"
"#include <apr_hash.h>\n"
"#include <apr_strings.h>\n"
"#include <signal.h>\n"
"#include <setjmp.h>\n"
"#include <ap_regex.h>\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//define \n"
"///////////////////////////////////////////////////////////////////////\n"
"\n"
"#define GET		__get__\n"
"#define POST	__post__\n"
"#define COOKIE	__cookie__\n"
"#define REQUEST __r__\n"
"#define POOL __p__\n"
"\n"
"#define HEADER_IN	__r__->headers_in\n"
"#define HEADER_OUT	__r__->headers_out\n"
"\n"
"#define tbl_set(a,b,c)		apr_table_set(a,b,c)\n"
"#define tbl_add(a,b,c)		apr_table_add(a,b,c)\n"
"#define tbl_clr(a)			apr_table_clear(a);\n"
"#define tbl_unset(a,b)		apr_table_unset(a,b)\n"
"\n"
"#undef printf\n"
"#define printf(arg,...) (arg==NULL)?NONE:ap_rprintf(__r__,arg, ##__VA_ARGS__)\n"
"#define psprintf(arg,...) (arg==NULL)?NONE:apr_psprintf(__r__,arg, ##__VA_ARGS__)\n"
"#define stnjoin(...) apr_pstrcat(__p__,__VA_ARGS__,NULL)\n"
"#define stncat(...) apr_pstrcat(__p__,__VA_ARGS__,NULL)\n"
"#define stndup(a) apr_pstrdup (__p__,a)\n"
"\n"
"\n"
"#define unescape_url(a)		ap_unescape_url(a)\n"
"#define escape_uri(a)		ap_escape_uri(__p__,a)\n"
"#define escape_html(a)		ap_escape_html(__p__,a)\n"
"\n"
"\n"
"#define	REGEXOK				0\n"
"#define	REGEXNG				1\n"
"#define	REGEXERROR			-1\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//	typedef\n"
"///////////////////////////////////////////////////////////////////////\n"
"typedef apr_table_t * table;\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//const\n"
"///////////////////////////////////////////////////////////////////////\n"
"const char * NONE = \"\";\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//		struct\n"
"///////////////////////////////////////////////////////////////////////\n"
"//session\n"
"struct _sessionTable {\n"
"	int datasize;\n"
"	void * data;\n"
"	int keysize;\n"
"	void * key;\n"
"};\n"
"\n"
"//parameter\n"
"struct _param {\n"
"	request_rec * r;			//	request_rec\n"
"	apr_table_t * g;			//	get\n"
"	apr_table_t * p;			//	post\n"
"	apr_table_t * c;			//	cookie\n"
"	int * session_index;\n"
"	struct _sessionTable * session;\n"
"	int (* func)();				//	test\n"
"};\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//\n"
"///////////////////////////////////////////////////////////////////////\n"
"static request_rec * __r__;\n"
"static apr_pool_t * __p__;\n"
"static apr_table_t * __get__;\n"
"static apr_table_t * __post__;\n"
"static apr_table_t * __cookie__;\n"
"static 	int * __session_index__;\n"
"static struct _sessionTable * __session__;\n"
"\n"
"//setjump as core dump \n"
"jmp_buf jbuf;\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//		hash\n"
"///////////////////////////////////////////////////////////////////////\n"
"//#define hash	apr_hash_t * \n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//		\n"
"///////////////////////////////////////////////////////////////////////\n"
"void set_content_type(char * str){\n"
"  __r__->content_type = stndup(str);\n"
"}\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//	regex\n"
"///////////////////////////////////////////////////////////////////////\n"
"int regex_match(char * str,char * pattern){\n"
"	int ret=0;\n"
"	ap_regex_t preg;\n"
"	ap_regmatch_t regm[AP_MAX_REG_MATCH];\n"
"	if (0 == ap_regcomp(&preg, pattern, 0)) {\n"
"		if (0 == ap_regexec(&preg, str, AP_MAX_REG_MATCH, regm, 0)) {\n"
"			ret = REGEXOK;\n"
"		} else {\n"
"			ret = REGEXNG;\n"
"		}\n"
"	} else {\n"
"		ret = REGEXERROR;\n"
"	}\n"
"	ap_regfree(&preg);\n"
"	return ret;\n"
"}\n"
"\n"
"char * regex_replace(char *src, char *pattern, char *replaceStr)\n"
"{\n"
"	ap_regmatch_t match[AP_MAX_REG_MATCH];\n"
"	const char *result=\"\";\n"
"	int rc = 0;\n"
"\n"
"	ap_regex_t _regexp;\n"
"	ap_regex_t * regexp = &_regexp;\n"
"\n"
"	int ans = ap_regcomp(&_regexp, pattern, 0);\n"
"\n"
"	if(ans!=0)\n"
"		return NONE;\n"
"\n"
"\n"
"	int soffset = 0, eoffset = 0;\n"
"	char *str = NULL;\n"
"	const char *tail = NULL;\n"
"		\n"
"	while( ( rc = ap_regexec( regexp, src, regexp->re_nsub + 1, match, 0 ) ) == 0 ){\n"
"		soffset = match[0].rm_so;\n"
"		eoffset = match[0].rm_eo;\n"
"		if( ( str = ap_pregsub( __p__, \"$1\", src, regexp->re_nsub + 1, match ) ) == NULL )\n"
"			break;\n"
"\n"
"		result = apr_pstrcat( __p__, result,apr_pstrndup( __p__, src,soffset), replaceStr, NULL );\n"
"		src +=eoffset;\n"
"	}\n"
"	result = apr_pstrcat( __p__, result,src, NULL);\n"
"\n"
"	ap_regfree(regexp);\n"
"	return result;\n"
"}\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//		table\n"
"///////////////////////////////////////////////////////////////////////\n"
"apr_table_t * tbl_make(int size){\n"
"	return apr_table_make(__p__, size);\n"
"}\n"
"\n"
"int tbl_size(apr_table_t * __table__){\n"
"	if( __table__==NULL)\n"
"		return 0;\n"
"	const apr_array_header_t * arr = apr_table_elts(__table__);\n"
"	return arr->nelts;\n"
"}\n"
"\n"
"char * tbl_key_i(apr_table_t * __table__,int i){\n"
"	if(__table__==NULL)\n"
"		return NONE;\n"
"	const apr_array_header_t *arr = apr_table_elts(__table__);\n"
"	int size = arr->nelts;\n"
"\n"
"	if(i >= size)\n"
"		return NONE;\n"
"	apr_table_entry_t *entry =	(apr_table_entry_t *)(arr->elts + (arr->elt_size * i));\n"
"	return entry->key;\n"
"}\n"
"\n"
"char * tbl_val_i(apr_table_t * __table__,int i){\n"
"	if(__table__==NULL)\n"
"		return NONE;\n"
"	const apr_array_header_t *arr = apr_table_elts(__table__);\n"
"	int size = arr->nelts;\n"
"	if(i >= size)\n"
"		return NONE;\n"
"	apr_table_entry_t *entry =	(apr_table_entry_t *)(arr->elts + (arr->elt_size * i));\n"
"	return entry->val;\n"
"}\n"
"\n"
"char *  tbl_val(apr_table_t * __table__,char * args){\n"
"	if(__table__==NULL)	return NONE;\n"
"	if(args==NULL)	return NONE;\n"
"\n"
"	char * tmp = apr_table_get(__table__,args);\n"
"	if(tmp==NULL)return NONE;\n"
"	return tmp;\n"
"}\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//		string\n"
"///////////////////////////////////////////////////////////////////////\n"
"char * stnreplace(char *buf, char *pre, char *aft)\n"
"{\n"
"	char * p;\n"
"	p = strstr(buf, pre);\n"
"	if (p){\n"
"		char *p_2 = p + strlen(pre);\n"
"		char * buf2 = stnreplace(p_2, pre, aft);\n"
"		int s = p-buf;\n"
"		buf = apr_pstrdup(__p__,buf);\n"
"		* (buf + s) = 0;\n"
"		return stnjoin(buf,aft,buf2);\n"
"	}\n"
"	return buf;\n"
"}\n"
"\n"
"\n"
"///////////////////////////////////////////////////////////////////////\n"
"//		Exclusive use\n"
"///////////////////////////////////////////////////////////////////////\n"
"char *  getGet(char * args){\n"
"	if(__get__==NULL)	return NONE;\n"
"	if(args==NULL)	return NONE;\n"
"	return apr_table_get(__get__,args);\n"
"}\n"
"\n"
"char *  getPost(char * args){\n"
"	if(__post__==NULL)	return NONE;\n"
"	if(args==NULL)	return NONE;\n"
"	return apr_table_get(__post__,args);\n"
"}\n"
"\n"
"char *  getCookie(char * args){\n"
"	if(__cookie__==NULL)	return NONE;\n"
"	if(args==NULL)	return NONE;\n"
"	return apr_table_get(__cookie__,args);\n"
"}\n"
"\n"
"void setCookie(char * args1,char * args2){\n"
"	char * c1 = apr_pstrdup(__p__, \"Set-Cookie\");\n"
"	char * c2 = apr_pstrdup(__p__, stnjoin(args1,\"=\",args2));\n"
"	apr_table_addn(__r__->headers_out, c1,c2);\n"
"}\n"
"\n"
"void setSession(char * key,char * data){\n"
"	int i;\n"
"	int flag = 0;\n"
"	for(i=0;i < * __session_index__;i++){\n"
"		if(!strcmp(__session__[i].key,key)){\n"
"			flag = 1;\n"
"			break;\n"
"		}\n"
"	}\n"
"	__session__[i].data = (void*)apr_pstrdup(__p__,data);\n"
"	__session__[i].datasize = strlen(data)+1;\n"
"\n"
"	__session__[i].key = (void*)apr_pstrdup(__p__,key);\n"
"	__session__[i].keysize = strlen(key)+1;\n"
"\n"
"	if(flag == 0)\n"
"		(* __session_index__)++;\n"
"}\n"
"\n"
"char * getSession(char * key){\n"
"	int i;\n"
"	for(i=0;i < * __session_index__;i++){\n"
"		if(!strcmp(__session__[i].key,key)){\n"
"			return __session__[i].data;\n"
"		}\n"
"	}\n"
"	return NONE;\n"
"}\n"
"\n"
"void setSession_ptr(char * key,void * data,int size){\n"
"	int i;\n"
"	int flag = 0;\n"
"	for(i=0;i < * __session_index__;i++){\n"
"		if(!strcmp(__session__[i].key,key)){\n"
"			flag = 1;\n"
"			break;\n"
"		}\n"
"	}\n"
"	__session__[i].data = (void*)apr_pstrdup(__p__,data);\n"
"	__session__[i].datasize = size;\n"
"\n"
"	__session__[i].key = (void*)apr_pstrdup(__p__,key);\n"
"	__session__[i].keysize = strlen(key)+1;\n"
"\n"
"	if(flag == 0)\n"
"		(* __session_index__)++;\n"
"}\n"
"\n"
"void * getSession_ptr(char * key){\n"
"	int i;\n"
"	for(i=0;i < * __session_index__;i++){\n"
"		if(!strcmp(__session__[i].key,key)){\n"
"			return __session__[i].data;\n"
"		}\n"
"	}\n"
"	return NULL;\n"
"}\n"
"\n"
"\n"
"//signal handler \n"
"void sigint_handler(int s){\n"
"\n"
"	int i, nr;\n"
"	void *trace[128];\n"
"	char **ents;\n"
"\n"
"\n"
"	switch(s){\n"
"		case SIGBUS:\n"
"	 		ap_rprintf(__r__, \"<br><font color=red size=6>Bus Error</font>\\n\");\n"
"			break;\n"
"		case SIGSEGV:\n"
"	 		ap_rprintf(__r__, \"<br><font color=red size=6>Segmentation Violation</font>\\n\");\n"
"			break;\n"
"		case SIGALRM:\n"
"	 		ap_rprintf(__r__, \"<br><font color=red size=6>CSP Time Out</font>\\n\");\n"
"			break;\n"
"		default:\n"
"	 		ap_rprintf(__r__, \"<br><font color=red size=6>signal %d </font>\\n\",s);\n"
"			break;\n"
"	}\n"
"\n"
"	nr = backtrace(trace, 128);\n"
"	if (nr>=128){\n"
"	    printf(\"Stack too deep, some entries are stripped off\\n\");  \n"
"	} else {\n"
"		ents = backtrace_symbols(trace, nr);\n"
"\n"
"		if (ents == NULL) {\n"
"			printf(\"backtrace_symbols !!!\");\n"
"		} else {\n"
"			printf(\"<hr>\");\n"
"			for(i=0; i<nr; i++){\n"
"				printf(\"#%d : %s<br>\\n\", i, ents[i]);\n"
"			}\n"
"		}\n"
"	}\n"
"\n"
"\n"
"	longjmp( jbuf, 1 );\n"
"}\n"
"\n"
"//this function is called from apache\n"
"int callmain( struct _param * param ){\n"
"\n"
"	if(param->r==NULL){\n"
"		return 1;\n"
"	}\n"
"	__get__ = param->g;\n"
"	__post__ = param->p;\n"
"	__r__ = param->r;\n"
"	__p__ = param->r->pool;\n"
"	__cookie__ = param->c;\n"
"	__session_index__ = param->session_index;\n"
"	__session__ = param->session;\n"
"\n"
"\n"
"	signal( SIGSEGV, &sigint_handler );\n"
"	signal( SIGTSTP , &sigint_handler );\n"
"	signal( SIGILL , &sigint_handler );\n"
"	signal( SIGHUP , &sigint_handler );\n"
"	signal( SIGFPE  , &sigint_handler );\n"
"	signal( SIGALRM  , &sigint_handler );\n"
"	alarm(5);\n"
"\n"
"	if( setjmp( jbuf ) == 1 ) {\n"
"		return 1;\n"
"	}\n"
"\n"
"	main();\n"
"\n"
"	return 0;\n"
"}\n"
"\n"
# 189 "trans.c" 2
 ,fpw);

 char * t11 = gm_getmem(t1);
 char * t22 = gm_getmem(t2);


 if(mode1flag == 0){

  apr_file_puts("int main(){\n",fpw);
  apr_file_puts( t11 , fpw);
  apr_file_puts("	}\n",fpw);
  apr_file_puts("\n/////////////11\n", fpw);
 } else {
  while(*t22!=0){
   if(strncmp(t22,"HTML();",7)==0){
    t22+=7;
    apr_file_puts("\n/////////////\n", fpw);
    apr_file_puts( t11 , fpw);
    apr_file_puts("\n/////////////\n", fpw);
   }
   apr_file_putc( *t22 , fpw);
   t22++;
  }
 }

 apr_file_close(fpw);
 return 0;
}
# 13 "include.c" 2

# 1 "session.c" 1
# 10 "session.c"
struct _sessionTable {
 int datasize;
 void * data;
 int keysize;
 void * key;
};

struct _param {
 request_rec * r;
 apr_table_t * g;
 apr_table_t * p;
 apr_table_t * c;
 int * session_index;
 struct _sessionTable * session;
 int (* func)();
};


static char * makeSessionID(request_rec *r){
 char * sessionID = apr_psprintf(r->pool,"ID_%lld",apr_time_now());
}





static void sessionGet(int * session_index,struct _sessionTable * session,char * sessionid,apr_pool_t * p,request_rec *r){

    char * sesdir;
 int i;

 sesdir = cat("/tmp/csp/session/",sessionid);
 apr_dir_make_recursive(sesdir,APR_OS_DEFAULT,p);

 apr_file_t *fpr;

 apr_file_open(&fpr, sesdir, APR_READ, APR_OS_DEFAULT , p);
 if(fpr == NULL){
  return;
 }

 unsigned int len = sizeof(int);

 apr_file_read(fpr,(void * )session_index,&len);

 for(i=0;i < * session_index;i++){
  len = sizeof(int);
  apr_file_read(fpr, (void *)&session[i].keysize, &len);
  len = session[i].keysize;
  session[i].key = apr_palloc(p,len);
  apr_file_read(fpr, (void *)session[i].key, &len);
  len = sizeof(int);
  apr_file_read(fpr, (void *)&session[i].datasize, &len);
  len = session[i].datasize;
  session[i].data = apr_palloc(p,len);
  apr_file_read(fpr, (void *)session[i].data, &len);
 }

 apr_file_close(fpr);
}





static void sessionSet(int * session_index,struct _sessionTable * session,char * sessionid,apr_pool_t * p,request_rec *r){
    char * sesdir;
 int i;

 if(sessionid==NULL){
  sessionid = apr_psprintf(r->pool,"ID_%lld",apr_time_now());
  setCookie(r,"SESSIONID",sessionid);
 }
 sesdir = cat("/tmp/csp/session/",sessionid);

 unsigned int len = sizeof(int);

 apr_file_t *fpw;
 apr_file_open(&fpw, sesdir, APR_WRITE|APR_CREATE|APR_TRUNCATE|APR_FOPEN_BINARY, APR_OS_DEFAULT , p);
 if(fpw == NULL){
  return;
 }

 apr_file_write(fpw, (const void *)session_index, &len);
 for(i=0;i<* session_index;i++){
  len = sizeof(int);
  apr_file_write(fpw, (const void *)&session[i].keysize, &len);
  len = session[i].keysize;
  apr_file_write(fpw, (const void *)session[i].key, &len);

  len = sizeof(int);
  apr_file_write(fpw, (const void *)&session[i].datasize, &len);
  len = session[i].datasize;
  apr_file_write(fpw, (const void *)session[i].data, &len);
 }
 apr_file_close(fpw);
}
# 14 "include.c" 2


////////////////////////////////////////////////////////////////////////////////////////////////
//		debug
////////////////////////////////////////////////////////////////////////////////////////////////
static void print_table(request_rec *r,apr_table_t *table) {
	if (apr_is_empty_table(table)) {
		ap_rprintf(r,"There is no element. <br>\n");
	}
	else {
		const apr_array_header_t *arr = apr_table_elts(table);
		int i;
		for (i = 0; i < arr->nelts; i++) {
			apr_table_entry_t *entry = 	(apr_table_entry_t *)(arr->elts + (arr->elt_size * i));
			ap_rprintf(r,"%d element : key=[%s],value=[%s]<br>\n", i, entry->key, entry->val);
		}
	}
}


//static void my_signal_handler (int x) {

void errordispay(request_rec *r,char * title,char *contents){
	ap_rprintf(r,"<h2>%s</h2>\n",title);
	ap_rprintf(r,"<hr>\n<pre>\n");
	ap_rprintf(r,"%s",contents);
	ap_rprintf(r,"</pre>\n");
}


////////////////////////////////////////////////////////////////////////////////////////////////
//
//		handler
//
////////////////////////////////////////////////////////////////////////////////////////////////
static int csp_handler(request_rec *r)
{
	apr_pool_t *p = r->pool;
	char * tmp;
	int i;

    if (strcmp(r->handler, "csp")) {
        return DECLINED;
    }
    r->content_type = "text/html";

    if (r->header_only)
	    return OK;

//	ap_rprintf(r,"filename = %s<br>\n",r->filename);
//    return OK;

// 		Error buffer
//    GROWMEM * errbuffer = getGrowMem(p,1024);

	// make folder name by accessed file 
	char * folder = apr_pstrdup(p,(const char * )r->filename);
	tmp = strrchr(folder,'/');
	if(tmp != NULL) *tmp = '\0';

  	// strip filename 
	char * filename = NULL;
	tmp = apr_pstrdup(p,(const char * )r->filename);
	tmp = strrchr(tmp,'/');
	if(tmp!=(char * )NULL) filename = tmp + 1;


	//get GETS
    apr_table_t * get = getGET(r);
	//get POSTS
    apr_table_t * post = getPOST(r);
    //get COOKIES
    apr_table_t * cookie = getCOOKIE(r);

    //get session
    char * sessionid = NULL;
    int session_index = 0;
	struct _sessionTable * session = apr_palloc(p,sizeof(struct _sessionTable)*SESSION_MAX_NUM);
	if(cookie!=NULL){
		sessionid = apr_table_get(cookie,"SESSIONID");
		if(sessionid!=NULL){
			sessionGet(&session_index,session,sessionid,p,r);
		}
	}

	char * tmpdir = "/tmp/csp";
	//to copies etc
	char * dstdir = cat(tmpdir,"/lib",folder,"/");
	char * dstfile = cat(tmpdir,"/lib",folder,"/",filename);
	char * dstcfile = cat(tmpdir,"/lib",folder,"/",filename,".c");
	char * dstofile = cat(tmpdir,"/lib",folder,"/",filename,".o");
	char * dstsofile = cat(tmpdir,"/lib",folder,"/lib",filename,".so");

	//get maked time
    apr_time_t  mtime1 = 0l;     //
    apr_time_t  mtime2 = 0l;     //csp file

	apr_file_t * fpr = NULL;
	apr_finfo_t finfo1;
	apr_finfo_t finfo2;

	//I want to know the time stamp without opening 
    apr_file_open(&fpr, dstsofile, APR_READ, APR_OS_DEFAULT , p);
	if(fpr!=NULL){
	    apr_file_info_get(&finfo1, APR_FINFO_CTIME, fpr);
		mtime1 = finfo1.ctime;
		apr_file_close(fpr);
	}

    apr_file_open(&fpr, r->filename, APR_READ, APR_OS_DEFAULT , p);
	if(fpr==NULL){
		return   HTTP_NOT_FOUND;
	}
    apr_file_info_get(&finfo2, APR_FINFO_CTIME, fpr);
	mtime2 = finfo2.ctime;
	apr_file_close(fpr);


	//It copies it when there is an update. 
	if(mtime2>mtime1){

		//make folder 
		apr_dir_make_recursive(dstdir,APR_OS_DEFAULT,p);

	   //trans (include develops)
	    GROWMEM * incl = getGrowMem(p,1024);
		int ret = includetenkai(p,incl,filename,folder,r);
		if(ret==CSPERROR){
			ap_rprintf(r,"<h2>include error</h2>");
			return OK;
		}


	   //trans
	    GROWMEM * binclude = getGrowMem(p,1024);
    	GROWMEM * blib = getGrowMem(p,1024);
		csptoc(p,incl,dstcfile,dstdir,binclude,blib,r);

		//compiles
		chdir(folder);
		int ccc = system(cat("apxs -Wc,-std=c99 ","-I ",folder," ",gm_getmem(binclude)," -c ",dstcfile," 2>",dstfile,".log"));
		if(ccc!=0){
  			char * errorlog = (char * )apr_pcalloc(p,1024*10);
  			int len = 1024*10;
		    apr_file_open(&fpr, cat(dstfile,".log"), APR_READ, APR_OS_DEFAULT , p);
			apr_file_read(fpr,errorlog,&len);
			apr_file_close(fpr);
			errordispay(r,"compile error",errorlog);
			return   OK;
		}
		system(cat("gcc -shared -Wl,-soname,lib",filename,".so -o ",dstdir,"lib",filename,".so  ",dstofile," ",gm_getmem(blib)," 2>",dstfile,"1.log"));
		if(ccc!=0){
  			char * errorlog = (char * )apr_pcalloc(p,1024*10);
  			int len = 1024*10;
		    apr_file_open(&fpr, cat(dstfile,"1.log"), APR_READ, APR_OS_DEFAULT , p);
			apr_file_read(fpr,errorlog,&len);
			apr_file_close(fpr);
			errordispay(r,"link error",errorlog);
			return   OK;
		}
	} else 
		chdir(folder);

	//go go go
	apr_dso_handle_t * dso_h = NULL;
	apr_status_t rv;
	int st = 0;
	char * fname = cat(dstdir,"lib",filename,".so");

	//set parameter 
	struct _param param  = {
		r,get,post,cookie,&session_index,session,NULL
	};

	int (*fn)(struct _param *);

    if ((rv = apr_dso_load(&dso_h, fname, p)) == APR_SUCCESS) {

	   if ((rv = apr_dso_sym( (apr_dso_handle_sym_t * ) &fn,dso_h,"callmain")) == APR_SUCCESS) {
			st = (* fn)(&param);
	   }
	   apr_dso_unload(dso_h);
	} else {
		char errstr[1024];
		apr_dso_error(dso_h, errstr, 1024);
		errordispay(r,"dso error",errstr);
		return OK;
//		return   HTTP_INTERNAL_SERVER_ERROR;
	}

//	save session
	if(session_index!=0){
		sessionSet(&session_index,session,sessionid,p,r);
	}

	//Location Header in jump to url
	if(apr_table_get(r->headers_out,"Location")!=NULL)
		return 302;
	return OK;
}

////////////////////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////////////////////
static void csp_register_hooks(apr_pool_t *p)
{
    ap_hook_handler(csp_handler, NULL, NULL, APR_HOOK_MIDDLE);
}


////////////////////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////////////////////
module AP_MODULE_DECLARE_DATA csp_module = {
    STANDARD20_MODULE_STUFF,
    create_per_dir_config, /* create per-dir    config structures */
    NULL,                  /* merge  per-dir    config structures */
    NULL,                  /* create per-server config structures */
    NULL,                  /* merge  per-server config structures */
    csp_cmds,              /* table of config file commands       */
    csp_register_hooks  /* register hooks                      */
};

