#!/bin/sh
usage()
{
	echo -e "Usage: cstlgen.sh {vector | deque | list | string} name type [algo] [include] [debug] [path]"
	echo -e "   or: cstlgen.sh {set | multiset} name type comp [include] [debug1] [path]"
	echo -e "   or: cstlgen.sh {map | multimap} name keytype valuetype comp [include] [debug1] [debug2] [path]"
}

container=$1
case $container in
"vector")
	lower="vector"
	upper="VECTOR"
	name=$2
	type=$3
	algo=$4
	include_file=$5
	debug=$6
	path=$7
	heap=$8
	;;
"deque")
	lower="deque"
	upper="DEQUE"
	name=$2
	type=$3
	algo=$4
	include_file=$5
	debug=$6
	path=$7
	heap=$8
	;;
"ring")
	lower="ring"
	upper="RING"
	name=$2
	type=$3
	algo=$4
	include_file=$5
	debug=$6
	path=$7
	heap=$8
	;;
"list")
	lower="list"
	upper="LIST"
	name=$2
	type=$3
	algo=$4
	include_file=$5
	debug=$6
	path=$7
	heap=$8
	;;
"string")
	lower="string"
	upper="STRING"
	name=$2
	type=$3
	algo=$4
	include_file=$5
	debug=$6
	path=$7
	heap=$8
	;;
"set")
	lower="set"
	upper="SET"
	name=$2
	type=$3
	comp=$4
	include_file=$5
	debug1=$6
	path=$7
	heap=$8
	;;
"multiset")
	lower="set"
	upper="MULTISET"
	name=$2
	type=$3
	comp=$4
	include_file=$5
	debug1=$6
	path=$7
	heap=$8
	;;
"map")
	lower="map"
	upper="MAP"
	name=$2
	type=$3
	value=$4
	comp=$5
	include_file=$6
	debug1=$7
	debug2=$8
	path=$9
	shift
	heap=$9
	;;
"multimap")
	lower="map"
	upper="MULTIMAP"
	name=$2
	type=$3
	value=$4
	comp=$5
	include_file=$6
	debug1=$7
	debug2=$8
	path=$9
	shift
	heap=$9
	;;
*)
	usage
	exit
	;;
esac
if [ "$type" = "" ]; then
	usage
	exit
fi
if [ "$path" = "" ]; then
	path=$name
else
	path=`echo "$path" | sed -e "s:[^/]$:&/:"`$name
fi
if [ "$algo" = "" -o "$algo" = "no" ]; then
	algo="false"
fi
if [ "$include_file" = "false" -o "$include_file" = "no" ]; then
	include_file=""
fi
if [ "$debug" = "false" -o "$debug" = "no" ]; then
	debug=""
fi


hdr="\
#include \"../cstl/${lower}.h\"
#include \"./list_debug.h\"
#include \"./deque_debug.h\"
#include \"./rbtree_debug.h\"
#undef CSTL_VECTOR_MAGIC
#undef CSTL_RING_MAGIC
#undef CSTL_DEQUE_MAGIC
#undef CSTL_LIST_MAGIC
#undef CSTL_STRING_MAGIC
"
if [ "$algo" != "false" ]; then
	hdr=${hdr}"#include \"../cstl/algorithm.h\"
	"
fi
if [ $container = "map" -o $container = "multimap" ]; then
	hdr=${hdr}"CSTL_${upper}_INTERFACE($name, $type, $value)"
else
	hdr=${hdr}"CSTL_${upper}_INTERFACE($name, $type)"
fi
if [ "$debug1" != "" ]; then
	format=`echo "$debug1" | grep '%[#+-]*[0-9]*[dioxXucsfeEgGp]'`
	if [ "$debug1" == "$format" ]; then
		rbdebug=`echo "$lower" | tr "[:lower:]" "[:upper:]"`
		hdr=${hdr}"CSTL_${rbdebug}_DEBUG_INTERFACE($name)"
	fi
fi
if [ "$debug" != "" ]; then
	format=`echo "$debug" | grep '%[#+-]*[0-9]*[dioxXucsfeEgGp]'`
	if [ "$debug" == "$format" ]; then
		hdr=${hdr}"CSTL_${upper}_DEBUG_INTERFACE($name, $type)"
	fi
fi

src="\
#include \"../cstl/${lower}.h\"
#include \"./list_debug.h\"
#include \"./deque_debug.h\"
#include \"./rbtree_debug.h\"
#undef assert
#undef CSTL_VECTOR_MAGIC
#undef CSTL_RING_MAGIC
#undef CSTL_DEQUE_MAGIC
#undef CSTL_LIST_MAGIC
#undef CSTL_STRING_MAGIC
#undef CSTL_RBTREE_MAGIC
"
if [ "$algo" != "false" ]; then
	src=${src}"#include \"../cstl/algorithm.h\"
	"
fi
if [ $container = "set" -o $container = "multiset" ]; then
	src=${src}"CSTL_${upper}_IMPLEMENT($name, $type, $comp)"
elif [ $container = "map" -o $container = "multimap" ]; then
	src=${src}"CSTL_${upper}_IMPLEMENT($name, $type, $value, $comp)"
else
	src=${src}"CSTL_${upper}_IMPLEMENT($name, $type)"
fi
if [ "$rbdebug" != "" ]; then
	format=`echo "$debug2" | grep '%[#+-]*[0-9]*[dioxXucsfeEgGp]'`
	if [ "$debug2" != "" -a "$debug2" == "$format" ]; then
		src=${src}"CSTL_${rbdebug}_DEBUG_IMPLEMENT($name, $type, $value, $comp, $debug1, $debug2, 1)"
	else
		src=${src}"CSTL_${rbdebug}_DEBUG_IMPLEMENT($name, $type, $comp, $debug1, 1)"
	fi
fi
if [ "$debug" != "" ]; then
	format=`echo "$debug" | grep '%[#+-]*[0-9]*[dioxXucsfeEgGp]'`
	if [ "$debug" == "$format" ]; then
		src=${src}"CSTL_${upper}_DEBUG_IMPLEMENT($name, $type, $debug)"
	fi
fi

rev=`grep '$Id' "../cstl/${lower}.h"`
vectorrev=`grep '$Id' "../cstl/vector.h"`
ringrev=`grep '$Id' "../cstl/ring.h"`
algorev=`grep '$Id' "../cstl/algorithm.h"`
rbtreerev=`grep '$Id' "../cstl/rbtree.h"`
rbdebugrev=`grep '$Id' "./rbtree_debug.h"`

# ヘッダファイル生成
included=`echo "$name""_H_INCLUDED" | tr "[:lower:]" "[:upper:]"`
echo -e "/* ${name}.h" > "$path"".h"
echo -e " * " >> "$path"".h"
echo -e " * generated by cstlgen.sh" >> "$path"".h"
echo -e "${rev}" >> "$path"".h"
if [ $lower = "vector" -a "$algo" != "false" ]; then
	echo -e "${algorev}" >> "$path"".h"
elif [ $lower = "ring" -a "$algo" != "false" ]; then
	echo -e "${algorev}" >> "$path"".h"
elif [ $lower = "deque" ]; then
	echo -e "${vectorrev}" >> "$path"".h"
	echo -e "${ringrev}" >> "$path"".h"
	if [ "$algo" != "false" ]; then
		echo -e "${algorev}" >> "$path"".h"
	fi
elif [ $lower = "string" ]; then
	echo -e "${vectorrev}" >> "$path"".h"
	if [ "$algo" != "false" ]; then
		echo -e "${algorev}" >> "$path"".h"
	fi
elif [ $lower = "set" -o $lower = "multiset" -o\
	   $lower = "map" -o $lower = "multimap" ]; then
	echo -e "${rbtreerev}" >> "$path"".h"
	if [ "$rbdebug" != "" ]; then
		echo -e "${rbdebugrev}" >> "$path"".h"
	fi
fi
echo -e " */" >> "$path"".h"
echo -e "#ifndef $included\n#define $included\n" >> "$path"".h"
echo -e "#include <stddef.h>" >> "$path"".h"
if [ "$include_file" != "" ]; then
	echo -e "#include \"$include_file\"\n" >> "$path"".h"
else
	echo -e "" >> "$path"".h"
fi
if [ $lower = "string" ]; then
	echo -e "#define CSTL_NPOS	((size_t)-1)\n" >> "$path"".h"
fi
if [ $lower = "ring" ]; then
echo -e "\
#ifndef NDEBUG
#define CSTL_${upper}_MAGIC(x) x
#else
#define CSTL_${upper}_MAGIC(x)
#endif\n" >> "$path"".h"
fi
echo "$hdr" | cpp -I.. | grep "$name" | indent -kr -ut -ts4 \
| sed -e "s/$name \* /$name */g" >> "$path"".h"
echo -e "\n#endif /* $included */" >> "$path"".h"

# ソースファイル生成
echo -e "/* ${name}.c" > "$path"".c"
echo -e " * " >> "$path"".c"
echo -e " * generated by cstlgen.sh" >> "$path"".c"
echo -e "${rev}" >> "$path"".c"
if [ $lower = "vector" -a "$algo" != "false" ]; then
	echo -e "${algorev}" >> "$path"".c"
elif [ $lower = "ring" -a "$algo" != "false" ]; then
	echo -e "${algorev}" >> "$path"".c"
elif [ $lower = "deque" ]; then
	echo -e "${vectorrev}" >> "$path"".c"
	echo -e "${ringrev}" >> "$path"".c"
	if [ "$algo" != "false" ]; then
		echo -e "${algorev}" >> "$path"".c"
	fi
elif [ $lower = "string" ]; then
	echo -e "${vectorrev}" >> "$path"".c"
	if [ "$algo" != "false" ]; then
		echo -e "${algorev}" >> "$path"".c"
	fi
elif [ $lower = "set" -o $lower = "multiset" -o\
	   $lower = "map" -o $lower = "multimap" ]; then
	echo -e "${rbtreerev}" >> "$path"".c"
	if [ "$rbdebug" != "" ]; then
		echo -e "${rbdebugrev}" >> "$path"".c"
	fi
fi
echo -e " */" >> "$path"".c"
echo -e "#include <stdlib.h>" >> "$path"".c"
if [ "$comp" = "strcmp" ]; then
	echo -e "#include <string.h>" >> "$path"".c"
fi
if [ "$rbdebug" != "" -o "$debug" != "" ]; then
	echo -e "#include <stdio.h>" >> "$path"".c"
fi
echo -e "#include <assert.h>" >> "$path"".c"
echo -e "#include \"$name.h\"\n" >> "$path"".c"
if [ $lower != "ring" ]; then
if [ $lower = "deque" ]; then
echo -e "\
#ifndef NDEBUG
#define CSTL_${upper}_MAGIC(x) x
#define CSTL_VECTOR_MAGIC(x) x
#define CSTL_RING_MAGIC(x) x
#else
#define CSTL_${upper}_MAGIC(x)
#define CSTL_VECTOR_MAGIC(x)
#define CSTL_RING_MAGIC(x)
#endif\n" >> "$path"".c"
elif [ $lower = "string" ]; then
echo -e "\
#ifndef NDEBUG
#define CSTL_${upper}_MAGIC(x) x
#define CSTL_VECTOR_MAGIC(x) x
#else
#define CSTL_${upper}_MAGIC(x)
#define CSTL_VECTOR_MAGIC(x)
#endif\n" >> "$path"".c"
elif [ $lower = "set" -o $lower = "multiset" -o\
	   $lower = "map" -o $lower = "multimap" ]; then
echo -e "\
#ifndef NDEBUG
#define CSTL_RBTREE_MAGIC(x) x
#else
#define CSTL_RBTREE_MAGIC(x)
#endif\n" >> "$path"".c"
else
echo -e "\
#ifndef NDEBUG
#define CSTL_${upper}_MAGIC(x) x
#else
#define CSTL_${upper}_MAGIC(x)
#endif\n" >> "$path"".c"
fi
fi
if [ "$heap" != "" ]; then
echo -e "\
#include \"heap.h\"
extern Heap $heap;
#define malloc(s)      Heap_alloc(&$heap, s)
#define realloc(p, s)  Heap_realloc(&$heap, p, s)
#define free(p)        Heap_free(&$heap, p)
" >> "$path"".c"
fi
if [ $lower = "set" -o $lower = "multiset" -o\
	 $lower = "map" -o $lower = "multimap" ]; then
echo -e "\
enum {
	CSTL_RBTREE_RED,
	CSTL_RBTREE_BLACK,
	CSTL_RBTREE_HEAD
};\n" >> "$path"".c"
fi
echo "$src" | cpp -I.. | grep "$name" | indent -kr -ut -ts4 \
| sed -e "s/$name \* /$name */g" | sed -e 's/^} /}\
\
/' >> "$path"".c"

# コンパイル確認
gcc -Wall -ansi -pedantic-errors "$path"".c" -c -DNDEBUG
gcc -Wall -ansi -pedantic-errors "$path"".c" -c
rm "$path"".o"
