
/* Time-stamp: <2009/05/07 13:15:14 Shinya Abe> */

/*
 *  Cue - A Unit Testing Framework for C, based on CUnit.
 *
 *  Author: Shinya Abe
 *  License: LGPL
 */

#ifndef CUE_H
#define CUE_H

#include <stdlib.h>
#include <cue/basic.h>

void
cue_setup();

void
cue_register(const char* name, CU_TestFunc test);

void
cue_result();

#define CU_SETUP() \
  cue_setup()

#define CU_PROTOTYPE(test) \
  void test()

#define CU_DEF(test) \
  void test()

#define CU_REGISTER(name, test) \
  cue_register(name, test)

#define CU_RUN() \
  cue_result()

#endif
