
/* Time-stamp: <2009/06/02 17:18:53 Shinya Abe> */

/*
 *  Cue - A Unit Testing Framework for C, based on CUnit.
 *
 *  Author: Shinya Abe
 *  License: LGPL
 */

#include <stdio.h>
#include "cunit.h"
#include "testdb.h"
#include "util.h"
#include "testrun.h"
#include "basic.h"

#define BAR "============================================="

static CU_pSuite suite;

__attribute__((constructor))
void
cue_setup()
{
  suite = NULL;
  CU_initialize_registry();
  suite = CU_add_suite("Cue", NULL, NULL);
}

void
cue_register(const char* name, CU_TestFunc test)
{
  CU_add_test(suite, name, test);
}

__attribute__((destructor))
void
cue_result()
{
  unsigned int n_asserts, n_successes;
  double s_rate;

  CU_basic_set_mode(CU_BRM_VERBOSE);
  /* CU_basic_set_mode(CU_BRM_NORMAL); */
  CU_basic_run_tests();
  printf("\n");
  /* CU_basic_show_failures(CU_get_failure_list()); */
  /* printf("\n"); */

  n_asserts = CU_get_number_of_asserts();
  n_successes = CU_get_number_of_successes();

  if(n_asserts == 0) {
    s_rate = 1.0;
  }
  else {
    s_rate = (double)(n_successes) / (double)(n_asserts);
  }

  if(n_asserts == n_successes) {
    fprintf(stdout, "\033[1;32m%s\033[0m", BAR);
  }
  else {
    fprintf(stdout, "\033[1;31m%s\033[0m", BAR);
  }
  
  fprintf(stdout, "[%3.0lf\%]\n\n", 100 * s_rate);
}
