/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "DummyOptionWidget.h"
#include "Dummy.h"

#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>

DummyOptionWidget::DummyOptionWidget(QWidget *parent)
: OptionWidget(parent), dummy(0)
{
	setWindowTitle(tr("Dummy Variable"));
	setWhatsThis("set dummy");
}

DummyOptionWidget::~DummyOptionWidget()
{
	delete dummy;
}

void DummyOptionWidget::construct()
{
	xDummyLineEdit = new QLineEdit;
	connect(xDummyLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *xVarLabel = new QLabel;
	xVarLabel->setText(tr("Variable") + " &X:");
	xVarLabel->setBuddy(xDummyLineEdit);

	yDummyLineEdit = new QLineEdit;
	connect(yDummyLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *yVarLabel = new QLabel;
	yVarLabel->setText(tr("Variable") + " &Y:");
	yVarLabel->setBuddy(yDummyLineEdit);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(xVarLabel, 0, 0);
	mainLayout->addWidget(xDummyLineEdit, 0, 1);
	mainLayout->addWidget(yVarLabel, 1, 0);
	mainLayout->addWidget(yDummyLineEdit, 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	setLayout(mainLayout);
}

void DummyOptionWidget::init()
{
	delete dummy;
	dummy = new Dummy;
	setWidget();
}

void DummyOptionWidget::apply()
{
	dummy->setDummyVar1(xDummyLineEdit->text());
	dummy->setDummyVar2(yDummyLineEdit->text());
	emit executed(dummy->command());
}

void DummyOptionWidget::setWidget()
{
	xDummyLineEdit->setText(dummy->dummyVar1());
	yDummyLineEdit->setText(dummy->dummyVar2());
}
