/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TERMINAL_POST_SCRIPT_INCLUDED
#define TERMINAL_POST_SCRIPT_INCLUDED

#include "Terminal.h"

#include <QtCore/QString>
#include <QtCore/QStringList>

//! set terminal postscript コマンド
class TerminalPostScript : public Terminal
{
	public:
		TerminalPostScript();

		void setMode(int mode);
		int mode() const;

		void setEnhanced (bool enhanced);
		bool enhances() const;

		void setColor(bool color);
		bool isColor() const;

		void setBlackText(bool black);
		bool isBlackText() const;

		void setSolid(bool solid);
		bool isSolid() const;

		void setDashLength(double dl);
		double dashLength() const;

		void setLineWidth(double lw);
		double lineWidth() const;

		void setDuplexing(int duplex);
		int duplexing() const;

		void setRounded(bool round);
		bool rounds() const;

		void setFontFile(const QString &fileName, bool add);
		const QStringList &fontFile() const;

		void setPalFuncParam(int samples, 
				double maxdeviation = 0.003);
		int samples() const;
		double maxDeviation() const;

		void setFontName(const QString &name);
		const QString &fontName() const;

		void setFontSize(int size);
		int fontSize() const;

		//! モード
		static const char * const MODE[];
		//! 色の有無
		static const char * const COLOR[];
		//! 線の種類
		static const char * const LINE_STYLE[];

	private:
		QString terminalOption() const;
		int mode_;
		bool enhances_;
		bool isColor_;
		bool isBlackText_;
		bool isSolid_;
		double dashLength_;
		double lineWidth_;
		int duplexing_;
		bool rounds_;
		QStringList fontFileList;
		int samples_;
		double maxDeviation_;
		QString fontName_;
		int fontSize_;
};
#endif // TERMINAL_POST_SCRIPT_INCLUDED
