package Cuitter::Plugin::Help;

use Mouse::Role;

requires qw( output );

has help => ( is => 'rw', isa => 'HashRef' );

sub _init_Help {
    my $self = shift;
    $self->help( {} );
    $self->set_help( 'help', '( command ) show help of command.' );
}

sub set_help {
    my ( $self, $name, $comment ) = @_;
    $self->help->{ "$name" } = $comment;
}

sub get_help {
    my ( $self, $name ) = @_;
    if ( $name ) {
        return "$name : ". $self->help->{ "$name" }."\n";
    }
    else {
        my $rtn = "";
        for my $key ( keys %{ $self->help } ) {
            $rtn .= "/$key : ".$self->help->{ "$key" }."\n";
        }
        return $rtn;
    }
}

sub com_help {
    my ( $self, $command ) = @_;
    $self->output->print( $self->get_help( $command ) );
    1;
}

no Mouse::Role;

1;
__END__

=head1 NAME

Cuitter::Plugin::Help - Cuitter Plugin

=head1 DESCRIPTION

This plugin provides help-documentation methods and commands.

=head1 COMMANDS IT PROVIDES

=head2 /help [ command ]

show help

=head1 LICENSE

Artistic

=head1 AUTHOR

Satoshi Azuma E<lt>ytnobody@gmail.comE<gt>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
