package Cuitter::Plugin::QuoteTweet;
use Mouse::Role;
use Encode;

requires qw( client status set_help com_ft );

sub _init_QuoteTweet {
    my $self = shift;
    $self->set_help( 'qt', '( id ) Quote-Tweet a tweet that labeled (id).' );
}

sub com_qt {
    my ( $self, $id, @messages ) = @_;
    my $message = "";
    $message = join( " ", @messages ) if @messages;
    my $tweet = $self->status->[ $id ];
    $self->tweet( $message.' QT @'.$tweet->{user}{screen_name}. ': '. encode( "utf8", $tweet->{text} ) );
    $self->com_ft;
    1;
}

no Mouse::Role;
1;
__END__

=head1 NAME

Cuitter::Plugin::QuoteTweet - a Cuitter Plugin

=head1 SYNOPSIS

On your shell, execute like following.

  $ cuitter --plugins QuoteTweet

=head1 DESCRIPTION

This plugin provides /qt command to cuitter.

=head1 Provides Command

=head2 /qt [ target-status-id ] [ message ]

QuoteTweet to target tweet.

=head1 AUTHOR

Satoshi Azuma E<lt>ytnobody@gmail.comE<gt>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
