package Cuitter::Plugin::Retweet;
use Mouse::Role;
use Encode;
use Data::Dumper;

requires qw( client status set_help com_ft );

sub _init_Retweet {
    my $self = shift;
    $self->set_help( 'rt', '( id ) Retweet a tweet that labeled (id).' );
}

sub com_rt {
    my ( $self, $id ) = @_;
    my $tweet = $self->status->[ $id ];
    $self->tweet( 'RT @'.$tweet->{user}{screen_name}. ': '. encode( "utf8", $tweet->{text} ) );
    $self->com_ft;
    1;
}

no Mouse::Role;
1;
__END__

=head1 NAME

Cuitter::Plugin::Retweet - a Cuitter Plugin

=head1 SYNOPSIS

On your shell, execute like following.

  $ cuitter --plugins Retweet

=head1 DESCRIPTION

This plugin provides /rt command to cuitter.

=head1 Provides Command

=head2 /rt [ target-status-id ] 

Retweet to target tweet.

=head1 AUTHOR

Satoshi Azuma E<lt>ytnobody@gmail.comE<gt>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
