/*
 * "CUnit for Mr.Ando" is CppUnit-x based C langage testing framework
 * for Mr.Ando. It provide the C source code for unit testing. 
 * Copyright (C) 2004 Toshikazu Ando.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <testRunner.h>
#include "plus.h"

static unsigned int testPlus(void);

/** Main function. */
int main(void) {
    return (int) testRunner(testPlus);
}

static unsigned int testPlus(void) {
    unsigned int err;
    unsigned int ans;
    unsigned int data1;
    unsigned int data2;
    
    data1 = 1;
    data2 = 1;
    err = plus(data1,data2,&ans); // do Test
    TEST_ASSERT_EQUALS((data1 + data2),(int)ans);
    TEST_ASSERT_EQUALS(err,0);
    
    data1 = 100;
    data2 = 1;
    err = plus(data1,data2,&ans); // do Test
    TEST_ASSERT(err != 0);

    data1 = 0;
    data2 = 0xffffffffu; // -1
    err = plus(data1,data2,&ans); // do Test
    TEST_ASSERT(err != 0);

    data1 = 1;
    data2 = 99;
    err = plus(data1,data2,&ans); // do Test
    TEST_ASSERT(err != 0);
    
    return 0;
}
