/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.tutorial.modules.actions.portlets;

import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;

import org.apache.velocity.context.Context;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.modules.actions.portlets.browser.DatabaseBrowserAction;
import org.apache.jetspeed.services.resources.JetspeedResources;

/**
 * Handle refresh
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: CafeBrowserAction.java,v 1.1 2004/04/08 17:03:54 taylor Exp $
 */
public class CafeBrowserAction extends DatabaseBrowserAction
{
    public static final String BROWSER_COMMAND = "cb_command";
    public static final String BROWSER_REFRESH = "refresh";
    /**
     * Build the normal state content for this portlet.
     *
     * @param portlet The velocity-based portlet that is being built.
     * @param context The velocity context for this request.
     * @param rundata The turbine rundata context for this request.
     */
    protected void buildNormalContext( VelocityPortlet portlet,
                                       Context context,
                                       RunData rundata )
    {
        String refresh = rundata.getParameters().getString(BROWSER_COMMAND);
        if (refresh != null && refresh.equals(BROWSER_REFRESH))
        {
            this.clearDatabaseBrowserIterator(portlet,rundata);
        }
        super.buildNormalContext(portlet, context, rundata);
    }
}

