/*
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.searchmap;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * SearchMapのResultDataです。 <BR>
 * 
 */
public class SearchMapResultData implements ALData {

  
  private ALNumberField id;  
  /** 検索文字列 */
  private ALStringField keyword;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {

    id = new ALNumberField();
    keyword = new ALStringField();
    keyword.setTrim(true);

  }
  
  /**
   * @return
   */
  public ALNumberField getId() {
    return id;
  }

  /**
   * @return
   */
  public String getKeyword() {
    return keyword.getValue();
  }
  /**
   * @param i
   */
  public void setId(long i) {
    id.setValue(i);
  }

  /**
   * @param string
   */
  public void setKeyword(String string) {
    keyword.setValue(string);
  }


}
