/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.screens;

import java.util.ArrayList;

import net.sf.json.JSONArray;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.circulation.CirculationConfirmFormData;
import com.aimluck.eip.circulation.CirculationFormData;
import com.aimluck.eip.circulation.CirculationMultiDelete;

/**
 * 回覧板をJSONデータとして出力するクラスです。 <br />
 * 
 */
public class CirculationFormJSONScreen extends ALJSONScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(CirculationFormJSONScreen.class.getName());

  @Override
  protected String getJSONString(RunData rundata, Context context)
      throws Exception {
    String result = new JSONArray().toString();
    String mode = this.getMode();
    try {

      if (ALEipConstants.MODE_INSERT.equals(mode)) {
        CirculationFormData formData = new CirculationFormData();
        formData.initField();
        if (formData.doInsert(this, rundata, context)) {
        } else {
          ArrayList list = (ArrayList) context
              .get(ALEipConstants.ERROR_MESSAGE_LIST);
          JSONArray json = JSONArray.fromObject(list);
          result = json.toString();
        }

      } else if (ALEipConstants.MODE_UPDATE.equals(mode)) {

        CirculationFormData formData = new CirculationFormData();
        formData.initField();
        if (formData.doUpdate(this, rundata, context)) {
        } else {
          ArrayList list = (ArrayList) context
              .get(ALEipConstants.ERROR_MESSAGE_LIST);
          JSONArray json = JSONArray.fromObject(list);
          result = json.toString();
        }
      } else if (ALEipConstants.MODE_DELETE.equals(mode)) {

        CirculationFormData formData = new CirculationFormData();
        formData.initField();
        if (formData.doDelete(this, rundata, context)) {
        } else {
          ArrayList list = (ArrayList) context
              .get(ALEipConstants.ERROR_MESSAGE_LIST);
          JSONArray json = JSONArray.fromObject(list);
          result = json.toString();
          }
      }else if ("multi_delete".equals(mode)) {

        CirculationMultiDelete delete = new CirculationMultiDelete();
        
        if (delete.doMultiAction(this, rundata, context)) {
        } else {
          ArrayList list = (ArrayList) context
              .get(ALEipConstants.ERROR_MESSAGE_LIST);
          JSONArray json = JSONArray.fromObject(list);
          result = json.toString();
        }
      } else if ("confirm".equals(mode)) {
        CirculationConfirmFormData formData = new CirculationConfirmFormData();
        formData.initField();
        if (formData.doUpdate(this, rundata, context)) {
        } else {
          ArrayList list = (ArrayList) context
              .get(ALEipConstants.ERROR_MESSAGE_LIST);
          JSONArray json = JSONArray.fromObject(list);
          result = json.toString();
        }
      } else if ("categorytemplate".equals(mode)) {
        int value = Integer
            .valueOf(rundata.getParameters().getStrings("value")[0]);
        CirculationFormData formData = new CirculationFormData();
        formData.initField();
        formData.loadCategoryList(rundata, context);
        result = formData.CategoryTemplate(value);
      }
        
    }catch (Exception e) {
      logger.error("[CirculationFormJSONScreen]", e);
    }

    return result;
  }
}

