/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.services.registry;

import java.util.Iterator;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.om.registry.*;

import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.om.registry.base.CategoryIterator;

/**
 * TestRegistryCategories
 *
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestRegistryCategories.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestRegistryCategories extends JetspeedTestCase {

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestRegistryCategories( String name ) {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestRegistryCategories.class.getName() } );
    }
 
    public void setup() {
        System.out.println("Setup: Testing categories of Registry");
     }
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestRegistryCategories.class );
    }

    /**
     * Tests categories
     * @throws Exception
     */
    public void testCategories() throws Exception 
    {
        try
        {
            PortletRegistry registry = (PortletRegistry)Registry.get(Registry.PORTLET);

            PortletEntry pe = (PortletEntry)registry.getEntry("RSS");
            assertNotNull(pe);

            Iterator iterator = registry.findPortletsByCategory("rss");
            int count = 0;
            init();
            PortletEntry rss;
            while (iterator.hasNext())
            {
                rss = (PortletEntry)iterator.next();
                print(iterator, rss);
                count++;
            }
            System.out.println("[RSS] count = " + count);
            System.out.println("------------------");            
            assertEquals( "RSS Count", 10, count);
            //assertEquals( "RSS Count", 2, count);

            registry.removeEntry(pe);
            iterator = registry.findPortletsByCategory("rss");
            assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
            //assertTrue(iterator.hasNext());
              
            registry.addEntry(pe);
            iterator = registry.findPortletsByCategory("rss");
            assertTrue(iterator.hasNext());
            rss = (PortletEntry)iterator.next();
            Iterator cats = rss.listCategories();
            assertNotNull(cats);
            assertTrue(cats.hasNext());
            Category cat = (Category)cats.next();
            assertTrue(cat.getName().startsWith("rss") || cat.getName().startsWith("news"));


            iterator = registry.listByCategory();
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
            //    print(iterator, entry);
                count++;
            }
            System.out.println("[Everything] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByCategory("General");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[General] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByGroupCategory("base", "news.xml.rss");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[base][xml.rss] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByCategory("");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByGroupCategory("", "");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[][] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByGroupCategory("Jetspeed", "");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[Jetspeed][] count = " + count);
            System.out.println("------------------");

            iterator = registry.findPortletsByCategory("news");
            count = 0;
            init();
            while (iterator.hasNext())
            {
                PortletEntry entry = (PortletEntry)iterator.next();
                //print(iterator, entry);
                count++;
            }
            System.out.println("[news] count = " + count);
            System.out.println("------------------");

           
//            SortedMap sm = tree.tailMap("sports");
//            Iterator it = sm.keySet().iterator();
        }
        catch (Exception e)
        {
            String errmsg = "Error in category test: " + e.toString();
           // e.printStackTrace();
           assertNotNull(errmsg, null);
        }
    }

    private String lastGroup = "";
    private String lastCategory = "";

    private void init()
    {
        lastGroup = "";
        lastCategory = "";
    }

    private void print(Iterator iterator, PortletEntry entry)
    {
        String group = ((CategoryIterator)iterator).getGroup();
        String category = ((CategoryIterator)iterator).getCategory();
        if (!lastGroup.equals(group))
        {
            System.out.println("Group: [" + group + "]");
            lastGroup = group;
        }
        if (!lastCategory.equals(category))
        {
            System.out.println("....Cat: [" + category + "]");
            lastCategory = category;
        }
        System.out.println("........" + entry.getName());
     }
    
    /**
     * Tests IdentityElement unmarshaling entryset base stuff
     * @throws Exception
     */


    /*
      Configuration object to run Turbine outside a servlet container
      ( uses turbine.properties )
    */
    private static TurbineConfig config = null;
    
    /*    
      Sets up TurbineConfig using the system property:
      <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
           config = new TurbineConfig( "webapp", "/WEB-INF/conf/TurbineResources.properties");
           config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }
}
