/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.services.registry;

import java.io.File;
import java.io.FileReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.jetspeed.test.JetspeedTestCase;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/**
 * TestCastor
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestCastor.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */
public class TestCastor extends JetspeedTestCase
{
    public TestCastor(String name)
    {
        super(name);
    }
            
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        junit.awtui.TestRunner.main(new String[] { TestCastor.class.getName() });
    }
    
    public void testUnMarshall()
    {
        System.out.println("This Test is for testing compatibility with new versions of Castor as they are released.");
        String mapFile = "test/conf/registry-mapping.xml";
        String registryFile = "test/conf/test-registry.xreg";
        
        File map = new File(mapFile);
        try
        {
            Mapping mapping = new Mapping();
            InputSource is = new InputSource(new FileReader(map));
            is.setSystemId(mapFile);
            mapping.loadMapping(is);
            
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
       
            Document d = builder.parse(new File(registryFile));

            Unmarshaller unmarshaller = new Unmarshaller(mapping);
            RegistryFragment fragment = (RegistryFragment) unmarshaller.unmarshal((Node) d);
            
        }
        catch (Exception e)
        {
            e.printStackTrace();
            fail("Error in mapping creation");            
       }
        
    }
            
}
