/*
	Copyright (c) 2004-2007, The Dojo Foundation
	All Rights Reserved.

	Licensed under the Academic Free License version 2.1 or above OR the
	modified BSD license. For more information on Dojo licensing, see:

		http://dojotoolkit.org/book/dojo-book-0-9/introduction/licensing
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.storage.Provider"]){dojo._hasResource["dojox.storage.Provider"]=true;dojo.provide("dojox.storage.Provider");dojo.declare("dojox.storage.Provider",null,{constructor:function(){},SUCCESS:"success",FAILED:"failed",PENDING:"pending",SIZE_NOT_AVAILABLE:"Size not available",SIZE_NO_LIMIT:"No size limit",DEFAULT_NAMESPACE:"default",onHideSettingsUI:null,initialize:function(){console.warn("dojox.storage.initialize not implemented");},isAvailable:function(){console.warn("dojox.storage.isAvailable not implemented");},put:function(_1,_2,_3,_4){console.warn("dojox.storage.put not implemented");},get:function(_5,_6){console.warn("dojox.storage.get not implemented");},hasKey:function(_7,_8){return (this.get(_7)!=null);},getKeys:function(_9){console.warn("dojox.storage.getKeys not implemented");},clear:function(_a){console.warn("dojox.storage.clear not implemented");},remove:function(_b,_c){console.warn("dojox.storage.remove not implemented");},getNamespaces:function(){console.warn("dojox.storage.getNamespaces not implemented");},isPermanent:function(){console.warn("dojox.storage.isPermanent not implemented");},getMaximumSize:function(){console.warn("dojox.storage.getMaximumSize not implemented");},putMultiple:function(_d,_e,_f,_10){console.warn("dojox.storage.putMultiple not implemented");},getMultiple:function(_11,_12){console.warn("dojox.storage.getMultiple not implemented");},removeMultiple:function(_13,_14){console.warn("dojox.storage.remove not implemented");},isValidKeyArray:function(_15){if(_15===null||typeof _15==="undefined"||!_15 instanceof Array){return false;}for(var k=0;k<_15.length;k++){if(!this.isValidKey(_15[k])){return false;}}return true;},hasSettingsUI:function(){return false;},showSettingsUI:function(){console.warn("dojox.storage.showSettingsUI not implemented");},hideSettingsUI:function(){console.warn("dojox.storage.hideSettingsUI not implemented");},isValidKey:function(_17){if((_17==null)||(typeof _17=="undefined")){return false;}return /^[0-9A-Za-z_]*$/.test(_17);},getResourceList:function(){return [];}});}if(!dojo._hasResource["dojox.storage.manager"]){dojo._hasResource["dojox.storage.manager"]=true;dojo.provide("dojox.storage.manager");dojox.storage.manager=new function(){this.currentProvider=null;this.available=false;this._initialized=false;this._providers=[];this._onLoadListeners=[];this.initialize=function(){this.autodetect();};this.register=function(_18,_19){this._providers[this._providers.length]=_19;this._providers[_18]=_19;};this.setProvider=function(_1a){};this.autodetect=function(){if(this._initialized){return;}var _1b=djConfig["forceStorageProvider"]||false;var _1c;for(var i=0;i<this._providers.length;i++){_1c=this._providers[i];if(_1b==_1c.declaredClass){_1c.isAvailable();break;}else{if(_1c.isAvailable()){break;}}}if(!_1c){this._initialized=true;this.available=false;this.currentProvider=null;console.warn("No storage provider found for this platform");this.loaded();return;}this.currentProvider=_1c;dojo.mixin(dojox.storage,this.currentProvider);dojox.storage.initialize();this._initialized=true;this.available=true;};this.isAvailable=function(){return this.available;};this.addOnLoad=function(_1e){this._onLoadListeners.push(_1e);if(this.isInitialized()){this._fireLoaded();}};this.removeOnLoad=function(_1f){for(var i=0;i<this._onLoadListeners.length;i++){if(_1f==this._onLoadListeners[i]){this._onLoadListeners=this._onLoadListeners.splice(i,1);break;}}};this.isInitialized=function(){if(this.currentProvider!=null&&this.currentProvider.declaredClass=="dojox.storage.FlashStorageProvider"&&dojox.flash.ready==false){return false;}else{return this._initialized;}};this.supportsProvider=function(_21){try{var _22=eval("new "+_21+"()");var _23=_22.isAvailable();if(!_23){return false;}return _23;}catch(e){return false;}};this.getProvider=function(){return this.currentProvider;};this.loaded=function(){this._fireLoaded();};this._fireLoaded=function(){dojo.forEach(this._onLoadListeners,function(i){try{i();}catch(e){console.debug(e);}});};this.getResourceList=function(){var _25=[];dojo.forEach(dojox.storage.manager._providers,function(_26){_25=_25.concat(_26.getResourceList());});return _25;};};}if(!dojo._hasResource["dojox._sql._crypto"]){dojo._hasResource["dojox._sql._crypto"]=true;dojo.provide("dojox._sql._crypto");dojo.mixin(dojox._sql._crypto,{_POOL_SIZE:100,encrypt:function(_27,_28,_29){this._initWorkerPool();var msg={plaintext:_27,password:_28};msg=dojo.toJson(msg);msg="encr:"+String(msg);this._assignWork(msg,_29);},decrypt:function(_2b,_2c,_2d){this._initWorkerPool();var msg={ciphertext:_2b,password:_2c};msg=dojo.toJson(msg);msg="decr:"+String(msg);this._assignWork(msg,_2d);},_initWorkerPool:function(){if(!this._manager){try{this._manager=google.gears.factory.create("beta.workerpool","1.0");this._unemployed=[];this._employed={};this._handleMessage=[];var _2f=this;this._manager.onmessage=function(msg,_31){var _32=_2f._employed["_"+_31];_2f._employed["_"+_31]=undefined;_2f._unemployed.push("_"+_31);if(_2f._handleMessage.length){var _33=_2f._handleMessage.shift();_2f._assignWork(_33.msg,_33.callback);}_32(msg);};var _34="function _workerInit(){"+"gearsWorkerPool.onmessage = "+String(this._workerHandler)+";"+"}";var _35=_34+" _workerInit();";for(var i=0;i<this._POOL_SIZE;i++){this._unemployed.push("_"+this._manager.createWorker(_35));}}catch(exp){throw exp.message||exp;}}},_assignWork:function(msg,_38){if(!this._handleMessage.length&&this._unemployed.length){var _39=this._unemployed.shift().substring(1);this._employed["_"+_39]=_38;this._manager.sendMessage(msg,_39);}else{this._handleMessage={msg:msg,callback:_38};}},_workerHandler:function(msg,_3b){var _3c=[99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22];var _3d=[[0,0,0,0],[1,0,0,0],[2,0,0,0],[4,0,0,0],[8,0,0,0],[16,0,0,0],[32,0,0,0],[64,0,0,0],[128,0,0,0],[27,0,0,0],[54,0,0,0]];function Cipher(_3e,w){var Nb=4;var Nr=w.length/Nb-1;var _42=[[],[],[],[]];for(var i=0;i<4*Nb;i++){_42[i%4][Math.floor(i/4)]=_3e[i];}_42=AddRoundKey(_42,w,0,Nb);for(var _44=1;_44<Nr;_44++){_42=SubBytes(_42,Nb);_42=ShiftRows(_42,Nb);_42=MixColumns(_42,Nb);_42=AddRoundKey(_42,w,_44,Nb);}_42=SubBytes(_42,Nb);_42=ShiftRows(_42,Nb);_42=AddRoundKey(_42,w,Nr,Nb);var _45=new Array(4*Nb);for(var i=0;i<4*Nb;i++){_45[i]=_42[i%4][Math.floor(i/4)];}return _45;};function SubBytes(s,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){s[r][c]=_3c[s[r][c]];}}return s;};function ShiftRows(s,Nb){var t=new Array(4);for(var r=1;r<4;r++){for(var c=0;c<4;c++){t[c]=s[r][(c+r)%Nb];}for(var c=0;c<4;c++){s[r][c]=t[c];}}return s;};function MixColumns(s,Nb){for(var c=0;c<4;c++){var a=new Array(4);var b=new Array(4);for(var i=0;i<4;i++){a[i]=s[i][c];b[i]=s[i][c]&128?s[i][c]<<1^283:s[i][c]<<1;}s[0][c]=b[0]^a[1]^b[1]^a[2]^a[3];s[1][c]=a[0]^b[1]^a[2]^b[2]^a[3];s[2][c]=a[0]^a[1]^b[2]^a[3]^b[3];s[3][c]=a[0]^b[0]^a[1]^a[2]^b[3];}return s;};function AddRoundKey(_55,w,rnd,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){_55[r][c]^=w[rnd*4+c][r];}}return _55;};function KeyExpansion(key){var Nb=4;var Nk=key.length/4;var Nr=Nk+6;var w=new Array(Nb*(Nr+1));var _60=new Array(4);for(var i=0;i<Nk;i++){var r=[key[4*i],key[4*i+1],key[4*i+2],key[4*i+3]];w[i]=r;}for(var i=Nk;i<(Nb*(Nr+1));i++){w[i]=new Array(4);for(var t=0;t<4;t++){_60[t]=w[i-1][t];}if(i%Nk==0){_60=SubWord(RotWord(_60));for(var t=0;t<4;t++){_60[t]^=_3d[i/Nk][t];}}else{if(Nk>6&&i%Nk==4){_60=SubWord(_60);}}for(var t=0;t<4;t++){w[i][t]=w[i-Nk][t]^_60[t];}}return w;};function SubWord(w){for(var i=0;i<4;i++){w[i]=_3c[w[i]];}return w;};function RotWord(w){w[4]=w[0];for(var i=0;i<4;i++){w[i]=w[i+1];}return w;};function AESEncryptCtr(_68,_69,_6a){if(!(_6a==128||_6a==192||_6a==256)){return "";}var _6b=_6a/8;var _6c=new Array(_6b);for(var i=0;i<_6b;i++){_6c[i]=_69.charCodeAt(i)&255;}var key=Cipher(_6c,KeyExpansion(_6c));key=key.concat(key.slice(0,_6b-16));var _6f=16;var _70=new Array(_6f);var _71=(new Date()).getTime();for(var i=0;i<4;i++){_70[i]=(_71>>>i*8)&255;}for(var i=0;i<4;i++){_70[i+4]=(_71/4294967296>>>i*8)&255;}var _72=KeyExpansion(key);var _73=Math.ceil(_68.length/_6f);var _74=new Array(_73);for(var b=0;b<_73;b++){for(var c=0;c<4;c++){_70[15-c]=(b>>>c*8)&255;}for(var c=0;c<4;c++){_70[15-c-4]=(b/4294967296>>>c*8);}var _77=Cipher(_70,_72);var _78=b<_73-1?_6f:(_68.length-1)%_6f+1;var ct="";for(var i=0;i<_78;i++){var _7a=_68.charCodeAt(b*_6f+i);var _7b=_7a^_77[i];ct+=String.fromCharCode(_7b);}_74[b]=escCtrlChars(ct);}var _7c="";for(var i=0;i<8;i++){_7c+=String.fromCharCode(_70[i]);}_7c=escCtrlChars(_7c);return _7c+"-"+_74.join("-");};function AESDecryptCtr(_7d,_7e,_7f){if(!(_7f==128||_7f==192||_7f==256)){return "";}var _80=_7f/8;var _81=new Array(_80);for(var i=0;i<_80;i++){_81[i]=_7e.charCodeAt(i)&255;}var _83=KeyExpansion(_81);var key=Cipher(_81,_83);key=key.concat(key.slice(0,_80-16));var _85=KeyExpansion(key);_7d=_7d.split("-");var _86=16;var _87=new Array(_86);var _88=unescCtrlChars(_7d[0]);for(var i=0;i<8;i++){_87[i]=_88.charCodeAt(i);}var _89=new Array(_7d.length-1);for(var b=1;b<_7d.length;b++){for(var c=0;c<4;c++){_87[15-c]=((b-1)>>>c*8)&255;}for(var c=0;c<4;c++){_87[15-c-4]=((b/4294967296-1)>>>c*8)&255;}var _8c=Cipher(_87,_85);_7d[b]=unescCtrlChars(_7d[b]);var pt="";for(var i=0;i<_7d[b].length;i++){var _8e=_7d[b].charCodeAt(i);var _8f=_8e^_8c[i];pt+=String.fromCharCode(_8f);}_89[b-1]=pt;}return _89.join("");};function escCtrlChars(str){return str.replace(/[\0\t\n\v\f\r\xa0!-]/g,function(c){return "!"+c.charCodeAt(0)+"!";});};function unescCtrlChars(str){return str.replace(/!\d\d?\d?!/g,function(c){return String.fromCharCode(c.slice(1,-1));});};function encrypt(_94,_95){return AESEncryptCtr(_94,_95,256);};function decrypt(_96,_97){return AESDecryptCtr(_96,_97,256);};var cmd=msg.substr(0,4);var arg=msg.substr(5);if(cmd=="encr"){arg=eval("("+arg+")");var _9a=arg.plaintext;var _9b=arg.password;var _9c=encrypt(_9a,_9b);gearsWorkerPool.sendMessage(String(_9c),_3b);}else{if(cmd=="decr"){arg=eval("("+arg+")");var _9d=arg.ciphertext;var _9b=arg.password;var _9c=decrypt(_9d,_9b);gearsWorkerPool.sendMessage(String(_9c),_3b);}}}});}if(!dojo._hasResource["dojox._sql.common"]){dojo._hasResource["dojox._sql.common"]=true;dojo.provide("dojox._sql.common");dojox.sql=new Function("return dojox.sql._exec(arguments);");dojo.mixin(dojox.sql,{dbName:null,debug:(dojo.exists("dojox.sql.debug")?dojox.sql.debug:false),open:function(_9e){if(this._dbOpen&&(!_9e||_9e==this.dbName)){return;}if(!this.dbName){this.dbName="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");}if(!_9e){_9e=this.dbName;}try{this._initDb();this.db.open(_9e);this._dbOpen=true;}catch(exp){throw exp.message||exp;}},close:function(_9f){if(dojo.isIE){return;}if(!this._dbOpen&&(!_9f||_9f==this.dbName)){return;}if(!_9f){_9f=this.dbName;}try{this.db.close(_9f);this._dbOpen=false;}catch(exp){throw exp.message||exp;}},_exec:function(_a0){try{this._initDb();if(!this._dbOpen){this.open();this._autoClose=true;}var sql=null;var _a2=null;var _a3=null;var _a4=dojo._toArray(_a0);sql=_a4.splice(0,1)[0];if(this._needsEncrypt(sql)||this._needsDecrypt(sql)){_a2=_a4.splice(_a4.length-1,1)[0];_a3=_a4.splice(_a4.length-1,1)[0];}if(this.debug){this._printDebugSQL(sql,_a4);}if(this._needsEncrypt(sql)){var _a5=new dojox.sql._SQLCrypto("encrypt",sql,_a3,_a4,_a2);return;}else{if(this._needsDecrypt(sql)){var _a5=new dojox.sql._SQLCrypto("decrypt",sql,_a3,_a4,_a2);return;}}var rs=this.db.execute(sql,_a4);rs=this._normalizeResults(rs);if(this._autoClose){this.close();}return rs;}catch(exp){exp=exp.message||exp;console.debug("SQL Exception: "+exp);if(this._autoClose){try{this.close();}catch(e){console.debug("Error closing database: "+e.message||e);}}throw exp;}},_initDb:function(){if(!this.db){try{this.db=google.gears.factory.create("beta.database","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);dojox.off.onFrameworkEvent("coreOperationFailed");throw "Google Gears must be allowed to run";}}},_printDebugSQL:function(sql,_a8){var msg="dojox.sql(\""+sql+"\"";for(var i=0;i<_a8.length;i++){if(typeof _a8[i]=="string"){msg+=", \""+_a8[i]+"\"";}else{msg+=", "+_a8[i];}}msg+=")";console.debug(msg);},_normalizeResults:function(rs){var _ac=[];if(!rs){return [];}while(rs.isValidRow()){var row={};for(var i=0;i<rs.fieldCount();i++){var _af=rs.fieldName(i);var _b0=rs.field(i);row[_af]=_b0;}_ac.push(row);rs.next();}rs.close();return _ac;},_needsEncrypt:function(sql){return /encrypt\([^\)]*\)/i.test(sql);},_needsDecrypt:function(sql){return /decrypt\([^\)]*\)/i.test(sql);}});dojo.declare("dojox.sql._SQLCrypto",null,{constructor:function(_b3,sql,_b5,_b6,_b7){if(_b3=="encrypt"){this._execEncryptSQL(sql,_b5,_b6,_b7);}else{this._execDecryptSQL(sql,_b5,_b6,_b7);}},_execEncryptSQL:function(sql,_b9,_ba,_bb){var _bc=this._stripCryptoSQL(sql);var _bd=this._flagEncryptedArgs(sql,_ba);var _be=this;this._encrypt(_bc,_b9,_ba,_bd,function(_bf){var _c0=false;var _c1=[];var exp=null;try{_c1=dojox.sql.db.execute(_bc,_bf);}catch(execError){_c0=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_bb(null,true,exp.toString());return;}_c1=dojox.sql._normalizeResults(_c1);if(dojox.sql._autoClose){dojox.sql.close();}if(dojox.sql._needsDecrypt(sql)){var _c3=_be._determineDecryptedColumns(sql);_be._decrypt(_c1,_c3,_b9,function(_c4){_bb(_c4,false,null);});}else{_bb(_c1,false,null);}});},_execDecryptSQL:function(sql,_c6,_c7,_c8){var _c9=this._stripCryptoSQL(sql);var _ca=this._determineDecryptedColumns(sql);var _cb=false;var _cc=[];var exp=null;try{_cc=dojox.sql.db.execute(_c9,_c7);}catch(execError){_cb=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_c8(_cc,true,exp.toString());return;}_cc=dojox.sql._normalizeResults(_cc);if(dojox.sql._autoClose){dojox.sql.close();}this._decrypt(_cc,_ca,_c6,function(_ce){_c8(_ce,false,null);});},_encrypt:function(sql,_d0,_d1,_d2,_d3){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalArgs=_d1;for(var i=0;i<_d1.length;i++){if(_d2[i]){var _d5=_d1[i];var _d6=i;this._totalCrypto++;dojox._sql._crypto.encrypt(_d5,_d0,dojo.hitch(this,function(_d7){this._finalArgs[_d6]=_d7;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_d3(this._finalArgs);}}));}}this._finishedSpawningCrypto=true;},_decrypt:function(_d8,_d9,_da,_db){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalResultSet=_d8;for(var i=0;i<_d8.length;i++){var row=_d8[i];for(var _de in row){if(_d9=="*"||_d9[_de]){this._totalCrypto++;var _df=row[_de];this._decryptSingleColumn(_de,_df,_da,i,function(_e0){_db(_e0);});}}}this._finishedSpawningCrypto=true;},_stripCryptoSQL:function(sql){sql=sql.replace(/DECRYPT\(\*\)/ig,"*");var _e2=sql.match(/ENCRYPT\([^\)]*\)/ig);if(_e2!=null){for(var i=0;i<_e2.length;i++){var _e4=_e2[i];var _e5=_e4.match(/ENCRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_e4,_e5);}}_e2=sql.match(/DECRYPT\([^\)]*\)/ig);if(_e2!=null){for(var i=0;i<_e2.length;i++){var _e6=_e2[i];var _e7=_e6.match(/DECRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_e6,_e7);}}return sql;},_flagEncryptedArgs:function(sql,_e9){var _ea=new RegExp(/([\"][^\"]*\?[^\"]*[\"])|([\'][^\']*\?[^\']*[\'])|(\?)/ig);var _eb;var _ec=0;var _ed=[];while((_eb=_ea.exec(sql))!=null){var _ee=RegExp.lastMatch+"";if(/^[\"\']/.test(_ee)){continue;}var _ef=false;if(/ENCRYPT\([^\)]*$/i.test(RegExp.leftContext)){_ef=true;}_ed[_ec]=_ef;_ec++;}return _ed;},_determineDecryptedColumns:function(sql){var _f1={};if(/DECRYPT\(\*\)/i.test(sql)){_f1="*";}else{var _f2=/DECRYPT\((?:\s*\w*\s*\,?)*\)/ig;var _f3;while(_f3=_f2.exec(sql)){var _f4=new String(RegExp.lastMatch);var _f5=_f4.replace(/DECRYPT\(/i,"");_f5=_f5.replace(/\)/,"");_f5=_f5.split(/\s*,\s*/);dojo.forEach(_f5,function(_f6){if(/\s*\w* AS (\w*)/i.test(_f6)){_f6=_f6.match(/\s*\w* AS (\w*)/i)[1];}_f1[_f6]=true;});}}return _f1;},_decryptSingleColumn:function(_f7,_f8,_f9,_fa,_fb){dojox._sql._crypto.decrypt(_f8,_f9,dojo.hitch(this,function(_fc){this._finalResultSet[_fa][_f7]=_fc;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_fb(this._finalResultSet);}}));}});}if(!dojo._hasResource["dojox.sql"]){dojo._hasResource["dojox.sql"]=true;dojo.provide("dojox.sql");}if(!dojo._hasResource["dojox.storage.GearsStorageProvider"]){dojo._hasResource["dojox.storage.GearsStorageProvider"]=true;dojo.provide("dojox.storage.GearsStorageProvider");if(dojo.isGears){(function(){dojo.declare("dojox.storage.GearsStorageProvider",dojox.storage.Provider,{constructor:function(){},TABLE_NAME:"__DOJO_STORAGE",initialized:false,_available:null,initialize:function(){if(djConfig["disableGearsStorage"]==true){return;}this.TABLE_NAME="__DOJO_STORAGE";try{dojox.sql("CREATE TABLE IF NOT EXISTS "+this.TABLE_NAME+"( "+" namespace TEXT, "+" key TEXT, "+" value TEXT "+")");dojox.sql("CREATE UNIQUE INDEX IF NOT EXISTS namespace_key_index"+" ON "+this.TABLE_NAME+" (namespace, key)");}catch(e){console.debug("dojox.storage.GearsStorageProvider.initialize:",e);this.initialized=false;dojox.storage.manager.loaded();return;}this.initialized=true;dojox.storage.manager.loaded();},isAvailable:function(){return this._available=dojo.isGears;},put:function(key,_fe,_ff,_100){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_100=_100||this.DEFAULT_NAMESPACE;if(dojo.isString(_fe)){_fe="string:"+_fe;}else{_fe=dojo.toJson(_fe);}try{dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?",_100,key);dojox.sql("INSERT INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)",_100,key,_fe);}catch(e){console.debug("dojox.storage.GearsStorageProvider.put:",e);_ff(this.FAILED,key,e.toString());return;}if(_ff){_ff(dojox.storage.SUCCESS,key,null);}},get:function(key,_102){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_102=_102||this.DEFAULT_NAMESPACE;var _103=dojox.sql("SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?",_102,key);if(!_103.length){return null;}else{_103=_103[0].value;}if(dojo.isString(_103)&&(/^string:/.test(_103))){_103=_103.substring("string:".length);}else{_103=dojo.fromJson(_103);}return _103;},getNamespaces:function(){var _104=[dojox.storage.DEFAULT_NAMESPACE];var rs=dojox.sql("SELECT namespace FROM "+this.TABLE_NAME+" DESC GROUP BY namespace");for(var i=0;i<rs.length;i++){if(rs[i].namespace!=dojox.storage.DEFAULT_NAMESPACE){_104.push(rs[i].namespace);}}return _104;},getKeys:function(_107){_107=_107||this.DEFAULT_NAMESPACE;if(this.isValidKey(_107)==false){throw new Error("Invalid namespace given: "+_107);}var rs=dojox.sql("SELECT key FROM "+this.TABLE_NAME+" WHERE namespace = ?",_107);var _109=[];for(var i=0;i<rs.length;i++){_109.push(rs[i].key);}return _109;},clear:function(_10b){if(this.isValidKey(_10b)==false){throw new Error("Invalid namespace given: "+_10b);}_10b=_10b||this.DEFAULT_NAMESPACE;dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ?",_10b);},remove:function(key,_10d){_10d=_10d||this.DEFAULT_NAMESPACE;dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND"+" key = ?",_10d,key);},putMultiple:function(keys,_10f,_110,_111){if(this.isValidKeyArray(keys)===false||!_10f instanceof Array||keys.length!=_10f.length){throw new Error("Invalid arguments: keys = ["+keys+"], values = ["+_10f+"]");}if(_111==null||typeof _111=="undefined"){_111=dojox.storage.DEFAULT_NAMESPACE;}if(this.isValidKey(_111)==false){throw new Error("Invalid namespace given: "+_111);}this._statusHandler=_110;try{dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _112="REPLACE INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)";for(var i=0;i<keys.length;i++){var _114=_10f[i];if(dojo.isString(_114)){_114="string:"+_114;}else{_114=dojo.toJson(_114);}dojox.sql.db.execute(_112,[_111,keys[i],_114]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();}catch(e){console.debug("dojox.storage.GearsStorageProvider.putMultiple:",e);if(_110){_110(this.FAILED,keys,e.toString());}return;}if(_110){_110(dojox.storage.SUCCESS,key,null);}},getMultiple:function(keys,_116){if(this.isValidKeyArray(keys)===false){throw new ("Invalid key array given: "+keys);}if(_116==null||typeof _116=="undefined"){_116=dojox.storage.DEFAULT_NAMESPACE;}if(this.isValidKey(_116)==false){throw new Error("Invalid namespace given: "+_116);}var _117="SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?";var _118=[];for(var i=0;i<keys.length;i++){var _11a=dojox.sql(_117,_116,keys[i]);if(!_11a.length){_118[i]=null;}else{_11a=_11a[0].value;if(dojo.isString(_11a)&&(/^string:/.test(_11a))){_118[i]=_11a.substring("string:".length);}else{_118[i]=dojo.fromJson(_11a);}}}return _118;},removeMultiple:function(keys,_11c){_11c=_11c||this.DEFAULT_NAMESPACE;dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _11d="DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?";for(var i=0;i<keys.length;i++){dojox.sql.db.execute(_11d,[_11c,keys[i]]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();},isPermanent:function(){return true;},getMaximumSize:function(){return this.SIZE_NO_LIMIT;},hasSettingsUI:function(){return false;},showSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},hideSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");}});dojox.storage.manager.register("dojox.storage.GearsStorageProvider",new dojox.storage.GearsStorageProvider());dojox.storage.manager.initialize();})();}}if(!dojo._hasResource["dojox.storage._common"]){dojo._hasResource["dojox.storage._common"]=true;dojo.provide("dojox.storage._common");dojox.storage.manager.initialize();}if(!dojo._hasResource["dojox.storage"]){dojo._hasResource["dojox.storage"]=true;dojo.provide("dojox.storage");}if(!dojo._hasResource["dojox.off.files"]){dojo._hasResource["dojox.off.files"]=true;dojo.provide("dojox.off.files");dojox.off.files={versionURL:"version.js",listOfURLs:[],refreshing:false,_cancelID:null,_error:false,_errorMessages:[],_currentFileIndex:0,_store:null,_doSlurp:false,slurp:function(){this._doSlurp=true;},cache:function(_11f){if(dojo.isString(_11f)){var url=this._trimAnchor(_11f+"");if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{if(_11f instanceof dojo._Url){var url=this._trimAnchor(_11f.uri);if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{dojo.forEach(_11f,function(url){url=this._trimAnchor(url);if(!this.isAvailable(url)){this.listOfURLs.push(url);}},this);}}},printURLs:function(){console.debug("The following URLs are cached for offline use:");dojo.forEach(this.listOfURLs,function(i){console.debug(i);});},remove:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){this.listOfURLs=this.listOfURLs.splice(i,1);break;}}},isAvailable:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){return true;}}return false;},refresh:function(_127){try{if(djConfig.isDebug){this.printURLs();}this.refreshing=true;if(this.versionURL){this._getVersionInfo(function(_128,_129,_12a){if(djConfig.isDebug||!_129||_12a||!_128||_128!=_129){console.warn("Refreshing offline file list");this._doRefresh(_127,_129);}else{console.warn("No need to refresh offline file list");_127(false,[]);}});}else{console.warn("Refreshing offline file list");this._doRefresh(_127);}}catch(e){this.refreshing=false;dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}},abortRefresh:function(){if(!this.refreshing){return;}this._store.abortCapture(this._cancelID);this.refreshing=false;},_slurp:function(){if(!this._doSlurp){return;}var _12b=dojo.hitch(this,function(url){if(this._sameLocation(url)){this.cache(url);}});_12b(window.location.href);dojo.query("script").forEach(function(i){try{_12b(i.getAttribute("src"));}catch(exp){}});dojo.query("link").forEach(function(i){try{if(!i.getAttribute("rel")||i.getAttribute("rel").toLowerCase()!="stylesheet"){return;}_12b(i.getAttribute("href"));}catch(exp){}});dojo.query("img").forEach(function(i){try{_12b(i.getAttribute("src"));}catch(exp){}});dojo.query("a").forEach(function(i){try{_12b(i.getAttribute("href"));}catch(exp){}});dojo.forEach(document.styleSheets,function(_131){try{if(_131.cssRules){dojo.forEach(_131.cssRules,function(rule){var text=rule.cssText;if(text){var _134=text.match(/url\(\s*([^\) ]*)\s*\)/i);if(!_134){return;}for(var i=1;i<_134.length;i++){_12b(_134[i]);}}});}else{if(_131.cssText){var _136;var text=_131.cssText.toString();var _138=text.split(/\f|\r|\n/);for(var i=0;i<_138.length;i++){_136=_138[i].match(/url\(\s*([^\) ]*)\s*\)/i);if(_136&&_136.length){_12b(_136[1]);}}}}}catch(exp){}});},_sameLocation:function(url){if(!url){return false;}if(url.length&&url.charAt(0)=="#"){return false;}url=new dojo._Url(url);if(!url.scheme&&!url.port&&!url.host){return true;}if(!url.scheme&&url.host&&url.port&&window.location.hostname==url.host&&window.location.port==url.port){return true;}if(!url.scheme&&url.host&&!url.port&&window.location.hostname==url.host&&window.location.port==80){return true;}return window.location.protocol==(url.scheme+":")&&window.location.hostname==url.host&&(window.location.port==url.port||!window.location.port&&!url.port);},_trimAnchor:function(url){return url.replace(/\#.*$/,"");},_doRefresh:function(_13c,_13d){var _13e;try{_13e=google.gears.factory.create("beta.localserver","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);dojox.off.onFrameworkEvent("coreOperationFailed");throw "Google Gears must be allowed to run";}var _13f="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");_13e.removeStore(_13f);_13e.openStore(_13f);var _140=_13e.createStore(_13f);this._store=_140;var self=this;this._currentFileIndex=0;this._cancelID=_140.capture(this.listOfURLs,function(url,_143,_144){if(!_143&&self.refreshing){self._cancelID=null;self.refreshing=false;var _145=[];_145.push("Unable to capture: "+url);_13c(true,_145);return;}else{if(_143){self._currentFileIndex++;}}if(_143&&self._currentFileIndex>=self.listOfURLs.length){self._cancelID=null;self.refreshing=false;if(_13d){dojox.storage.put("oldVersion",_13d,null,dojox.off.STORAGE_NAMESPACE);}dojox.storage.put("justDebugged",djConfig.isDebug,null,dojox.off.STORAGE_NAMESPACE);_13c(false,[]);}});},_getVersionInfo:function(_146){var _147=dojox.storage.get("justDebugged",dojox.off.STORAGE_NAMESPACE);var _148=dojox.storage.get("oldVersion",dojox.off.STORAGE_NAMESPACE);var _149=null;_146=dojo.hitch(this,_146);dojo.xhrGet({url:this.versionURL+"?browserbust="+new Date().getTime(),timeout:5*1000,handleAs:"javascript",error:function(err){dojox.storage.remove("oldVersion",dojox.off.STORAGE_NAMESPACE);dojox.storage.remove("justDebugged",dojox.off.STORAGE_NAMESPACE);_146(_148,_149,_147);},load:function(data){if(data){_149=data;}_146(_148,_149,_147);}});}};}if(!dojo._hasResource["dojox.off.sync"]){dojo._hasResource["dojox.off.sync"]=true;dojo.provide("dojox.off.sync");dojo.mixin(dojox.off.sync,{isSyncing:false,cancelled:false,successful:true,details:[],error:false,actions:null,autoSync:true,onSync:function(type){},synchronize:function(){if(this.isSyncing||dojox.off.goingOnline||(!dojox.off.isOnline)){return;}this.isSyncing=true;this.successful=false;this.details=[];this.cancelled=false;this.start();},cancel:function(){if(!this.isSyncing){return;}this.cancelled=true;if(dojox.off.files.refreshing){dojox.off.files.abortRefresh();}this.onSync("cancel");},finishedDownloading:function(_14d,_14e){if(typeof _14d=="undefined"){_14d=true;}if(!_14d){this.successful=false;this.details.push(_14e);this.error=true;}this.finished();},start:function(){if(this.cancelled){this.finished();return;}this.onSync("start");this.refreshFiles();},refreshFiles:function(){if(this.cancelled){this.finished();return;}this.onSync("refreshFiles");dojox.off.files.refresh(dojo.hitch(this,function(_14f,_150){if(_14f){this.error=true;this.successful=false;for(var i=0;i<_150.length;i++){this.details.push(_150[i]);}}this.upload();}));},upload:function(){if(this.cancelled){this.finished();return;}this.onSync("upload");dojo.connect(this.actions,"onReplayFinished",this,this.download);this.actions.replay();},download:function(){if(this.cancelled){this.finished();return;}this.onSync("download");},finished:function(){this.isSyncing=false;this.successful=(!this.cancelled&&!this.error);this.onSync("finished");},_save:function(_152){this.actions._save(function(){_152();});},_load:function(_153){this.actions._load(function(){_153();});}});dojo.declare("dojox.off.sync.ActionLog",null,{entries:[],reasonHalted:null,isReplaying:false,autoSave:true,add:function(_154){if(this.isReplaying){throw "Programming error: you can not call "+"dojox.off.sync.actions.add() while "+"we are replaying an action log";}this.entries.push(_154);if(this.autoSave){this._save();}},onReplay:function(_155,_156){},length:function(){return this.entries.length;},haltReplay:function(_157){if(!this.isReplaying){return;}if(_157){this.reasonHalted=_157.toString();}if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});}else{this.isReplaying=false;this.onReplayFinished();}},continueReplay:function(){if(!this.isReplaying){return;}this.entries.shift();if(!this.entries.length){if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});return;}else{this.isReplaying=false;this.onReplayFinished();return;}}var _15a=this.entries[0];this.onReplay(_15a,this);},clear:function(){if(this.isReplaying){return;}this.entries=[];if(this.autoSave){this._save();}},replay:function(){if(this.isReplaying){return;}this.reasonHalted=null;if(!this.entries.length){this.onReplayFinished();return;}this.isReplaying=true;var _15b=this.entries[0];this.onReplay(_15b,this);},onReplayFinished:function(){},toString:function(){var _15c="";_15c+="[";for(var i=0;i<this.entries.length;i++){_15c+="{";for(var j in this.entries[i]){_15c+=j+": \""+this.entries[i][j]+"\"";_15c+=", ";}_15c+="}, ";}_15c+="]";return _15c;},_save:function(_15f){if(!_15f){_15f=function(){};}try{var self=this;var _161=function(_162,key,_164){if(_162==dojox.storage.FAILED){dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:key,value:_164,namespace:dojox.off.STORAGE_NAMESPACE});_15f();}else{if(_162==dojox.storage.SUCCESS){_15f();}}};dojox.storage.put("actionlog",this.entries,_161,dojox.off.STORAGE_NAMESPACE);}catch(exp){console.debug("dojox.off.sync._save: "+exp.message||exp);dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:"actionlog",value:this.entries,namespace:dojox.off.STORAGE_NAMESPACE});_15f();}},_load:function(_165){var _166=dojox.storage.get("actionlog",dojox.off.STORAGE_NAMESPACE);if(!_166){_166=[];}this.entries=_166;_165();}});dojox.off.sync.actions=new dojox.off.sync.ActionLog();}if(!dojo._hasResource["dojox.off._common"]){dojo._hasResource["dojox.off._common"]=true;dojo.provide("dojox.off._common");dojo.mixin(dojox.off,{isOnline:false,NET_CHECK:5,STORAGE_NAMESPACE:"_dot",enabled:true,availabilityURL:dojo.moduleUrl("dojox","off/network_check.txt"),goingOnline:false,coreOpFailed:false,doNetChecking:true,hasOfflineCache:null,browserRestart:false,_STORAGE_APP_NAME:window.location.href.replace(/[^0-9A-Za-z_]/g,"_"),_initializeCalled:false,_storageLoaded:false,_pageLoaded:false,onLoad:function(){},onNetwork:function(type){},initialize:function(){this._initializeCalled=true;if(this._storageLoaded&&this._pageLoaded){this._onLoad();}},goOffline:function(){if((dojox.off.sync.isSyncing)||(this.goingOnline)){return;}this.goingOnline=false;this.isOnline=false;},goOnline:function(_168){if(dojox.off.sync.isSyncing||dojox.off.goingOnline){return;}this.goingOnline=true;this.isOnline=false;this._isSiteAvailable(_168);},onFrameworkEvent:function(type,_16a){if(type=="save"){if(_16a.isCoreSave&&(_16a.status==dojox.storage.FAILED)){dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}}else{if(type=="coreOperationFailed"){dojox.off.coreOpFailed=true;dojox.off.enabled=false;}}},_checkOfflineCacheAvailable:function(_16b){this.hasOfflineCache=dojo.isGears;_16b();},_onLoad:function(){dojox.off.files.cache(dojo.moduleUrl("dojo","dojo.js"));this._cacheDojoResources();dojox.off.files.cache(dojox.storage.manager.getResourceList());dojox.off.files._slurp();this._checkOfflineCacheAvailable(dojo.hitch(this,"_onOfflineCacheChecked"));},_onOfflineCacheChecked:function(){if(this.hasOfflineCache&&this.enabled){this._load(dojo.hitch(this,"_finishStartingUp"));}else{if(this.hasOfflineCache&&!this.enabled){this._finishStartingUp();}else{this._keepCheckingUntilInstalled();}}},_keepCheckingUntilInstalled:function(){this._finishStartingUp();},_finishStartingUp:function(){if(!this.hasOfflineCache){this.onLoad();}else{if(this.enabled){this._startNetworkThread();this.goOnline(dojo.hitch(this,function(){dojox.off.onLoad();}));}else{if(this.coreOpFailed){this.onFrameworkEvent("coreOperationFailed");}else{this.onLoad();}}}},_onPageLoad:function(){this._pageLoaded=true;if(this._storageLoaded&&this._initializeCalled){this._onLoad();}},_onStorageLoad:function(){this._storageLoaded=true;if(!dojox.storage.manager.isAvailable()&&dojox.storage.manager.isInitialized()){this.coreOpFailed=true;this.enabled=false;}if(this._pageLoaded&&this._initializeCalled){this._onLoad();}},_isSiteAvailable:function(_16c){dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){this.goingOnline=false;this.isOnline=false;if(_16c){_16c(false);}}),load:dojo.hitch(this,function(data){this.goingOnline=false;this.isOnline=true;if(_16c){_16c(true);}else{this.onNetwork("online");}})});},_startNetworkThread:function(){if(!this.doNetChecking){return;}window.setInterval(dojo.hitch(this,function(){var d=dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){if(this.isOnline){this.isOnline=false;try{if(typeof d.ioArgs.xhr.abort=="function"){d.ioArgs.xhr.abort();}}catch(e){}dojox.off.sync.isSyncing=false;this.onNetwork("offline");}}),load:dojo.hitch(this,function(data){if(!this.isOnline){this.isOnline=true;this.onNetwork("online");}})});}),this.NET_CHECK*1000);},_getAvailabilityURL:function(){var url=this.availabilityURL.toString();if(url.indexOf("?")==-1){url+="?";}else{url+="&";}url+="browserbust="+new Date().getTime();return url;},_onOfflineCacheInstalled:function(){this.onFrameworkEvent("offlineCacheInstalled");},_cacheDojoResources:function(){var _173=true;dojo.forEach(dojo.query("script"),function(i){var src=i.getAttribute("src");if(!src){return;}if(src.indexOf("_base/_loader/bootstrap.js")!=-1){_173=false;}});if(!_173){dojox.off.files.cache(dojo.moduleUrl("dojo","_base.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/loader.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/bootstrap.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/hostenv_browser.js").uri);}for(var i=0;i<dojo._loadedUrls.length;i++){dojox.off.files.cache(dojo._loadedUrls[i]);}},_save:function(){},_load:function(_177){dojox.off.sync._load(_177);}});dojox.storage.manager.addOnLoad(dojo.hitch(dojox.off,"_onStorageLoad"));dojo.addOnLoad(dojox.off,"_onPageLoad");}if(!dojo._hasResource["dojox.off"]){dojo._hasResource["dojox.off"]=true;dojo.provide("dojox.off");}if(!dojo._hasResource["dojox.off.ui"]){dojo._hasResource["dojox.off.ui"]=true;dojo.provide("dojox.off.ui");dojo.mixin(dojox.off.ui,{appName:"setme",autoEmbed:true,autoEmbedID:"dot-widget",runLink:window.location.href,runLinkTitle:"Run Application",learnHowPath:dojo.moduleUrl("dojox","off/resources/learnhow.html"),customLearnHowPath:false,htmlTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.html").uri,cssTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.css").uri,onlineImagePath:dojo.moduleUrl("dojox","off/resources/greenball.png").uri,offlineImagePath:dojo.moduleUrl("dojox","off/resources/redball.png").uri,rollerImagePath:dojo.moduleUrl("dojox","off/resources/roller.gif").uri,checkmarkImagePath:dojo.moduleUrl("dojox","off/resources/checkmark.png").uri,learnHowJSPath:dojo.moduleUrl("dojox","off/resources/learnhow.js").uri,_initialized:false,onLoad:function(){},_initialize:function(){if(this._validateAppName(this.appName)==false){alert("You must set dojox.off.ui.appName; it can only contain "+"letters, numbers, and spaces; right now it "+"is incorrectly set to '"+dojox.off.ui.appName+"'");dojox.off.enabled=false;return;}this.runLinkText="Run "+this.appName;dojo.connect(dojox.off,"onNetwork",this,"_onNetwork");dojo.connect(dojox.off.sync,"onSync",this,"_onSync");dojox.off.files.cache([this.htmlTemplatePath,this.cssTemplatePath,this.onlineImagePath,this.offlineImagePath,this.rollerImagePath,this.checkmarkImagePath]);if(this.autoEmbed){this._doAutoEmbed();}},_doAutoEmbed:function(){dojo.xhrGet({url:this.htmlTemplatePath,handleAs:"text",error:function(err){dojox.off.enabled=false;err=err.message||err;alert("Error loading the Dojo Offline Widget from "+this.htmlTemplatePath+": "+err);},load:dojo.hitch(this,this._templateLoaded)});},_templateLoaded:function(data){var _17a=dojo.byId(this.autoEmbedID);if(_17a){_17a.innerHTML=data;}this._initImages();this._updateNetIndicator();this._initLearnHow();this._initialized=true;if(!dojox.off.hasOfflineCache){this._showNeedsOfflineCache();return;}if(dojox.off.hasOfflineCache&&dojox.off.browserRestart){this._needsBrowserRestart();return;}else{var _17b=dojo.byId("dot-widget-browser-restart");if(_17b){_17b.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._onNetwork(dojox.off.isOnline?"online":"offline");this._testNet();},_testNet:function(){dojox.off.goOnline(dojo.hitch(this,function(_17c){this._onNetwork(_17c?"online":"offline");this.onLoad();}));},_updateNetIndicator:function(){var _17d=dojo.byId("dot-widget-network-indicator-online");var _17e=dojo.byId("dot-widget-network-indicator-offline");var _17f=dojo.byId("dot-widget-title-text");if(_17d&&_17e){if(dojox.off.isOnline==true){_17d.style.display="inline";_17e.style.display="none";}else{_17d.style.display="none";_17e.style.display="inline";}}if(_17f){if(dojox.off.isOnline){_17f.innerHTML="Online";}else{_17f.innerHTML="Offline";}}},_initLearnHow:function(){var _180=dojo.byId("dot-widget-learn-how-link");if(!_180){return;}if(!this.customLearnHowPath){var _181=djConfig.baseRelativePath;this.learnHowPath+="?appName="+encodeURIComponent(this.appName)+"&hasOfflineCache="+dojox.off.hasOfflineCache+"&runLink="+encodeURIComponent(this.runLink)+"&runLinkText="+encodeURIComponent(this.runLinkText)+"&baseRelativePath="+encodeURIComponent(_181);dojox.off.files.cache(this.learnHowJSPath);dojox.off.files.cache(this.learnHowPath);}_180.setAttribute("href",this.learnHowPath);var _182=dojo.byId("dot-widget-learn-how-app-name");if(!_182){return;}_182.innerHTML="";_182.appendChild(document.createTextNode(this.appName));},_validateAppName:function(_183){if(!_183){return false;}return (/^[a-z0-9 ]*$/i.test(_183));},_updateSyncUI:function(){var _184=dojo.byId("dot-roller");var _185=dojo.byId("dot-success-checkmark");var _186=dojo.byId("dot-sync-messages");var _187=dojo.byId("dot-sync-details");var _188=dojo.byId("dot-sync-cancel");if(dojox.off.sync.isSyncing){this._clearSyncMessage();if(_184){_184.style.display="inline";}if(_185){_185.style.display="none";}if(_186){dojo.removeClass(_186,"dot-sync-error");}if(_187){_187.style.display="none";}if(_188){_188.style.display="inline";}}else{if(_184){_184.style.display="none";}if(_188){_188.style.display="none";}if(_186){dojo.removeClass(_186,"dot-sync-error");}}},_setSyncMessage:function(_189){var _18a=dojo.byId("dot-sync-messages");if(_18a){while(_18a.firstChild){_18a.removeChild(_18a.firstChild);}_18a.appendChild(document.createTextNode(_189));}},_clearSyncMessage:function(){this._setSyncMessage("");},_initImages:function(){var _18b=dojo.byId("dot-widget-network-indicator-online");if(_18b){_18b.setAttribute("src",this.onlineImagePath);}var _18c=dojo.byId("dot-widget-network-indicator-offline");if(_18c){_18c.setAttribute("src",this.offlineImagePath);}var _18d=dojo.byId("dot-roller");if(_18d){_18d.setAttribute("src",this.rollerImagePath);}var _18e=dojo.byId("dot-success-checkmark");if(_18e){_18e.setAttribute("src",this.checkmarkImagePath);}},_showDetails:function(evt){evt.preventDefault();evt.stopPropagation();if(!dojox.off.sync.details.length){return;}var html="";html+="<html><head><title>Sync Details</title><head><body>";html+="<h1>Sync Details</h1>\n";html+="<ul>\n";for(var i=0;i<dojox.off.sync.details.length;i++){html+="<li>";html+=dojox.off.sync.details[i];html+="</li>";}html+="</ul>\n";html+="<a href='javascript:window.close()' "+"style='text-align: right; padding-right: 2em;'>"+"Close Window"+"</a>\n";html+="</body></html>";var _192="height=400,width=600,resizable=true,"+"scrollbars=true,toolbar=no,menubar=no,"+"location=no,directories=no,dependent=yes";var _193=window.open("","SyncDetails",_192);if(!_193){alert("Please allow popup windows for this domain; can't display sync details window");return;}_193.document.open();_193.document.write(html);_193.document.close();if(_193.focus){_193.focus();}},_cancel:function(evt){evt.preventDefault();evt.stopPropagation();dojox.off.sync.cancel();},_needsBrowserRestart:function(){var _195=dojo.byId("dot-widget-browser-restart");if(_195){dojo.addClass(_195,"dot-needs-browser-restart");}var _196=dojo.byId("dot-widget-browser-restart-app-name");if(_196){_196.innerHTML="";_196.appendChild(document.createTextNode(this.appName));}var _197=dojo.byId("dot-sync-status");if(_197){_197.style.display="none";}},_showNeedsOfflineCache:function(){var _198=dojo.byId("dot-widget-container");if(_198){dojo.addClass(_198,"dot-needs-offline-cache");}},_hideNeedsOfflineCache:function(){var _199=dojo.byId("dot-widget-container");if(_199){dojo.removeClass(_199,"dot-needs-offline-cache");}},_initMainEvtHandlers:function(){var _19a=dojo.byId("dot-sync-details-button");if(_19a){dojo.connect(_19a,"onclick",this,this._showDetails);}var _19b=dojo.byId("dot-sync-cancel-button");if(_19b){dojo.connect(_19b,"onclick",this,this._cancel);}},_setOfflineEnabled:function(_19c){var _19d=[];_19d.push(dojo.byId("dot-sync-status"));for(var i=0;i<_19d.length;i++){if(_19d[i]){_19d[i].style.visibility=(_19c?"visible":"hidden");}}},_syncFinished:function(){this._updateSyncUI();var _19f=dojo.byId("dot-success-checkmark");var _1a0=dojo.byId("dot-sync-details");if(dojox.off.sync.successful==true){this._setSyncMessage("Sync Successful");if(_19f){_19f.style.display="inline";}}else{if(dojox.off.sync.cancelled==true){this._setSyncMessage("Sync Cancelled");if(_19f){_19f.style.display="none";}}else{this._setSyncMessage("Sync Error");var _1a1=dojo.byId("dot-sync-messages");if(_1a1){dojo.addClass(_1a1,"dot-sync-error");}if(_19f){_19f.style.display="none";}}}if(dojox.off.sync.details.length&&_1a0){_1a0.style.display="inline";}},_onFrameworkEvent:function(type,_1a3){if(type=="save"){if(_1a3.status==dojox.storage.FAILED&&!_1a3.isCoreSave){alert("Please increase the amount of local storage available "+"to this application");if(dojox.storage.hasSettingsUI()){dojox.storage.showSettingsUI();}}}else{if(type=="coreOperationFailed"){console.log("Application does not have permission to use Dojo Offline");if(!this._userInformed){alert("This application will not work if Google Gears is not allowed to run");this._userInformed=true;}}else{if(type=="offlineCacheInstalled"){this._hideNeedsOfflineCache();if(dojox.off.hasOfflineCache==true&&dojox.off.browserRestart==true){this._needsBrowserRestart();return;}else{var _1a4=dojo.byId("dot-widget-browser-restart");if(_1a4){_1a4.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._testNet();}}}},_onSync:function(type){switch(type){case "start":this._updateSyncUI();break;case "refreshFiles":this._setSyncMessage("Downloading UI...");break;case "upload":this._setSyncMessage("Uploading new data...");break;case "download":this._setSyncMessage("Downloading new data...");break;case "finished":this._syncFinished();break;case "cancel":this._setSyncMessage("Canceling Sync...");break;default:dojo.warn("Programming error: "+"Unknown sync type in dojox.off.ui: "+type);break;}},_onNetwork:function(type){if(!this._initialized){return;}this._updateNetIndicator();if(type=="offline"){this._setSyncMessage("You are working offline");var _1a7=dojo.byId("dot-sync-details");if(_1a7){_1a7.style.display="none";}this._updateSyncUI();}else{if(dojox.off.sync.autoSync){window.setTimeout("dojox.off.sync.synchronize()",1000);}}}});dojo.connect(dojox.off,"onFrameworkEvent",dojox.off.ui,"_onFrameworkEvent");dojo.connect(dojox.off,"onLoad",dojox.off.ui,dojox.off.ui._initialize);}if(!dojo._hasResource["dojox.off.offline"]){dojo._hasResource["dojox.off.offline"]=true;dojo.provide("dojox.off.offline");}
