/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.commons.field;

import java.util.ArrayList;

/**
 * 携帯電話用の入力フィールドを表すクラス（年月日用）です。 <br />
 * 
 */
public class ALCellDateField extends ALDateField {

  /**
   * コンストラクタ
   * 
   */
  public ALCellDateField() {
    super();
  }

  /**
   * コンストラクタ
   * 
   * @param container
   */
  public ALCellDateField(ALDateContainer container) {
    super(container);
  }

  /**
   * 入力フィールド値を検証します。
   * 
   * @param msgList
   * @return
   */
  public boolean validate(ArrayList msgList) {
    if (msgList == null) {
      msgList = new ArrayList();
    }

    if (!isNotNullValue()) {
      if (isNotNull()) {
        msgList.add("『 " + fieldName + " 』を入力してください。");
        return false;
      }
    } else {
      try {
        value.getDate();
      } catch (NumberFormatException ex) {
        msgList.add("『 " + fieldName + " 』を正しく入力してください。");
        return false;
      } catch (ALIllegalDateException ex) {
        msgList.add(" 『 " + fieldName + " 』を正しく入力してください。");
        return false;
      }
    }
    return true;
  }
}
