/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.circulation;

import java.util.ArrayList;
import java.util.List;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 回覧板のResultDataです。 <BR>
 * 
 */
public class CirculationDetailResultData extends CirculationResultData {

  /** メモ */
  private ALStringField note;

  /** 更新日 */
  private ALStringField update_date;

  /** 確認コメント情報 */
  private List<CirculationResponseRecordData> responseRecords;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  @Override
  public void initField() {
    super.initField();
    note = new ALStringField();
    note.setTrim(false);
    update_date = new ALStringField();
    responseRecords = new ArrayList<CirculationResponseRecordData>();
  }
  
  /**
   * @return
   */
  @Override
  public String getNote() {
    return ALEipUtils.getMessageList(note.getValue());
  }

  public List<CirculationResponseRecordData> getResponseRecords() {
    return responseRecords;
  }

  /**
   * @param string
   */
  @Override
  public void setNote(String string) {
    note.setValue(string);
  }

  /**
   * @return
   */
  @Override
  public ALStringField getUpdateDate() {
    return update_date;
  }

  /**
   * @param string
   */
  @Override
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }

  public void setResponseRecords(List<CirculationResponseRecordData> list) {
    responseRecords.addAll(list);
  }

}
