/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

dojo.provide("aipo.circulation");
dojo.require("aipo.widget.MemberNormalSelectList");
dojo.require("dijit.form.ComboBox");
dojo.require("aipo.widget.DropdownDatepicker");

aipo.circulation.onLoadCirculationDialog = function(portlet_id){

  var obj = dojo.byId("circulation_name");
  if(obj){
     obj.focus();
  }
  
  var mpicker = dijit.byId("membernormalselect");
  if(mpicker){
    var select = dojo.byId('init_memberlist');
    var i;
    var s_o = select.options;
    if (s_o.length == 1 && s_o[0].value == "") return;
    for(i = 0 ; i < s_o.length; i ++ ) {
        mpicker.addOptionSync(s_o[i].value,s_o[i].text,true);
    }
  } 
}

aipo.circulation.onChangeNote = function(){
	document.getElementById("isChangedNote").checked = true;
}

aipo.circulation.onChangeSelecter = function(portletId , url , values, named , flgName){

    if(aipo.circulation.NoteChangeConfirm(flgName)){
        document.getElementById(flgName).checked = false;
        var callbackArgs = new Array();
        callbackArgs["named"] = named;
        aimluck.io.sendRawData(url + "&value=" + values,values,aipo.circulation.setTemplate,callbackArgs);
    }
    return false;	
}

aipo.circulation.setTemplate = function(array,rtnData){
        document.getElementsByName(array["named"])[0].value = rtnData["type"].toString().slice(3,-3);	
}

aipo.circulation.NoteChangeConfirm = function(flgName){

    if(document.getElementById(flgName).checked){
      if(!confirm( '申請内容は変更されています\n分類を変更すると内容が消えてしまいますがよろしいですか？')){
        return false;
      }
    }
    return true;
}

aipo.circulation.onReceiveMessage = function(msg){

    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('circulation');
    }
    if (dojo.byId('messageDiv')) {
        dojo.byId('messageDiv').innerHTML = msg;
    }
    
}

aipo.circulation.onListReceiveMessage = function(msg){
  
    if(!msg) {
        var arrDialog = dijit.byId("modalDialog");
        if(arrDialog){
            arrDialog.hide();
        }
        aipo.portletReload('circulation');
    }
    if (dojo.byId('listmessageDiv')) {
        dojo.byId('listmessageDiv').innerHTML = msg;
    }
    
}

aipo.circulation.onFocusComment = function(portlet_id){
    
}

aipo.circulation.submit_list = function(form) {
  var s_o = form.member_to.options;
  var tmp = '';

  for(i = 0 ; i < s_o.length; i++ ) {
    s_o[i].selected = false;
  }

  if(s_o.length > 0) {
    for(i = 0 ; i < s_o.length-1; i++ ) {
      tmp = tmp + s_o[i].value + ',';
    }
    tmp = tmp + s_o[s_o.length-1].value;
  }
  form.positions.value = tmp;
}

aipo.circulation.onConfirm = function(portletId){

    var form = dojo.byId("circulationForm"+portletId);
    aipo.circulation._portletId = portletId;
    form.mode.value = "confirm";
}
