/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.whereaboutsinformation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTWhereaboutsinformation;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whereaboutsinformation.util.WhereaboutsInformationUtils;

/**
 * WhereaboutsInformationのフォームデータを管理するクラスです。 <BR>
 * 
 */
public class WhereaboutsInformationPermitFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(WhereaboutsInformationPermitFormData.class.getName());

  /** 他者変更可：P 他者変更不可：A */
  private ALStringField permission;

  /** 離席理由 */
  private ALStringField reason;

  /** <code>start_date</code> 開始日時 */
  private ALDateTimeField return_date;

  private DataContext dataContext;

  /** ログインユーザーのID * */
  private int user_id;

  /**
   * init
   * 
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractFormData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);

    user_id = ALEipUtils.getUserId(rundata);

    dataContext = DatabaseOrmService.getInstance().getDataContext();

  }

  /**
   * 各フィールドを初期化します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {

  }

  /**
   * WhereaboutsInformationの各フィールドに対する制約条件を設定します。 <BR>
   * 
   * @see com.aimluck.eip.common.ALAbstractFormData#setValidator()
   */
  protected void setValidator() {

  }

  /**
   * WhereaboutsInformationのフォームに入力されたデータの妥当性検証を行います。 <BR>
   * 
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#validate(java.util.ArrayList)
   */
  protected boolean validate(ArrayList msgList) {

    return (msgList.size() == 0);
  }

  public ALStringField getReason() {
    return reason;
  }

  /**
   * 開始日時を取得します。
   * 
   * @return
   */
  public ALDateTimeField getReturnDate() {
    return return_date;
  }

  /**
   * WhereaboutsInformationをデータベースから読み出します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#loadFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected boolean loadFormData(RunData rundata, Context context,
      ArrayList msgList) {
    return true;
  }

  /**
   * WhereaboutsInformationをデータベースから削除します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#deleteFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  protected boolean deleteFormData(RunData rundata, Context context,
      ArrayList msgList) {
    return true;
  }

  /**
   * WhereaboutsInformationをデータベースに格納します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#insertFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean insertFormData(RunData rundata, Context context,
      ArrayList msgList) {
    return true;
  }

  /**
   * データベースに格納されているWhereaboutsInformationを更新します。 <BR>
   * 
   * @param rundata
   * @param context
   * @param msgList
   * @return TRUE 成功 FALSE 失敗
   * @see com.aimluck.eip.common.ALAbstractFormData#updateFormData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context, java.util.ArrayList)
   */
  protected boolean updateFormData(RunData rundata, Context context,
      ArrayList msgList) {
    try {
      // TODO レコードが無ければ追加、有れば更新を行なう。
      // レコードはユーザーIDに引っ掛けましょう。
      SelectQuery query = new SelectQuery(AvzTWhereaboutsinformation.class);
      Expression exp = ExpressionFactory.matchExp(
          AvzTWhereaboutsinformation.USER_ID_PROPERTY, Integer
              .valueOf(ALEipUtils.getUserId(rundata)));
      query.setQualifier(exp);
      List list = dataContext.performQuery(query);

      // user_idに紐づくレコードが存在するかどうか
      if (!(list.size() == 0)) {

        // 更新
        AvzTWhereaboutsinformation info = WhereaboutsInformationUtils
            .getAvzTwhereaboutsinformation(rundata, context);
        if (info == null)
          return false;

        info.setUpdateDate(Calendar.getInstance().getTime());
        // 他者入力変更
        String per = info.getPermission();
        if (per == null || per.equals("") || per.equals(WhereaboutsInformationUtils.PERMISSION_OFF)) {
          info.setPermission(WhereaboutsInformationUtils.PERMISSION_ON);
        } else {
          info.setPermission(WhereaboutsInformationUtils.PERMISSION_OFF);
        }

      } else {

        // 追加
        AvzTWhereaboutsinformation info = (AvzTWhereaboutsinformation) dataContext
            .createAndRegisterNewObject(AvzTWhereaboutsinformation.class);

        // 自動採取→info.setWhereaboutsinformationId(id);
        info.setUserId((Integer) ALEipUtils.getUserId(rundata));
        info.setCreateDate(Calendar.getInstance().getTime());
        info.setPermission(WhereaboutsInformationUtils.PERMISSION_ON);
        info.setStatus(WhereaboutsInformationUtils.STATUS_PRESENCE);
        info.setUpdateDate(Calendar.getInstance().getTime());
      }

      dataContext.commitChanges();

    } catch (Exception e) {
      dataContext.rollbackChanges();
      logger.error("Exception", e);
      return false;
    }
    return true;
  }

  /**
   * WhereaboutsInformation名を取得します。 <BR>
   * 
   * @return
   */
  public ALStringField getWhereaboutsInformationName() {
    return reason;
  }
}
