/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whereaboutsinformation;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTWhereaboutsinformation;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whereaboutsinformation.util.WhereaboutsInformationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WhereaboutsInformationFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhereaboutsInformationFormData.class.getName());
    private ALStringField status;
    private ALStringField reason;
    private ALDateTimeField return_date;
    private ALDateTimeField now_date;
    private DataContext dataContext;
    private int user_id;
    private int vmUserId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String vmUserIdStr = rundata.getParameters().getString("vmUserId");
        if (StringUtils.isNotEmpty((String)vmUserIdStr)) {
            this.setVmUserId(Integer.parseInt(vmUserIdStr));
        }
        this.user_id = ALEipUtils.getUserId((RunData)rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.status = new ALStringField();
        this.reason = new ALStringField();
        this.reason.setFieldName("\u96e2\u5e2d\u7406\u7531");
        this.reason.setTrim(true);
        this.return_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        Calendar cal = Calendar.getInstance();
        cal.set(1, cal.get(1));
        cal.set(2, cal.get(2));
        cal.set(5, cal.get(5));
        cal.set(7, cal.get(7));
        cal.set(12, cal.get(12));
        int min = cal.get(12);
        int hour = cal.get(11);
        if (55 <= min && min <= 59) {
            ++hour;
        }
        cal.set(11, hour);
        this.return_date.setValue(cal.getTime());
        this.return_date.setFieldName("\u623b\u308a\u65e5\u6642");
    }

    protected void setValidator() {
        this.reason.limitMaxLength(99);
    }

    protected boolean validate(ArrayList msgList) {
        try {
            this.reason.validate(msgList);
            this.return_date.validate(msgList);
            this.now_date = new ALDateTimeField("yyyy-MM-dd-HH-mm");
            Calendar cal = Calendar.getInstance();
            cal.set(1, cal.get(1));
            cal.set(2, cal.get(2));
            cal.set(5, cal.get(5));
            cal.set(7, cal.get(7));
            cal.set(12, cal.get(12));
            cal.set(11, cal.get(11));
            this.now_date.setValue(cal.getTime());
            if (this.return_date.getValue().before(this.now_date.getValue())) {
                msgList.add("\u300e <span class='em'>\u623b\u308a\u6642\u9593</span> \u300f\u306f\u73fe\u5728\u65e5\u6642\u4ee5\u964d\u306e\u65e5\u6642\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
        return msgList.size() == 0;
    }

    public ALStringField getReason() {
        return this.reason;
    }

    public ALDateTimeField getReturnDate() {
        return this.return_date;
    }

    public int getUserId() {
        return this.user_id;
    }

    public void setUserId(int user_id) {
        this.user_id = user_id;
    }

    public int getVmUserId() {
        return this.vmUserId;
    }

    public void setVmUserId(int vmUserId) {
        this.vmUserId = vmUserId;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            this.reason.setValue("");
            this.return_date.setValue(this.return_date.getValue());
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            SelectQuery query = new SelectQuery(AvzTWhereaboutsinformation.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)this.vmUserId);
            query.setQualifier(exp);
            List list = this.dataContext.performQuery((Query)query);
            if (list.size() != 0) {
                AvzTWhereaboutsinformation info = WhereaboutsInformationUtils.getAvzTwhereaboutsinformationById(String.valueOf(this.vmUserId));
                if (info == null) {
                    return false;
                }
                if (this.user_id == info.getUserId()) {
                    info.setNote(this.reason.getValue());
                    info.setUpdateDate(Calendar.getInstance().getTime());
                    info.setReturnDate(this.return_date.getValue());
                    info.setStatus("A");
                } else if (info.getPermission().equals("P")) {
                    info.setNote(this.reason.getValue());
                    info.setUpdateDate(Calendar.getInstance().getTime());
                    info.setReturnDate(this.return_date.getValue());
                    info.setStatus("A");
                }
            } else {
                AvzTWhereaboutsinformation info = (AvzTWhereaboutsinformation)this.dataContext.createAndRegisterNewObject(AvzTWhereaboutsinformation.class);
                info.setUserId(ALEipUtils.getUserId((RunData)rundata));
                info.setCreateDate(Calendar.getInstance().getTime());
                info.setNote(this.reason.getValue());
                info.setPermission("A");
                info.setStatus("A");
                info.setUpdateDate(Calendar.getInstance().getTime());
                info.setReturnDate(this.return_date.getValue());
            }
            this.dataContext.commitChanges();
        }
        catch (Exception e) {
            this.dataContext.rollbackChanges();
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }
}

