/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.whereaboutsinformation;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTWhereaboutsinformation;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whereaboutsinformation.util.WhereaboutsInformationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WhereaboutsInformationStatFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WhereaboutsInformationStatFormData.class.getName());
    private ALStringField reason;
    private ALDateTimeField return_date;
    private DataContext dataContext;
    private int user_id;
    private int vmUserId;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String vmUserIdStr = rundata.getParameters().getString("vmUserId");
        if (StringUtils.isNotEmpty((String)vmUserIdStr)) {
            this.setVmUserId(Integer.parseInt(vmUserIdStr));
        } else {
            this.setVmUserId(ALEipUtils.getUserId((RunData)rundata));
        }
        this.user_id = ALEipUtils.getUserId((RunData)rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
    }

    protected void setValidator() {
    }

    protected boolean validate(ArrayList msgList) {
        return msgList.size() == 0;
    }

    public ALStringField getReason() {
        return this.reason;
    }

    public ALDateTimeField getReturnDate() {
        return this.return_date;
    }

    public int getUserId() {
        return this.user_id;
    }

    public void setUserId(int user_id) {
        this.user_id = user_id;
    }

    public int getVmUserId() {
        return this.vmUserId;
    }

    public void setVmUserId(int vmUserId) {
        this.vmUserId = vmUserId;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            if (this.vmUserId == 0) {
                this.vmUserId = ALEipUtils.getUserId((RunData)rundata);
            }
            SelectQuery query = new SelectQuery(AvzTWhereaboutsinformation.class);
            Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)this.vmUserId);
            query.setQualifier(exp);
            List list = this.dataContext.performQuery((Query)query);
            if (list.size() != 0) {
                AvzTWhereaboutsinformation info = WhereaboutsInformationUtils.getAvzTwhereaboutsinformationById(String.valueOf(this.vmUserId));
                if (info == null) {
                    return false;
                }
                if (this.user_id == info.getUserId()) {
                    info.setNote("");
                    info.setUpdateDate(Calendar.getInstance().getTime());
                    info.setStatus("P");
                } else if (info.getPermission().equals("P")) {
                    info.setNote("");
                    info.setUpdateDate(Calendar.getInstance().getTime());
                    info.setStatus("P");
                }
            } else {
                AvzTWhereaboutsinformation info = (AvzTWhereaboutsinformation)this.dataContext.createAndRegisterNewObject(AvzTWhereaboutsinformation.class);
                info.setUserId(ALEipUtils.getUserId((RunData)rundata));
                info.setCreateDate(Calendar.getInstance().getTime());
                info.setNote(this.reason.getValue());
                info.setPermission("A");
                info.setStatus("A");
                info.setUpdateDate(Calendar.getInstance().getTime());
                info.setReturnDate(this.return_date.getValue());
            }
            this.dataContext.commitChanges();
        }
        catch (Exception e) {
            this.dataContext.rollbackChanges();
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public ALStringField getWhereaboutsInformationName() {
        return this.reason;
    }
}

