/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.intramail;

import java.util.List;
import java.util.jar.Attributes;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTIntramail;
import com.aimluck.eip.cayenne.om.portlet.auto._AvzTIntramail;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.intramail.util.IntraMailUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 下書きトレイを管理するクラスです。 <BR>
 * 
 */
public class IntraMailDraftSelectData extends ALAbstractSelectData implements ALData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(IntraMailDraftSelectData.class.getName());

  /** ログインユーザーのID * */
  private int login_user_id;
  
  /** 標準画面モードか？ */
  private boolean isBuildNormal = true;
  
  /** 下書きか？・・・詳細画面の表示の切り替え用フラグ */
  private boolean isDraft = true;

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractSelectData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    
    super.init(action, rundata, context);
    
    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    if (sort == null || sort.equals("")) {
      String sortStr = ALEipUtils.getPortlet(rundata, context)
          .getPortletConfig().getInitParameter("p4a-sort");
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, sortStr);
      if ("update_date".equals(sortStr)) {
        ALEipUtils.setTemp(rundata, context, LIST_SORT_TYPE_STR, "desc");
      }

      logger.debug("[IntraMailDraftSelectData] Init Parameter. : "
          + ALEipUtils.getPortlet(rundata, context).getPortletConfig()
              .getInitParameter("p4a-sort"));
    }

    login_user_id = ALEipUtils.getUserId(rundata);

  }


  /**
   * 一覧データを取得します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   * @see com.aimluck.eip.common.ALAbstractListData#selectData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public List selectList(RunData rundata, Context context) {
    try {
      DataContext dataContext = DatabaseOrmService.getInstance()
          .getDataContext();

      SelectQuery query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      buildSelectQueryForListViewSort(query, rundata, context);

      List list = dataContext.performQuery(query);
      return buildPaginatedList(list);
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   */
  private SelectQuery getSelectQuery(RunData rundata, Context context) {
    
    SelectQuery query = new SelectQuery(AvzTIntramail.class);
    Expression exp01 = ExpressionFactory.matchExp(
        _AvzTIntramail.OWNER_ID_PROPERTY, login_user_id);
        
    query.setQualifier(exp01);
    
    Expression exp02 = ExpressionFactory.matchExp(
        _AvzTIntramail.SEND_FLG_PROPERTY, "F");
    
    query.andQualifier(exp02);

    return buildSelectQueryForFilter(query, rundata, context);
  }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   * 
   * @param obj
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getListData(java.lang.Object)
   */
  @Override
  protected Object getResultData(Object obj) {
    try {
      AvzTIntramail mail = (AvzTIntramail) obj;
      
      IntraMailResultData rd = new IntraMailResultData();
      rd.initField();
      rd.setMailId(mail.getIntramailId().toString());
      rd.setSubject(ALCommonUtils.compressString(mail.getSubject(),getStrLength()));  
      rd.setPerson(ALEipUtils.getUserFullName(mail.getOwnerId()));
      rd.setFileVolume(mail.getMailVolume().toString());
      rd.setDest(ALCommonUtils.compressString(IntraMailUtils.getDestNames(mail), 15));
      rd.setCreateDate(IntraMailUtils.translateDate(mail.getCreateDate(),
          "yyyy年M月d日"));
      rd.setUpdateDate(IntraMailUtils.translateDate(mail.getUpdateDate(), 
          "yyyy年M月d日H時m分"));
      
      return rd;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      ex.printStackTrace();
      return null;
    }
  }

  /**
   * 詳細データを取得します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public Object selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    try {
      AvzTIntramail mail = 
        IntraMailUtils.getAvzTIntramail(rundata, context);
      return mail;
    } catch (ALPageNotFoundException pageNotFound) {
      throw pageNotFound;
    }
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   * 
   * @param obj
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultDataDetail(java.lang.Object)
   */
  @Override
  protected Object getResultDataDetail(Object obj) {
    return IntraMailUtils.getResultDataDetail(obj, login_user_id, null);
  }
  
  /**
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getColumnMap()
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    
    //Sort処理用
    map.putValue("subject", _AvzTIntramail.SUBJECT_PROPERTY);
    map.putValue("update_date", _AvzTIntramail.UPDATE_DATE_PROPERTY);

    return map;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return null;
  }
  
  public boolean isBuildNormal() {
    return isBuildNormal;
  }


  public void setBuildNormal(boolean isBuildNormal) {
    this.isBuildNormal = isBuildNormal;
  }
  
	public boolean isDraft() {
		return isDraft;
	}
}
