/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2008 Aimluck,Inc.
 * http://aipostyle.com/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.intramail.util;

import java.util.Calendar;
import java.util.List;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

import com.aimluck.eip.cayenne.om.portlet.EipTWhatsNew;
import com.aimluck.eip.orm.DatabaseOrmService;

/**
 * WhatsNewのユーティリティクラスです。 <BR>
 * 
 */
public class IntraMailWhatsNewUtils {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(IntraMailWhatsNewUtils.class.getName());

  /** table識別用 */
  public static final int WHATS_NEW_TYPE_INTRAMAIL = 99;

  /** table識別用? */
  public static final int INDIVIDUAL_WHATS_NEW = -1;

  /**
   * 新着情報追加(個別新着情報)
   * 
   * @param dataContext
   *          <code>DataContext</code>
   * @param type
   *          種別
   * @param entityid
   *          エンティティID
   * @param uid
   *          ユーザID
   */
  public static void insertWhatsNew(DataContext dataContext, int type,
      int entityid, int uid) {
    EipTWhatsNew entry = null;
    SelectQuery query = null;
    try {
      query = new SelectQuery(EipTWhatsNew.class);
      Expression exp = ExpressionFactory.matchExp(
          EipTWhatsNew.PORTLET_TYPE_PROPERTY, Integer.valueOf(type));
      query.setQualifier(exp);
      Expression exp1 = ExpressionFactory.matchExp(
          EipTWhatsNew.USER_ID_PROPERTY, Integer.valueOf(uid));
      query.andQualifier(exp1);
      Expression exp2 = ExpressionFactory.matchExp(
          EipTWhatsNew.ENTITY_ID_PROPERTY, Integer.valueOf(entityid));
      query.andQualifier(exp2);
      Expression exp3 = ExpressionFactory.matchExp(
          EipTWhatsNew.PARENT_ID_PROPERTY, Integer
              .valueOf(INDIVIDUAL_WHATS_NEW));
      query.andQualifier(exp3);
      List<?> entries = dataContext.performQuery(query);
      if (entries == null || entries.size() < 1) {
        // 新規オブジェクトモデル
        entry = (EipTWhatsNew) dataContext
            .createAndRegisterNewObject(EipTWhatsNew.class);
        entry.setCreateDate(Calendar.getInstance().getTime());
        entry.setEntityId(entityid);
        entry.setPortletType(Integer.valueOf(type));
        entry.setParentId(Integer.valueOf(INDIVIDUAL_WHATS_NEW));
      } else {
        entry = (EipTWhatsNew) entries.get(0);
      }
      entry.setUpdateDate(Calendar.getInstance().getTime());
      entry.setUserId(Integer.valueOf(uid));
    } catch (Exception e) {
      logger.error("Exception", e);
    }
  }

  /**
   * 既読フラグを追加(個別新着用)
   * 
   * @param type
   *          種別
   * @param entityid
   *          エンティティID
   * @param uid
   *          ユーザID
   */
  public static void shiftWhatsNewReadFlag(int type, int entityid, int uid) {
    DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
    SelectQuery query = null;

    query = new SelectQuery(EipTWhatsNew.class);
    Expression exp = ExpressionFactory.matchExp(
        EipTWhatsNew.PORTLET_TYPE_PROPERTY, Integer.valueOf(type));
    query.setQualifier(exp);
    Expression exp1 = ExpressionFactory.matchExp(EipTWhatsNew.USER_ID_PROPERTY,
        Integer.valueOf(uid));
    query.andQualifier(exp1);
    Expression exp2 = ExpressionFactory.matchExp(
        EipTWhatsNew.ENTITY_ID_PROPERTY, Integer.valueOf(entityid));
    query.andQualifier(exp2);
    Expression exp3 = ExpressionFactory.matchExp(
        EipTWhatsNew.PARENT_ID_PROPERTY, Integer.valueOf("-1"));
    query.andQualifier(exp3);

    List<?> entries = dataContext.performQuery(query);
    if (entries != null && entries.size() > 0) {
      dataContext.deleteObjects(entries);
    }
    //dataContext.commitChanges();
  }
}
