/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.rss.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.rss.RssResultData;
import com.aimluck.eip.rss.UrlResultData;
import com.aimluck.eip.util.ALCommonUtils;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import com.sun.syndication.io.FeedException;

/**
 * RSSのユーティリティクラスです <br />
 */
public class RssUtils {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(RssUtils.class.getName());

  /** タイトルパラメータの接頭語 */
  private static final String TITLE = "title";

  /** URLパラメータの接頭語 */
  private static final String LINK = "link";
  
  /** 
   * RSS配信URLの一覧取得
   * PSMLファイルより取得します。
   */
  public static List<UrlResultData> getTitles(PortletConfig config, RunData rundata) {
    // ResultDataのリスト
    List<UrlResultData> linkList = new ArrayList<UrlResultData>();
    try {
      for (int i = 1; i < 11; i++) {
        StringBuffer sb = new StringBuffer();
        UrlResultData rd = new UrlResultData();
        rd.initField();
        sb.append("p").append(Integer.toHexString(i)).append("a-")
            .append(TITLE).append(Integer.toHexString(i));
        String title = config.getInitParameter(sb.toString());
        sb = new StringBuffer();
        sb.append("p").append(Integer.toHexString(i)).append("b-").append(LINK)
            .append(Integer.toHexString(i));
        String link = config.getInitParameter(sb.toString());

        if (title != null && (!title.equals(""))) {
          rd.setTitle(title);
        } else {
          rd.setTitle(link);
        }
        if (link != null && (!link.equals(""))) {
          rd.setLink(link);
          linkList.add(rd);
        }
        rd.setNo(String.valueOf(i));
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }
    return linkList;
  }
  
  /** 
   * RSS配信URLの一覧取得
   * PSMLファイルより取得します。
   */
  public static List<UrlResultData> getTitles(VelocityPortlet portlet, RunData rundata) {
    return getTitles(portlet.getPortletConfig(), rundata);
  }
  
  /** 
   * RSS配信元より記事一覧を取得します。
   */
  public static List<RssResultData> readRSS(String url, int strLength) {
    
    List<RssResultData> linkList = new ArrayList<RssResultData>();
    try {
      
      // HTTPを元にフィードを取得するクラス「FeedFetcher」 ………(1)
      FeedFetcher fetcher = new HttpURLFeedFetcher();

      // フィードの内容、フィードに含まれる記事エントリの内容を出力する
      SyndFeed feed = fetcher.retrieveFeed(new URL(url));

      //System.out.format("フィードタイトル:[%s] 著者:[%s]\n", feed.getTitle(), feed
      //    .getUri());

      for (SyndEntry entry : (List<SyndEntry>) feed.getEntries()) {
        RssResultData rd = new RssResultData();
        rd.initField();
        rd.setFeedTitle(feed.getTitle());
        rd.setTitle(ALCommonUtils.compressString(entry.getTitle(), strLength));
        rd.setLink(entry.getLink());
        rd.setPublishedDate(entry.getPublishedDate());
        //System.out.format("\t更新時刻:[%s] URL:[%s] 記事タイトル:[%s]\n", entry
        //    .getPublishedDate(), entry.getLink(), entry.getTitle());
        linkList.add(rd);
      }
      
    } catch (IllegalArgumentException e) {
      // TODO 自動生成された catch ブロック
      e.printStackTrace();
    } catch (MalformedURLException e) {
      // TODO 自動生成された catch ブロック
      e.printStackTrace();
    } catch (IOException e) {
      // TODO 自動生成された catch ブロック
      e.printStackTrace();
    } catch (FeedException e) {
      // TODO 自動生成された catch ブロック
      e.printStackTrace();
    } catch (FetcherException e) {
      // TODO 自動生成された catch ブロック
      e.printStackTrace();
    } catch (Exception e) {
      // TODO 自動生成された catch ブロック
      e.printStackTrace();
    }
    return linkList;
  }
}
