/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.intramail;

import java.util.ArrayList;
import java.util.List;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.intramail.beans.ReceiveUserBean;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 社内メール詳細画面データ <BR>
 * 
 */
public class IntraMailDetailResultData extends IntraMailResultData {
  
  /** 本文 */
  private ALStringField body;
  
  /** 宛先ユーザーリスト */
  private List<ReceiveUserBean> receiveUserBeans;
  
  /** 添付ファイルリスト */
  private List<FileuploadBean> attachmentFileList = null;

  @Override
  public void initField() {
    super.initField();
    body = new ALStringField();
    attachmentFileList = new ArrayList<FileuploadBean>();
  }
  
  /**
   * @param string
   */
  public void setBody(String string) {
    body.setValue(string);
  }

  /**
   * @param string
   */
  public String getBody() {
    return ALEipUtils.getMessageList(body.getValue());
  }
  
  /**
   * @param list
   */
  public void setAttachmentFiles(List<FileuploadBean> list) {
    attachmentFileList = list;
  }
  
  /**
   * @return list
   */
  public List<FileuploadBean> getAttachmentFileList() {
    return attachmentFileList;
  }

  public List<ReceiveUserBean> getReceiveUserBeans() {
    return receiveUserBeans;
  }

  public void setReceiveUserBeans(List<ReceiveUserBean> receiveUserBeans) {
    this.receiveUserBeans = receiveUserBeans;
  }
}
