/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.actions.circulation;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.circulation.CirculationCategorySelectData;
import com.aimluck.eip.circulation.CirculationSelectData;
import com.aimluck.eip.util.ALEipUtils;


/**
 * 回覧板のアクションクラスです。 <BR>
 * 
 */
public class CirculationAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(CirculationAction.class.getName());

  /**
   * 通常表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // セッション情報のクリア
    clearCirculationSession(rundata, context);

    CirculationSelectData listData = new CirculationSelectData();
    listData.initField();
    listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("p1a-rows")));
    listData.setStrLength(Integer.parseInt(portlet.getPortletConfig()
        .getInitParameter("p3a-strlen")));
    listData.doViewList(this, rundata, context);
    
    setTemplate(rundata, "circulation");
  }

  /**
   * 最大化表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    try {
      if (getMode() == null) {
        doCirculation_list(rundata, context);
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }
  }

  /**
   * Circulationを一覧表示します。 <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doCirculation_list(RunData rundata, Context context) throws Exception {
    CirculationSelectData listData = new CirculationSelectData();
    listData.initField();
    listData.loadCategoryList(rundata, context);
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1b-rows")));
    listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet(rundata,
        context).getPortletConfig().getInitParameter("p3a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "circulation-list");
  }
  
  /**
   * カテゴリを一覧表示します。 <BR>
   * 
   * @param rundata
   * @param context
   * @throws Exception 
   */
  public void doCirculation_category_list(RunData rundata, Context context)
      throws Exception {
    CirculationCategorySelectData listData = new CirculationCategorySelectData();
    listData.initField();
    listData.setRowsNum(Integer.parseInt(ALEipUtils
        .getPortlet(rundata, context).getPortletConfig().getInitParameter(
            "p1a-rows")));
    listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet(rundata,
        context).getPortletConfig().getInitParameter("p3a-strlen")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "circulation-category-list");
  }

  private void clearCirculationSession(RunData rundata, Context context) {
    List list = new ArrayList();
    // エンティティIDの初期化
    list.add("entityid");
    // 選択しているタブ情報の削除
    list.add("tab");
    ALEipUtils.removeTemp(rundata, context, list);
  }

}
