/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.extcabinet;

import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.extcabinet.ExtCabinetFolderResultData;
import com.aimluck.eip.extcabinet.ExtCabinetFolderSelectData;
import com.aimluck.eip.extcabinet.util.ExtCabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.AvzTCabinetFolder;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 文書管理のフォルダ詳細データを管理するためのクラスです。 <br />
 * ※フォルダ詳細画面を表示するために使用します。
 */
public class ExtCabinetFolderSelectData extends ALAbstractSelectData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(ExtCabinetFolderSelectData.class.getName());

  /** フォルダ情報一覧 */
  private List<ExtFolderInfo> folder_hierarchy_list;

  int folder_id = 0;

  private RunData rundata;

  /**
   *
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractSelectData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
  	
  	super.init(action, rundata, context);
  	
    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    if (sort == null || sort.equals("")) {
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, ALEipUtils
          .getPortlet(rundata, context).getPortletConfig().getInitParameter(
              "p3c-sort"));
      logger.debug("[CabinetSelectData] Init Parameter. : "
          + ALEipUtils.getPortlet(rundata, context).getPortletConfig()
              .getInitParameter("p3c-sort"));
    }

    folder_hierarchy_list = ExtCabinetUtils.getFolderList(ExtCabinetUtils.ROOT_PARENT_FODLER_ID);
    //members = new ArrayList();
    this.rundata = rundata;

    // 自ポートレットからのリクエストであれば、パラメータを展開しセッションに保存する。
    if (ALEipUtils.isMatch(rundata, context)) {
      // ENTITY ID
      if (rundata.getParameters().containsKey(ExtCabinetUtils.REQUEST_KEY_FOLDER_ID)) {
        // entityid=new を指定することによって明示的にセッション変数を削除することができる。
        ALEipUtils.setTemp(rundata, context, ExtCabinetUtils.SESSION_KEY_FOLDER_ID,
            rundata.getParameters().getString(ExtCabinetUtils.REQUEST_KEY_FOLDER_ID));
      }
    }
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectList(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  protected List selectList(RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  protected Object selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    // オブジェクトモデルを取得
    return ExtCabinetUtils.getAvzTCabinetFolder(rundata, context);
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultData(java.lang.Object)
   */
  @Override
  protected Object getResultData(Object obj) throws ALPageNotFoundException,
      ALDBErrorException {
    return null;
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultDataDetail(java.lang.Object)
   */
  @Override
  protected Object getResultDataDetail(Object obj)
      throws ALPageNotFoundException, ALDBErrorException {

    try {
      AvzTCabinetFolder record = (AvzTCabinetFolder) obj;

      folder_id = record.getFolderId().intValue();

      ExtCabinetFolderResultData rd = new ExtCabinetFolderResultData();
      rd.initField();
      rd.setFolderId(record.getFolderId().longValue());
      rd.setFolderName(record.getFolderName());
      rd.setNote(record.getNote());
      rd.setPosition(ExtCabinetUtils.getFolderPosition(folder_hierarchy_list,
          folder_id));

      String createUserName = "";
      ALEipUser createUser = ALEipUtils.getALEipUser(record.getCreateUserId()
          .intValue());
      if (createUser != null) {
        createUserName = createUser.getAliasName().getValue();
      }

      rd.setCreateUser(createUserName);
      rd.setCreateDate(ALDateUtil.format(record.getCreateDate(), "yyyy年M月d日"));
      String updateUserName = "";
      ALEipUser updateUser = ALEipUtils.getALEipUser(record.getUpdateUserId()
          .intValue());
      if (updateUser != null) {
        updateUserName = updateUser.getAliasName().getValue();
      }

      rd.setUpdateUser(updateUserName);
      rd.setUpdateDate(ALDateUtil.format(record.getUpdateDate(), "yyyy年M月d日"));

      Integer folder_id = record.getFolderId();
      Integer user_id = record.getCreateUserId();        
      List<String> aclHandle = ExtCabinetUtils.getFolderAclHandle(rundata, folder_id, user_id);
      rd.setisFolderCreatable(ExtCabinetUtils.isFolderCreatable(aclHandle));
      rd.setisFileCreatable(ExtCabinetUtils.isFileCreatable(aclHandle));
      rd.setisReadable(ExtCabinetUtils.isReadable(aclHandle));
      rd.setisWritable(ExtCabinetUtils.isWritable(aclHandle));
      rd.setisDeletable(ExtCabinetUtils.isDeletable(aclHandle));

      return rd;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * @see com.aimluck.eip.common.ALAbstractSelectData#getColumnMap()
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    return map;
  }

  public int getFolderId() {
    return folder_id;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   *
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return null;
  }
}
