/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.extcabinet;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 文書管理のフォルダのResultDataです。 <BR>
 *
 */
public class ExtCabinetFolderResultData implements ALData {

  /** Folder ID */
  private ALNumberField folder_id;

  /** フォルダ名 */
  private ALStringField folder_name;

  /** フォルダ位置 */
  private String position;

  /** メモ */
  private ALStringField note;

  /** 登録者名 */
  private ALStringField create_user;

  /** 更新者名 */
  private ALStringField update_user;

  /** 登録日 */
  private ALStringField create_date;

  /** 更新日 */
  private ALStringField update_date;
  
  /** フォルダ作成権限 */
  private boolean is_foldercreatable;
  
  /** ファイル作成権限 */
  private boolean is_filecreatable;
  
  /** 参照権限 */
  private boolean is_readable;
  
  /** 編集権限 */
  private boolean is_writable;
  
  /** 削除権限 */
  private boolean is_deletable;

  /**
   *
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    folder_id = new ALNumberField();
    folder_name = new ALStringField();
    note = new ALStringField();
    note.setTrim(false);
    create_user = new ALStringField();
    update_user = new ALStringField();
    create_date = new ALStringField();
    update_date = new ALStringField();
    is_foldercreatable = false;
    is_filecreatable = false;
    is_readable = false;
    is_writable = false;
    is_deletable = false;
  }

  /**
   * @return
   */
  public ALNumberField getFolderId() {
    return folder_id;
  }

  /**
   * @return
   */
  public ALStringField getFolderName() {
    return folder_name;
  }

  /**
   * @param i
   */
  public void setFolderId(long i) {
    folder_id.setValue(i);
  }

  /**
   * @param string
   */
  public void setFolderName(String string) {
    folder_name.setValue(string);
  }

  public String getPosition() {
    return position;
  }

  public void setPosition(String str) {
    position = str;
  }

  /**
   * @return
   */
  public String getNote() {
    return ALEipUtils.getMessageList(note.getValue());
  }

  /**
   * @param string
   */
  public void setNote(String string) {
    note.setValue(string);
  }

  public ALStringField getCreateUser() {
    return create_user;
  }

  public void setCreateUser(String str) {
    create_user.setValue(str);
  }

  public ALStringField getUpdateUser() {
    return update_user;
  }

  public void setUpdateUser(String str) {
    update_user.setValue(str);
  }

  /**
   * @return
   */
  public ALStringField getCreateDate() {
    return create_date;
  }

  /**
   * @return
   */
  public ALStringField getUpdateDate() {
    return update_date;
  }

  /**
   * @param string
   */
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  /**
   * @param string
   */
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }
  
  public void setisFolderCreatable(boolean b) {
    this.is_foldercreatable = b;
  }
  public boolean isFolderCreatable() {
    return is_foldercreatable;
  }
	public void setisFileCreatable(boolean is_filecreatable) {
		this.is_filecreatable = is_filecreatable;
	}
	public boolean isFileCreatable() {
		return is_filecreatable;
	}
  public void setisReadable(boolean b) {
    this.is_readable = b;
  }
  public boolean isReadable() {
    return is_readable;
  }
  public void setisWritable(boolean b) {
    this.is_writable = b;
  }
  public boolean isWritable() {
    return is_writable;
  }
  public void setisDeletable(boolean b) {
    this.is_deletable = b;
  }
  public boolean isDeletable() {
    return is_deletable;
  }

}
