/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.actions.coordinationforgooglecal;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.coordinationforgooglecal.CoordinationForGoogleCalFormData;
import com.aimluck.eip.coordinationforgooglecal.CoordinationForGoogleCalInsertFormData;
import com.aimluck.eip.coordinationforgooglecal.CoordinationForGoogleCalSelectData;
import com.aimluck.eip.coordinationforgooglecal.util.CoordinationForGoogleCalUtils;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;


/**
 * CoordinationForGoogleCalのアクションクラスです。 <BR>
 * 
 */
public class CoordinationForGoogleCalAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(CoordinationForGoogleCalAction.class.getName());

  String act = null;
  String view_type = null;

  /**
   * 通常表示の際の処理を記述します。 <BR>
   * 
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildNormalContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {
    act = rundata.getParameters().getString("act");
    view_type = "nomal_view";

    if ("reading".equals(act)) {
      doSchedule_reading_ics(rundata, context);
    }else if("insert".equals(act)){
      doSchedule_import_ics(rundata, context);
    }else{
      // セッション情報のクリア
      clearCoordinationforgooglecalSession(rundata, context);

      CoordinationForGoogleCalSelectData listData = new CoordinationForGoogleCalSelectData();
      listData.initField();
      listData.doViewList(this, rundata, context);

      setTemplate(rundata, "coordinationforgooglecal");      

    }

  }
  
  /**
   * 最大化表示の際の処理を記述します。<BR>
   * @param portlet
   * @param context
   * @param rundata
   * @see org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction#buildMaximizedContext(org.apache.jetspeed.portal.portlets.VelocityPortlet,
   *      org.apache.velocity.context.Context, org.apache.turbine.util.RunData)
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {

    // MODEを取得
    try {
      
      act = rundata.getParameters().getString("act");
      view_type = "list_view";

      if ("reading".equals(act)) {
        doSchedule_reading_ics(rundata, context);
      }else if("insert".equals(act)){
        doSchedule_import_ics(rundata, context);
      }else{
        if (getMode() == null) {
          doCoordination_for_google_cal_list(portlet, rundata, context);
          setTemplate(rundata, "coordinationforgooglecal-list");
        }
      }

    } catch (Exception ex) {
      logger.error("Exception", ex);
    }
  }
  
  /**
   * 最大化画面を表示します。
   * @param rundata
   * @param context
   */
  public void doCoordination_for_google_cal_list(VelocityPortlet portlet, RunData rundata, Context context) throws Exception {
    CoordinationForGoogleCalSelectData listData = new CoordinationForGoogleCalSelectData();
    listData.initField();
    listData.doViewList(this, rundata, context);
  }
  
  

  protected void doSchedule_reading_ics(RunData rundata, Context context)throws Exception {

    CoordinationForGoogleCalFormData formData = new CoordinationForGoogleCalFormData();
    formData.initField();
    CoordinationForGoogleCalUtils.doIcsInsert(this, rundata, context,formData);

    context.put("temp_folder", formData.getTempFolderIndex());
    context.put("time_change", rundata.getParameters().getString("time_change"));
    context.put("view_date_year_from", rundata.getParameters().getInt("view_date_year_from"));
    context.put("view_date_month_from", rundata.getParameters().getInt("view_date_month_from"));
    context.put("view_date_year_to", rundata.getParameters().getInt("view_date_year_to"));
    context.put("view_date_month_to", rundata.getParameters().getInt("view_date_month_to"));
    context.put("from_date", rundata.getParameters().getString("from_date"));
    context.put("to_date", rundata.getParameters().getString("to_date"));
    String pr = rundata.getParameters().getString("period");
    if(pr == null){
      pr = "";
    }
    context.put("period", pr);

    if("list_view".equals(view_type)){
      setTemplate(rundata, "coordinationforgooglecal-list");      
    }else{
      setTemplate(rundata, "coordinationforgooglecal");      
    }
  }
  
  
  protected void doSchedule_import_ics(RunData rundata, Context context)throws Exception {
 
    CoordinationForGoogleCalInsertFormData formData = new CoordinationForGoogleCalInsertFormData();
    formData.initField();
    formData.doInsert(this, rundata, context);
        
    if("list_view".equals(view_type)){
      setTemplate(rundata, "coordinationforgooglecal-list");      
    }else{
      setTemplate(rundata, "coordinationforgooglecal");      
    }
  }
  
  
  
  private void clearCoordinationforgooglecalSession(RunData rundata, Context context) {
    List list = new ArrayList();
    // エンティティIDの初期化
    list.add("entityid");
    // 選択しているタブ情報の削除
    list.add("tab");
    ALEipUtils.removeTemp(rundata, context, list);
  }

}
