/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.whereaboutsinformation;

import com.aimluck.commons.field.ALStringField;

/**
 * 行先板のResultData（名前と場所）です。 <br />
 */
public class WhereaboutsInformationResultData {

  /** 居場所 */
  private ALStringField place = null;

  /** スケジュールID */
  private ALStringField scheduleId = null;

  /** ユーザーID */
  private ALStringField userId = null;

  /** 公開フラグ */
  private boolean publicable = true;

  /** メンバーフラグ */
  private boolean member = true;

  /** 日付 */
  private ALStringField date;

  /**
   * @see com.aimluck.eip.common.ALData#initField()
   */
  // オブジェクトのフィールドを初期化するメソッドです。
  public void initField() {
    userId = new ALStringField();
    scheduleId = new ALStringField();
    place = new ALStringField();
    place.setValue("スケジュール記載無し");
    date = new ALStringField();
  }

  // 以下getとset
  /**
   * @return
   */
  public ALStringField getUserId() {
    return userId;
  }

  /**
   * @return
   */
  public ALStringField getScheduleId() {
    return scheduleId;
  }

  /**
   * @return
   */
  public ALStringField getPlace() {
    return place;
  }

  /**
   * @param field
   */
  public void setScheduleId(String field) {
    scheduleId.setValue(field);
  }

  /**
   * @param field
   */
  public void setPlace(String field) {
    place.setValue(field);
  }

  /**
   * @param field
   */
  public void setUserId(String field) {
    userId.setValue(field);
  }

  public boolean isPublicable() {
    return publicable;
  }

  public void setPublicable(boolean publicable) {
    this.publicable = publicable;
  }

  public boolean isMember() {
    return member;
  }

  public void setMember(boolean member) {
    this.member = member;
  }

  public ALStringField getDate() {
    return date;
  }

  public void setDate(String field) {
    date.setValue(field);
  }
}
