/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.intramail;

import java.util.jar.Attributes;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.AvzTIntramail;
import com.aimluck.eip.cayenne.om.portlet.AvzTIntramailMap;
import com.aimluck.eip.cayenne.om.portlet.auto._AvzTIntramail;
import com.aimluck.eip.cayenne.om.portlet.auto._AvzTIntramailMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.intramail.util.IntraMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 受信トレイデータを管理するクラスです。 <BR>
 * 
 */
public class IntraMailReceiveSelectData extends
    ALAbstractSelectData<AvzTIntramailMap, AvzTIntramail> implements ALData {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(IntraMailReceiveSelectData.class
      .getName());

  /** ログインユーザーのID * */
  private int login_user_id;

  /** 標準画面モードか？ */
  private boolean isBuildNormal = true;

  /** 下書きか？・・・詳細画面の表示の切り替え用フラグ */
  private final boolean isDraft = false;

  // private String map_id;

  /**
   * 
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractSelectData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {

    super.init(action, rundata, context);

    String sort = ALEipUtils.getTemp(rundata, context, LIST_SORT_STR);
    if (sort == null || sort.equals("")) {
      String sortStr =
        ALEipUtils
          .getPortlet(rundata, context)
          .getPortletConfig()
          .getInitParameter("p2a-sort");
      ALEipUtils.setTemp(rundata, context, LIST_SORT_STR, sortStr);
      if ("update_date".equals(sortStr)) {
        ALEipUtils.setTemp(rundata, context, LIST_SORT_TYPE_STR, "desc");
      }

      logger.debug("[IntraMailReceiveSelectData] Init Parameter. : "
        + ALEipUtils
          .getPortlet(rundata, context)
          .getPortletConfig()
          .getInitParameter("p2a-sort"));
    }

    login_user_id = ALEipUtils.getUserId(rundata);

  }

  /**
   * 一覧データを取得します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   * @see com.aimluck.eip.common.ALAbstractListData#selectData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public ResultList<AvzTIntramailMap> selectList(RunData rundata,
      Context context) {
    try {
      SelectQuery<AvzTIntramailMap> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      buildSelectQueryForListViewSort(query, rundata, context);
      return query.getResultList();
    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   */
  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   */
  private SelectQuery<AvzTIntramailMap> getSelectQuery(RunData rundata,
      Context context) {

    SelectQuery<AvzTIntramailMap> query =
      Database.query(AvzTIntramailMap.class);
    Expression exp01 =
      ExpressionFactory.matchExp(
        _AvzTIntramailMap.USER_ID_PROPERTY,
        login_user_id);

    query.setQualifier(exp01);

    Expression exp02 =
      ExpressionFactory.matchExp(
        _AvzTIntramailMap.TRANSMISSION_CLS_PROPERTY,
        IntraMailUtils.TRANSMISSION_CLS_RECEIVE);

    query.andQualifier(exp02);

    Expression exp03 =
      ExpressionFactory.matchExp(
        _AvzTIntramailMap.VIEW_FLG_PROPERTY,
        IntraMailUtils.VIEW_FLG_VISIBLE);

    query.andQualifier(exp03);

    Expression exp04 =
      ExpressionFactory.matchExp(
        _AvzTIntramailMap.DISABLED_PROPERTY,
        IntraMailUtils.AVAILABLE);

    query.andQualifier(exp04);

    return buildSelectQueryForFilter(query, rundata, context);
  }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   * 
   * @param obj
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getListData(java.lang.Object)
   */
  @Override
  protected Object getResultData(AvzTIntramailMap obj) {
    try {
      AvzTIntramailMap record = obj;
      AvzTIntramail mail = record.getToAvzTIntramail();

      IntraMailResultData rd = new IntraMailResultData();
      rd.initField();
      rd.setMailId(mail.getIntramailId().toString());
      rd.setMapId(record.getId().toString());
      rd.setSubject(ALCommonUtils.compressString(
        mail.getSubject(),
        getStrLength()));
      rd.setPerson(ALEipUtils.getUserFullName(mail.getOwnerId()));
      rd.setFileVolume(mail.getMailVolume().toString());
      if (mail.getAvzTIntramailFileArray().size() > 0) {
        rd.hasAttachments(true);
      }

      if (rd.hasAttachments()) {
        rd.setWithFilesImage("images/intramail/intramail_withfiles.gif");
        rd.setWithFilesImageDescription("添付有");
      }

      if (IntraMailUtils.READ_FLG_READ.equals(record.getReadFlg())) {
        rd.setReadImage("images/intramail/intramail_readmail.gif");
        rd.setReadImageDescription("既読");
      } else {
        rd.setReadImage("images/intramail/intramail_unreadmail.gif");
        rd.setReadImageDescription("未読");
      }

      rd.setCreateDate(IntraMailUtils.translateDate(
        record.getCreateDate(),
        "yyyy年M月d日"));
      rd.setUpdateDate(IntraMailUtils.translateDate(
        record.getUpdateDate(),
        "yyyy年M月d日H時m分"));

      return rd;
    } catch (Exception ex) {
      logger.error("Exception", ex);
      ex.printStackTrace();
      return null;
    }
  }

  /**
   * 詳細データを取得します。 <BR>
   * 
   * @param rundata
   * @param context
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public AvzTIntramail selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    try {
      AvzTIntramail mail = IntraMailUtils.getAvzTIntramail(rundata, context);
      return mail;
    } catch (ALPageNotFoundException pageNotFound) {
      throw pageNotFound;
    }
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   * 
   * @param obj
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultDataDetail(java.lang.Object)
   */
  @Override
  protected Object getResultDataDetail(AvzTIntramail obj) {
    return IntraMailUtils.getResultDataDetail(
      obj,
      login_user_id,
      IntraMailUtils.TRANSMISSION_CLS_RECEIVE);
  }

  /**
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getColumnMap()
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();

    // Sort処理用
    map.putValue("read_flg", _AvzTIntramailMap.READ_FLG_PROPERTY);
    map.putValue("subject", _AvzTIntramailMap.TO_AVZ_TINTRAMAIL_PROPERTY
      + "."
      + _AvzTIntramail.SUBJECT_PROPERTY);
    map.putValue("person", _AvzTIntramailMap.TO_AVZ_TINTRAMAIL_PROPERTY
      + "."
      + _AvzTIntramail.OWNER_ID_PROPERTY);
    map.putValue("update_date", _AvzTIntramailMap.UPDATE_DATE_PROPERTY);

    return map;
  }

  /**
   * アクセス権限チェック用メソッド。<br />
   * アクセス権限の機能名を返します。
   * 
   * @return
   */
  @Override
  public String getAclPortletFeature() {
    return null;
  }

  public boolean isBuildNormal() {
    return isBuildNormal;
  }

  public void setBuildNormal(boolean isBuildNormal) {
    this.isBuildNormal = isBuildNormal;
  }

  public boolean isDraft() {
    return isDraft;
  }

  public int getLoginUserId() {
    return login_user_id;
  }

  public int getCountUnRead() {

    try {

      DataContext dataContext =
        DatabaseOrmService.getInstance().getDataContext();

      SelectQuery<AvzTIntramailMap> query =
        Database.query(AvzTIntramailMap.class);
      Expression exp01 =
        ExpressionFactory.matchExp(
          _AvzTIntramailMap.USER_ID_PROPERTY,
          login_user_id);

      query.setQualifier(exp01);

      Expression exp02 =
        ExpressionFactory.matchExp(
          _AvzTIntramailMap.TRANSMISSION_CLS_PROPERTY,
          IntraMailUtils.TRANSMISSION_CLS_RECEIVE);

      query.andQualifier(exp02);

      Expression exp03 =
        ExpressionFactory.matchExp(
          _AvzTIntramailMap.VIEW_FLG_PROPERTY,
          IntraMailUtils.VIEW_FLG_VISIBLE);

      query.andQualifier(exp03);

      Expression exp04 =
        ExpressionFactory.matchExp(
          _AvzTIntramailMap.DISABLED_PROPERTY,
          IntraMailUtils.AVAILABLE);

      query.andQualifier(exp04);

      Expression exp05 =
        ExpressionFactory.matchExp(
          _AvzTIntramailMap.READ_FLG_PROPERTY,
          IntraMailUtils.READ_FLG_UNREAD);

      query.andQualifier(exp05);

      ResultList<AvzTIntramailMap> list = query.getResultList();
      if (list == null || list.size() == 0) {
        logger.debug("[IntraMailUtils] Not found ID...");
        return 0;
      }

      return list.size();

    } catch (Exception ex) {
      ex.printStackTrace();
      logger.error("Exception", ex);
      return 0;
    }
  }
}
