/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * LunchOrderFormのResultDataです。 <BR>
 * 
 */
public class LunchOrderInputFormResultData implements ALData {
  /** 商品ID */
  private ALNumberField itemId;

  /** お弁当名 */
  private ALStringField itemName;

  /** 価格 */
  private ALNumberField itemPrice;

  /** コメント */
  private ALStringField comment;

  /** 項番表示・非表示ステータス */
  private ALNumberField item_number_status;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    itemName = new ALStringField();
    itemPrice = new ALNumberField();
    comment = new ALStringField();
    item_number_status = new ALNumberField();
    itemId = new ALNumberField();
  }

  public ALStringField getItemName() {
    return itemName;
  }

  public void setItemName(String string) {
    itemName.setValue(string);
  }

  /**
   * @return
   */
  public ALNumberField getItemPrice() {
    return itemPrice;
  }

  /**
   * @param i
   */
  public void setItemPrice(int i) {
    itemPrice.setValue(i);
  }

  /**
   * @return
   */
  public ALStringField getComment() {
    return comment;
  }

  /**
   * @param string
   */
  public void setComment(String string) {
    comment.setValue(string);
  }

  /**
   * 
   * @return
   */
  public ALNumberField getItemNumberStatus() {
    return item_number_status;
  }

  /**
   * @param i
   */
  public void setitemNumberStatus(int i) {
    item_number_status.setValue(i);
  }

  /**
   * 
   * @return
   */
  public ALNumberField getItemId() {
    return itemId;
  }

  /**
   * @param i
   */
  public void setItemId(int i) {
    itemId.setValue(i);
  }
}
