/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import net.sf.json.JSONArray;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.lunchorder.LunchOrderConfirmationFormData;

/**
 * 注文入力内容確認画面のﾃﾞｰﾀをJSONデータとして出力するクラスです。<br />
 * 
 */
public class LunchOrderConfirmationJSONScreen extends ALJSONScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(LunchOrderConfirmationJSONScreen.class.getName());

  String result = new JSONArray().toString();

  String mode = this.getMode();

  protected String getJSONString(RunData rundata, Context context)
      throws Exception {

    try {
      LunchOrderConfirmationFormData formData = new LunchOrderConfirmationFormData();
      formData.initField();//フィールド初期化
      formData.insertFormData(rundata, context);//DBにinsert処理

    } catch (Exception e) {
      logger.error("[LunchOrderInpuｔFormJSONScreen]", e);
    }
    return result;
  }
}
