/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.coordinationforgooglecal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.ExDate;
import net.fortuna.ical4j.model.property.RRule;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.AvzTCoordinationForGoogleCal;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.coordinationforgooglecal.CoordinationForGoogleCalFormData;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;

/**
 * CoordinationForGoogleCalのユーティリティクラスです。 <BR>
 * 
 */
public class CoordinationForGoogleCalUtils {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(CoordinationForGoogleCalUtils.class
      .getName());

  /** SUMMARY */
  public static final String PROPERTY_NAME_SUMMARY = "SUMMARY";

  /** LOCATION */
  public static final String PROPERTY_NAME_LOCATION = "LOCATION";

  /** DESCRPTION */
  public static final String PROPERTY_NAME_DESCRIPTION = "DESCRIPTION";

  /** CLASS */
  public static final String PROPERTY_NAME_CLASS = "CLASS";

  /** PRIVATE */
  public static final String PROPERTY_NAME_PRIVATE = "PRIVATE";

  /** CREATED */
  public static final String PROPERTY_NAME_CREATED = "CREATED";

  /** LAST-MODIFIED */
  public static final String PROPERTY_NAME_LAST_MODIFIED = "LAST-MODIFIED";

  /** RRULE */
  public static final String PROPERTY_NAME_RRULE = "RRULE";

  /** VALUE */
  public static final String PROPERTY_NAME_VALUE = "VALUE";

  /** DATE */
  public static final String PROPERTY_DATETIPE_DATE = "DATE";

  /** DTSTART */
  public static final String PROPERTY_NAME_DTSTART = "DTSTART";

  /** DTEND */
  public static final String PROPERTY_NAME_DTEND = "DTEND";

  /** EXDATE */
  public static final String PROPERTY_NAME_EXDATE = "EXDATE";

  /** (タイトルなし) */
  public static final String SCHEDULE_HAS_NOT_NAME = "(タイトルなし)";

  /** 空欄表示 */
  public static final String SPACE_DISPLAY = "";

  /** 終日予定 */
  public static final String SCHEDULE_AT_ALL_DAY = "終日予定";

  /** 繰り返しパターン(毎日) */
  public static final String RRULE_FREQ_DAILY = "DAILY";

  /** 繰り返しパターン(毎週) */
  public static final String RRULE_FREQ_WEEKLY = "WEEKLY";

  /** 繰り返しパターン(毎月) */
  public static final String RRULE_FREQ_MONTHLY = "MONTHLY";

  /** 繰り返しパターン(毎年) */
  public static final String RRULE_FREQ_YEARLY = "YEARLY";

  /** 繰り返しパターン(毎日)表示結果 */
  public static final String FREQ_DAYLY_RESULT = "毎日";

  /** 繰り返しパターン(毎週)表示結果 */
  public static final String FREQ_WEEKLY_RESULT = "毎週";

  /** 繰り返しパターン(毎月)表示結果 */
  public static final String FREQ_MONTHLY_RESULT = "毎月";

  /** 繰り返しパターン(毎年)表示結果 */
  public static final String FREQ_YEARLY_RESULT = "毎年";

  /** 繰り返しパターン(毎日)INTERVAL表示 */
  public static final String DAYLY_EVERY_VALUE = "日おき";

  /** 繰り返しパターン(毎週)INTERVAL表示 */
  public static final String WEEKLY_EVERY_VALUE = "週おき";

  /** 繰り返しパターン(毎月)INTERVAL表示 */
  public static final String MONTHLY_EVERY_VALUE = "ヶ月に１回";

  /** 繰り返しパターン(毎年)INTERVAL表示 */
  public static final String YEARLY_EVERY_VALUE = "年に１回";

  /** 曜日表記 月曜日 */
  public static final String ORTHOGRAPHY_MONDAY = "月";

  /** 曜日表記 火曜日 */
  public static final String ORTHOGRAPHY_TUESDAY = "火";

  /** 曜日表記 水曜日 */
  public static final String ORTHOGRAPHY_WEDNESDAY = "水";

  /** 曜日表記 木曜日 */
  public static final String ORTHOGRAPHY_THURSDAY = "木";

  /** 曜日表記 金曜日 */
  public static final String ORTHOGRAPHY_FRIDAY = "金";

  /** 曜日表記 土曜日 */
  public static final String ORTHOGRAPHY_SATURDAY = "土";

  /** 曜日表記 日曜日 */
  public static final String ORTHOGRAPHY_SUNDAY = "日";

  /** ICS一時保管フォルダ名 */
  public static final String ICS_TEMP_FOLDER =
    JetspeedResources.getString("aipo.tmp.directory", "")
      + System.getProperty("file.separator")
      + "ics";

  /** ICSファイルを一時保管するディレクトリの指定 */
  public static final String ICS_SCHEDULE_TEMP_FOLDER = "account_schedule";

  /** ICSファイルを一時保管するファイル名の指定 */
  public static final String FOLDER_TMP_FOR_USERINFO_ICS_FILENAME =
    "schedule_info.ics";

  /** P */
  public static final String INSERT_FLAG_P = "P";

  /** O */
  public static final String INSERT_FLAG_O = "O";

  /** T */
  public static final String INSERT_FLAG_T = "T";

  /** S */
  public static final String INSERT_FLAG_S = "S";

  /** U */
  public static final String INSERT_FLAG_U = "U";

  public static final String ERROR_FLAG_POSSIBLE = "可";

  public static final String ERROR_FLAG_IMPOSSIBLE = "不可";

  /** localhost */
  public static final String LOCAL_HOST = "localhost";

  public static final String VIEW_DATE_YEAR_FROM = "view_date_year_from";

  public static final String VIEW_DATE_YEAR_TO = "view_date_year_to";

  public static final String VIEW_DATE_MONTH_FROM = "view_date_month_from";

  public static final String VIEW_DATE_MONTH_TO = "view_date_month_to";

  /**
   * インポート・エクスポート時に 選択した日時の範囲を取得する
   * 
   * @param boolean
   * @return 選択範囲
   */
  public static boolean setTimeRange(RunData rundata, Context context,
      DateTime from_d, DateTime to_d, String time_select_flg) {

    Calendar select_form_time = Calendar.getInstance();
    Calendar select_to_time = Calendar.getInstance();

    if ("month_select".equals(time_select_flg)) {

      // インポート対象範囲の開始日に選択値をセット
      int form_year = rundata.getParameters().getInt("view_date_year_from");
      int from_month = rundata.getParameters().getInt("view_date_month_from");

      select_form_time.set(Calendar.YEAR, form_year);
      select_form_time.set(Calendar.MONTH, from_month - 1);

      int from_day = select_form_time.getActualMinimum(Calendar.DATE);
      int from_hour = select_form_time.getActualMinimum(Calendar.HOUR_OF_DAY);
      int from_minute = select_form_time.getActualMinimum(Calendar.MINUTE);
      int from_second = select_form_time.getActualMinimum(Calendar.SECOND);

      select_form_time.set(Calendar.DAY_OF_MONTH, from_day);
      select_form_time.set(Calendar.HOUR_OF_DAY, from_hour);
      select_form_time.set(Calendar.MINUTE, from_minute);
      select_form_time.set(Calendar.SECOND, from_second);

      from_d.setTime(select_form_time.getTime().getTime());

      // インポート対象範囲の終了日に選択値をセット
      int to_year = rundata.getParameters().getInt("view_date_year_to");
      int to_month = rundata.getParameters().getInt("view_date_month_to");

      select_to_time.set(Calendar.YEAR, to_year);
      select_to_time.set(Calendar.MONTH, to_month - 1);

      int to_day = select_to_time.getActualMaximum(Calendar.DATE);
      int to_hour = select_to_time.getActualMaximum(Calendar.HOUR_OF_DAY);
      int to_minute = select_to_time.getActualMaximum(Calendar.MINUTE);
      int to_second = select_to_time.getActualMaximum(Calendar.SECOND);

      select_to_time.set(Calendar.DAY_OF_MONTH, to_day);
      select_to_time.set(Calendar.HOUR_OF_DAY, to_hour);
      select_to_time.set(Calendar.MINUTE, to_minute);
      select_to_time.set(Calendar.SECOND, to_second);

      to_d.setTime(select_to_time.getTime().getTime());

    } else {

      // インポート対象範囲の開始日に選択値をセット
      int from_year = rundata.getParameters().getInt("from_date_year");
      int from_month = rundata.getParameters().getInt("from_date_month");
      int from_day = rundata.getParameters().getInt("from_date_day");

      select_form_time.set(from_year, from_month - 1, from_day);

      int from_hour = select_form_time.getActualMinimum(Calendar.HOUR_OF_DAY);
      int from_minute = select_form_time.getActualMinimum(Calendar.MINUTE);
      int from_second = select_form_time.getActualMinimum(Calendar.SECOND);

      select_form_time.set(Calendar.HOUR_OF_DAY, from_hour);
      select_form_time.set(Calendar.MINUTE, from_minute);
      select_form_time.set(Calendar.SECOND, from_second);

      from_d.setTime(select_form_time.getTime().getTime());

      // インポート対象範囲の終了日に選択値をセット
      int to_year = rundata.getParameters().getInt("to_date_year");
      int to_month = rundata.getParameters().getInt("to_date_month");
      int to_day = rundata.getParameters().getInt("to_date_day");

      select_to_time.set(to_year, to_month - 1, to_day);

      int to_hour = select_to_time.getActualMaximum(Calendar.HOUR_OF_DAY);
      int to_minute = select_to_time.getActualMaximum(Calendar.MINUTE);
      int to_second = select_to_time.getActualMaximum(Calendar.SECOND);

      select_to_time.set(Calendar.HOUR_OF_DAY, to_hour);
      select_to_time.set(Calendar.MINUTE, to_minute);
      select_to_time.set(Calendar.SECOND, to_second);

      to_d.setTime(select_to_time.getTime().getTime());

    }

    return true;
  }

  /**
   * 繰り返しパターンの情報を取得 インポート内容の表示
   * 
   * @param str
   * @return 繰り返しパターン
   */
  public static String getRepeatPatern(VEvent ve) {

    String repeatPatern = null;

    Property pro = ve.getProperty(PROPERTY_NAME_RRULE);
    RRule rrl = (RRule) pro;

    // FREQ要素をチェック
    String freq = rrl.getRecur().getFrequency();

    if (RRULE_FREQ_DAILY.equals(freq)) {
      repeatPatern = FREQ_DAYLY_RESULT;
    } else if (RRULE_FREQ_WEEKLY.equals(freq)) {
      repeatPatern = FREQ_WEEKLY_RESULT;
    } else if (RRULE_FREQ_MONTHLY.equals(freq)) {
      repeatPatern = FREQ_MONTHLY_RESULT;
    } else {
      repeatPatern = FREQ_YEARLY_RESULT;
    }

    // 繰り返しパターンの追加情報取得
    repeatPatern = addRepeatInfo(rrl, freq, repeatPatern);

    return repeatPatern;
  }

  /**
   * 繰り返しパターンの追加情報を取得 インポート内容の表示
   * 
   * @param str
   * @return 繰り返しパターン
   */
  public static String addRepeatInfo(RRule rrl, String freq, String repeatPatern) {

    if (RRULE_FREQ_DAILY.equals(freq)) {

      int inter = rrl.getRecur().getInterval();
      if (inter != 0 && inter > 0) {
        repeatPatern = "" + inter + "" + DAYLY_EVERY_VALUE;
      }

    } else if (RRULE_FREQ_WEEKLY.equals(freq)) {

      int inter = rrl.getRecur().getInterval();
      if (inter != 0 && inter > 0) {
        repeatPatern = "" + inter + "" + WEEKLY_EVERY_VALUE;
      }

      if (rrl.getRecur().getDayList().size() != 0) {
        repeatPatern = repeatPatern + getDayListParameter(rrl);
      }

    } else if (RRULE_FREQ_MONTHLY.equals(freq)) {

      int inter = rrl.getRecur().getInterval();
      if (inter != 0 && inter > 0) {
        repeatPatern = "" + inter + "" + MONTHLY_EVERY_VALUE;
      }

      if (rrl.getRecur().getDayList().size() != 0) {

        repeatPatern = repeatPatern + getDayListParameter(rrl);

      } else if (rrl.getRecur().getMonthDayList().size() != 0) {

        repeatPatern = repeatPatern + getMonthDayListParameter(rrl);

      }

    } else {

      int inter = rrl.getRecur().getInterval();
      if (inter != 0 && inter > 0) {
        repeatPatern = "" + inter + "" + YEARLY_EVERY_VALUE;
      }

    }

    return repeatPatern;

  }

  /**
   * 曜日ごとの繰り返しの情報を取得 インポート内容の表示
   * 
   * @param str
   * @return 曜日毎繰り返しパターン
   */
  public static String getDayListParameter(RRule rrl) {
    String dayLstPatern = null;

    List dayLst = new ArrayList();
    dayLst = rrl.getRecur().getDayList();

    for (int i = 0; i < dayLst.size(); i++) {
      String dayOfWeek = dayLst.get(i).toString();
      dayOfWeek = changeOrthographyDayOfWeek(dayOfWeek);
      if (i == 0) {
        dayLstPatern = dayOfWeek;
      } else {
        dayLstPatern = dayLstPatern + "," + dayOfWeek;
      }

    }

    return dayLstPatern;
  }

  /**
   * 曜日ごとの繰り返しの表示方法を取得 インポート内容の表示
   * 
   * @param str
   * @return 曜日毎繰り返しパターン
   */
  public static String changeOrthographyDayOfWeek(String dayOfWeek) {

    if ("MO".equals(dayOfWeek)) {
      dayOfWeek = ORTHOGRAPHY_MONDAY;
    } else if ("TU".equals(dayOfWeek)) {
      dayOfWeek = ORTHOGRAPHY_TUESDAY;
    } else if ("WE".equals(dayOfWeek)) {
      dayOfWeek = ORTHOGRAPHY_WEDNESDAY;
    } else if ("TH".equals(dayOfWeek)) {
      dayOfWeek = ORTHOGRAPHY_THURSDAY;
    } else if ("FR".equals(dayOfWeek)) {
      dayOfWeek = ORTHOGRAPHY_FRIDAY;
    } else if ("SA".equals(dayOfWeek)) {
      dayOfWeek = ORTHOGRAPHY_SATURDAY;
    } else if ("SU".equals(dayOfWeek)) {
      dayOfWeek = ORTHOGRAPHY_SUNDAY;

      // 毎週でない曜日繰り返しパターンの場合
    } else {

      String day_of_week = "" + dayOfWeek.charAt(1) + dayOfWeek.charAt(2) + "";

      if ("MO".equals(day_of_week)) {
        day_of_week = ORTHOGRAPHY_MONDAY;
      } else if ("TU".equals(day_of_week)) {
        day_of_week = ORTHOGRAPHY_TUESDAY;
      } else if ("WE".equals(day_of_week)) {
        day_of_week = ORTHOGRAPHY_WEDNESDAY;
      } else if ("TH".equals(day_of_week)) {
        day_of_week = ORTHOGRAPHY_THURSDAY;
      } else if ("FR".equals(day_of_week)) {
        day_of_week = ORTHOGRAPHY_FRIDAY;
      } else if ("SA".equals(day_of_week)) {
        day_of_week = ORTHOGRAPHY_SATURDAY;
      } else {
        day_of_week = ORTHOGRAPHY_SUNDAY;
      }

      dayOfWeek = "第" + dayOfWeek.charAt(0) + day_of_week;

    }

    return dayOfWeek;
  }

  /**
   * 日にちごとの繰り返しの情報を取得 インポート内容の表示
   * 
   * @param str
   * @return 日にち毎繰り返しパターン
   */
  public static String getMonthDayListParameter(RRule rrl) {
    String monthDayLstPatern = null;

    List monthDayLst = new ArrayList();
    monthDayLst = rrl.getRecur().getMonthDayList();

    for (int i = 0; i < monthDayLst.size(); i++) {

      String dayOfMonth = monthDayLst.get(i).toString();
      if (i == 0) {
        monthDayLstPatern = dayOfMonth;
      } else {
        monthDayLstPatern = monthDayLstPatern + "," + dayOfMonth;
      }

    }

    if (monthDayLstPatern != null || "".equals(monthDayLstPatern)) {
      monthDayLstPatern = monthDayLstPatern + "日";
    }

    return monthDayLstPatern;
  }

  /**
   * 繰り返しの期間情報を取得 インポート内容の表示
   * 
   * @param str
   * @return 繰り返し期間
   */
  public static String getUntil(VEvent ve, String repeatPatern) {

    Property pro = ve.getProperty(PROPERTY_NAME_RRULE);
    RRule rrl = (RRule) pro;

    // until要素をチェック
    if (rrl == null || rrl.getRecur().getUntil() == null) {
      repeatPatern = repeatPatern + "(期限なし)";
    } else {
      Calendar untilcal = Calendar.getInstance();
      untilcal.setTime(rrl.getRecur().getUntil());
      repeatPatern =
        repeatPatern
          + "("
          + untilcal.get(Calendar.YEAR)
          + "年"
          + (untilcal.get(Calendar.MONTH) + 1)
          + "月"
          + untilcal.get(Calendar.DAY_OF_MONTH)
          + "日迄)";
    }

    return repeatPatern;
  }

  public static void doIcsInsert(ALAction action, RunData rundata,
      Context context, CoordinationForGoogleCalFormData formData) {
    formData.doUpdate(action, rundata, context);
  }

  /**
   * 一時ファイルの保存先フォルダを取得
   * 
   * @param index
   * @return
   */
  public static String getScheduleIcsFolderName(String index) {
    String result =
      ICS_TEMP_FOLDER
        + File.separator
        + ICS_SCHEDULE_TEMP_FOLDER
        + File.separator
        + index;
    return result;
  }

  /**
   * 繰り返しパターンをDBに保存する形に変換
   * 
   * @param index
   * @return
   */
  public static boolean insertRepeatPatern(ALStringField rep,
      EipTSchedule schedule, VEvent ve, Calendar startDate, Calendar endDate,
      int interyear) {

    String repeatPatern = rep.getValue();
    String dtflg = null;
    Property pro = ve.getProperty(PROPERTY_NAME_RRULE);
    RRule rrl = (RRule) pro;
    String rp = null;

    // 単発予定の場合
    if (repeatPatern == null) {
      dtflg = "N";

      schedule.setRepeatPattern("N");

      // "終日予定"の場合
    } else if (SCHEDULE_AT_ALL_DAY.equals(repeatPatern)) {
      dtflg = "S";

      schedule.setRepeatPattern("S");

    } else {

      // "毎日"の場合
      if ('日' == repeatPatern.charAt(1)) {

        if (repeatPatern.indexOf("期限なし") != -1) {
          dtflg = "DN";

          schedule.setRepeatPattern("DN");

        } else {
          dtflg = "DL";

          schedule.setRepeatPattern("DL");

        }

      } else if ('週' == repeatPatern.charAt(1)) {

        if (repeatPatern.indexOf("期限なし") != -1) {
          dtflg = "WN";
          rp = "W0000000N";

        } else {
          dtflg = "WL";
          rp = "W0000000L";
        }

        rp = insertWeeklyRepeat(rp, rrl);
        schedule.setRepeatPattern(rp);

      } else if ('月' == repeatPatern.charAt(1)
        || repeatPatern.indexOf("ヶ月") != -1) {

        List monthDayLst = new ArrayList();
        monthDayLst = rrl.getRecur().getMonthDayList();
        String dayOfMonth = null;

        if (repeatPatern.indexOf("期限なし") != -1) {

          dtflg = "MN";

          for (int j = 0; j < monthDayLst.size(); j++) {
            dayOfMonth = monthDayLst.get(j).toString();
            if (dayOfMonth.length() == 1) {
              dayOfMonth = "0" + dayOfMonth;
            }
          }

          rp = "M" + dayOfMonth + "N";

        } else {

          dtflg = "ML";

          for (int j = 0; j < monthDayLst.size(); j++) {
            dayOfMonth = monthDayLst.get(j).toString();
            if (dayOfMonth.length() == 1) {
              dayOfMonth = "0" + dayOfMonth;
            }
          }

          rp = "M" + dayOfMonth + "L";
        }

        schedule.setRepeatPattern(rp);

      } else {
        dtflg = "Y";
      }

    }

    insertDtTime(dtflg, schedule, ve, startDate, endDate, rp, interyear);

    return true;
  }

  /**
   * 毎週の繰り返し
   * 
   * @param index
   * @return
   */
  public static String insertWeeklyRepeat(String rp, RRule rrl) {

    List dayLst = new ArrayList();
    dayLst = rrl.getRecur().getDayList();

    for (int i = 0; i < dayLst.size(); i++) {
      String dayOfWeek = dayLst.get(i).toString();
      if ("SU".equals(dayOfWeek)) {
        rp =
          ""
            + rp.charAt(0)
            + 1
            + rp.charAt(2)
            + rp.charAt(3)
            + rp.charAt(4)
            + rp.charAt(5)
            + rp.charAt(6)
            + rp.charAt(7)
            + rp.charAt(8)
            + "";

      } else if ("MO".equals(dayOfWeek)) {
        rp =
          ""
            + rp.charAt(0)
            + rp.charAt(1)
            + 1
            + rp.charAt(3)
            + rp.charAt(4)
            + rp.charAt(5)
            + rp.charAt(6)
            + rp.charAt(7)
            + rp.charAt(8)
            + "";

      } else if ("TU".equals(dayOfWeek)) {
        rp =
          ""
            + rp.charAt(0)
            + rp.charAt(1)
            + rp.charAt(2)
            + 1
            + rp.charAt(4)
            + rp.charAt(5)
            + rp.charAt(6)
            + rp.charAt(7)
            + rp.charAt(8)
            + "";

      } else if ("WE".equals(dayOfWeek)) {
        rp =
          ""
            + rp.charAt(0)
            + rp.charAt(1)
            + rp.charAt(2)
            + rp.charAt(3)
            + 1
            + rp.charAt(5)
            + rp.charAt(6)
            + rp.charAt(7)
            + rp.charAt(8)
            + "";

      } else if ("TH".equals(dayOfWeek)) {
        rp =
          ""
            + rp.charAt(0)
            + rp.charAt(1)
            + rp.charAt(2)
            + rp.charAt(3)
            + rp.charAt(4)
            + 1
            + rp.charAt(6)
            + rp.charAt(7)
            + rp.charAt(8)
            + "";

      } else if ("FR".equals(dayOfWeek)) {
        rp =
          ""
            + rp.charAt(0)
            + rp.charAt(1)
            + rp.charAt(2)
            + rp.charAt(3)
            + rp.charAt(4)
            + rp.charAt(5)
            + 1
            + rp.charAt(7)
            + rp.charAt(8)
            + "";

      } else {
        rp =
          ""
            + rp.charAt(0)
            + rp.charAt(1)
            + rp.charAt(2)
            + rp.charAt(3)
            + rp.charAt(4)
            + rp.charAt(5)
            + rp.charAt(6)
            + 1
            + rp.charAt(8)
            + "";

      }

    }

    return rp;
  }

  /**
   * 開始日時、終了日時を保存
   * 
   * @param index
   * @return
   */
  public static boolean insertDtTime(String dtflg, EipTSchedule schedule,
      VEvent ve, Calendar startDate, Calendar endDate, String rp, int interyear) {

    Property pro = ve.getProperty(PROPERTY_NAME_RRULE);
    RRule rrl = (RRule) pro;

    // 単発予定の場合
    if ("N".equals(dtflg)) {

      // iCalendarファイルの開始・終了日時をそのままセット
      startDate.setTime(ve.getStartDate().getDate());
      endDate.setTime(ve.getEndDate().getDate());

      // 終日予定の場合
    } else if ("S".equals(dtflg)) {

      // 開始・終了日時の時分秒を0:00に変更してセット
      startDate.setTime(ve.getStartDate().getDate());
      endDate.setTime(ve.getEndDate().getDate());

      startDate.set(Calendar.HOUR_OF_DAY, 0);
      startDate.set(Calendar.MINUTE, 0);
      startDate.set(Calendar.SECOND, 0);

      endDate
        .set(Calendar.DAY_OF_MONTH, endDate.get(Calendar.DAY_OF_MONTH) - 1);
      endDate.set(Calendar.HOUR_OF_DAY, 0);
      endDate.set(Calendar.MINUTE, 0);
      endDate.set(Calendar.SECOND, 0);

      // 毎日繰り返し・期限なしの場合
    } else if ("DN".equals(dtflg)) {

      // 繰り返し間隔を取得
      int interval = rrl.getRecur().getInterval();

      // 繰り返し間隔の指定がない場合
      if (interval == -1) {

        // iCalendarファイルの開始・終了日時をそのままセット
        startDate.setTime(ve.getStartDate().getDate());
        endDate.setTime(ve.getEndDate().getDate());

        // 繰り返し間隔の指定がある場合
      } else {
        // 繰り返しパターンを単発に変更
        schedule.setRepeatPattern("N");
      }

      // 毎日繰り返し・期限ありの場合
    } else if ("DL".equals(dtflg)) {

      // 繰り返し間隔を取得
      int interval = rrl.getRecur().getInterval();

      // 繰り返し間隔指定のない場合
      if (interval == -1) {

        startDate.setTime(ve.getStartDate().getDate());
        // 繰り返し期限の年月日 + 予定終了時間
        endDate.setTime(untilTimeForAipo(rrl, ve));

        // 繰り返し間隔指定のある場合
      } else {
        // 繰り返しパターンを単発に変更
        schedule.setRepeatPattern("N");
      }

      // 週間繰り返し・期限なしの場合
    } else if ("WN".equals(dtflg)) {

      // 繰り返し間隔を取得
      int interval = rrl.getRecur().getInterval();

      // 繰り返し間隔指定のない場合
      if (interval == -1) {

        // iCalendarファイルの開始・終了日時をそのままセット
        startDate.setTime(ve.getStartDate().getDate());
        endDate.setTime(ve.getEndDate().getDate());

        // 繰り返し間隔指定のある場合
      } else {

        // １週間の期限ありの予定を繰り返し感覚に合わせて予定を作成
        // 繰り返しパターンを週間繰り返し・期限ありに変更
        rp =
          ""
            + rp.charAt(0)
            + rp.charAt(1)
            + rp.charAt(2)
            + rp.charAt(3)
            + rp.charAt(4)
            + rp.charAt(5)
            + rp.charAt(6)
            + rp.charAt(7)
            + "L"
            + "";

        schedule.setRepeatPattern(rp);

        Calendar weekend = Calendar.getInstance();
        weekend.setTime(endDate.getTime());

        // 終了時間を１週間の中の最終予定日にセット
        if ('1' == rp.charAt(1)) {
          weekend.set(Calendar.DAY_OF_WEEK, 1);
        }
        if ('1' == rp.charAt(2)) {
          weekend.set(Calendar.DAY_OF_WEEK, 2);
        }
        if ('1' == rp.charAt(3)) {
          weekend.set(Calendar.DAY_OF_WEEK, 3);
        }
        if ('1' == rp.charAt(4)) {
          weekend.set(Calendar.DAY_OF_WEEK, 4);
        }
        if ('1' == rp.charAt(5)) {
          weekend.set(Calendar.DAY_OF_WEEK, 5);
        }
        if ('1' == rp.charAt(6)) {
          weekend.set(Calendar.DAY_OF_WEEK, 6);
        }
        if ('1' == rp.charAt(7)) {
          weekend.set(Calendar.DAY_OF_WEEK, 7);
        }

        endDate.setTime(weekend.getTime());
      }

      // 週間繰り返し・期限ありの場合
    } else if ("WL".equals(dtflg)) {

      // 繰り返し間隔を取得
      int interval = rrl.getRecur().getInterval();

      // 繰り返し間隔指定がない場合
      if (interval == -1) {

        startDate.setTime(ve.getStartDate().getDate());
        // 繰り返し期限の年月日 + 予定終了時間
        endDate.setTime(untilTimeForAipo(rrl, ve));

        // 繰り返し間隔指定がある場合
      } else {

        Calendar weekend = Calendar.getInstance();
        weekend.setTime(endDate.getTime());

        // 終了時間を１週間の中の最終予定日にセット
        if ('1' == rp.charAt(1)) {
          weekend.set(Calendar.DAY_OF_WEEK, 1);
        }
        if ('1' == rp.charAt(2)) {
          weekend.set(Calendar.DAY_OF_WEEK, 2);
        }
        if ('1' == rp.charAt(3)) {
          weekend.set(Calendar.DAY_OF_WEEK, 3);
        }
        if ('1' == rp.charAt(4)) {
          weekend.set(Calendar.DAY_OF_WEEK, 4);
        }
        if ('1' == rp.charAt(5)) {
          weekend.set(Calendar.DAY_OF_WEEK, 5);
        }
        if ('1' == rp.charAt(6)) {
          weekend.set(Calendar.DAY_OF_WEEK, 6);
        }
        if ('1' == rp.charAt(7)) {
          weekend.set(Calendar.DAY_OF_WEEK, 7);
        }

        endDate.setTime(weekend.getTime());
      }

      // 月別繰り返し・期限なしの場合
    } else if ("MN".equals(dtflg)) {

      // 繰り返し間隔の取得
      int interval = rrl.getRecur().getInterval();

      // 月別繰り返し日が曜日指定の場合 例)毎月第３火曜日
      if (rrl.getRecur().getDayList().size() != 0) {

        // 繰り返しパターンを単発に変更
        schedule.setRepeatPattern("N");

        // 繰り返し間隔指定がない場合
      } else if (interval == -1) {

        // iCalendarファイルの開始・終了日時をそのままセット
        startDate.setTime(ve.getStartDate().getDate());
        endDate.setTime(ve.getEndDate().getDate());

        // 繰り返し間隔指定のある場合
      } else {
        // 繰り返しパターンを単発に変更
        schedule.setRepeatPattern("N");
      }

      // 月別繰り返し・期限ありの場合
    } else if ("ML".equals(dtflg)) {

      // 繰り返し間隔を取得
      int interval = rrl.getRecur().getInterval();

      // 月別繰り返し日が曜日指定の場合 例)毎月第３火曜日
      if (rrl.getRecur().getDayList().size() != 0) {
        // 繰り返しパターンを単発に変更
        schedule.setRepeatPattern("N");

        // 繰り返し間隔指定がない場合
      } else if (interval == -1) {
        startDate.setTime(ve.getStartDate().getDate());
        // 繰り返し期限の年月日 + 予定終了時間
        endDate.setTime(untilTimeForAipo(rrl, ve));
      } else {
        // 繰り返しパターンを単発に変更
        schedule.setRepeatPattern("N");
      }

      // 年間繰り返しの場合
    } else {

      // DTSTARTのVALUEを取得
      Parameter date_value =
        ve.getStartDate().getParameters().getParameter(
          CoordinationForGoogleCalUtils.PROPERTY_NAME_VALUE);

      // DTSTARTにVALUE属性のパラメータがない場合
      if (date_value == null || "".equals(date_value)) {

        // 繰り返しパターンを単発に変更
        schedule.setRepeatPattern("N");

        // DTSTARTにVALUE属性のパラメータがある場合
      } else if (CoordinationForGoogleCalUtils.PROPERTY_DATETIPE_DATE
        .equals(date_value.getValue())) {

        startDate.set(Calendar.DAY_OF_MONTH, startDate
          .get(Calendar.DAY_OF_MONTH));
        startDate.set(Calendar.HOUR_OF_DAY, 0);
        startDate.set(Calendar.MINUTE, 0);
        startDate.set(Calendar.SECOND, 0);

        // GoogleカレンダーとAipoで終日予定の期間の定義が異なるので合わせる (i=0の時のみ)
        if (interyear == 0) {
          endDate.set(
            Calendar.DAY_OF_MONTH,
            endDate.get(Calendar.DAY_OF_MONTH) - 1);

        } else {
          endDate
            .set(Calendar.DAY_OF_MONTH, endDate.get(Calendar.DAY_OF_MONTH));

        }
        endDate.set(Calendar.HOUR_OF_DAY, 0);
        endDate.set(Calendar.MINUTE, 0);
        endDate.set(Calendar.SECOND, 0);

        // 繰り返しパターンを終日に変更
        schedule.setRepeatPattern("S");
      }

    }
    schedule.setStartDate(startDate.getTime());
    schedule.setEndDate(endDate.getTime());

    return true;
  }

  /**
   * 期限有りのスケジュール インポート時にDBに保存する形に 期限日時を設定
   * 
   * @param Date
   * @return 期限日時
   */
  public static Date untilTimeForAipo(RRule rrl, VEvent ve) {

    Calendar un = Calendar.getInstance();
    un.setTime(rrl.getRecur().getUntil());

    Calendar en = Calendar.getInstance();
    en.setTime(ve.getEndDate().getDate());

    en.set(Calendar.YEAR, un.get(Calendar.YEAR));
    en.set(Calendar.MONTH, un.get(Calendar.MONTH));
    en.set(Calendar.DAY_OF_MONTH, un.get(Calendar.DAY_OF_MONTH));

    return en.getTime();

  }

  /**
   * Googleカレンダーの 間隔ありスケジュールに対応 日にちごとの間隔有り繰り返し
   * 
   */
  public static boolean createDailyIntervalSchedule(VEvent ve, Date now,
      int loginuser, RRule rrl, EipTSchedule schedule, Calendar startDate,
      Calendar endDate, DateTime to_d, Calendar start, int interval,
      int distribution) {

    Date untilpla = rrl.getRecur().getUntil();
    // 終了期限がない場合
    if (untilpla == null) {

      for (int i = 0;; i++) {

        if (to_d.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        startDate.set(Calendar.DAY_OF_MONTH, startDate
          .get(Calendar.DAY_OF_MONTH)
          + interval);
        endDate.set(Calendar.DAY_OF_MONTH, endDate.get(Calendar.DAY_OF_MONTH)
          + interval);

      }

    } else {

      for (int i = 0;; i++) {
        if (to_d.before(startDate.getTime())
          || untilpla.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        startDate.set(Calendar.DAY_OF_MONTH, startDate
          .get(Calendar.DAY_OF_MONTH)
          + interval);
        endDate.set(Calendar.DAY_OF_MONTH, endDate.get(Calendar.DAY_OF_MONTH)
          + interval);

      }
    }

    return true;
  }

  /**
   * Googleカレンダーの 間隔ありスケジュールに対応 週ごとの間隔有り繰り返し
   * 
   */
  public static boolean createWeeklyIntervalSchedule(VEvent ve, Date now,
      int loginuser, RRule rrl, EipTSchedule schedule, Calendar startDate,
      Calendar endDate, DateTime to_d, Calendar start, int interval,
      int distribution) {

    Date untilpla = rrl.getRecur().getUntil();
    // 終了期限がない場合
    if (untilpla == null) {

      for (int i = 0;; i++) {

        if (to_d.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        startDate.set(Calendar.WEEK_OF_MONTH, startDate
          .get(Calendar.WEEK_OF_MONTH)
          + interval);
        endDate.set(Calendar.WEEK_OF_MONTH, endDate.get(Calendar.WEEK_OF_MONTH)
          + interval);

      }

    } else {

      for (int i = 0;; i++) {

        if (to_d.before(startDate.getTime())
          || untilpla.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        startDate.set(Calendar.WEEK_OF_MONTH, startDate
          .get(Calendar.WEEK_OF_MONTH)
          + interval);
        endDate.set(Calendar.WEEK_OF_MONTH, endDate.get(Calendar.WEEK_OF_MONTH)
          + interval);

      }
    }

    return true;
  }

  /**
   * Googleカレンダーの 月間繰り返し曜日指定・間隔ありスケジュールに対応 月ごとの間隔有り繰り返し
   * 
   */
  public static boolean createMonthlySetDayOfWeekIntervalSchedule(VEvent ve,
      Date now, int loginuser, RRule rrl, EipTSchedule schedule,
      Calendar startDate, Calendar endDate, DateTime to_d, Calendar start,
      int interval, int distribution) {

    Date untilpla = rrl.getRecur().getUntil();
    // 終了期限がない場合
    if (untilpla == null) {

      for (int i = 0;; i++) {

        if (to_d.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        int monthnum = startDate.get(Calendar.MONTH);
        startDate.set(Calendar.MONTH, startDate.get(Calendar.MONTH) + interval);
        endDate.set(Calendar.MONTH, endDate.get(Calendar.MONTH) + interval);

        String day = rrl.getRecur().getDayList().get(0).toString();

        String weekday = "" + day.charAt(1) + day.charAt(2) + "";

        int weekdaynum = 0;
        if ("SU".equals(weekday)) {

          weekdaynum = Calendar.SUNDAY;

        } else if ("MO".equals(weekday)) {

          weekdaynum = Calendar.MONDAY;

        } else if ("TU".equals(weekday)) {

          weekdaynum = Calendar.TUESDAY;

        } else if ("WE".equals(weekday)) {

          weekdaynum = Calendar.WEDNESDAY;

        } else if ("TH".equals(weekday)) {

          weekdaynum = Calendar.THURSDAY;

        } else if ("FR".equals(weekday)) {

          weekdaynum = Calendar.FRIDAY;

        } else {

          weekdaynum = Calendar.SATURDAY;

        }

        startDate.set(Calendar.DAY_OF_WEEK, weekdaynum);
        endDate.set(Calendar.DAY_OF_WEEK, weekdaynum);

        // 月の何週目で繰り返すかどうかを取得
        String weeknum = "" + day.charAt(0) + "";
        int num = 0;

        if ("1".equals(weeknum)) {
          num = 1;
        } else if ("2".equals(weeknum)) {
          num = 2;
        } else if ("3".equals(weeknum)) {
          num = 3;
        } else if ("4".equals(weeknum)) {
          num = 4;
        } else if ("5".equals(weeknum)) {
          num = 5;
        }

        startDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);
        endDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);

      }

    } else {

      for (int i = 0;; i++) {
        if (to_d.before(startDate.getTime())
          || untilpla.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        int monthnum = startDate.get(Calendar.MONTH);
        startDate.set(Calendar.MONTH, startDate.get(Calendar.MONTH) + interval);
        endDate.set(Calendar.MONTH, endDate.get(Calendar.MONTH) + interval);

        String day = rrl.getRecur().getDayList().get(0).toString();

        String weekday = "" + day.charAt(1) + day.charAt(2) + "";

        int weekdaynum = 0;
        if ("SU".equals(weekday)) {

          weekdaynum = Calendar.SUNDAY;

        } else if ("MO".equals(weekday)) {

          weekdaynum = Calendar.MONDAY;

        } else if ("TU".equals(weekday)) {

          weekdaynum = Calendar.TUESDAY;

        } else if ("WE".equals(weekday)) {

          weekdaynum = Calendar.WEDNESDAY;

        } else if ("TH".equals(weekday)) {

          weekdaynum = Calendar.THURSDAY;

        } else if ("FR".equals(weekday)) {

          weekdaynum = Calendar.FRIDAY;

        } else {

          weekdaynum = Calendar.SATURDAY;

        }

        startDate.set(Calendar.DAY_OF_WEEK, weekdaynum);
        endDate.set(Calendar.DAY_OF_WEEK, weekdaynum);

        // 月の何週目で繰り返すかどうかを取得
        String weeknum = "" + day.charAt(0) + "";
        int num = 0;

        if ("1".equals(weeknum)) {
          num = 1;
        } else if ("2".equals(weeknum)) {
          num = 2;
        } else if ("3".equals(weeknum)) {
          num = 3;
        } else if ("4".equals(weeknum)) {
          num = 4;
        } else if ("5".equals(weeknum)) {
          num = 5;
        }

        startDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);
        endDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);

      }

    }

    return true;
  }

  /**
   * Googleカレンダーの 月間繰り返し曜日指定スケジュールに対応
   * 
   */
  public static boolean createMonthlySetDayOfWeekSchedule(VEvent ve, Date now,
      int loginuser, RRule rrl, EipTSchedule schedule, Calendar startDate,
      Calendar endDate, DateTime to_d, Calendar start, int interval,
      int distribution) {

    Date untilpla = rrl.getRecur().getUntil();
    // 終了期限がない場合
    if (untilpla == null) {

      for (int i = 0;; i++) {

        if (to_d.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        startDate.set(Calendar.MONTH, startDate.get(Calendar.MONTH) + 1);
        endDate.set(Calendar.MONTH, endDate.get(Calendar.MONTH) + 1);

        String day = rrl.getRecur().getDayList().get(0).toString();

        String weekday = "" + day.charAt(1) + day.charAt(2) + "";

        int weekdaynum = 0;
        if ("SU".equals(weekday)) {

          weekdaynum = Calendar.SUNDAY;

        } else if ("MO".equals(weekday)) {

          weekdaynum = Calendar.MONDAY;

        } else if ("TU".equals(weekday)) {

          weekdaynum = Calendar.TUESDAY;

        } else if ("WE".equals(weekday)) {

          weekdaynum = Calendar.WEDNESDAY;

        } else if ("TH".equals(weekday)) {

          weekdaynum = Calendar.THURSDAY;

        } else if ("FR".equals(weekday)) {

          weekdaynum = Calendar.FRIDAY;

        } else {

          weekdaynum = Calendar.SATURDAY;

        }

        startDate.set(Calendar.DAY_OF_WEEK, weekdaynum);
        endDate.set(Calendar.DAY_OF_WEEK, weekdaynum);

        // 月の何週目で繰り返すかどうかを取得
        String weeknum = "" + day.charAt(0) + "";
        int num = 0;

        if ("1".equals(weeknum)) {
          num = 1;
        } else if ("2".equals(weeknum)) {
          num = 2;
        } else if ("3".equals(weeknum)) {
          num = 3;
        } else if ("4".equals(weeknum)) {
          num = 4;
        } else if ("5".equals(weeknum)) {
          num = 5;
        }

        startDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);
        endDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);

      }

    } else {

      for (int i = 0;; i++) {
        if (to_d.before(startDate.getTime())
          || untilpla.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        startDate.set(Calendar.MONTH, startDate.get(Calendar.MONTH) + 1);
        endDate.set(Calendar.MONTH, endDate.get(Calendar.MONTH) + 1);

        String day = rrl.getRecur().getDayList().get(0).toString();

        String weekday = "" + day.charAt(1) + day.charAt(2) + "";

        int weekdaynum = 0;
        if ("SU".equals(weekday)) {

          weekdaynum = Calendar.SUNDAY;

        } else if ("MO".equals(weekday)) {

          weekdaynum = Calendar.MONDAY;

        } else if ("TU".equals(weekday)) {

          weekdaynum = Calendar.TUESDAY;

        } else if ("WE".equals(weekday)) {

          weekdaynum = Calendar.WEDNESDAY;

        } else if ("TH".equals(weekday)) {

          weekdaynum = Calendar.THURSDAY;

        } else if ("FR".equals(weekday)) {

          weekdaynum = Calendar.FRIDAY;

        } else {

          weekdaynum = Calendar.SATURDAY;

        }

        startDate.set(Calendar.DAY_OF_WEEK, weekdaynum);
        endDate.set(Calendar.DAY_OF_WEEK, weekdaynum);

        // 月の何週目で繰り返すかどうかを取得
        String weeknum = "" + day.charAt(0) + "";
        int num = 0;

        if ("1".equals(weeknum)) {
          num = 1;
        } else if ("2".equals(weeknum)) {
          num = 2;
        } else if ("3".equals(weeknum)) {
          num = 3;
        } else if ("4".equals(weeknum)) {
          num = 4;
        } else if ("5".equals(weeknum)) {
          num = 5;
        }

        startDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);
        endDate.set(Calendar.DAY_OF_WEEK_IN_MONTH, num);

      }

    }

    return true;
  }

  /**
   * Googleカレンダーの 間隔ありスケジュールに対応 月ごとの間隔有り繰り返し
   * 
   */
  public static boolean createMonthlyIntervalSchedule(VEvent ve, Date now,
      int loginuser, RRule rrl, EipTSchedule schedule, Calendar startDate,
      Calendar endDate, DateTime to_d, Calendar start, int interval,
      int distribution) {

    Date untilpla = rrl.getRecur().getUntil();
    // 終了期限がない場合
    if (untilpla == null) {

      for (int i = 0;; i++) {

        if (to_d.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        startDate.set(Calendar.MONTH, startDate.get(Calendar.MONTH) + interval);
        endDate.set(Calendar.MONTH, endDate.get(Calendar.MONTH) + interval);

      }

    } else {

      for (int i = 0;; i++) {
        if (to_d.before(startDate.getTime())
          || untilpla.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        } else {

          // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
          int interyear = 0;
          // UID重複チェック実装時には引数にuid_plaを追加
          insertSchedule(
            ve,
            now,
            loginuser,
            schedule,
            startDate,
            endDate,
            distribution,
            interyear);

          startDate.set(Calendar.MONTH, startDate.get(Calendar.MONTH)
            + interval);
          endDate.set(Calendar.MONTH, endDate.get(Calendar.MONTH) + interval);

        }

      }

    }

    return true;
  }

  /**
   * Googleカレンダーの 年毎の繰り返し・間隔有りスケジュールに対応
   * 
   */
  public static boolean createYearlyIntervalSchedule(VEvent ve, Date now,
      int loginuser, RRule rrl, EipTSchedule schedule, Calendar startDate,
      Calendar endDate, DateTime to_d, Calendar start, int interval,
      int distribution) {

    Date untilpla = rrl.getRecur().getUntil();
    // 終了期限がない場合
    if (untilpla == null) {

      for (int interyear = 0;; interyear++) {

        if (to_d.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }
        if (interyear == 0) {

          // 初期の開始・終了日時に戻す
          startDate.setTime(ve.getStartDate().getDate());
          endDate.setTime(ve.getEndDate().getDate());

          // UID重複チェック実装時には引数にuid_plaを追加
          insertSchedule(
            ve,
            now,
            loginuser,
            schedule,
            startDate,
            endDate,
            distribution,
            interyear);

          startDate.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + interval);
          endDate.set(Calendar.YEAR, endDate.get(Calendar.YEAR) + interval);

        } else {
          // UID重複チェック実装時には引数にuid_plaを追加
          insertSchedule(
            ve,
            now,
            loginuser,
            schedule,
            startDate,
            endDate,
            distribution,
            interyear);

          startDate.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + interval);
          endDate.set(Calendar.YEAR, endDate.get(Calendar.YEAR) + interval);
        }

      }

    } else {

      for (int interyear = 0;; interyear++) {
        if (to_d.before(startDate.getTime())
          || untilpla.before(startDate.getTime())
          || start.getTime().before(startDate.getTime())) {
          break;
        }
        if (interyear == 0) {

          // 初期の開始・終了日時に戻す
          startDate.setTime(ve.getStartDate().getDate());
          endDate.setTime(ve.getEndDate().getDate());

          // UID重複チェック実装時には引数にuid_plaを追加
          insertSchedule(
            ve,
            now,
            loginuser,
            schedule,
            startDate,
            endDate,
            distribution,
            interyear);

          startDate.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + interval);
          endDate.set(Calendar.YEAR, endDate.get(Calendar.YEAR) + interval);

        } else {
          // UID重複チェック実装時には引数にuid_plaを追加
          insertSchedule(
            ve,
            now,
            loginuser,
            schedule,
            startDate,
            endDate,
            distribution,
            interyear);

          startDate.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + interval);
          endDate.set(Calendar.YEAR, endDate.get(Calendar.YEAR) + interval);
        }
      }
    }

    return true;
  }

  /**
   * Googleカレンダーの 年毎の繰り返しスケジュールに対応
   * 
   */
  public static boolean createYearlySchedule(VEvent ve, Date now,
      int loginuser, RRule rrl, EipTSchedule schedule, Calendar startDate,
      Calendar endDate, DateTime to_d, int distribution) {

    Date untilpla = rrl.getRecur().getUntil();
    // 終了期限がない場合
    if (untilpla == null) {

      // 未来5年分の繰り返しを単発スケジュールとして保存
      for (int i = 0; i <= 5; i++) {
        Calendar start = Calendar.getInstance();
        start.setTime(ve.getStartDate().getDate());
        start.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + i);
        if (to_d.before(start.getTime())) {
          continue;
        }

        // 初期の開始・終了日時に戻す
        startDate.setTime(ve.getStartDate().getDate());
        endDate.setTime(ve.getEndDate().getDate());

        startDate.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + i);
        endDate.set(Calendar.YEAR, endDate.get(Calendar.YEAR) + i);

        // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
        int interyear = 0;
        // UID重複チェック実装時には引数にuid_plaを追加
        insertSchedule(
          ve,
          now,
          loginuser,
          schedule,
          startDate,
          endDate,
          distribution,
          interyear);

        // 初期の開始・終了日時に戻す
        startDate.setTime(ve.getStartDate().getDate());
        endDate.setTime(ve.getEndDate().getDate());
      }

    } else {

      Calendar until = Calendar.getInstance();
      until.setTime(rrl.getRecur().getUntil());

      int untilyear = until.get(Calendar.YEAR);
      Calendar nowtime = Calendar.getInstance();
      int nowyear = nowtime.get(Calendar.YEAR);

      int remainder = untilyear - nowyear + 1;

      if (remainder < 5) {

        // 現在から完了日時までの繰り返しを単発スケジュールとして保存
        for (int i = 0; i < remainder; i++) {

          // 初期の開始・終了日時に戻す
          startDate.setTime(ve.getStartDate().getDate());
          endDate.setTime(ve.getEndDate().getDate());

          startDate.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + i);
          endDate.set(Calendar.YEAR, endDate.get(Calendar.YEAR) + i);

          if (to_d.before(startDate.getTime())
            || untilpla.before(startDate.getTime())) {
            break;
          }

          // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
          int interyear = 0;
          // UID重複チェック実装時には引数にuid_plaを追加
          insertSchedule(
            ve,
            now,
            loginuser,
            schedule,
            startDate,
            endDate,
            distribution,
            interyear);

        }
      } else {

        // 未来5年分の繰り返しを単発スケジュールとして保存
        for (int i = 0; i <= 5; i++) {

          // 初期の開始・終了日時に戻す
          startDate.setTime(ve.getStartDate().getDate());
          endDate.setTime(ve.getEndDate().getDate());

          startDate.set(Calendar.YEAR, startDate.get(Calendar.YEAR) + i);
          endDate.set(Calendar.YEAR, endDate.get(Calendar.YEAR) + i);

          if (to_d.before(startDate.getTime())
            || untilpla.before(startDate.getTime())) {
            break;
          }

          // 繰り返し間隔指定ありの年間終日スケジュールでのみ使用
          int interyear = 0;
          // UID重複チェック実装時には引数にuid_plaを追加
          insertSchedule(
            ve,
            now,
            loginuser,
            schedule,
            startDate,
            endDate,
            distribution,
            interyear);

        }

      }

    }
    return true;
  }

  /**
   * スケジュール情報を DBに保存する
   * 
   */
  public static boolean insertSchedule(VEvent ve, Date now, int loginuser,
      EipTSchedule schedule, Calendar startDate, Calendar endDate,
      int distribution, int interyear) {

    AvzTCoordinationForGoogleCal coordination = null;

    String event_uid = ve.getUid().getValue();

    // UID重複チェック実装時には引数にuid_plaを追加
    EipTSchedule updateCheck = updateCheck(event_uid);
    // AvzTCoordinationForGoogleCal coordination = uidCheck(uid);

    if (updateCheck == null) {

      // 新規オブジェクトモデル
      schedule = Database.create(EipTSchedule.class);

      // 新規オブジェクトモデル
      coordination = Database.create(AvzTCoordinationForGoogleCal.class);

      schedule.setParentId(Integer.valueOf(0));
      // 編集フラグは固定値"T"
      schedule.setEditFlag(INSERT_FLAG_T);
    } else {
      schedule = updateCheck;

      SelectQuery<AvzTCoordinationForGoogleCal> q =
        Database.query(AvzTCoordinationForGoogleCal.class);

      Expression exp =
        ExpressionFactory.matchExp(
          AvzTCoordinationForGoogleCal.SCHEDULE_ID_PROPERTY,
          schedule.getScheduleId());

      q.setQualifier(exp);
      ResultList<AvzTCoordinationForGoogleCal> coordinations =
        q.getResultList();
      if (coordinations.size() == 0 || coordinations == null) {

        coordination = Database.create(AvzTCoordinationForGoogleCal.class);

      } else {
        coordination = coordinations.get(0);
      }
    }

    coordination.setEipTSchedule(schedule);
    coordination.setUId(event_uid);

    // タイトルを保存
    // SUMMARY要素がなかったらスケジュール名に"(タイトルなし)"を保存
    if (ve
      .getProperties(CoordinationForGoogleCalUtils.PROPERTY_NAME_SUMMARY)
      .size() == 0
      || "".equals(ve.getSummary().getValue())) {
      schedule.setName(CoordinationForGoogleCalUtils.SCHEDULE_HAS_NOT_NAME);
    } else {
      schedule.setName(ve.getSummary().getValue().toString());
    }

    // 場所を保存
    // LOCATION要素がなかったら場所に空欄を保存
    if (ve
      .getProperties(CoordinationForGoogleCalUtils.PROPERTY_NAME_LOCATION)
      .size() == 0
      || "".equals(ve.getLocation().getValue())) {
      schedule.setPlace(CoordinationForGoogleCalUtils.SPACE_DISPLAY);
    } else {
      schedule.setPlace(ve.getLocation().getValue());
    }

    // 詳細を保存
    // DESCRIPTION要素がなかったら内容に空欄を保存
    if (ve.getProperties(
      CoordinationForGoogleCalUtils.PROPERTY_NAME_DESCRIPTION).size() == 0
      || "".equals(ve.getDescription().getValue())) {
      schedule.setNote(CoordinationForGoogleCalUtils.SPACE_DISPLAY);
    } else {
      schedule.setNote(ve.getDescription().getValue());
    }

    // 公開状態保存
    // CLASS要素がない場合、空欄、"PRIVATE"の場合は公開フラグに"P"を保存

    if (1 == distribution) {
      schedule.setPublicFlag(INSERT_FLAG_P);
    } else {
      if (ve
        .getProperties(CoordinationForGoogleCalUtils.PROPERTY_NAME_CLASS)
        .size() == 0
        || "".equals(ve.getClassification().getValue())
        || CoordinationForGoogleCalUtils.PROPERTY_NAME_PRIVATE.equals(ve
          .getClassification()
          .getValue())) {
        schedule.setPublicFlag(INSERT_FLAG_P);
        // 上記以外は"O"を保存
      } else {
        schedule.setPublicFlag(INSERT_FLAG_O);
      }
    }

    // ユーザID、作成ユーザID、更新ユーザIDはログインユーザIDを保存
    schedule.setOwnerId(loginuser);
    schedule.setCreateUserId(loginuser);
    schedule.setUpdateUserId(loginuser);

    // CREATED要素がない場合、作成日に現在時刻を保存
    if (now.before(ve.getCreated().getDate())) {

      Database.delete(schedule);
      Database.delete(coordination);

      return true;

    } else {
      if (ve
        .getProperties(CoordinationForGoogleCalUtils.PROPERTY_NAME_CREATED)
        .size() == 0) {
        schedule.setCreateDate(now);
      } else {
        schedule.setCreateDate(ve.getCreated().getDate());
      }
    }

    // LAST-MODIFIED要素がない場合、更新日に現在時刻を取得
    if (now.before(ve.getLastModified().getDate())) {

      Database.delete(schedule);
      Database.delete(coordination);

      return true;

    } else {
      if (ve.getProperties(
        CoordinationForGoogleCalUtils.PROPERTY_NAME_LAST_MODIFIED).size() == 0) {
        schedule.setUpdateDate(now);
      } else {
        schedule.setUpdateDate(ve.getLastModified().getDate());
      }

    }

    // 繰り返し等ルールを取得
    ALStringField rep = new ALStringField();
    if (ve
      .getProperties(CoordinationForGoogleCalUtils.PROPERTY_NAME_RRULE)
      .size() == 0) {

      // DTSTART要素にVALUE属性がなければ処理なし
      if (ve.getStartDate().getParameters().getParameter(
        CoordinationForGoogleCalUtils.PROPERTY_NAME_VALUE) == null) {
      } else {

        if (ve.getStartDate().getParameters().getParameter(
          CoordinationForGoogleCalUtils.PROPERTY_NAME_VALUE).getValue() == null
          || "".equals(ve
            .getStartDate()
            .getParameters()
            .getParameter("VALUE")
            .getValue())) {
          rep.setValue(CoordinationForGoogleCalUtils.SPACE_DISPLAY);

          // DTSTARTのVALUE属性がDATEならば終日予定としてセット
        } else if (CoordinationForGoogleCalUtils.PROPERTY_DATETIPE_DATE
          .equals(ve.getStartDate().getParameters().getParameter(
            CoordinationForGoogleCalUtils.PROPERTY_NAME_VALUE).getValue())) {

          rep.setValue(CoordinationForGoogleCalUtils.SCHEDULE_AT_ALL_DAY);

        } else {
          rep.setValue(CoordinationForGoogleCalUtils.SPACE_DISPLAY);
        }
      }

    } else {
      // 繰り返しパターンを取得
      String repeatPatern = CoordinationForGoogleCalUtils.getRepeatPatern(ve);
      repeatPatern = CoordinationForGoogleCalUtils.getUntil(ve, repeatPatern);
      rep.setValue(repeatPatern);
    }

    // 取得したルールごとに繰り返しパターン、開始日時、終了日時を保存する
    CoordinationForGoogleCalUtils.insertRepeatPatern(
      rep,
      schedule,
      ve,
      startDate,
      endDate,
      interyear);

    // 開始時間が終了時間より遅かったらエラーを返す
    if (schedule.getEndDate().before(schedule.getStartDate())
      || ve.getEndDate().getDate().before(ve.getStartDate().getDate())) {

      Database.delete(schedule);
      Database.delete(coordination);

      return true;

    }

    if (updateCheck == null) {
      EipTScheduleMap map = Database.create(EipTScheduleMap.class);

      map.setEipTSchedule(schedule);
      map.setUserId(loginuser);

      map.setStatus(INSERT_FLAG_O);
      map.setType(INSERT_FLAG_U);

      map.setCommonCategoryId(Integer.valueOf(1));

      map.setEipTSchedule(schedule);

      SelectQuery<EipTCommonCategory> query =
        Database.query(EipTCommonCategory.class);

      Expression exp =
        ExpressionFactory.matchDbExp(
          EipTCommonCategory.COMMON_CATEGORY_ID_PK_COLUMN,
          1);

      query.setQualifier(exp);

      ResultList<EipTCommonCategory> result = query.getResultList();

      EipTCommonCategory category1 = (result.get(0));
      map.setEipTCommonCategory(category1);
    }

    return true;

  }

  public static void insertDummySchedule(int loginuser, List dummyList) {

    for (int i = 0; i < dummyList.size(); i++) {
      VEvent dummy = (VEvent) dummyList.get(i);

      String sum = dummy.getSummary().getValue();
      Date start = dummy.getStartDate().getDate();

      Property pro =
        dummy.getProperty(CoordinationForGoogleCalUtils.PROPERTY_NAME_RRULE);
      RRule rrl = (RRule) pro;

      PropertyList exdate = dummy.getProperties(PROPERTY_NAME_EXDATE);
      if (exdate.size() != 0) {
        for (int j = 0; j < exdate.size(); j++) {
          ExDate dummy_date = (ExDate) exdate.get(j);
          DateList dumList = dummy_date.getDates();

          for (int k = 0; k < dumList.size(); k++) {

            DateTime dum_start = null;
            Date dum_start2 = null;
            Date dum = null;

            // DTSTART要素にVALUE属性がなければ処理なし
            if (dummy.getStartDate().getParameters().getParameter(
              CoordinationForGoogleCalUtils.PROPERTY_NAME_VALUE) == null) {
              dum_start = (DateTime) dumList.get(k);
              dum = dum_start;

            } else {

              dum_start2 = (Date) dumList.get(k);
              Calendar dum_start3 = Calendar.getInstance();
              dum_start3.setTime(dum_start2);
              dum_start3.set(Calendar.HOUR_OF_DAY, 0);
              dum_start3.set(Calendar.MINUTE, 0);
              dum_start3.set(Calendar.SECOND, 0);

              dum = dum_start3.getTime();

            }

            SelectQuery<EipTSchedule> query =
              Database.query(EipTSchedule.class);

            Expression exp =
              ExpressionFactory.matchExp(EipTSchedule.NAME_PROPERTY, sum);

            Expression exp2 =
              ExpressionFactory.matchExp(EipTSchedule.START_DATE_PROPERTY, dum);
            if ((RRULE_FREQ_MONTHLY.equals(rrl.getRecur().getFrequency())
              && rrl.getRecur().getInterval() < 0 && rrl
              .getRecur()
              .getDayList()
              .size() == 0)
              || RRULE_FREQ_WEEKLY.equals(rrl.getRecur().getFrequency())
              || RRULE_FREQ_DAILY.equals(rrl.getRecur().getFrequency())) {

              Expression exp3 =
                ExpressionFactory.matchExp(
                  EipTSchedule.START_DATE_PROPERTY,
                  start);
              query.setQualifier(exp.andExp(exp2.orExp(exp3)));

            } else {
              query.setQualifier(exp.andExp(exp2));
            }

            ResultList<EipTSchedule> result = query.getResultList();

            for (int l = 0; l < result.size(); l++) {
              EipTSchedule hasdummy = result.get(l);

              String repeatpatern = hasdummy.getRepeatPattern();

              if ("S".equals(repeatpatern) || "N".equals(repeatpatern)) {
                Database.delete(hasdummy);
              } else {

                if (exdate.size() != 0) {

                  // ダミーのスケジュールを登録する．
                  EipTSchedule dummySchedule =
                    Database.create(EipTSchedule.class);

                  // 親スケジュール ID
                  dummySchedule.setParentId(hasdummy.getScheduleId());
                  // 予定
                  dummySchedule.setName("dummy");
                  // 場所
                  dummySchedule.setPlace("");
                  // 内容
                  dummySchedule.setNote("");
                  // 公開フラグ
                  dummySchedule.setPublicFlag("P");
                  // 共有メンバーによる編集／削除フラグ
                  dummySchedule.setEditFlag("F");
                  // オーナーID
                  dummySchedule.setOwnerId(Integer.valueOf(loginuser));
                  // 作成日
                  Date now2 = new Date();
                  dummySchedule.setCreateDate(now2);
                  dummySchedule.setCreateUserId(Integer.valueOf(loginuser));
                  // 更新日
                  dummySchedule.setUpdateDate(now2);
                  dummySchedule.setUpdateUserId(Integer.valueOf(loginuser));
                  dummySchedule.setRepeatPattern("N");
                  dummySchedule.setStartDate(dum);

                  Calendar enddate = Calendar.getInstance();
                  enddate.setTime(dum);

                  Calendar endtime = Calendar.getInstance();
                  endtime.setTime(hasdummy.getEndDate());

                  endtime.set(Calendar.YEAR, enddate.get(Calendar.YEAR));
                  endtime.set(Calendar.MONTH, enddate.get(Calendar.MONTH));
                  endtime.set(Calendar.DAY_OF_MONTH, enddate
                    .get(Calendar.DAY_OF_MONTH));

                  dummySchedule.setEndDate(endtime.getTime());

                  EipTScheduleMap map = Database.create(EipTScheduleMap.class);

                  map.setEipTSchedule(dummySchedule);
                  map.setUserId(loginuser);

                  map.setStatus("D");
                  map.setType(INSERT_FLAG_U);

                  map.setCommonCategoryId(Integer.valueOf(1));

                  map.setEipTSchedule(dummySchedule);

                  SelectQuery<EipTCommonCategory> query2 =
                    Database.query(EipTCommonCategory.class);

                  Expression exp4 =
                    ExpressionFactory.matchDbExp(
                      EipTCommonCategory.COMMON_CATEGORY_ID_PK_COLUMN,
                      1);

                  query2.setQualifier(exp4);

                  ResultList<EipTCommonCategory> results =
                    query2.getResultList();

                  EipTCommonCategory category1 = (results.get(0));
                  map.setEipTCommonCategory(category1);
                }
              }
            }
          }
        }
      }
    }
  }

  /**
   * インポート時に 一度Aipoからエクスポートしたスケジュールだった場合 上書き保存する
   * 
   */
  public static EipTSchedule updateCheck(String event_uid) {

    try {
      EipTSchedule updatecheck = null;

      // Aipoから一度エクスポートしたスケジュールをインポートした場合
      if (event_uid.indexOf("Aipo:") != -1) {
        String[] uidAry = event_uid.split(":");

        // String uid = crypt(uid_pla);

        SelectQuery<EipTSchedule> q = Database.query(EipTSchedule.class);

        Expression exp =
          ExpressionFactory.matchDbExp(
            EipTSchedule.SCHEDULE_ID_PK_COLUMN,
            Integer.parseInt(uidAry[2]));

        q.setQualifier(exp);
        ResultList<EipTSchedule> schedules = q.getResultList();

        if (schedules == null || schedules.size() == 0) {
        } else {
          updatecheck = schedules.get(0);

        }

        // 以前Googleからインポートしたものと同じスケジュールデータを再びインポートした場合
      } else {

        SelectQuery<AvzTCoordinationForGoogleCal> q =
          Database.query(AvzTCoordinationForGoogleCal.class);

        Expression exp =
          ExpressionFactory.matchExp(
            AvzTCoordinationForGoogleCal.U_ID_PROPERTY,
            event_uid);

        q.setQualifier(exp);
        ResultList<AvzTCoordinationForGoogleCal> coordination =
          q.getResultList();

        if (coordination == null || coordination.size() == 0) {
        } else {
          for (int i = 0; i < coordination.size(); i++) {
            AvzTCoordinationForGoogleCal coor = coordination.get(i);
            int sche_id = coor.getScheduleId();

            SelectQuery<EipTSchedule> qu = Database.query(EipTSchedule.class);

            Expression sexp =
              ExpressionFactory.matchDbExp(
                EipTSchedule.SCHEDULE_ID_PK_COLUMN,
                sche_id);

            qu.setQualifier(sexp);
            ResultList<EipTSchedule> schedule = qu.getResultList();

            if (schedule == null || schedule.size() == 0) {
            } else {
              for (int j = 0; j < schedule.size(); j++) {

                Database.delete(schedule.get(j));

              }
            }
          }
        }
      }
      return updatecheck;

    } catch (Exception ex) {
      logger.error("Exception", ex);
    }
    return null;

  }

  public static AvzTCoordinationForGoogleCal updateCheck2(String event_uid,
      String uid_pla) {
    return null;

  }

  //
  // /**
  // * MD5アルゴリズム
  // * 文字列を暗号化する
  // *
  // * @param str 暗号化される文字列
  // * @return 暗号化結果
  // * @throws NoSuchAlgorithmException
  // */
  // public static String crypt(String str) throws NoSuchAlgorithmException
  // {
  // if (str == null || str.length() == 0) {
  // throw new IllegalArgumentException("String to encript cannot be null or
  // zero length");
  // }
  //                      
  // MessageDigest md = MessageDigest.getInstance("MD5");
  // md.update(str.getBytes());
  // byte[] hash = md.digest();
  //
  // return hashByte2MD5(hash);
  // }
  //  
  // //MD5 ハッシュ関数
  // private static String hashByte2MD5(byte []hash) {
  // StringBuffer hexString = new StringBuffer();
  // for (int i = 0; i < hash.length; i++) {
  // if ((0xff & hash[i]) < 0x10) {
  // hexString.append("0" + Integer.toHexString((0xFF & hash[i])));
  // } else {
  // hexString.append(Integer.toHexString(0xFF & hash[i]));
  // }
  // }
  //      
  // return hexString.toString();
  // }
  //  

  public static int getViewDateYear(RunData rundata, Context context,
      String name) {
    String view_date_year = null;
    String idParam = rundata.getParameters().getString(name);
    view_date_year = ALEipUtils.getTemp(rundata, context, name);
    if (idParam == null && view_date_year == null) {
      Calendar cal = Calendar.getInstance();
      view_date_year = Integer.toString(cal.get(Calendar.YEAR));
      ALEipUtils.setTemp(rundata, context, name, view_date_year);
    } else if (idParam != null) {
      ALEipUtils.setTemp(rundata, context, name, idParam);
      view_date_year = idParam;
    }
    return Integer.parseInt(view_date_year);
  }

  public static int getViewDateMonth(RunData rundata, Context context,
      String name) {
    String view_date_month = null;
    String idParam = rundata.getParameters().getString(name);
    view_date_month = ALEipUtils.getTemp(rundata, context, name);
    if (idParam == null && view_date_month == null) {
      Calendar cal = Calendar.getInstance();
      view_date_month = Integer.toString(cal.get(Calendar.MONTH));
      ALEipUtils.setTemp(rundata, context, name, view_date_month);
    } else if (idParam != null) {
      ALEipUtils.setTemp(rundata, context, name, idParam);
      view_date_month = idParam;
    }
    return Integer.parseInt(view_date_month);
  }

  /** 一時ファイルの新規生成 */
  public static String getNewAttachmentFolderName(File folder) {
    String FILE_SEPARATOR = System.getProperty("file.separator");
    int maxNum = 1;
    String[] filenames = folder.list();
    File file = null;
    int tmpInt = 1;
    int length = filenames.length;
    for (int i = 0; i < length; i++) {
      file = new File(folder.getAbsolutePath() + FILE_SEPARATOR + filenames[i]);
      if (file.isDirectory()) {
        try {
          tmpInt = Integer.parseInt(file.getName());
          if (maxNum <= tmpInt) {
            maxNum = tmpInt + 1;
          }
        } catch (NumberFormatException e) {
          logger.error(e);
        }
      }
    }
    return Integer.toString(maxNum);
  }
}
