/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.portlet.AvzTCirculationFile;
import com.aimluck.eip.circulation.util.CirculationUtils;
import com.aimluck.eip.orm.Database;

/**
 * 回覧板の添付ファイルの一覧を処理するクラスです。 <br />
 */
public class CirculationFileRawScreen extends FileuploadRawScreen {
  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(CirculationFileRawScreen.class
      .getName());

  /**
   * @see org.apache.turbine.modules.screens.RawScreen#doOutput(org.apache.turbine.util.RunData)
   */
  @Override
  protected void doOutput(RunData rundata) throws Exception {
    try {
      AvzTCirculationFile circulationfile =
        CirculationUtils.getAvzTCirculationFile(rundata);

      super.setFilePath(CirculationUtils.getSaveDirPath(Database
        .getDomainName(), circulationfile.getOwnerId().intValue())
        + circulationfile.getFilePath());
      super.setFileName(circulationfile.getFileName());
      super.doOutput(rundata);

    } catch (Exception e) {
      logger.error("[ERROR]", e);
    }
  }
}
