/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.whereaboutsboard.util;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;

import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;

public class WhereaboutsboardUtils {

  /** <code>SCHEDULEMAP_TYPE_USER</code> ユーザ */
  public static final String SCHEDULEMAP_TYPE_USER = "U";

  /** <code>SCHEDULEMAP_TYPE_FACILITY</code> 設備 */
  public static final String SCHEDULEMAP_TYPE_FACILITY = "F";

  /**
   * スケジュールデータから場所を取得します。 「場所」→「施設」→「予定名」の優先順位で表示します。
   * 「施設」が複数登録されている場合は、”もしくは”で連結して表示します。
   * 
   * @param schedule
   * @return
   */
  public static String getPlace(EipTSchedule schedule) {

    String place = schedule.getPlace();
    if (place.length() == 0) {

      SelectQuery<EipTScheduleMap> mapquery =
        Database.query(EipTScheduleMap.class);
      Expression mapexp1 =
        ExpressionFactory.matchExp(
          EipTScheduleMap.SCHEDULE_ID_PROPERTY,
          schedule.getScheduleId());
      mapquery.setQualifier(mapexp1);

      Expression mapexp3 =
        ExpressionFactory.matchExp(
          EipTScheduleMap.TYPE_PROPERTY,
          SCHEDULEMAP_TYPE_FACILITY);
      mapquery.andQualifier(mapexp3);

      StringBuffer buf_facility = new StringBuffer();
      ResultList<EipTScheduleMap> schedulemaps = mapquery.getResultList();
      if (schedulemaps != null && schedulemaps.size() != 0) {
        for (EipTScheduleMap map : schedulemaps) {
          SelectQuery<EipMFacility> fquery = Database.query(EipMFacility.class);
          Expression fexp =
            ExpressionFactory.matchDbExp(
              EipMFacility.FACILITY_ID_PK_COLUMN,
              map.getUserId());
          fquery.setQualifier(fexp);

          ResultList<EipMFacility> aList = fquery.getResultList();
          if (aList != null && aList.size() != 0) {
            EipMFacility f = aList.get(0);
            String facility = f.getFacilityName();
            if (buf_facility.length() == 0) {
              buf_facility.append(facility);
            } else {
              buf_facility.append(" もしくは " + facility);
            }
          }
        }
      }

      if (buf_facility.length() == 0) {
        place = schedule.getName();
      } else {
        place = buf_facility.toString();
      }

    }
    return place;
  }

}
