#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int lambda_uniq = 0;

char* fread_wm(FILE *fp)     //read with malloc
{
	char *str = malloc(sizeof(char) * 10);
	int size = 10;
	int i = 0;
	
	while((str[i] = fgetc(fp)) != EOF){
		if(i % 10 == 0){
			size += 10;
			realloc(str,sizeof(char) * (size + 1));
		}
		i++;
	}
	str[i] = '\0';
	return str;
}

char* strcat_wm(char *str,char *str2)
{
	int str2_len = strlen(str2);
	
	str = realloc(str,sizeof(char) * (strlen(str) + strlen(str2)));
	return strcat(str,str2);
}

char* strrep_wm(char *str,char *str2,int s,int e)
{
	char *lstr = malloc(sizeof(char) * (strlen(str) - e));
	str = realloc(str,sizeof(char) * (strlen(str) - (e - s + 1) + strlen(str2) + 1 + strlen(str) - e));
	
	strcpy(lstr,&str[e + 1]);
	str[s] = '\0';
	str = strcat(strcat(str,str2),lstr);
	free(lstr);
	return str;
}

char* strget_wm(char *str,int s,int e)
{
	char *str2 = malloc(sizeof(char) * (e - s + 2));
	memcpy(str2,&str[s],sizeof(char) * (e - s + 2));
	str2[e - s + 1] = '\0';
	return str2;
}

int find_e(char *str,int s)
{
	int i = s + 1;
	int s_f = 0;
	int b_f = 1;
	
	while(str[i] != '\0' && b_f > 0){
		if(str[i] == '\"'){
			if(s_f == 0){
				s_f = 1;
			}
			else{
				s_f = 0;
			}
		}
		if(s_f == 0){
			if(str[i] == '(' || str[i] == '{' || str[i] == '['){
				b_f++;
			}
			else if(str[i] == ')' || str[i] == '}' || str[i] == ']'){
				b_f--;
			}
		}
		i++;
	}
	return i - 1;
}

char* make_func(char *name,char *ret,char *argv,char *block,char *code)
{
	char *code2 = malloc(sizeof(char) * (strlen(name) + strlen(ret) + strlen(argv) + strlen(block) + 30));
	char *init = NULL;
	
	sprintf(code2,"\n%s %s(%s){%s}\n",ret,name,argv,block);
	realloc(code,sizeof(char) * (strlen(code) + strlen(code2) + 1));
	code = strcat(code,code2);
	free(code2);
	
	init = malloc(sizeof(char) * (strlen(name) + strlen(ret) + strlen(argv) + 30 + strlen(code)));
	sprintf(init,"%s %s(%s);\n",ret,name,argv);
	init = strcat(init,code);
	free(code);
	return init;
}

char* analysis(char *block,char *name,char *code)
{
	int n = 0;
	char *ret_and_argv;
	char *ret;
	char *argv;
	char *block2;
	char *block3;
	char *func;

	int i = 0;
	
//	sscanf(block,"{(%s)%s}",ret_and_argv,block2);

	while(block[i] != ')'){
		i++;
	}
	ret_and_argv = strget_wm(block,2,i - 1);
	block2 = strget_wm(block,i + 1,strlen(block) - 2);
	
	if((n = strstr(ret_and_argv,":")) == NULL){
		return NULL;
	}
	n -= (int)ret_and_argv;
	ret = strget_wm(ret_and_argv,0,n - 1);
	argv = strget_wm(ret_and_argv,n + 1,strlen(ret_and_argv) - 1);
	
	block3 = malloc(sizeof(char) * (strlen(block2) + 2));
	sprintf(block3,"%s;",block2);
	
	free(ret_and_argv);
	free(block2);
	func = make_func(name,ret,argv,block3,code);
	free(ret);
	free(argv);
	free(block3);
	return func;
}

char* lambda_tr(char *code)
{
	int s = 0;
	int e = 0;
	char lambda[50];
	char *block;
	
	while(1){
		s = 0;
		e = 0;
		
		if((s = strstr(code,"{(")) == NULL){
			return code;
		}
		s -= (int)code;
		e = find_e(code,s);
		sprintf(lambda,"_lambda%d",lambda_uniq);
		lambda_uniq++;
		block = strget_wm(code,s,e);
		code = strrep_wm(code,lambda,s,e);
		
		code = analysis(block,lambda,code);
		free(block);
	}
}

int main(int argc, char* argv[])
{
	FILE *fp = NULL;
	char *code;
	char fn[256];
	int i = 0;
	int j = 0;
	
	if(argc < 2){
		printf("error:argv error\n");
		return 0;
	}

	for(i = 1;i < argc;i++){
		fp = fopen(argv[i],"r");
		if(fp == NULL){
			printf("error:file open error:%s\n",argv[i]);
			return 0;
		}

		code = fread_wm(fp);
		fclose(fp);
		code = lambda_tr(code);
		
		sprintf(fn,"%s.c",argv[i]);
		if((fp = fopen(fn,"w")) == NULL){
			printf("error:file open error:%s\n",fn);
			return 0;
		}
		for(j = 0;code[j] != '\0';j++){
			fputc(code[j],fp);
		}
		fclose(fp);
		free(code);
	}
}
