/***************************************************************************
 *            cxp-profile.h
 *
 *  Mon Nov 29 23:38:45 2004
 *  Copyright  2004  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CXP_PROFILE_H
#define _CXP_PROFILE_H

#ifdef __cplusplus
extern "C"
{
#endif

#include <glib.h>
#include <glib-object.h>

#define CXP_TYPE_PROFILE				(cxp_profile_get_type ())
#define CXP_PROFILE(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_PROFILE, CxpProfile))
#define CXP_PROFILE_CLASS(vtable)		(G_TYPE_CHECK_CLASS_CAST ((vtable), CXP_TYPE_PROFILE, CxpProfileClass))
#define CXP_IS_PROFILE(obj)				(G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_PROFILE))
#define CXP_IS_PROFILE_CLASS(vtable)	(G_TYPE_CHECK_CLASS_TYPE ((vtable), CXP_TYPE_PROFILE))
#define CXP_PROFILE_GET_CLASS(inst)		(G_TYPE_INSTANCE_GET_INTERFACE ((inst), CXP_TYPE_PROFILE, CxpProfileClass))

/*
 * Type macros.
 */

	typedef struct _CxpProfile CxpProfile;
	typedef struct _CxpProfileClass CxpProfileClass;
	typedef struct _CxpProfilePrivate CxpProfilePrivate;

	struct _CxpProfile
	{
		GObject parent;
		/* private */
		CxpProfilePrivate *priv;
	};

	struct _CxpProfileClass
	{
		GObjectClass parent;
		/* class members */
	};

/* used by CXP_TYPE_PROFILE */
	GType cxp_profile_get_type (void);

/*
 * Method definitions.
 */
	CxpProfile *cxp_profile_new (const gchar * appname, const gchar *section);
	gint cxp_profile_get_integer (CxpProfile * profile, const gchar * name);
	gchar *cxp_profile_get_string (CxpProfile * profile, const gchar * name);
	void cxp_profile_set_integer (CxpProfile * profile, const gchar * key,
				      gint value);
	void cxp_profile_set_string (CxpProfile * profile, const gchar * key,
				     const gchar * value);
#ifdef __cplusplus
}
#endif

#endif				/* _CXP_PROFILE_H */
