/***************************************************************************
 *            cxp-entry-dialog.c
 *
 *  Sun Feb 13 23:50:30 2005
 *  Copyright  2005  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#include "cxp-entry-dialog.h"

/* If you use Pimpls, include the private structure 
 * definition here. Some people create a cxp-property_dialog-private.h header
 * which is included by the cxp-property_dialog.c file and which contains the
 * definition for this private structure.
 */

struct _CxpEntryDialogPrivate
{
	GtkWidget *msg_label;
	GtkWidget *entry;
	gboolean dispose_has_run;
};

static GObjectClass *parent_class = NULL;


enum
{
	CXP_ENTRY_DIALOG_FILENAME = 1,
};

static void cxp_entry_dialog_class_init (gpointer g_class,
					    gpointer g_class_data);
static void cxp_entry_dialog_instance_init (GTypeInstance * instance,
					       gpointer g_class);
static void cxp_entry_dialog_dispose (GObject * obj);
static void cxp_entry_dialog_finalize (GObject * obj);

static void cxp_entry_dialog_class_init (gpointer g_class,
					    gpointer g_class_data)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (g_class);
	CxpEntryDialogClass *klass = CXP_ENTRY_DIALOG_CLASS (g_class);
	GParamSpec *pspec;

	gobject_class->dispose = cxp_entry_dialog_dispose;
	gobject_class->finalize = cxp_entry_dialog_finalize;

	parent_class = g_type_class_peek_parent (klass);

}

static void cxp_entry_dialog_instance_init (GTypeInstance * instance,
					       gpointer g_class)
{
	CxpEntryDialog *self = CXP_ENTRY_DIALOG (instance);
	GtkWidget *ok_button;
	GtkWidget *cancel_button;

	self->private = g_new (CxpEntryDialogPrivate, 1);
	self->private->dispose_has_run = FALSE;

	gtk_window_set_destroy_with_parent(GTK_WINDOW(self), TRUE);
	gtk_dialog_set_default_response (GTK_DIALOG (self), GTK_RESPONSE_OK);

	self->private->msg_label = gtk_label_new("Message");
	gtk_misc_set_alignment (GTK_MISC(self->private->msg_label), 0, 0);
	gtk_label_set_line_wrap (GTK_LABEL(self->private->msg_label), TRUE);
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(self)->vbox), self->private->msg_label, TRUE, TRUE, 2);
	gtk_widget_show(self->private->msg_label);

	self->private->entry = gtk_entry_new();
	gtk_box_pack_start (GTK_BOX(GTK_DIALOG(self)->vbox), self->private->entry, TRUE, TRUE, 2);
	gtk_widget_show(self->private->entry);

	ok_button = gtk_button_new_from_stock("gtk-ok");
	gtk_dialog_add_action_widget (GTK_DIALOG (self), ok_button, GTK_RESPONSE_OK);
	gtk_widget_show (ok_button);

	cancel_button = gtk_button_new_from_stock("gtk-cancel");
	gtk_dialog_add_action_widget (GTK_DIALOG (self), cancel_button, GTK_RESPONSE_CANCEL);
	gtk_widget_show (cancel_button);

}

static void cxp_entry_dialog_dispose (GObject * obj)
{
	CxpEntryDialog *self = CXP_ENTRY_DIALOG (obj);

	if (self->private->dispose_has_run)
	{
		/* If dispose did already run, return. */
		return;
	}
	/* Make sure dispose does not run twice. */
	self->private->dispose_has_run = TRUE;

	/* 
	 * In dispose, you are supposed to free all types referenced from this
	 * object which might themselves hold a reference to self. Generally,
	 * the most simple solution is to unref all members on which you own a 
	 * reference.
	 */

	/* Chain up to the parent class */
	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void cxp_entry_dialog_finalize (GObject * obj)
{
	CxpEntryDialog *self = CXP_ENTRY_DIALOG (obj);

	/*
	 * Here, complete object destruction.
	 * You might not need to do much...
	 */

	g_free (self->private);

	/* Chain up to the parent class */
	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

GType cxp_entry_dialog_get_type (void)
{
	static GType type = 0;

	if (type == 0)
	{
		static const GTypeInfo info = {
			sizeof (CxpEntryDialogClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			cxp_entry_dialog_class_init,	/* class_init */
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof (CxpEntryDialog),
			0,	/* n_preallocs */
			cxp_entry_dialog_instance_init	/* instance_init */
		};
		type = g_type_register_static (GTK_TYPE_DIALOG,
					       "CxpEntryDialogType",
					       &info, 0);
	}
	return type;
}

GtkWidget *cxp_entry_dialog_new(const gchar *title, const gchar *message, const gchar *entry_text)
{
	CxpEntryDialog *dialog;

	dialog = g_object_new(CXP_TYPE_ENTRY_DIALOG, NULL);
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_label_set_text(GTK_LABEL(dialog->private->msg_label), message);
	gtk_entry_set_text(GTK_ENTRY(dialog->private->entry), entry_text);

	return	GTK_WIDGET(dialog);
}

gchar *cxp_entry_dialog_get_entry_text(CxpEntryDialog *dialog)
{
	return	g_strdup(gtk_entry_get_text(GTK_ENTRY(dialog->private->entry)));
}
