/***************************************************************************
 *            cxp-mime-manager.h
 *
 *  Wed 8 31 20:59:53 2005
 *  Copyright  2005  Yasumichi Akahoshi
 *  yasumichi@users.sourceforge.jp
 ***************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CXP_MIME_MANAGER_H
#define CXP_MIME_MANAGER_H

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define CXP_TYPE_MIME_MANAGER         (cxp_mime_manager_get_type ())
#define CXP_MIME_MANAGER(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), CXP_TYPE_MIME_MANAGER, CxpMimeManager))
#define CXP_MIME_MANAGER_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), CXP_TYPE_MIME_MANAGER, CxpMimeManagerClass))
#define CXP_IS_MIME_MANAGER(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), CXP_TYPE_MIME_MANAGER))
#define CXP_IS_MIME_MANAGER_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), CXP_TYPE_MIME_MANAGER))
#define CXP_MIME_MANAGER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), CXP_TYPE_MIME_MANAGER, CxpMimeManagerClass))

typedef struct CxpMimeManagerPrivate CxpMimeManagerPrivate;

typedef struct {
	GObject parent;
	CxpMimeManagerPrivate *priv;
} CxpMimeManager;

typedef struct {
	GObjectClass parent_class;
	/* Add Signal Functions Here */
} CxpMimeManagerClass;

GType cxp_mime_manager_get_type();
CxpMimeManager *cxp_mime_manager_new();
gchar *cxp_mime_manager_get_comment_from_mime (CxpMimeManager *manager, const gchar *mimetype);
GdkPixbuf* cxp_mime_manager_lookup_icon (CxpMimeManager *manager, const gchar *mimetype);

G_END_DECLS

#endif /* CXP_MIME_MANAGER_H */
