/*
 * Decompiled with CFR 0.152.
 */
package daruma.storage_manager.type_definition.types;

import daruma.geometry.CoordinateSystem;
import daruma.geometry.DrmGeometry;
import daruma.geometry.GeometryException;
import daruma.geometry.GeometryFormatConverter;
import daruma.geometry.TransformationContext;
import daruma.geometry.TransformationException;
import daruma.global_switch.ImplementationSwitches;
import daruma.sql.SQLDataType;
import daruma.sql.SQLDataTypeConstant;
import daruma.sql.TableColumn;
import daruma.sql.TableColumnDefinition;
import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.storage_manager.type_definition.ElementName;
import daruma.storage_manager.type_definition.NoNeedToConvertTypeException;
import daruma.storage_manager.type_definition.TypeDefinition;
import daruma.storage_manager.type_definition.TypeException;
import daruma.storage_manager.type_definition.TypedInstance;
import daruma.util.EqualChecker;
import daruma.util.LogWriter;
import daruma.util.Pair;
import daruma.xml.SimpleXPath;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.XMLFormatConverter;
import daruma.xml.util.XMLParseErrorException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryPropertyTypeDefinition
extends TypeDefinition {
    private static final String ColNameGeoValueSuffix = "_geo_";
    public static final String ColNameGeoSrsNameSuffix = "_srs_name_";
    private static final String ColNameGeoXmlSuffix = "_xml_";
    public static final String DefaultSrsName = "#system";
    private static final int ColIndexGeoValue = 0;
    private static final int ColIndexSrsName = 1;
    private static final int ColIndexGeoXml = 2;
    private static final int NUMBER_OF_COLUMNS = 3;

    public GeometryPropertyTypeDefinition() {
        super(true, true);
    }

    @Override
    public SQLDataType getSingleSQLDataType() {
        return null;
    }

    @Override
    public List<TableColumnDefinition> getCompositeSQLDataType(StorageManager storage, SimpleXPath path) throws TypeException {
        ArrayList<TableColumnDefinition> ret = new ArrayList<TableColumnDefinition>();
        String colNameBody = null;
        if (path == null) {
            colNameBody = ColumnNameFactory.getTopLevelElementColumnName();
        } else {
            SimpleXPath newPath = new SimpleXPath(path);
            try {
                colNameBody = storage.getShortXPathStringForDB(newPath);
            }
            catch (StorageException ex) {
                throw new TypeException(ex);
            }
        }
        ret.add(new TableColumnDefinition(ColumnNameFactory.getColumnName(colNameBody, ColNameGeoValueSuffix), new SQLDataType("geometry", "AsText", DrmGeometry.class)));
        ret.add(new TableColumnDefinition(ColumnNameFactory.getColumnName(colNameBody, ColNameGeoSrsNameSuffix), SQLDataTypeConstant.BLOB));
        ret.add(new TableColumnDefinition(ColumnNameFactory.getColumnName(colNameBody, ColNameGeoXmlSuffix), SQLDataTypeConstant.BLOB));
        return ret;
    }

    @Override
    public Pair<TypedInstance, Integer> createInstance(Element element, ElementName topLevelElement, SimpleXPath path, StorageManager storage, int elementIndex) throws TypeException {
        String rawXMLString;
        String srsName;
        String wktValue;
        Element geometryElement;
        LogWriter.qwrite("DEBUG", this.getClass().getName(), ": createInstance()");
        LogWriter.qwrite("DEBUG", "elementIndex = ", elementIndex);
        LogWriter.qwrite("DEBUG", element);
        try {
            geometryElement = ElementUtil.getSingleChildElement(element);
        }
        catch (XMLParseErrorException e) {
            throw new TypeException(e.getMessage(), e);
        }
        ElementName geometryTypeName = new ElementName(geometryElement);
        if (geometryElement.getNamespaceURI() == null || !geometryElement.getNamespaceURI().equals(URI.GML)) {
            throw new TypeException("unexpected geometry type \"" + geometryTypeName + "\"");
        }
        try {
            DrmGeometry geometry = GeometryFormatConverter.parseFromGMLElement(geometryElement);
            wktValue = GeometryFormatConverter.convertGeometryToWKTString(geometry, true);
            srsName = geometry.getSrsName();
        }
        catch (GeometryException e) {
            throw new TypeException("unexpected geometry type \"" + geometryTypeName + "\": " + e.getMessage());
        }
        try {
            rawXMLString = XMLFormatConverter.toString(geometryElement, false);
        }
        catch (TransformerException e) {
            throw new TypeException("unexpected exception, Can't convert XML to string: " + e.getMessage(), e);
        }
        SimpleXPath p = path == null ? null : new SimpleXPath(path, new UniversalName(element));
        List<TableColumnDefinition> defs = this.getCompositeSQLDataType(storage, p);
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(new TableColumn(defs.get(0), wktValue));
        columns.add(new TableColumn(defs.get(1), srsName));
        columns.add(new TableColumn(defs.get(2), rawXMLString));
        return new Pair<TypedInstance, Integer>(new TypedInstance(columns, this), element.getChildNodes().getLength());
    }

    @Override
    public int convertToXMLElement(Element element, Document doc, StorageManager storage, TransformationContext trans, List<TableColumn> columns, int index, long id) throws TypeException {
        Element geometryElement;
        if (index + 3 - 1 >= columns.size()) {
            throw new TypeException("internal error in " + this.getClass().getName() + ": unexpected instantiation");
        }
        try {
            geometryElement = XMLFormatConverter.stringToElement(columns.get(index + 2).getValue(), doc);
        }
        catch (TransformerException e) {
            throw new TypeException("unexpected exception, Can't convert string to XML: " + e.getMessage(), e);
        }
        if (ImplementationSwitches.instance().getEnableGeometryConversion()) {
            try {
                DrmGeometry geometry = GeometryFormatConverter.parseFromGMLElement(geometryElement);
                geometry = GeometryPropertyTypeDefinition.transformGeometry(geometry, trans);
                element.appendChild(GeometryFormatConverter.convertToGMLElement(doc, geometry));
            }
            catch (GeometryException e) {
                throw new TypeException("internal error: " + e.getMessage());
            }
        } else {
            element.appendChild(geometryElement);
        }
        return index + 3;
    }

    public static String convertShortXPathToColumnName(String shortXPathString) {
        return ColumnNameFactory.getColumnName(shortXPathString, ColNameGeoValueSuffix);
    }

    public static String convertShortXPathToSrsColumnName(String shortXPathString) {
        return ColumnNameFactory.getColumnName(shortXPathString, ColNameGeoSrsNameSuffix);
    }

    private static DrmGeometry transformGeometry(DrmGeometry geometry, TransformationContext trans) throws NoNeedToConvertTypeException {
        LogWriter.qwrite("DEBUG", "terget SRS = ", trans.getTargetCoordinateSystem().getSrsName());
        LogWriter.qwrite("DEBUG", "object SRS = ", geometry.getSrsName());
        switch (trans.getTransformationType()) {
            case Selective: {
                CoordinateSystem target = trans.getTargetCoordinateSystem();
                String objCoord = geometry.getSrsName();
                if (EqualChecker.equals(target.getSrsName(), objCoord)) break;
                throw new NoNeedToConvertTypeException();
            }
            case Conv: {
                try {
                    geometry = trans.transform(geometry);
                    break;
                }
                catch (TransformationException e) {
                    throw new NoNeedToConvertTypeException(e.getMessage());
                }
            }
        }
        return geometry;
    }
}

